// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AggregateCreateReader is a Reader for the AggregateCreate structure.
type AggregateCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewAggregateCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAggregateCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAggregateCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAggregateCreateCreated creates a AggregateCreateCreated with default headers values
func NewAggregateCreateCreated() *AggregateCreateCreated {
	return &AggregateCreateCreated{}
}

/*
AggregateCreateCreated describes a response with status code 201, with default header values.

Created
*/
type AggregateCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate create created response has a 2xx status code
func (o *AggregateCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate create created response has a 3xx status code
func (o *AggregateCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate create created response has a 4xx status code
func (o *AggregateCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate create created response has a 5xx status code
func (o *AggregateCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate create created response a status code equal to that given
func (o *AggregateCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the aggregate create created response
func (o *AggregateCreateCreated) Code() int {
	return 201
}

func (o *AggregateCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregateCreateCreated %s", 201, payload)
}

func (o *AggregateCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregateCreateCreated %s", 201, payload)
}

func (o *AggregateCreateCreated) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateCreateAccepted creates a AggregateCreateAccepted with default headers values
func NewAggregateCreateAccepted() *AggregateCreateAccepted {
	return &AggregateCreateAccepted{}
}

/*
AggregateCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AggregateCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate create accepted response has a 2xx status code
func (o *AggregateCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate create accepted response has a 3xx status code
func (o *AggregateCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate create accepted response has a 4xx status code
func (o *AggregateCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate create accepted response has a 5xx status code
func (o *AggregateCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate create accepted response a status code equal to that given
func (o *AggregateCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aggregate create accepted response
func (o *AggregateCreateAccepted) Code() int {
	return 202
}

func (o *AggregateCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregateCreateAccepted %s", 202, payload)
}

func (o *AggregateCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregateCreateAccepted %s", 202, payload)
}

func (o *AggregateCreateAccepted) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateCreateDefault creates a AggregateCreateDefault with default headers values
func NewAggregateCreateDefault(code int) *AggregateCreateDefault {
	return &AggregateCreateDefault{
		_statusCode: code,
	}
}

/*
	AggregateCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 460770 | The aggregate create job failed to create the aggregate. |
| 786438 | Failed to create an aggregate on the node. |
| 786439 | An aggregate already uses the specified name. |
| 786446 | The node is not in cluster. |
| 786468 | VLDB is offline. |
| 786819 | The value is invalid for the specified option at the current privilege level. |
| 786902 | RAID-TEC aggregate is not fully supported. |
| 786911 | Not every node in the cluster has the Data ONTAP version required for the feature. |
| 786973 | The number of disks specified does not meet the minimum number of disks required for this operation. |
| 787069 | Node is setup for MetroCluster over IP configuration; creating an unmirrored aggregate is not supported in this configuration. |
| 787092 | The target field cannot be specified for this operation. |
| 787267 | The number of disks specified does not meet the minimum number of disks required for the creation of a new RAID group. |
| 918138 | Internal error. Failed to get encryption operation status. |
| 1114292 | The required SnapLock license is not installed. |
| 2425736 | No matching node found for the target UUID. |
| 19726341 | Not enough eligible spare disks are available on the node. |
| 19726344 | No recommendation can be made for this cluster. |
| 19726357 | Automatic aggregate creation is not supported on MetroCluster with Fibre Channel (FC). |
| 19726358 | Automatic aggregate creation is not supported on ONTAP Cloud. |
| 19726373 | Recommendation specified for creating aggregates is not current. |
| 19726378 | Failed to create recommended aggregates on one or more nodes. |
| 19726382 | Another provisioning operation is in progress on this cluster. Wait a few minutes, and try the operation again. |
| 19726386 | Encountered an error when retrieving licensing information on this cluster. |
| 19726387 | No recommendation can be provided for this cluster within the license capacity. |
| 19726401 | Aggregate recommendations are not supported when the DR group is not in the "normal" state. |
| 19726402 | Internal error. Unable to determine the MetroCluster configuration state. |
| 19726403 | Aggregate recommendation is not supported when there are no healthy target connections to remote storage. |
| 19726544 | POST on the aggregate endpoint is not supported on this version of ONTAP. |
| 65537119 | Key management is not configured for the admin SVM. Configure a key manager for the admin SVM. |
| 196608055 | Aggregate recommendation is not supported on this node because it does not support NetApp Aggregate Encryption (NAE). |
| 196608206 | Internal error. Failed to get encryption operation status. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AggregateCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aggregate create default response has a 2xx status code
func (o *AggregateCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aggregate create default response has a 3xx status code
func (o *AggregateCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aggregate create default response has a 4xx status code
func (o *AggregateCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aggregate create default response has a 5xx status code
func (o *AggregateCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aggregate create default response a status code equal to that given
func (o *AggregateCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aggregate create default response
func (o *AggregateCreateDefault) Code() int {
	return o._statusCode
}

func (o *AggregateCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregate_create default %s", o._statusCode, payload)
}

func (o *AggregateCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /storage/aggregates][%d] aggregate_create default %s", o._statusCode, payload)
}

func (o *AggregateCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AggregateCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
