// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAggregateDeleteParams creates a new AggregateDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAggregateDeleteParams() *AggregateDeleteParams {
	return &AggregateDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAggregateDeleteParamsWithTimeout creates a new AggregateDeleteParams object
// with the ability to set a timeout on a request.
func NewAggregateDeleteParamsWithTimeout(timeout time.Duration) *AggregateDeleteParams {
	return &AggregateDeleteParams{
		timeout: timeout,
	}
}

// NewAggregateDeleteParamsWithContext creates a new AggregateDeleteParams object
// with the ability to set a context for a request.
func NewAggregateDeleteParamsWithContext(ctx context.Context) *AggregateDeleteParams {
	return &AggregateDeleteParams{
		Context: ctx,
	}
}

// NewAggregateDeleteParamsWithHTTPClient creates a new AggregateDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewAggregateDeleteParamsWithHTTPClient(client *http.Client) *AggregateDeleteParams {
	return &AggregateDeleteParams{
		HTTPClient: client,
	}
}

/*
AggregateDeleteParams contains all the parameters to send to the API endpoint

	for the aggregate delete operation.

	Typically these are written to a http.Request.
*/
type AggregateDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Aggregate UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aggregate delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateDeleteParams) WithDefaults() *AggregateDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aggregate delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := AggregateDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the aggregate delete params
func (o *AggregateDeleteParams) WithTimeout(timeout time.Duration) *AggregateDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aggregate delete params
func (o *AggregateDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aggregate delete params
func (o *AggregateDeleteParams) WithContext(ctx context.Context) *AggregateDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aggregate delete params
func (o *AggregateDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aggregate delete params
func (o *AggregateDeleteParams) WithHTTPClient(client *http.Client) *AggregateDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aggregate delete params
func (o *AggregateDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the aggregate delete params
func (o *AggregateDeleteParams) WithReturnTimeout(returnTimeout *int64) *AggregateDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the aggregate delete params
func (o *AggregateDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the aggregate delete params
func (o *AggregateDeleteParams) WithUUID(uuid string) *AggregateDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the aggregate delete params
func (o *AggregateDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AggregateDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
