// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewAggregateGetParams creates a new AggregateGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAggregateGetParams() *AggregateGetParams {
	return &AggregateGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAggregateGetParamsWithTimeout creates a new AggregateGetParams object
// with the ability to set a timeout on a request.
func NewAggregateGetParamsWithTimeout(timeout time.Duration) *AggregateGetParams {
	return &AggregateGetParams{
		timeout: timeout,
	}
}

// NewAggregateGetParamsWithContext creates a new AggregateGetParams object
// with the ability to set a context for a request.
func NewAggregateGetParamsWithContext(ctx context.Context) *AggregateGetParams {
	return &AggregateGetParams{
		Context: ctx,
	}
}

// NewAggregateGetParamsWithHTTPClient creates a new AggregateGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewAggregateGetParamsWithHTTPClient(client *http.Client) *AggregateGetParams {
	return &AggregateGetParams{
		HTTPClient: client,
	}
}

/*
AggregateGetParams contains all the parameters to send to the API endpoint

	for the aggregate get operation.

	Typically these are written to a http.Request.
*/
type AggregateGetParams struct {

	/* AutoProvisionPolicy.

	   If set to expand, a query is run on the system for the recommended optimal expansion layout of the aggregate.
	*/
	AutoProvisionPolicy *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FlashPoolEligible.

	   If set to 'true' along with show_spares, the spares object is restricted to return spare groups that are compatible with flash pool creation or addition for the specified aggregate. The default setting is 'false'.
	*/
	FlashPoolEligible *bool

	/* ShowSpares.

	   If set to 'true', the spares object is returned instead of records to show the spare groups in the cluster that are compatible with the aggregate. The default setting is 'false'.
	*/
	ShowSpares *bool

	/* UUID.

	   Aggregate UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aggregate get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateGetParams) WithDefaults() *AggregateGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aggregate get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the aggregate get params
func (o *AggregateGetParams) WithTimeout(timeout time.Duration) *AggregateGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aggregate get params
func (o *AggregateGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aggregate get params
func (o *AggregateGetParams) WithContext(ctx context.Context) *AggregateGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aggregate get params
func (o *AggregateGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aggregate get params
func (o *AggregateGetParams) WithHTTPClient(client *http.Client) *AggregateGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aggregate get params
func (o *AggregateGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutoProvisionPolicy adds the autoProvisionPolicy to the aggregate get params
func (o *AggregateGetParams) WithAutoProvisionPolicy(autoProvisionPolicy *string) *AggregateGetParams {
	o.SetAutoProvisionPolicy(autoProvisionPolicy)
	return o
}

// SetAutoProvisionPolicy adds the autoProvisionPolicy to the aggregate get params
func (o *AggregateGetParams) SetAutoProvisionPolicy(autoProvisionPolicy *string) {
	o.AutoProvisionPolicy = autoProvisionPolicy
}

// WithFields adds the fields to the aggregate get params
func (o *AggregateGetParams) WithFields(fields []string) *AggregateGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the aggregate get params
func (o *AggregateGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFlashPoolEligible adds the flashPoolEligible to the aggregate get params
func (o *AggregateGetParams) WithFlashPoolEligible(flashPoolEligible *bool) *AggregateGetParams {
	o.SetFlashPoolEligible(flashPoolEligible)
	return o
}

// SetFlashPoolEligible adds the flashPoolEligible to the aggregate get params
func (o *AggregateGetParams) SetFlashPoolEligible(flashPoolEligible *bool) {
	o.FlashPoolEligible = flashPoolEligible
}

// WithShowSpares adds the showSpares to the aggregate get params
func (o *AggregateGetParams) WithShowSpares(showSpares *bool) *AggregateGetParams {
	o.SetShowSpares(showSpares)
	return o
}

// SetShowSpares adds the showSpares to the aggregate get params
func (o *AggregateGetParams) SetShowSpares(showSpares *bool) {
	o.ShowSpares = showSpares
}

// WithUUID adds the uuid to the aggregate get params
func (o *AggregateGetParams) WithUUID(uuid string) *AggregateGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the aggregate get params
func (o *AggregateGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AggregateGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AutoProvisionPolicy != nil {

		// query param auto_provision_policy
		var qrAutoProvisionPolicy string

		if o.AutoProvisionPolicy != nil {
			qrAutoProvisionPolicy = *o.AutoProvisionPolicy
		}
		qAutoProvisionPolicy := qrAutoProvisionPolicy
		if qAutoProvisionPolicy != "" {

			if err := r.SetQueryParam("auto_provision_policy", qAutoProvisionPolicy); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FlashPoolEligible != nil {

		// query param flash_pool_eligible
		var qrFlashPoolEligible bool

		if o.FlashPoolEligible != nil {
			qrFlashPoolEligible = *o.FlashPoolEligible
		}
		qFlashPoolEligible := swag.FormatBool(qrFlashPoolEligible)
		if qFlashPoolEligible != "" {

			if err := r.SetQueryParam("flash_pool_eligible", qFlashPoolEligible); err != nil {
				return err
			}
		}
	}

	if o.ShowSpares != nil {

		// query param show_spares
		var qrShowSpares bool

		if o.ShowSpares != nil {
			qrShowSpares = *o.ShowSpares
		}
		qShowSpares := swag.FormatBool(qrShowSpares)
		if qShowSpares != "" {

			if err := r.SetQueryParam("show_spares", qShowSpares); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamAggregateGet binds the parameter fields
func (o *AggregateGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
