// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AggregateModifyCollectionReader is a Reader for the AggregateModifyCollection structure.
type AggregateModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAggregateModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAggregateModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAggregateModifyCollectionOK creates a AggregateModifyCollectionOK with default headers values
func NewAggregateModifyCollectionOK() *AggregateModifyCollectionOK {
	return &AggregateModifyCollectionOK{}
}

/*
AggregateModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type AggregateModifyCollectionOK struct {
	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate modify collection o k response has a 2xx status code
func (o *AggregateModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate modify collection o k response has a 3xx status code
func (o *AggregateModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate modify collection o k response has a 4xx status code
func (o *AggregateModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate modify collection o k response has a 5xx status code
func (o *AggregateModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate modify collection o k response a status code equal to that given
func (o *AggregateModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate modify collection o k response
func (o *AggregateModifyCollectionOK) Code() int {
	return 200
}

func (o *AggregateModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregateModifyCollectionOK %s", 200, payload)
}

func (o *AggregateModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregateModifyCollectionOK %s", 200, payload)
}

func (o *AggregateModifyCollectionOK) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateModifyCollectionAccepted creates a AggregateModifyCollectionAccepted with default headers values
func NewAggregateModifyCollectionAccepted() *AggregateModifyCollectionAccepted {
	return &AggregateModifyCollectionAccepted{}
}

/*
AggregateModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AggregateModifyCollectionAccepted struct {
	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate modify collection accepted response has a 2xx status code
func (o *AggregateModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate modify collection accepted response has a 3xx status code
func (o *AggregateModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate modify collection accepted response has a 4xx status code
func (o *AggregateModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate modify collection accepted response has a 5xx status code
func (o *AggregateModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate modify collection accepted response a status code equal to that given
func (o *AggregateModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aggregate modify collection accepted response
func (o *AggregateModifyCollectionAccepted) Code() int {
	return 202
}

func (o *AggregateModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregateModifyCollectionAccepted %s", 202, payload)
}

func (o *AggregateModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregateModifyCollectionAccepted %s", 202, payload)
}

func (o *AggregateModifyCollectionAccepted) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateModifyCollectionDefault creates a AggregateModifyCollectionDefault with default headers values
func NewAggregateModifyCollectionDefault(code int) *AggregateModifyCollectionDefault {
	return &AggregateModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	AggregateModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262247 | The value is invalid for the field. |
| 460777 | Failed to get information on the job. |
| 786434 | Cannot connect to node where the aggregate resides. |
| 786435 | Internal Error. Failed to create a communication handle. |
| 786439 | An aggregate already uses the specified name. |
| 786447 | Failed to modify the aggregate. |
| 786456 | Failed to add disks to the aggregate. |
| 786458 | Failed to rename aggregate. |
| 786465 | Failed to take aggregate offline because of the reason outlined in the message. |
| 786467 | Failed to take aggregate online because of the reason outlined in the message. |
| 786468 | VLDB is offline. |
| 786472 | Node that hosts the aggregate is offline. |
| 786479 | Cannot find node ID for the node. |
| 786491 | Not enough spares on the node. |
| 786730 | Internal Error |
| 786771 | Aggregate does not exist. |
| 786787 | Aggregate is not online. |
| 786808 | Aggregate mirror failed. |
| 786867 | Specified aggregate resides on the remote cluster. |
| 786911 | Not every node in the cluster has the Data ONTAP version required for the feature. |
| 786923 | This operation is not allowed during the pre-commit phase of a 7-mode to clustered Data ONTAP transition. |
| 786924 | Internal error for an aggregate that is in the pre-commit phase of a 7-mode to clustered Data ONTAP transition. |
| 786955 | Modifying raidtype to raid_tec requires a minimum of six disks in the RAID Group. |
| 786956 | Modifying raidtype to raid_dp requires a minimum of four disks in the RAID Group. |
| 786965 | Spare Selection in userspace failed. |
| 787046 | Mirroring of a FabricPool is not allowed. |
| 787092 | The target field cannot be specified for this operation. |
| 787144 | Aggregate is not a FabricPool. |
| 787156 | Modifying the attributes of mirror object store is not allowed. |
| 787169 | Only one field can be modified per operation. |
| 787170 | Failed to patch the \"block_storage.primary.disk_count\" because the disk count specified is smaller than existing disk count. |
| 787172 | This query is only allowed during the modification of the specified field. |
| 787178 | Unmirroring an aggregate with a PATCH operation is not supported. |
| 787187 | Internal error. Failed to check if the aggregate is a FabricPool. |
| 787266 | Invalid aggregate state. This state is not supported for a PATCH operation. |
| 787273 | Allocation unit count is not valid. |
| 787274 | Raidtype is not valid. |
| 787275 | Patch request with multiple records is not valid. |
| 787276 | Storage pool name and uuid do not match. |
| 787277 | Storage pool name and uuid are empty. |
| 787278 | Incorrect storage pool name specified. |
| 787279 | Incorrect storage pool uuid specified. |
| 787280 | Allocation unit count specified is smaller than the existing allocation unit count. |
| 787281 | Cannot modify RAID type of aggregate hybrid cache tier. |
| 787282 | RAID group must be specified on a disk addition to an aggregate with mixed RAID types. |
| 787283 | RAID group must be specified on a disk addition to a Flash Pool aggregate. |
| 787284 | The specified RAID group uses capacity from one or more storage pools. |
| 787287 | Cannot add physical SSD cache because aggregate uses cache capacity from a storage pool. |
| 787288 | Cannot add storage pool units because aggregate uses physical SSD cache. |
| 787289 | Incorrect raid_group specified during first time addition of physical SSD cache to an aggregate. |
| 787291 | Cannot specify RAID group which is located on the aggregate primary tier. |
| 787293 | Cannot specify RAID group which is located on the aggregate cache tier. |
| 787294 | This query is only allowed during the modification of the specific fields. |
| 787295 | The storage pool allocation units count is required. |
| 1258699 | Cannot use all the disks specified for the requested operation. |
| 1263500 | Operation will lead to creation of new raid group. |
| 1263501 | Operation will exceed half of the maximum volume sizes allowed on the node. |
| 1263502 | One spare data partition from at least one of the chosen root-data1-data2 disks will not be used. |
| 1263503 | Operation will lead to downsizing of one or more disks. |
| 1263504 | Operation will lead to a spares low condition. |
| 1263598 | One or more selected disks will be partitioned. |
| 1263624 | Operation will lead to a no sparecore condition. |
| 2425736 | No matching node found for the UUID provided. |
| 7208962 | Aggregate in an inconsistent state. |
| 7208993 | Failed to offline as the volume is being used. |
| 7209033 | CIFS open files prevent operation. |
| 7209049 | Cannot perform the operation because the aggregate is currently expanding. |
| 7209075 | Cannot perform the operation because the volume size limit for this system type would be exceeded. |
| 7209090 | Inconsistent state. |
| 7209183 | Volume is a partial volume. |
| 7209229 | This version of ONTAP does not recognize the filesystem. It is probably from a later version of the software and is being left offline. |
| 7209246 | The specified operation could not be completed as the volume is currently busy. |
| 7209247 | The volume was not found. |
| 7209263 | Container has failed. |
| 7209271 | wafliron is currently active. |
| 7209275 | Container was created in an unclustered ONTAP deployment. |
| 7209463 | Nvfile replay pending. |
| 7209966 | Another online request is already in progress for aggregate. The previous online request is waiting on a response from the licensing manager. |
| 11206666 | Storage pool is not healthy. |
| 11210659 | Aggregate is not online. |
| 11210662 | Adding capacity from storage pool to a mirrored aggregate is not supported. |
| 11210667 | Storage pool does not have enough spare allocation units. |
| 11210670 | Cannot add capacity from storage pool to aggregate, because currently allocated capacity to the aggregate does not span across all disks belonging to the storage pool. |
| 11210672 | Cannot grow aggregate as no capacity is allocated to it from storage pool. |
| 11210673 | Mixing of physical SSDs and capacity from a storage pool is not allowed in same aggregate. |
| 11210675 | Capacity in storage pool belongs to different fault isolation domain than aggregate. |
| 11210678 | Storage pool does not have enough disks to create RAID groups of same raid type as that of already allocated cache tier. |
| 11210679 | Storage pool does not have enough disks to create RAID groups of type RAID-DP. |
| 11210680 | Storage pool does not have enough disks to create RAID groups of same raid type as that of the aggregate. |
| 11210685 | Storage pool does not have enough disks to create RAID groups of type RAID-TEC. |
| 11210688 | Capacity from storage pool cannot be added to an SSD aggregate and a Flash Pool. |
| 13108106 | Cannot run aggregate relocation because volume expand is in progress. |
| 19726347 | There are a number of unassigned disks visible to the node that owns this aggregate. |
| 19726382 | Another provisioning operation is in progress on this cluster. Wait a few minutes, and try the operation again. |
| 19726390 | Unable to automatically expand this aggregate. |
| 19726391 | Too many unassigned disks visible to the node that owns this aggregate. |
| 19726392 | Layout of this aggregate is not a supported configuration. |
| 19726393 | Failed to expand the aggregate. Aggregate expansion is not supported on this system. |
| 19726394 | Automatic aggregate expansion is not supported on systems with multiple data aggregates. |
| 19726395 | Automatic aggregate expansion is not supported when MetroCluster is not configured. |
| 19726396 | Automatic aggregate expansion is not supported when the DR group is not in a normal state. |
| 19726397 | Aggregates must contain disks with identical disk-types and disk-sizes. |
| 19726402 | Internal error. Unable to determine the MetroCluster configuration state. |
| 19726538 | Cannot perform the operation because the aggregate is not in a healthy state. |
| 19726541 | Cannot perform the operation because the specified aggregate is a root aggregate. |
| 19726544 | PATCH on the aggregate endpoint is not supported on this version of ONTAP. |
| 26542083 | Destination node is at higher Data ONTAP version than source node. |
| 26542084 | Source node is at higher Data ONTAP version than destination node. |
| 26542097 | Unable to get D-blade ID of destination. |
| 26542101 | Unable to contact the source node. |
| 26542102 | Unable to contact the destination node. |
| 26542120 | An SVM migrate operation is in progress. When the migrate operation completes, try the operation again. |
| 26542121 | A MetroCluster disaster recovery operation is in progress. When the recovery operation completes, try the operation again. |
| 196608334 | Failed to modify the aggregate because it contains NAE volumes. |
| 196608335 | Failed to modify the aggregate because it contains non-encrypted volumes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AggregateModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aggregate modify collection default response has a 2xx status code
func (o *AggregateModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aggregate modify collection default response has a 3xx status code
func (o *AggregateModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aggregate modify collection default response has a 4xx status code
func (o *AggregateModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aggregate modify collection default response has a 5xx status code
func (o *AggregateModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aggregate modify collection default response a status code equal to that given
func (o *AggregateModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aggregate modify collection default response
func (o *AggregateModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *AggregateModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregate_modify_collection default %s", o._statusCode, payload)
}

func (o *AggregateModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates][%d] aggregate_modify_collection default %s", o._statusCode, payload)
}

func (o *AggregateModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AggregateModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
AggregateModifyCollectionBody aggregate modify collection body
swagger:model AggregateModifyCollectionBody
*/
type AggregateModifyCollectionBody struct {

	// links
	Links *models.AggregateInlineLinks `json:"_links,omitempty"`

	// Tags are an optional way to track the uses of a resource. Tag values must be formatted as key:value strings.
	// Example: ["team:csi","environment:test"]
	// Max Items: 64
	AggregateInlineTags []*string `json:"_tags,omitempty"`

	// Information on the aggregate's remaining hot spare disks.
	AggregateResponseInlineRecommendationSpares []*models.AggregateSpare `json:"recommendation_spares,omitempty"`

	// aggregate response inline records
	AggregateResponseInlineRecords []*models.Aggregate `json:"records,omitempty"`

	// aggregate response inline spares
	AggregateResponseInlineSpares []*models.AggregateSpare `json:"spares,omitempty"`

	// List of warnings and remediation advice for the aggregate recommendation.
	AggregateResponseInlineWarnings []*models.AggregateWarning `json:"warnings,omitempty"`

	// block storage
	BlockStorage *models.AggregateInlineBlockStorage `json:"block_storage,omitempty"`

	// cloud storage
	CloudStorage *models.AggregateInlineCloudStorage `json:"cloud_storage,omitempty"`

	// Timestamp of aggregate creation.
	// Example: 2018-01-01 12:00:00-04:00
	// Read Only: true
	CreateTime *string `json:"create_time,omitempty"`

	// data encryption
	DataEncryption *models.AggregateInlineDataEncryption `json:"data_encryption,omitempty"`

	// dr home node
	DrHomeNode *models.AggregateInlineDrHomeNode `json:"dr_home_node,omitempty"`

	// error
	Error *models.Error `json:"error,omitempty"`

	// home node
	HomeNode *models.AggregateInlineHomeNode `json:"home_node,omitempty"`

	// inactive data reporting
	InactiveDataReporting *models.AggregateInlineInactiveDataReporting `json:"inactive_data_reporting,omitempty"`

	// inode attributes
	InodeAttributes *models.AggregateInlineInodeAttributes `json:"inode_attributes,omitempty"`

	// Specifies whether the aggregate is in a spares low condition on any of the RAID groups.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: false
	// Read Only: true
	IsSpareLow *bool `json:"is_spare_low,omitempty"`

	// metric
	Metric *models.AggregateInlineMetric `json:"metric,omitempty"`

	// Aggregate name.
	// Example: node1_aggr_1
	Name *string `json:"name,omitempty"`

	// node
	Node *models.AggregateInlineNode `json:"node,omitempty"`

	// Specifies whether or not SIDL is enabled on the aggregate.
	SidlEnabled *bool `json:"sidl_enabled,omitempty"`

	// SnapLock type.
	// Enum: ["non_snaplock","compliance","enterprise"]
	SnaplockType *string `json:"snaplock_type,omitempty"`

	// snapshot
	Snapshot *models.AggregateInlineSnapshot `json:"snapshot,omitempty"`

	// space
	Space *models.AggregateInlineSpace `json:"space,omitempty"`

	// Operational state of the aggregate.
	// Enum: ["online","onlining","offline","offlining","relocating","unmounted","restricted","inconsistent","failed","unknown"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.AggregateInlineStatistics `json:"statistics,omitempty"`

	// Aggregate UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// Number of volumes in the aggregate.
	// Read Only: true
	VolumeCount *int64 `json:"volume-count,omitempty"`
}

// Validate validates this aggregate modify collection body
func (o *AggregateModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregateInlineTags(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregateResponseInlineRecommendationSpares(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregateResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregateResponseInlineSpares(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregateResponseInlineWarnings(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBlockStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloudStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDataEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDrHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateHomeNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInactiveDataReporting(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateInodeAttributes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMetric(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNode(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnaplockType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateAggregateInlineTags(formats strfmt.Registry) error {
	if swag.IsZero(o.AggregateInlineTags) { // not required
		return nil
	}

	iAggregateInlineTagsSize := int64(len(o.AggregateInlineTags))

	if err := validate.MaxItems("info"+"."+"_tags", "body", iAggregateInlineTagsSize, 64); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateAggregateResponseInlineRecommendationSpares(formats strfmt.Registry) error {
	if swag.IsZero(o.AggregateResponseInlineRecommendationSpares) { // not required
		return nil
	}

	for i := 0; i < len(o.AggregateResponseInlineRecommendationSpares); i++ {
		if swag.IsZero(o.AggregateResponseInlineRecommendationSpares[i]) { // not required
			continue
		}

		if o.AggregateResponseInlineRecommendationSpares[i] != nil {
			if err := o.AggregateResponseInlineRecommendationSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "recommendation_spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateAggregateResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.AggregateResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.AggregateResponseInlineRecords); i++ {
		if swag.IsZero(o.AggregateResponseInlineRecords[i]) { // not required
			continue
		}

		if o.AggregateResponseInlineRecords[i] != nil {
			if err := o.AggregateResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateAggregateResponseInlineSpares(formats strfmt.Registry) error {
	if swag.IsZero(o.AggregateResponseInlineSpares) { // not required
		return nil
	}

	for i := 0; i < len(o.AggregateResponseInlineSpares); i++ {
		if swag.IsZero(o.AggregateResponseInlineSpares[i]) { // not required
			continue
		}

		if o.AggregateResponseInlineSpares[i] != nil {
			if err := o.AggregateResponseInlineSpares[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateAggregateResponseInlineWarnings(formats strfmt.Registry) error {
	if swag.IsZero(o.AggregateResponseInlineWarnings) { // not required
		return nil
	}

	for i := 0; i < len(o.AggregateResponseInlineWarnings); i++ {
		if swag.IsZero(o.AggregateResponseInlineWarnings[i]) { // not required
			continue
		}

		if o.AggregateResponseInlineWarnings[i] != nil {
			if err := o.AggregateResponseInlineWarnings[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateBlockStorage(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockStorage) { // not required
		return nil
	}

	if o.BlockStorage != nil {
		if err := o.BlockStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateCloudStorage(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudStorage) { // not required
		return nil
	}

	if o.CloudStorage != nil {
		if err := o.CloudStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateDataEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.DataEncryption) { // not required
		return nil
	}

	if o.DataEncryption != nil {
		if err := o.DataEncryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "data_encryption")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateDrHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(o.DrHomeNode) { // not required
		return nil
	}

	if o.DrHomeNode != nil {
		if err := o.DrHomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dr_home_node")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateHomeNode(formats strfmt.Registry) error {
	if swag.IsZero(o.HomeNode) { // not required
		return nil
	}

	if o.HomeNode != nil {
		if err := o.HomeNode.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateInactiveDataReporting(formats strfmt.Registry) error {
	if swag.IsZero(o.InactiveDataReporting) { // not required
		return nil
	}

	if o.InactiveDataReporting != nil {
		if err := o.InactiveDataReporting.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "inactive_data_reporting")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateInodeAttributes(formats strfmt.Registry) error {
	if swag.IsZero(o.InodeAttributes) { // not required
		return nil
	}

	if o.InodeAttributes != nil {
		if err := o.InodeAttributes.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "inode_attributes")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateMetric(formats strfmt.Registry) error {
	if swag.IsZero(o.Metric) { // not required
		return nil
	}

	if o.Metric != nil {
		if err := o.Metric.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateNode(formats strfmt.Registry) error {
	if swag.IsZero(o.Node) { // not required
		return nil
	}

	if o.Node != nil {
		if err := o.Node.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

var aggregateModifyCollectionBodyTypeSnaplockTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["non_snaplock","compliance","enterprise"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateModifyCollectionBodyTypeSnaplockTypePropEnum = append(aggregateModifyCollectionBodyTypeSnaplockTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// snaplock_type
	// SnaplockType
	// non_snaplock
	// END DEBUGGING
	// AggregateModifyCollectionBodySnaplockTypeNonSnaplock captures enum value "non_snaplock"
	AggregateModifyCollectionBodySnaplockTypeNonSnaplock string = "non_snaplock"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// snaplock_type
	// SnaplockType
	// compliance
	// END DEBUGGING
	// AggregateModifyCollectionBodySnaplockTypeCompliance captures enum value "compliance"
	AggregateModifyCollectionBodySnaplockTypeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// snaplock_type
	// SnaplockType
	// enterprise
	// END DEBUGGING
	// AggregateModifyCollectionBodySnaplockTypeEnterprise captures enum value "enterprise"
	AggregateModifyCollectionBodySnaplockTypeEnterprise string = "enterprise"
)

// prop value enum
func (o *AggregateModifyCollectionBody) validateSnaplockTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateModifyCollectionBodyTypeSnaplockTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateModifyCollectionBody) validateSnaplockType(formats strfmt.Registry) error {
	if swag.IsZero(o.SnaplockType) { // not required
		return nil
	}

	// value enum
	if err := o.validateSnaplockTypeEnum("info"+"."+"snaplock_type", "body", *o.SnaplockType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

var aggregateModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["online","onlining","offline","offlining","relocating","unmounted","restricted","inconsistent","failed","unknown"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateModifyCollectionBodyTypeStatePropEnum = append(aggregateModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// online
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateOnline captures enum value "online"
	AggregateModifyCollectionBodyStateOnline string = "online"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// onlining
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateOnlining captures enum value "onlining"
	AggregateModifyCollectionBodyStateOnlining string = "onlining"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// offline
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateOffline captures enum value "offline"
	AggregateModifyCollectionBodyStateOffline string = "offline"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// offlining
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateOfflining captures enum value "offlining"
	AggregateModifyCollectionBodyStateOfflining string = "offlining"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// relocating
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateRelocating captures enum value "relocating"
	AggregateModifyCollectionBodyStateRelocating string = "relocating"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// unmounted
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateUnmounted captures enum value "unmounted"
	AggregateModifyCollectionBodyStateUnmounted string = "unmounted"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// restricted
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateRestricted captures enum value "restricted"
	AggregateModifyCollectionBodyStateRestricted string = "restricted"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// inconsistent
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateInconsistent captures enum value "inconsistent"
	AggregateModifyCollectionBodyStateInconsistent string = "inconsistent"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// failed
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateFailed captures enum value "failed"
	AggregateModifyCollectionBodyStateFailed string = "failed"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionBody
	// AggregateModifyCollectionBody
	// state
	// State
	// unknown
	// END DEBUGGING
	// AggregateModifyCollectionBodyStateUnknown captures enum value "unknown"
	AggregateModifyCollectionBodyStateUnknown string = "unknown"
)

// prop value enum
func (o *AggregateModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate modify collection body based on the context it is used
func (o *AggregateModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregateResponseInlineRecommendationSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregateResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregateResponseInlineSpares(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregateResponseInlineWarnings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateBlockStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloudStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreateTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDrHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateHomeNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInactiveDataReporting(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInodeAttributes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSpareLow(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMetric(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNode(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateAggregateResponseInlineRecommendationSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AggregateResponseInlineRecommendationSpares); i++ {

		if o.AggregateResponseInlineRecommendationSpares[i] != nil {
			if err := o.AggregateResponseInlineRecommendationSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "recommendation_spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateAggregateResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AggregateResponseInlineRecords); i++ {

		if o.AggregateResponseInlineRecords[i] != nil {
			if err := o.AggregateResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateAggregateResponseInlineSpares(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AggregateResponseInlineSpares); i++ {

		if o.AggregateResponseInlineSpares[i] != nil {
			if err := o.AggregateResponseInlineSpares[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "spares" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateAggregateResponseInlineWarnings(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.AggregateResponseInlineWarnings); i++ {

		if o.AggregateResponseInlineWarnings[i] != nil {
			if err := o.AggregateResponseInlineWarnings[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "warnings" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateBlockStorage(ctx context.Context, formats strfmt.Registry) error {

	if o.BlockStorage != nil {
		if err := o.BlockStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateCloudStorage(ctx context.Context, formats strfmt.Registry) error {

	if o.CloudStorage != nil {
		if err := o.CloudStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateCreateTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"create_time", "body", o.CreateTime); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateDataEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.DataEncryption != nil {
		if err := o.DataEncryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "data_encryption")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateDrHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if o.DrHomeNode != nil {
		if err := o.DrHomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "dr_home_node")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateHomeNode(ctx context.Context, formats strfmt.Registry) error {

	if o.HomeNode != nil {
		if err := o.HomeNode.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateInactiveDataReporting(ctx context.Context, formats strfmt.Registry) error {

	if o.InactiveDataReporting != nil {
		if err := o.InactiveDataReporting.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "inactive_data_reporting")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateInodeAttributes(ctx context.Context, formats strfmt.Registry) error {

	if o.InodeAttributes != nil {
		if err := o.InodeAttributes.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "inode_attributes")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateIsSpareLow(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"is_spare_low", "body", o.IsSpareLow); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateMetric(ctx context.Context, formats strfmt.Registry) error {

	if o.Metric != nil {
		if err := o.Metric.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateNode(ctx context.Context, formats strfmt.Registry) error {

	if o.Node != nil {
		if err := o.Node.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *AggregateModifyCollectionBody) contextValidateVolumeCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"volume-count", "body", o.VolumeCount); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res AggregateModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0 aggregate modify collection params body block storage hybrid cache simulated raid groups items0
swagger:model AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0
*/
type AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0 struct {

	// Number of added data disks in RAID group.
	AddedDataDiskCount *int64 `json:"added_data_disk_count,omitempty"`

	// Number of added parity disks in RAID group.
	AddedParityDiskCount *int64 `json:"added_parity_disk_count,omitempty"`

	// Number of existing data disks in the RAID group.
	ExistingDataDiskCount *int64 `json:"existing_data_disk_count,omitempty"`

	// Number of existing parity disks in the RAID group.
	ExistingParityDiskCount *int64 `json:"existing_parity_disk_count,omitempty"`

	// Indicates whether the disk is partitioned (true) or whole (false).
	IsPartition *bool `json:"is_partition,omitempty"`

	// Name of the raid group.
	Name *string `json:"name,omitempty"`

	// Usable size of each disk, in bytes.
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this aggregate modify collection params body block storage hybrid cache simulated raid groups items0
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this aggregate modify collection params body block storage hybrid cache simulated raid groups items0 based on context it is used
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0 aggregate modify collection params body block storage hybrid cache storage pools items0
swagger:model AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0
*/
type AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0 struct {

	// Allocation count of storage pool.
	AllocationUnitsCount *int32 `json:"allocation_units_count,omitempty"`

	// storage pool
	StoragePool *models.StoragePoolReference `json:"storage_pool,omitempty"`
}

// Validate validates this aggregate modify collection params body block storage hybrid cache storage pools items0
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStoragePool(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) validateStoragePool(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePool) { // not required
		return nil
	}

	if o.StoragePool != nil {
		if err := o.StoragePool.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate modify collection params body block storage hybrid cache storage pools items0 based on the context it is used
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) contextValidateStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if o.StoragePool != nil {
		if err := o.StoragePool.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_pool")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0 aggregate modify collection params body block storage primary simulated raid groups items0
swagger:model AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
*/
type AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0 struct {

	// Number of added data disks in RAID group.
	AddedDataDiskCount *int64 `json:"added_data_disk_count,omitempty"`

	// Number of added parity disks in RAID group.
	AddedParityDiskCount *int64 `json:"added_parity_disk_count,omitempty"`

	// Number of data disks in RAID group.
	DataDiskCount *int64 `json:"data_disk_count,omitempty"`

	// Number of existing data disks in the RAID group.
	ExistingDataDiskCount *int64 `json:"existing_data_disk_count,omitempty"`

	// Number of existing parity disks in the RAID group.
	ExistingParityDiskCount *int64 `json:"existing_parity_disk_count,omitempty"`

	// Indicates whether the disk is partitioned (true) or whole (false).
	IsPartition *bool `json:"is_partition,omitempty"`

	// Name of the raid group.
	Name *string `json:"name,omitempty"`

	// Number of parity disks in RAID group.
	ParityDiskCount *int64 `json:"parity_disk_count,omitempty"`

	// RAID type of the aggregate.
	// Enum: ["raid_dp","raid_tec","raid0","raid4"]
	RaidType *string `json:"raid_type,omitempty"`

	// Usable size of each disk, in bytes.
	UsableSize *int64 `json:"usable_size,omitempty"`
}

// Validate validates this aggregate modify collection params body block storage primary simulated raid groups items0
func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid0","raid4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum = append(aggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidDp captures enum value "raid_dp"
	AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidTec captures enum value "raid_tec"
	AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid0
	// END DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid0 captures enum value "raid0"
	AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid0 string = "raid0"

	// BEGIN DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid4 captures enum value "raid4"
	AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0RaidTypeRaid4 string = "raid4"
)

// prop value enum
func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0TypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(o.RaidType) { // not required
		return nil
	}

	// value enum
	if err := o.validateRaidTypeEnum("raid_type", "body", *o.RaidType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this aggregate modify collection params body block storage primary simulated raid groups items0 based on context it is used
func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0) UnmarshalBinary(b []byte) error {
	var res AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineLinks aggregate inline links
swagger:model aggregate_inline__links
*/
type AggregateInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline links
func (o *AggregateInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline links based on the context it is used
func (o *AggregateInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineBlockStorage Configuration information for the locally attached portion of the aggregate. When a cloud store is also used by this aggregate, this is referred to as the performance tier.
swagger:model aggregate_inline_block_storage
*/
type AggregateInlineBlockStorage struct {

	// hybrid cache
	HybridCache *models.AggregateInlineBlockStorageInlineHybridCache `json:"hybrid_cache,omitempty"`

	// mirror
	Mirror *models.AggregateInlineBlockStorageInlineMirror `json:"mirror,omitempty"`

	// Plex reference for each plex in the aggregate.
	// Read Only: true
	Plexes []*models.PlexReference `json:"plexes,omitempty"`

	// primary
	Primary *models.AggregateInlineBlockStorageInlinePrimary `json:"primary,omitempty"`

	// Type of aggregate.
	// Read Only: true
	// Enum: ["hdd","hybrid","lun","ssd","vmdisk"]
	StorageType *string `json:"storage_type,omitempty"`

	// If true, aggregate is using shared disks.
	// Read Only: true
	UsesPartitions *bool `json:"uses_partitions,omitempty"`
}

// Validate validates this aggregate inline block storage
func (o *AggregateInlineBlockStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateHybridCache(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMirror(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePlexes(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePrimary(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineBlockStorage) validateHybridCache(formats strfmt.Registry) error {
	if swag.IsZero(o.HybridCache) { // not required
		return nil
	}

	if o.HybridCache != nil {
		if err := o.HybridCache.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineBlockStorage) validateMirror(formats strfmt.Registry) error {
	if swag.IsZero(o.Mirror) { // not required
		return nil
	}

	if o.Mirror != nil {
		if err := o.Mirror.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineBlockStorage) validatePlexes(formats strfmt.Registry) error {
	if swag.IsZero(o.Plexes) { // not required
		return nil
	}

	for i := 0; i < len(o.Plexes); i++ {
		if swag.IsZero(o.Plexes[i]) { // not required
			continue
		}

		if o.Plexes[i] != nil {
			if err := o.Plexes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "plexes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateInlineBlockStorage) validatePrimary(formats strfmt.Registry) error {
	if swag.IsZero(o.Primary) { // not required
		return nil
	}

	if o.Primary != nil {
		if err := o.Primary.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineBlockStorageTypeStorageTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["hdd","hybrid","lun","ssd","vmdisk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageTypeStorageTypePropEnum = append(aggregateInlineBlockStorageTypeStorageTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// hdd
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeHdd captures enum value "hdd"
	AggregateInlineBlockStorageStorageTypeHdd string = "hdd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// hybrid
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeHybrid captures enum value "hybrid"
	AggregateInlineBlockStorageStorageTypeHybrid string = "hybrid"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeLun captures enum value "lun"
	AggregateInlineBlockStorageStorageTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageStorageTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage
	// AggregateInlineBlockStorage
	// storage_type
	// StorageType
	// vmdisk
	// END DEBUGGING
	// AggregateInlineBlockStorageStorageTypeVmdisk captures enum value "vmdisk"
	AggregateInlineBlockStorageStorageTypeVmdisk string = "vmdisk"
)

// prop value enum
func (o *AggregateInlineBlockStorage) validateStorageTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageTypeStorageTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorage) validateStorageType(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageType) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageTypeEnum("info"+"."+"block_storage"+"."+"storage_type", "body", *o.StorageType); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline block storage based on the context it is used
func (o *AggregateInlineBlockStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateHybridCache(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMirror(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePlexes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePrimary(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsesPartitions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineBlockStorage) contextValidateHybridCache(ctx context.Context, formats strfmt.Registry) error {

	if o.HybridCache != nil {
		if err := o.HybridCache.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineBlockStorage) contextValidateMirror(ctx context.Context, formats strfmt.Registry) error {

	if o.Mirror != nil {
		if err := o.Mirror.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "mirror")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineBlockStorage) contextValidatePlexes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"plexes", "body", []*models.PlexReference(o.Plexes)); err != nil {
		return err
	}

	for i := 0; i < len(o.Plexes); i++ {

		if o.Plexes[i] != nil {
			if err := o.Plexes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "plexes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateInlineBlockStorage) contextValidatePrimary(ctx context.Context, formats strfmt.Registry) error {

	if o.Primary != nil {
		if err := o.Primary.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "block_storage" + "." + "primary")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineBlockStorage) contextValidateStorageType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"storage_type", "body", o.StorageType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorage) contextValidateUsesPartitions(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"uses_partitions", "body", o.UsesPartitions); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineBlockStorage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineBlockStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineBlockStorageInlineHybridCache Contains the configuration for the hybrid cache. The hybrid cache is made up of either whole SSDs or storage pool SSDs.
swagger:model aggregate_inline_block_storage_inline_hybrid_cache
*/
type AggregateInlineBlockStorageInlineHybridCache struct {

	// Number of disks used in the cache tier of the aggregate. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 6
	DiskCount *int64 `json:"disk_count,omitempty"`

	// Type of disk being used by the aggregate's cache tier.
	// Read Only: true
	// Enum: ["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]
	DiskType *string `json:"disk_type,omitempty"`

	// Specifies whether the aggregate uses HDDs with SSDs as a cache.
	// Read Only: true
	Enabled *bool `json:"enabled,omitempty"`

	// Option to specify the maximum number of disks that can be included in a RAID group.
	// Example: 24
	RaidSize *int64 `json:"raid_size,omitempty"`

	// RAID type for SSD cache of the aggregate. Only provided when hybrid_cache.enabled is 'true'.
	// Enum: ["raid_dp","raid_tec","raid4"]
	RaidType *string `json:"raid_type,omitempty"`

	// simulated raid groups
	SimulatedRaidGroups []*AggregateModifyCollectionParamsBodyBlockStorageHybridCacheSimulatedRaidGroupsItems0 `json:"simulated_raid_groups,omitempty"`

	// Total usable space in bytes of SSD cache. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 1612709888
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// List of storage pool properties and allocation_units_count for aggregate.
	StoragePools []*AggregateModifyCollectionParamsBodyBlockStorageHybridCacheStoragePoolsItems0 `json:"storage_pools,omitempty"`

	// Space used in bytes of SSD cache. Only provided when hybrid_cache.enabled is 'true'.
	// Example: 26501122
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this aggregate inline block storage inline hybrid cache
func (o *AggregateInlineBlockStorageInlineHybridCache) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSimulatedRaidGroups(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStoragePools(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum = append(aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// fc
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeFc captures enum value "fc"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeFc string = "fc"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeLun captures enum value "lun"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// nl_sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeNlSas captures enum value "nl_sas"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeNlSas string = "nl_sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// nvme_ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeNvmeSsd captures enum value "nvme_ssd"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeNvmeSsd string = "nvme_ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSas captures enum value "sas"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// sata
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSata captures enum value "sata"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSata string = "sata"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// scsi
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeScsi captures enum value "scsi"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeScsi string = "scsi"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd_cap
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdCap captures enum value "ssd_cap"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// ssd_zns
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdZns captures enum value "ssd_zns"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// disk_type
	// DiskType
	// vm_disk
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheDiskTypeVMDisk captures enum value "vm_disk"
	AggregateInlineBlockStorageInlineHybridCacheDiskTypeVMDisk string = "vm_disk"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlineHybridCache) validateDiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineHybridCacheTypeDiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) validateDiskType(formats strfmt.Registry) error {
	if swag.IsZero(o.DiskType) { // not required
		return nil
	}

	// value enum
	if err := o.validateDiskTypeEnum("info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"disk_type", "body", *o.DiskType); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid4"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum = append(aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidDp captures enum value "raid_dp"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidTec captures enum value "raid_tec"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_hybrid_cache
	// AggregateInlineBlockStorageInlineHybridCache
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaid4 captures enum value "raid4"
	AggregateInlineBlockStorageInlineHybridCacheRaidTypeRaid4 string = "raid4"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlineHybridCache) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineHybridCacheTypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(o.RaidType) { // not required
		return nil
	}

	// value enum
	if err := o.validateRaidTypeEnum("info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"raid_type", "body", *o.RaidType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) validateSimulatedRaidGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.SimulatedRaidGroups) { // not required
		return nil
	}

	for i := 0; i < len(o.SimulatedRaidGroups); i++ {
		if swag.IsZero(o.SimulatedRaidGroups[i]) { // not required
			continue
		}

		if o.SimulatedRaidGroups[i] != nil {
			if err := o.SimulatedRaidGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) validateStoragePools(formats strfmt.Registry) error {
	if swag.IsZero(o.StoragePools) { // not required
		return nil
	}

	for i := 0; i < len(o.StoragePools); i++ {
		if swag.IsZero(o.StoragePools[i]) { // not required
			continue
		}

		if o.StoragePools[i] != nil {
			if err := o.StoragePools[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache" + "." + "storage_pools" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline hybrid cache based on the context it is used
func (o *AggregateInlineBlockStorageInlineHybridCache) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDiskType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSimulatedRaidGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStoragePools(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateDiskType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"disk_type", "body", o.DiskType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"enabled", "body", o.Enabled); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateSimulatedRaidGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SimulatedRaidGroups); i++ {

		if o.SimulatedRaidGroups[i] != nil {
			if err := o.SimulatedRaidGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateStoragePools(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.StoragePools); i++ {

		if o.StoragePools[i] != nil {
			if err := o.StoragePools[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "hybrid_cache" + "." + "storage_pools" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *AggregateInlineBlockStorageInlineHybridCache) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"hybrid_cache"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlineHybridCache) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlineHybridCache) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlineHybridCache
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineBlockStorageInlineMirror aggregate inline block storage inline mirror
swagger:model aggregate_inline_block_storage_inline_mirror
*/
type AggregateInlineBlockStorageInlineMirror struct {

	// Aggregate is SyncMirror protected
	// Example: false
	Enabled *bool `json:"enabled,omitempty"`

	// state
	// Read Only: true
	// Enum: ["unmirrored","normal","degraded","resynchronizing","failed"]
	State *string `json:"state,omitempty"`
}

// Validate validates this aggregate inline block storage inline mirror
func (o *AggregateInlineBlockStorageInlineMirror) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["unmirrored","normal","degraded","resynchronizing","failed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum = append(aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// unmirrored
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateUnmirrored captures enum value "unmirrored"
	AggregateInlineBlockStorageInlineMirrorStateUnmirrored string = "unmirrored"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// normal
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateNormal captures enum value "normal"
	AggregateInlineBlockStorageInlineMirrorStateNormal string = "normal"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// degraded
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateDegraded captures enum value "degraded"
	AggregateInlineBlockStorageInlineMirrorStateDegraded string = "degraded"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// resynchronizing
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateResynchronizing captures enum value "resynchronizing"
	AggregateInlineBlockStorageInlineMirrorStateResynchronizing string = "resynchronizing"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_mirror
	// AggregateInlineBlockStorageInlineMirror
	// state
	// State
	// failed
	// END DEBUGGING
	// AggregateInlineBlockStorageInlineMirrorStateFailed captures enum value "failed"
	AggregateInlineBlockStorageInlineMirrorStateFailed string = "failed"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlineMirror) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlineMirrorTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlineMirror) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"block_storage"+"."+"mirror"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline mirror based on the context it is used
func (o *AggregateInlineBlockStorageInlineMirror) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlineMirror) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"mirror"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlineMirror) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlineMirror) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlineMirror
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineBlockStorageInlinePrimary Configuration information for the primary storage portion of the aggregate. This excludes the hybrid cache details.
swagger:model aggregate_inline_block_storage_inline_primary
*/
type AggregateInlineBlockStorageInlinePrimary struct {

	// The checksum style used by the aggregate.
	// Enum: ["block","advanced_zoned","mixed"]
	ChecksumStyle *string `json:"checksum_style,omitempty"`

	// The class of disks being used by the aggregate.
	// Example: performance
	// Enum: ["capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]
	DiskClass *string `json:"disk_class,omitempty"`

	// Number of disks used in the aggregate. This includes parity disks, but excludes disks in the hybrid cache.
	// Example: 8
	DiskCount *int64 `json:"disk_count,omitempty"`

	// The type of disk being used by the aggregate.
	// Read Only: true
	// Enum: ["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]
	DiskType *string `json:"disk_type,omitempty"`

	// Option to specify the maximum number of disks that can be included in a RAID group.
	// Example: 16
	RaidSize *int64 `json:"raid_size,omitempty"`

	// RAID type of the aggregate.
	// Enum: ["raid_dp","raid_tec","raid0","raid4","mixed_raid_type"]
	RaidType *string `json:"raid_type,omitempty"`

	// simulated raid groups
	SimulatedRaidGroups []*AggregateModifyCollectionParamsBodyBlockStoragePrimarySimulatedRaidGroupsItems0 `json:"simulated_raid_groups,omitempty"`
}

// Validate validates this aggregate inline block storage inline primary
func (o *AggregateInlineBlockStorageInlinePrimary) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateChecksumStyle(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDiskClass(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDiskType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRaidType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSimulatedRaidGroups(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["block","advanced_zoned","mixed"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// block
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleBlock captures enum value "block"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleBlock string = "block"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// advanced_zoned
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleAdvancedZoned captures enum value "advanced_zoned"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleAdvancedZoned string = "advanced_zoned"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// checksum_style
	// ChecksumStyle
	// mixed
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryChecksumStyleMixed captures enum value "mixed"
	AggregateInlineBlockStorageInlinePrimaryChecksumStyleMixed string = "mixed"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlinePrimary) validateChecksumStyleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeChecksumStylePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) validateChecksumStyle(formats strfmt.Registry) error {
	if swag.IsZero(o.ChecksumStyle) { // not required
		return nil
	}

	// value enum
	if err := o.validateChecksumStyleEnum("info"+"."+"block_storage"+"."+"primary"+"."+"checksum_style", "body", *o.ChecksumStyle); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["capacity","performance","archive","solid_state","array","virtual","data_center","capacity_flash"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// capacity
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassCapacity captures enum value "capacity"
	AggregateInlineBlockStorageInlinePrimaryDiskClassCapacity string = "capacity"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// performance
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassPerformance captures enum value "performance"
	AggregateInlineBlockStorageInlinePrimaryDiskClassPerformance string = "performance"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// archive
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassArchive captures enum value "archive"
	AggregateInlineBlockStorageInlinePrimaryDiskClassArchive string = "archive"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// solid_state
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassSolidState captures enum value "solid_state"
	AggregateInlineBlockStorageInlinePrimaryDiskClassSolidState string = "solid_state"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// array
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassArray captures enum value "array"
	AggregateInlineBlockStorageInlinePrimaryDiskClassArray string = "array"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// virtual
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassVirtual captures enum value "virtual"
	AggregateInlineBlockStorageInlinePrimaryDiskClassVirtual string = "virtual"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// data_center
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassDataCenter captures enum value "data_center"
	AggregateInlineBlockStorageInlinePrimaryDiskClassDataCenter string = "data_center"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_class
	// DiskClass
	// capacity_flash
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskClassCapacityFlash captures enum value "capacity_flash"
	AggregateInlineBlockStorageInlinePrimaryDiskClassCapacityFlash string = "capacity_flash"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlinePrimary) validateDiskClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeDiskClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) validateDiskClass(formats strfmt.Registry) error {
	if swag.IsZero(o.DiskClass) { // not required
		return nil
	}

	// value enum
	if err := o.validateDiskClassEnum("info"+"."+"block_storage"+"."+"primary"+"."+"disk_class", "body", *o.DiskClass); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["fc","lun","nl_sas","nvme_ssd","sas","sata","scsi","ssd","ssd_cap","ssd_zns","vm_disk"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// fc
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeFc captures enum value "fc"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeFc string = "fc"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// lun
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeLun captures enum value "lun"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeLun string = "lun"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// nl_sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeNlSas captures enum value "nl_sas"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeNlSas string = "nl_sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// nvme_ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeNvmeSsd captures enum value "nvme_ssd"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeNvmeSsd string = "nvme_ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// sas
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSas captures enum value "sas"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSas string = "sas"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// sata
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSata captures enum value "sata"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSata string = "sata"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// scsi
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeScsi captures enum value "scsi"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeScsi string = "scsi"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsd captures enum value "ssd"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsd string = "ssd"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd_cap
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdCap captures enum value "ssd_cap"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdCap string = "ssd_cap"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// ssd_zns
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdZns captures enum value "ssd_zns"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeSsdZns string = "ssd_zns"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// disk_type
	// DiskType
	// vm_disk
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryDiskTypeVMDisk captures enum value "vm_disk"
	AggregateInlineBlockStorageInlinePrimaryDiskTypeVMDisk string = "vm_disk"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlinePrimary) validateDiskTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeDiskTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) validateDiskType(formats strfmt.Registry) error {
	if swag.IsZero(o.DiskType) { // not required
		return nil
	}

	// value enum
	if err := o.validateDiskTypeEnum("info"+"."+"block_storage"+"."+"primary"+"."+"disk_type", "body", *o.DiskType); err != nil {
		return err
	}

	return nil
}

var aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["raid_dp","raid_tec","raid0","raid4","mixed_raid_type"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum = append(aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid_dp
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidDp captures enum value "raid_dp"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidDp string = "raid_dp"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid_tec
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidTec captures enum value "raid_tec"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaidTec string = "raid_tec"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid0
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid0 captures enum value "raid0"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid0 string = "raid0"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// raid4
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid4 captures enum value "raid4"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeRaid4 string = "raid4"

	// BEGIN DEBUGGING
	// aggregate_inline_block_storage_inline_primary
	// AggregateInlineBlockStorageInlinePrimary
	// raid_type
	// RaidType
	// mixed_raid_type
	// END DEBUGGING
	// AggregateInlineBlockStorageInlinePrimaryRaidTypeMixedRaidType captures enum value "mixed_raid_type"
	AggregateInlineBlockStorageInlinePrimaryRaidTypeMixedRaidType string = "mixed_raid_type"
)

// prop value enum
func (o *AggregateInlineBlockStorageInlinePrimary) validateRaidTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineBlockStorageInlinePrimaryTypeRaidTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) validateRaidType(formats strfmt.Registry) error {
	if swag.IsZero(o.RaidType) { // not required
		return nil
	}

	// value enum
	if err := o.validateRaidTypeEnum("info"+"."+"block_storage"+"."+"primary"+"."+"raid_type", "body", *o.RaidType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) validateSimulatedRaidGroups(formats strfmt.Registry) error {
	if swag.IsZero(o.SimulatedRaidGroups) { // not required
		return nil
	}

	for i := 0; i < len(o.SimulatedRaidGroups); i++ {
		if swag.IsZero(o.SimulatedRaidGroups[i]) { // not required
			continue
		}

		if o.SimulatedRaidGroups[i] != nil {
			if err := o.SimulatedRaidGroups[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "primary" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline block storage inline primary based on the context it is used
func (o *AggregateInlineBlockStorageInlinePrimary) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDiskType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSimulatedRaidGroups(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) contextValidateDiskType(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"block_storage"+"."+"primary"+"."+"disk_type", "body", o.DiskType); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineBlockStorageInlinePrimary) contextValidateSimulatedRaidGroups(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SimulatedRaidGroups); i++ {

		if o.SimulatedRaidGroups[i] != nil {
			if err := o.SimulatedRaidGroups[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "block_storage" + "." + "primary" + "." + "simulated_raid_groups" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlinePrimary) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineBlockStorageInlinePrimary) UnmarshalBinary(b []byte) error {
	var res AggregateInlineBlockStorageInlinePrimary
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineCloudStorage Configuration information for the cloud storage portion of the aggregate. This is referred to as the capacity tier.
swagger:model aggregate_inline_cloud_storage
*/
type AggregateInlineCloudStorage struct {

	// Specifies whether the aggregate is eligible for a cloud store to be attached.
	// Read Only: true
	AttachEligible *bool `json:"attach_eligible,omitempty"`

	// Specifies the minimum percentage of performance tier free space that must exist in order for migration of data from the capacity tier to performance tier to be allowed. Only valid for PATCH operations.
	MigrateThreshold *int64 `json:"migrate_threshold,omitempty"`

	// Configuration information for each cloud storage portion of the aggregate.
	// Read Only: true
	Stores []*models.CloudStorageTier `json:"stores,omitempty"`

	// The percentage of space in the performance tier that must be used before data is tiered out to the cloud store. Only valid for PATCH operations.
	TieringFullnessThreshold *int64 `json:"tiering_fullness_threshold,omitempty"`
}

// Validate validates this aggregate inline cloud storage
func (o *AggregateInlineCloudStorage) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStores(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineCloudStorage) validateStores(formats strfmt.Registry) error {
	if swag.IsZero(o.Stores) { // not required
		return nil
	}

	for i := 0; i < len(o.Stores); i++ {
		if swag.IsZero(o.Stores[i]) { // not required
			continue
		}

		if o.Stores[i] != nil {
			if err := o.Stores[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cloud_storage" + "." + "stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this aggregate inline cloud storage based on the context it is used
func (o *AggregateInlineCloudStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAttachEligible(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStores(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineCloudStorage) contextValidateAttachEligible(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"cloud_storage"+"."+"attach_eligible", "body", o.AttachEligible); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineCloudStorage) contextValidateStores(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"cloud_storage"+"."+"stores", "body", []*models.CloudStorageTier(o.Stores)); err != nil {
		return err
	}

	for i := 0; i < len(o.Stores); i++ {

		if o.Stores[i] != nil {
			if err := o.Stores[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cloud_storage" + "." + "stores" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineCloudStorage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineCloudStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineCloudStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineDataEncryption aggregate inline data encryption
swagger:model aggregate_inline_data_encryption
*/
type AggregateInlineDataEncryption struct {

	// Specifies whether the aggregate uses self-encrypting drives with data protection enabled.
	// Read Only: true
	DriveProtectionEnabled *bool `json:"drive_protection_enabled,omitempty"`

	// Specifies whether NetApp aggregate encryption is enabled. All data in the aggregate is encrypted.
	SoftwareEncryptionEnabled *bool `json:"software_encryption_enabled,omitempty"`
}

// Validate validates this aggregate inline data encryption
func (o *AggregateInlineDataEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline data encryption based on the context it is used
func (o *AggregateInlineDataEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDriveProtectionEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineDataEncryption) contextValidateDriveProtectionEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"data_encryption"+"."+"drive_protection_enabled", "body", o.DriveProtectionEnabled); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineDataEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineDataEncryption) UnmarshalBinary(b []byte) error {
	var res AggregateInlineDataEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineDrHomeNode Node where the aggregate resides after disaster recovery. The value for this field might differ from the 'node' field during switchover.
swagger:model aggregate_inline_dr_home_node
*/
type AggregateInlineDrHomeNode struct {

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline dr home node
func (o *AggregateInlineDrHomeNode) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline dr home node based on the context it is used
func (o *AggregateInlineDrHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineDrHomeNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineDrHomeNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineDrHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineHomeNode Node where the aggregate resides after giveback. The value for this field might differ from the value of the 'node' field during takeover.
swagger:model aggregate_inline_home_node
*/
type AggregateInlineHomeNode struct {

	// links
	Links *models.AggregateInlineHomeNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline home node
func (o *AggregateInlineHomeNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineHomeNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline home node based on the context it is used
func (o *AggregateInlineHomeNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineHomeNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineHomeNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineHomeNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineHomeNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineHomeNodeInlineLinks aggregate inline home node inline links
swagger:model aggregate_inline_home_node_inline__links
*/
type AggregateInlineHomeNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline home node inline links
func (o *AggregateInlineHomeNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineHomeNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline home node inline links based on the context it is used
func (o *AggregateInlineHomeNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineHomeNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "home_node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineHomeNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineHomeNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineHomeNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineInactiveDataReporting aggregate inline inactive data reporting
swagger:model aggregate_inline_inactive_data_reporting
*/
type AggregateInlineInactiveDataReporting struct {

	// Specifies whether or not inactive data reporting is enabled on the aggregate.
	Enabled *bool `json:"enabled,omitempty"`

	// Timestamp at which inactive data reporting was enabled on the aggregate.
	// Example: 2019-12-12 12:00:00-04:00
	// Read Only: true
	// Format: date-time
	StartTime *strfmt.DateTime `json:"start_time,omitempty"`
}

// Validate validates this aggregate inline inactive data reporting
func (o *AggregateInlineInactiveDataReporting) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStartTime(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineInactiveDataReporting) validateStartTime(formats strfmt.Registry) error {
	if swag.IsZero(o.StartTime) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"inactive_data_reporting"+"."+"start_time", "body", "date-time", o.StartTime.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline inactive data reporting based on the context it is used
func (o *AggregateInlineInactiveDataReporting) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStartTime(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineInactiveDataReporting) contextValidateStartTime(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"inactive_data_reporting"+"."+"start_time", "body", o.StartTime); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineInactiveDataReporting) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineInactiveDataReporting) UnmarshalBinary(b []byte) error {
	var res AggregateInlineInactiveDataReporting
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineInodeAttributes aggregate inline inode attributes
swagger:model aggregate_inline_inode_attributes
*/
type AggregateInlineInodeAttributes struct {

	// Number of files that can currently be stored on disk for system metadata files. This number will dynamically increase as more system files are created.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 31136
	FilePrivateCapacity *int64 `json:"file_private_capacity,omitempty"`

	// Number of files that can currently be stored on disk for user-visible files.  This number will dynamically increase as more user-visible files are created.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 31136
	FilePublicCapacity *int64 `json:"file_public_capacity,omitempty"`

	// Number of system metadata files used. If the referenced file system is restricted or offline, a value of 0 is returned.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 502
	FilesPrivateUsed *int64 `json:"files_private_used,omitempty"`

	// Maximum number of user-visible files that this referenced file system can currently hold. If the referenced file system is restricted or offline, a value of 0 is returned.
	// Example: 31136
	FilesTotal *int64 `json:"files_total,omitempty"`

	// Number of user-visible files used in the referenced file system. If the referenced file system is restricted or offline, a value of 0 is returned.
	// Example: 97
	FilesUsed *int64 `json:"files_used,omitempty"`

	// The count of the maximum number of user-visible files currently allowable on the referenced file system.
	// Example: 31136
	MaxFilesAvailable *int64 `json:"max_files_available,omitempty"`

	// The largest value to which the maxfiles-available parameter can be increased by reconfiguration, on the referenced file system.
	// Example: 2844525
	MaxFilesPossible *int64 `json:"max_files_possible,omitempty"`

	// The number of user-visible files currently in use on the referenced file system.
	// Example: 97
	MaxFilesUsed *int64 `json:"max_files_used,omitempty"`

	// The percentage of disk space currently in use based on user-visible file count on the referenced file system.
	// Example: 5
	// Maximum: 100
	// Minimum: 0
	UsedPercent *int64 `json:"used_percent,omitempty"`

	// The inofile-version of the aggregate. If the referenced file system is restricted or offline, a value of 0 is returned.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 4
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this aggregate inline inode attributes
func (o *AggregateInlineInodeAttributes) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUsedPercent(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineInodeAttributes) validateUsedPercent(formats strfmt.Registry) error {
	if swag.IsZero(o.UsedPercent) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"inode_attributes"+"."+"used_percent", "body", *o.UsedPercent, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"inode_attributes"+"."+"used_percent", "body", *o.UsedPercent, 100, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline inode attributes based on the context it is used
func (o *AggregateInlineInodeAttributes) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineInodeAttributes) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineInodeAttributes) UnmarshalBinary(b []byte) error {
	var res AggregateInlineInodeAttributes
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineMetric The most recent sample of I/O metrics for the aggregate.
swagger:model aggregate_inline_metric
*/
type AggregateInlineMetric struct {

	// links
	Links *models.AggregateInlineMetricInlineLinks `json:"_links,omitempty"`

	// The duration over which this sample is calculated. The time durations are represented in the ISO-8601 standard format. Samples can be calculated over the following durations:
	//
	// Example: PT15S
	// Read Only: true
	// Enum: ["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]
	Duration *string `json:"duration,omitempty"`

	// iops
	Iops *models.AggregateInlineMetricInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.AggregateInlineMetricInlineLatency `json:"latency,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput
	Throughput *models.AggregateInlineMetricInlineThroughput `json:"throughput,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this aggregate inline metric
func (o *AggregateInlineMetric) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateDuration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughput(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineMetric) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineMetricTypeDurationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["PT15S","PT4M","PT30M","PT2H","P1D","PT5M"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineMetricTypeDurationPropEnum = append(aggregateInlineMetricTypeDurationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT15S
	// END DEBUGGING
	// AggregateInlineMetricDurationPT15S captures enum value "PT15S"
	AggregateInlineMetricDurationPT15S string = "PT15S"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT4M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT4M captures enum value "PT4M"
	AggregateInlineMetricDurationPT4M string = "PT4M"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT30M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT30M captures enum value "PT30M"
	AggregateInlineMetricDurationPT30M string = "PT30M"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT2H
	// END DEBUGGING
	// AggregateInlineMetricDurationPT2H captures enum value "PT2H"
	AggregateInlineMetricDurationPT2H string = "PT2H"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// P1D
	// END DEBUGGING
	// AggregateInlineMetricDurationP1D captures enum value "P1D"
	AggregateInlineMetricDurationP1D string = "P1D"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// duration
	// Duration
	// PT5M
	// END DEBUGGING
	// AggregateInlineMetricDurationPT5M captures enum value "PT5M"
	AggregateInlineMetricDurationPT5M string = "PT5M"
)

// prop value enum
func (o *AggregateInlineMetric) validateDurationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineMetricTypeDurationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineMetric) validateDuration(formats strfmt.Registry) error {
	if swag.IsZero(o.Duration) { // not required
		return nil
	}

	// value enum
	if err := o.validateDurationEnum("info"+"."+"metric"+"."+"duration", "body", *o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineMetric) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineMetricTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineMetricTypeStatusPropEnum = append(aggregateInlineMetricTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// ok
	// END DEBUGGING
	// AggregateInlineMetricStatusOk captures enum value "ok"
	AggregateInlineMetricStatusOk string = "ok"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// error
	// END DEBUGGING
	// AggregateInlineMetricStatusError captures enum value "error"
	AggregateInlineMetricStatusError string = "error"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoData captures enum value "partial_no_data"
	AggregateInlineMetricStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoResponse captures enum value "partial_no_response"
	AggregateInlineMetricStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialOtherError captures enum value "partial_other_error"
	AggregateInlineMetricStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// AggregateInlineMetricStatusNegativeDelta captures enum value "negative_delta"
	AggregateInlineMetricStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// not_found
	// END DEBUGGING
	// AggregateInlineMetricStatusNotFound captures enum value "not_found"
	AggregateInlineMetricStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// AggregateInlineMetricStatusBackfilledData captures enum value "backfilled_data"
	AggregateInlineMetricStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// AggregateInlineMetricStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	AggregateInlineMetricStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// AggregateInlineMetricStatusInconsistentOldData captures enum value "inconsistent_old_data"
	AggregateInlineMetricStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// aggregate_inline_metric
	// AggregateInlineMetric
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// AggregateInlineMetricStatusPartialNoUUID captures enum value "partial_no_uuid"
	AggregateInlineMetricStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *AggregateInlineMetric) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineMetricTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineMetric) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"metric"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineMetric) validateThroughput(formats strfmt.Registry) error {
	if swag.IsZero(o.Throughput) { // not required
		return nil
	}

	if o.Throughput != nil {
		if err := o.Throughput.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"metric"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline metric based on the context it is used
func (o *AggregateInlineMetric) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDuration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughput(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineMetric) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateDuration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"duration", "body", o.Duration); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateThroughput(ctx context.Context, formats strfmt.Registry) error {

	if o.Throughput != nil {
		if err := o.Throughput.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "throughput")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineMetric) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"metric"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineMetric) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineMetric) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetric
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineMetricInlineLinks aggregate inline metric inline links
swagger:model aggregate_inline_metric_inline__links
*/
type AggregateInlineMetricInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline metric inline links
func (o *AggregateInlineMetricInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineMetricInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline metric inline links based on the context it is used
func (o *AggregateInlineMetricInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineMetricInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "metric" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineMetricInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineMetricInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineMetricInlineIops The rate of I/O operations observed at the storage object.
swagger:model aggregate_inline_metric_inline_iops
*/
type AggregateInlineMetricInlineIops struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline iops
func (o *AggregateInlineMetricInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline iops based on the context it is used
func (o *AggregateInlineMetricInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineMetricInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineMetricInlineIops) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineMetricInlineLatency The round trip latency in microseconds observed at the storage object.
swagger:model aggregate_inline_metric_inline_latency
*/
type AggregateInlineMetricInlineLatency struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline latency
func (o *AggregateInlineMetricInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline latency based on the context it is used
func (o *AggregateInlineMetricInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineMetricInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineMetricInlineLatency) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineMetricInlineThroughput The rate of throughput bytes per second observed at the storage object.
swagger:model aggregate_inline_metric_inline_throughput
*/
type AggregateInlineMetricInlineThroughput struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline metric inline throughput
func (o *AggregateInlineMetricInlineThroughput) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline metric inline throughput based on the context it is used
func (o *AggregateInlineMetricInlineThroughput) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineMetricInlineThroughput) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineMetricInlineThroughput) UnmarshalBinary(b []byte) error {
	var res AggregateInlineMetricInlineThroughput
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineNode Node where the aggregate currently resides.
swagger:model aggregate_inline_node
*/
type AggregateInlineNode struct {

	// links
	Links *models.AggregateInlineNodeInlineLinks `json:"_links,omitempty"`

	// name
	// Example: node1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this aggregate inline node
func (o *AggregateInlineNode) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineNode) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline node based on the context it is used
func (o *AggregateInlineNode) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineNode) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineNode) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineNode) UnmarshalBinary(b []byte) error {
	var res AggregateInlineNode
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineNodeInlineLinks aggregate inline node inline links
swagger:model aggregate_inline_node_inline__links
*/
type AggregateInlineNodeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this aggregate inline node inline links
func (o *AggregateInlineNodeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineNodeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline node inline links based on the context it is used
func (o *AggregateInlineNodeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineNodeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "node" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineNodeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineNodeInlineLinks) UnmarshalBinary(b []byte) error {
	var res AggregateInlineNodeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSnapshot aggregate inline snapshot
swagger:model aggregate_inline_snapshot
*/
type AggregateInlineSnapshot struct {

	// Total files allowed in snapshots
	// Example: 10
	// Read Only: true
	FilesTotal *int64 `json:"files_total,omitempty"`

	// Total files created in snapshots
	// Example: 3
	// Read Only: true
	FilesUsed *int64 `json:"files_used,omitempty"`

	// Maximum files available for snapshots
	// Example: 5
	// Read Only: true
	MaxFilesAvailable *int64 `json:"max_files_available,omitempty"`

	// Files in use by snapshots
	// Example: 50
	// Read Only: true
	MaxFilesUsed *int64 `json:"max_files_used,omitempty"`
}

// Validate validates this aggregate inline snapshot
func (o *AggregateInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline snapshot based on the context it is used
func (o *AggregateInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFilesTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFilesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxFilesAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMaxFilesUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSnapshot) contextValidateFilesTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot"+"."+"files_total", "body", o.FilesTotal); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSnapshot) contextValidateFilesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot"+"."+"files_used", "body", o.FilesUsed); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSnapshot) contextValidateMaxFilesAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot"+"."+"max_files_available", "body", o.MaxFilesAvailable); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSnapshot) contextValidateMaxFilesUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"snapshot"+"."+"max_files_used", "body", o.MaxFilesUsed); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpace aggregate inline space
swagger:model aggregate_inline_space
*/
type AggregateInlineSpace struct {

	// block storage
	BlockStorage *models.AggregateInlineSpaceInlineBlockStorage `json:"block_storage,omitempty"`

	// cloud storage
	CloudStorage *models.AggregateInlineSpaceInlineCloudStorage `json:"cloud_storage,omitempty"`

	// efficiency
	Efficiency *models.AggregateInlineSpaceInlineEfficiency `json:"efficiency,omitempty"`

	// efficiency without snapshots
	EfficiencyWithoutSnapshots *models.AggregateInlineSpaceInlineEfficiencyWithoutSnapshots `json:"efficiency_without_snapshots,omitempty"`

	// efficiency without snapshots flexclones
	EfficiencyWithoutSnapshotsFlexclones *models.AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones `json:"efficiency_without_snapshots_flexclones,omitempty"`

	// A summation of volume footprints (including volume guarantees), in bytes. This includes all of the volume footprints in the block_storage tier and the cloud_storage tier.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either footprint or **.
	//
	// Example: 608896
	// Read Only: true
	Footprint *int64 `json:"footprint,omitempty"`

	// snapshot
	Snapshot *models.AggregateInlineSpaceInlineSnapshot `json:"snapshot,omitempty"`

	// A summation of volume size, in bytes. This includes all of the volumes inside the aggregate.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either total_provisioned_space or **.
	//
	// Example: 20971520
	// Read Only: true
	TotalProvisionedSpace *int64 `json:"total_provisioned_space,omitempty"`
}

// Validate validates this aggregate inline space
func (o *AggregateInlineSpace) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloudStorage(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEfficiency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEfficiencyWithoutSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEfficiencyWithoutSnapshotsFlexclones(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpace) validateBlockStorage(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockStorage) { // not required
		return nil
	}

	if o.BlockStorage != nil {
		if err := o.BlockStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) validateCloudStorage(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudStorage) { // not required
		return nil
	}

	if o.CloudStorage != nil {
		if err := o.CloudStorage.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) validateEfficiency(formats strfmt.Registry) error {
	if swag.IsZero(o.Efficiency) { // not required
		return nil
	}

	if o.Efficiency != nil {
		if err := o.Efficiency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) validateEfficiencyWithoutSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(o.EfficiencyWithoutSnapshots) { // not required
		return nil
	}

	if o.EfficiencyWithoutSnapshots != nil {
		if err := o.EfficiencyWithoutSnapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) validateEfficiencyWithoutSnapshotsFlexclones(formats strfmt.Registry) error {
	if swag.IsZero(o.EfficiencyWithoutSnapshotsFlexclones) { // not required
		return nil
	}

	if o.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := o.EfficiencyWithoutSnapshotsFlexclones.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this aggregate inline space based on the context it is used
func (o *AggregateInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateBlockStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloudStorage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiencyWithoutSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFootprint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotalProvisionedSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpace) contextValidateBlockStorage(ctx context.Context, formats strfmt.Registry) error {

	if o.BlockStorage != nil {
		if err := o.BlockStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "block_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateCloudStorage(ctx context.Context, formats strfmt.Registry) error {

	if o.CloudStorage != nil {
		if err := o.CloudStorage.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "cloud_storage")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateEfficiency(ctx context.Context, formats strfmt.Registry) error {

	if o.Efficiency != nil {
		if err := o.Efficiency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateEfficiencyWithoutSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if o.EfficiencyWithoutSnapshots != nil {
		if err := o.EfficiencyWithoutSnapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateEfficiencyWithoutSnapshotsFlexclones(ctx context.Context, formats strfmt.Registry) error {

	if o.EfficiencyWithoutSnapshotsFlexclones != nil {
		if err := o.EfficiencyWithoutSnapshotsFlexclones.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "efficiency_without_snapshots_flexclones")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateFootprint(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"footprint", "body", o.Footprint); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "space" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineSpace) contextValidateTotalProvisionedSpace(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"total_provisioned_space", "body", o.TotalProvisionedSpace); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpace) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineBlockStorage aggregate inline space inline block storage
swagger:model aggregate_inline_space_inline_block_storage
*/
type AggregateInlineSpaceInlineBlockStorage struct {

	// Space used by different metafiles and internal operations inside the aggregate, in bytes.
	// Example: 2655
	// Read Only: true
	AggregateMetadata *int64 `json:"aggregate_metadata,omitempty"`

	// Aggregate metadata as a percentage.
	// Example: 8
	// Read Only: true
	AggregateMetadataPercent *int64 `json:"aggregate_metadata_percent,omitempty"`

	// Space available in bytes.
	// Example: 10156560384
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Amount of compacted data in bytes.
	// Example: 1990000
	// Read Only: true
	DataCompactedCount *int64 `json:"data_compacted_count,omitempty"`

	// Space saved in bytes by compacting the data.
	// Example: 1996000
	// Read Only: true
	DataCompactionSpaceSaved *int64 `json:"data_compaction_space_saved,omitempty"`

	// Percentage saved by compacting the data.
	// Example: 27
	// Read Only: true
	DataCompactionSpaceSavedPercent *int64 `json:"data_compaction_space_saved_percent,omitempty"`

	// The aggregate used percentage at which 'monitor.volume.full' EMS is generated.
	// Read Only: true
	FullThresholdPercent *int64 `json:"full_threshold_percent,omitempty"`

	// The size that is physically used in the block storage and has a cold temperature, in bytes. This property is only supported if the aggregate is either attached to a cloud store or can be attached to a cloud store.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either block_storage.inactive_user_data or **.
	//
	// Example: 304448
	// Read Only: true
	InactiveUserData *int64 `json:"inactive_user_data,omitempty"`

	// The percentage of inactive user data in the block storage. This property is only supported if the aggregate is either attached to a cloud store or can be attached to a cloud store.
	// This is an advanced property; there is an added computational cost to retrieving its value. The field is not populated for either a collection GET or an instance GET unless it is explicitly requested using the <i>fields</i> query parameter containing either block_storage.inactive_user_data_percent or **.
	//
	// Read Only: true
	InactiveUserDataPercent *int64 `json:"inactive_user_data_percent,omitempty"`

	// Total physical used size of an aggregate in bytes.
	// Example: 2461696
	// Read Only: true
	PhysicalUsed *int64 `json:"physical_used,omitempty"`

	// Physical used percentage.
	// Example: 50
	// Read Only: true
	PhysicalUsedPercent *int64 `json:"physical_used_percent,omitempty"`

	// Total usable space in bytes, not including WAFL reserve and aggregate snapshot reserve.
	// Example: 10156769280
	// Read Only: true
	Size *int64 `json:"size,omitempty"`

	// Space used or reserved in bytes. Includes volume guarantees and aggregate metadata.
	// Example: 2088960
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Total used including the snapshot reserve, in bytes.
	// Example: 674685
	// Read Only: true
	UsedIncludingSnapshotReserve *int64 `json:"used_including_snapshot_reserve,omitempty"`

	// Total used including the Snapshot reserve as a percentage.
	// Example: 35
	// Read Only: true
	UsedIncludingSnapshotReservePercent *int64 `json:"used_including_snapshot_reserve_percent,omitempty"`

	// Aggregate used percentage.
	// Example: 50
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`

	// Amount of shared bytes counted by storage efficiency.
	// Example: 1990000
	// Read Only: true
	VolumeDeduplicationSharedCount *int64 `json:"volume_deduplication_shared_count,omitempty"`

	// Amount of space saved in bytes by storage efficiency.
	// Example: 1996000
	// Read Only: true
	VolumeDeduplicationSpaceSaved *int64 `json:"volume_deduplication_space_saved,omitempty"`

	// Percentage of space saved by storage efficiency.
	// Example: 27
	// Read Only: true
	VolumeDeduplicationSpaceSavedPercent *int64 `json:"volume_deduplication_space_saved_percent,omitempty"`

	// A summation of volume footprints inside the aggregate, as a percentage. A volume's footprint is the amount of space being used for the volume in the aggregate.
	// Example: 14
	// Read Only: true
	VolumeFootprintsPercent *int64 `json:"volume_footprints_percent,omitempty"`
}

// Validate validates this aggregate inline space inline block storage
func (o *AggregateInlineSpaceInlineBlockStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline block storage based on the context it is used
func (o *AggregateInlineSpaceInlineBlockStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAggregateMetadata(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregateMetadataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataCompactedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataCompactionSpaceSaved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateDataCompactionSpaceSavedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFullThresholdPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInactiveUserData(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateInactiveUserDataPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePhysicalUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedIncludingSnapshotReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedIncludingSnapshotReservePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeDeduplicationSharedCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeDeduplicationSpaceSaved(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeDeduplicationSpaceSavedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolumeFootprintsPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateAggregateMetadata(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"aggregate_metadata", "body", o.AggregateMetadata); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateAggregateMetadataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"aggregate_metadata_percent", "body", o.AggregateMetadataPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"data_compacted_count", "body", o.DataCompactedCount); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactionSpaceSaved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"data_compaction_space_saved", "body", o.DataCompactionSpaceSaved); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateDataCompactionSpaceSavedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"data_compaction_space_saved_percent", "body", o.DataCompactionSpaceSavedPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateFullThresholdPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"full_threshold_percent", "body", o.FullThresholdPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateInactiveUserData(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"inactive_user_data", "body", o.InactiveUserData); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateInactiveUserDataPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"inactive_user_data_percent", "body", o.InactiveUserDataPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidatePhysicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"physical_used", "body", o.PhysicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidatePhysicalUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"physical_used_percent", "body", o.PhysicalUsedPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"size", "body", o.Size); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedIncludingSnapshotReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"used_including_snapshot_reserve", "body", o.UsedIncludingSnapshotReserve); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedIncludingSnapshotReservePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"used_including_snapshot_reserve_percent", "body", o.UsedIncludingSnapshotReservePercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"used_percent", "body", o.UsedPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSharedCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"volume_deduplication_shared_count", "body", o.VolumeDeduplicationSharedCount); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSpaceSaved(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"volume_deduplication_space_saved", "body", o.VolumeDeduplicationSpaceSaved); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeDeduplicationSpaceSavedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"volume_deduplication_space_saved_percent", "body", o.VolumeDeduplicationSpaceSavedPercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineBlockStorage) contextValidateVolumeFootprintsPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"block_storage"+"."+"volume_footprints_percent", "body", o.VolumeFootprintsPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineBlockStorage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineBlockStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineBlockStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineCloudStorage aggregate inline space inline cloud storage
swagger:model aggregate_inline_space_inline_cloud_storage
*/
type AggregateInlineSpaceInlineCloudStorage struct {

	// Used space in bytes in the cloud store. Only applicable for aggregates with a cloud store tier.
	// Example: 402743264
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this aggregate inline space inline cloud storage
func (o *AggregateInlineSpaceInlineCloudStorage) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline cloud storage based on the context it is used
func (o *AggregateInlineSpaceInlineCloudStorage) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineCloudStorage) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"cloud_storage"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineCloudStorage) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineCloudStorage) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineCloudStorage
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineEfficiency Storage efficiency.
swagger:model aggregate_inline_space_inline_efficiency
*/
type AggregateInlineSpaceInlineEfficiency struct {

	// Indicates whether or not aggregate has auto adaptive compression savings.
	// Read Only: true
	AutoAdaptiveCompressionSavings *bool `json:"auto_adaptive_compression_savings,omitempty"`

	// Indicates whether or not cross volume background deduplication is enabled.
	// Read Only: true
	CrossVolumeBackgroundDedupe *bool `json:"cross_volume_background_dedupe,omitempty"`

	// Indicates whether or not aggregate has cross volume deduplication savings.
	// Read Only: true
	CrossVolumeDedupeSavings *bool `json:"cross_volume_dedupe_savings,omitempty"`

	// Indicates whether or not cross volume inline deduplication is enabled.
	// Read Only: true
	CrossVolumeInlineDedupe *bool `json:"cross_volume_inline_dedupe,omitempty"`

	// Indicates whether Workload Informed TSSE is enabled on the system.
	EnableWorkloadInformedTsse *bool `json:"enable_workload_informed_tsse,omitempty"`

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// Minimum amount of used data in aggregate required to trigger cold compression on TSSE volumes.
	WiseTsseMinUsedCapacityPct *int64 `json:"wise_tsse_min_used_capacity_pct,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency
func (o *AggregateInlineSpaceInlineEfficiency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency based on the context it is used
func (o *AggregateInlineSpaceInlineEfficiency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAutoAdaptiveCompressionSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCrossVolumeBackgroundDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCrossVolumeDedupeSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCrossVolumeInlineDedupe(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateAutoAdaptiveCompressionSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"auto_adaptive_compression_savings", "body", o.AutoAdaptiveCompressionSavings); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeBackgroundDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"cross_volume_background_dedupe", "body", o.CrossVolumeBackgroundDedupe); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeDedupeSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"cross_volume_dedupe_savings", "body", o.CrossVolumeDedupeSavings); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateCrossVolumeInlineDedupe(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"cross_volume_inline_dedupe", "body", o.CrossVolumeInlineDedupe); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"logical_used", "body", o.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"ratio", "body", o.Ratio); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiency) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiency) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineEfficiencyWithoutSnapshots Storage efficiency that does not include the savings provided by snapshots.
swagger:model aggregate_inline_space_inline_efficiency_without_snapshots
*/
type AggregateInlineSpaceInlineEfficiencyWithoutSnapshots struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency without snapshots
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency without snapshots based on the context it is used
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots"+"."+"logical_used", "body", o.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots"+"."+"ratio", "body", o.Ratio); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshots) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiencyWithoutSnapshots
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones Storage efficiency that does not include the savings provided by snapshots and Flexclone volumes.
swagger:model aggregate_inline_space_inline_efficiency_without_snapshots_flexclones
*/
type AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones struct {

	// Logical used
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// Data reduction ratio (logical_used / used)
	// Read Only: true
	Ratio *float64 `json:"ratio,omitempty"`

	// Space saved by storage efficiencies (logical_used - used)
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`
}

// Validate validates this aggregate inline space inline efficiency without snapshots flexclones
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline efficiency without snapshots flexclones based on the context it is used
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRatio(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots_flexclones"+"."+"logical_used", "body", o.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateRatio(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots_flexclones"+"."+"ratio", "body", o.Ratio); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"efficiency_without_snapshots_flexclones"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineEfficiencyWithoutSnapshotsFlexclones
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineSpaceInlineSnapshot aggregate inline space inline snapshot
swagger:model aggregate_inline_space_inline_snapshot
*/
type AggregateInlineSpaceInlineSnapshot struct {

	// Available space for snapshots in bytes
	// Example: 2000
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// Percentage of space reserved for snapshots
	// Example: 20
	// Read Only: true
	ReservePercent *int64 `json:"reserve_percent,omitempty"`

	// Total space for snapshots in bytes
	// Example: 5000
	// Read Only: true
	Total *int64 `json:"total,omitempty"`

	// Space used by snapshots in bytes
	// Example: 3000
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// Percentage of disk space used by snapshots
	// Example: 45
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this aggregate inline space inline snapshot
func (o *AggregateInlineSpaceInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline space inline snapshot based on the context it is used
func (o *AggregateInlineSpaceInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReservePercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineSpaceInlineSnapshot) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineSnapshot) contextValidateReservePercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"reserve_percent", "body", o.ReservePercent); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineSnapshot) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineSpaceInlineSnapshot) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"space"+"."+"snapshot"+"."+"used_percent", "body", o.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineSpaceInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res AggregateInlineSpaceInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineStatistics The real time I/O statistics for the aggregate.
swagger:model aggregate_inline_statistics
*/
type AggregateInlineStatistics struct {

	// iops raw
	IopsRaw *models.AggregateInlineStatisticsInlineIopsRaw `json:"iops_raw,omitempty"`

	// latency raw
	LatencyRaw *models.AggregateInlineStatisticsInlineLatencyRaw `json:"latency_raw,omitempty"`

	// Errors associated with the sample. For example, if the aggregation of data over multiple nodes fails, then any partial errors might return "ok" on success or "error" on an internal uncategorized failure. Whenever a sample collection is missed but done at a later time, it is back filled to the previous 15 second timestamp and tagged with "backfilled_data". "Inconsistent_ delta_time" is encountered when the time between two collections is not the same for all nodes. Therefore, the aggregated value might be over or under inflated. "Negative_delta" is returned when an expected monotonically increasing value has decreased in value. "Inconsistent_old_data" is returned when one or more nodes do not have the latest data.
	// Example: ok
	// Read Only: true
	// Enum: ["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]
	Status *string `json:"status,omitempty"`

	// throughput raw
	ThroughputRaw *models.AggregateInlineStatisticsInlineThroughputRaw `json:"throughput_raw,omitempty"`

	// The timestamp of the performance data.
	// Example: 2017-01-25 11:20:13+00:00
	// Read Only: true
	// Format: date-time
	Timestamp *strfmt.DateTime `json:"timestamp,omitempty"`
}

// Validate validates this aggregate inline statistics
func (o *AggregateInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIopsRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatencyRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateThroughputRaw(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTimestamp(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineStatistics) validateIopsRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.IopsRaw) { // not required
		return nil
	}

	if o.IopsRaw != nil {
		if err := o.IopsRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineStatistics) validateLatencyRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.LatencyRaw) { // not required
		return nil
	}

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

var aggregateInlineStatisticsTypeStatusPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["ok","error","partial_no_data","partial_no_response","partial_other_error","negative_delta","not_found","backfilled_data","inconsistent_delta_time","inconsistent_old_data","partial_no_uuid"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		aggregateInlineStatisticsTypeStatusPropEnum = append(aggregateInlineStatisticsTypeStatusPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// ok
	// END DEBUGGING
	// AggregateInlineStatisticsStatusOk captures enum value "ok"
	AggregateInlineStatisticsStatusOk string = "ok"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// error
	// END DEBUGGING
	// AggregateInlineStatisticsStatusError captures enum value "error"
	AggregateInlineStatisticsStatusError string = "error"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoData captures enum value "partial_no_data"
	AggregateInlineStatisticsStatusPartialNoData string = "partial_no_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_response
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoResponse captures enum value "partial_no_response"
	AggregateInlineStatisticsStatusPartialNoResponse string = "partial_no_response"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_other_error
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialOtherError captures enum value "partial_other_error"
	AggregateInlineStatisticsStatusPartialOtherError string = "partial_other_error"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// negative_delta
	// END DEBUGGING
	// AggregateInlineStatisticsStatusNegativeDelta captures enum value "negative_delta"
	AggregateInlineStatisticsStatusNegativeDelta string = "negative_delta"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// not_found
	// END DEBUGGING
	// AggregateInlineStatisticsStatusNotFound captures enum value "not_found"
	AggregateInlineStatisticsStatusNotFound string = "not_found"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// backfilled_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusBackfilledData captures enum value "backfilled_data"
	AggregateInlineStatisticsStatusBackfilledData string = "backfilled_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// inconsistent_delta_time
	// END DEBUGGING
	// AggregateInlineStatisticsStatusInconsistentDeltaTime captures enum value "inconsistent_delta_time"
	AggregateInlineStatisticsStatusInconsistentDeltaTime string = "inconsistent_delta_time"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// inconsistent_old_data
	// END DEBUGGING
	// AggregateInlineStatisticsStatusInconsistentOldData captures enum value "inconsistent_old_data"
	AggregateInlineStatisticsStatusInconsistentOldData string = "inconsistent_old_data"

	// BEGIN DEBUGGING
	// aggregate_inline_statistics
	// AggregateInlineStatistics
	// status
	// Status
	// partial_no_uuid
	// END DEBUGGING
	// AggregateInlineStatisticsStatusPartialNoUUID captures enum value "partial_no_uuid"
	AggregateInlineStatisticsStatusPartialNoUUID string = "partial_no_uuid"
)

// prop value enum
func (o *AggregateInlineStatistics) validateStatusEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, aggregateInlineStatisticsTypeStatusPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *AggregateInlineStatistics) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.Status) { // not required
		return nil
	}

	// value enum
	if err := o.validateStatusEnum("info"+"."+"statistics"+"."+"status", "body", *o.Status); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineStatistics) validateThroughputRaw(formats strfmt.Registry) error {
	if swag.IsZero(o.ThroughputRaw) { // not required
		return nil
	}

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineStatistics) validateTimestamp(formats strfmt.Registry) error {
	if swag.IsZero(o.Timestamp) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"statistics"+"."+"timestamp", "body", "date-time", o.Timestamp.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this aggregate inline statistics based on the context it is used
func (o *AggregateInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIopsRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatencyRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateThroughputRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *AggregateInlineStatistics) contextValidateIopsRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.IopsRaw != nil {
		if err := o.IopsRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops_raw")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineStatistics) contextValidateLatencyRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.LatencyRaw != nil {
		if err := o.LatencyRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency_raw")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineStatistics) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"status", "body", o.Status); err != nil {
		return err
	}

	return nil
}

func (o *AggregateInlineStatistics) contextValidateThroughputRaw(ctx context.Context, formats strfmt.Registry) error {

	if o.ThroughputRaw != nil {
		if err := o.ThroughputRaw.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "throughput_raw")
			}
			return err
		}
	}

	return nil
}

func (o *AggregateInlineStatistics) contextValidateTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"timestamp", "body", o.Timestamp); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineStatistics) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineStatisticsInlineIopsRaw The number of I/O operations observed at the storage object. This can be used along with delta time to calculate the rate of I/O operations per unit of time.
swagger:model aggregate_inline_statistics_inline_iops_raw
*/
type AggregateInlineStatisticsInlineIopsRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline iops raw
func (o *AggregateInlineStatisticsInlineIopsRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline iops raw based on the context it is used
func (o *AggregateInlineStatisticsInlineIopsRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineIopsRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineIopsRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineIopsRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineStatisticsInlineLatencyRaw The raw latency in microseconds observed at the storage object. This can be divided by the raw IOPS value to calculate the average latency per I/O operation.
swagger:model aggregate_inline_statistics_inline_latency_raw
*/
type AggregateInlineStatisticsInlineLatencyRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline latency raw
func (o *AggregateInlineStatisticsInlineLatencyRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline latency raw based on the context it is used
func (o *AggregateInlineStatisticsInlineLatencyRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineLatencyRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineLatencyRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineLatencyRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
AggregateInlineStatisticsInlineThroughputRaw Throughput bytes observed at the storage object. This can be used along with delta time to calculate the rate of throughput bytes per unit of time.
swagger:model aggregate_inline_statistics_inline_throughput_raw
*/
type AggregateInlineStatisticsInlineThroughputRaw struct {

	// Performance metric for other I/O operations. Other I/O operations can be metadata operations, such as directory lookups and so on.
	Other *int64 `json:"other,omitempty"`

	// Performance metric for read I/O operations.
	// Example: 200
	Read *int64 `json:"read,omitempty"`

	// Performance metric aggregated over all types of I/O operations.
	// Example: 1000
	Total *int64 `json:"total,omitempty"`

	// Performance metric for write I/O operations.
	// Example: 100
	Write *int64 `json:"write,omitempty"`
}

// Validate validates this aggregate inline statistics inline throughput raw
func (o *AggregateInlineStatisticsInlineThroughputRaw) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this aggregate inline statistics inline throughput raw based on the context it is used
func (o *AggregateInlineStatisticsInlineThroughputRaw) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineThroughputRaw) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *AggregateInlineStatisticsInlineThroughputRaw) UnmarshalBinary(b []byte) error {
	var res AggregateInlineStatisticsInlineThroughputRaw
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
