// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewAggregateModifyParams creates a new AggregateModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewAggregateModifyParams() *AggregateModifyParams {
	return &AggregateModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewAggregateModifyParamsWithTimeout creates a new AggregateModifyParams object
// with the ability to set a timeout on a request.
func NewAggregateModifyParamsWithTimeout(timeout time.Duration) *AggregateModifyParams {
	return &AggregateModifyParams{
		timeout: timeout,
	}
}

// NewAggregateModifyParamsWithContext creates a new AggregateModifyParams object
// with the ability to set a context for a request.
func NewAggregateModifyParamsWithContext(ctx context.Context) *AggregateModifyParams {
	return &AggregateModifyParams{
		Context: ctx,
	}
}

// NewAggregateModifyParamsWithHTTPClient creates a new AggregateModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewAggregateModifyParamsWithHTTPClient(client *http.Client) *AggregateModifyParams {
	return &AggregateModifyParams{
		HTTPClient: client,
	}
}

/*
AggregateModifyParams contains all the parameters to send to the API endpoint

	for the aggregate modify operation.

	Typically these are written to a http.Request.
*/
type AggregateModifyParams struct {

	/* AutoProvisionPolicy.

	   If set to expand, the PATCH operation runs the recommended expansion of the aggregate.
	*/
	AutoProvisionPolicy *string

	/* DiskSize.

	   If set, PATCH only selects disks of the specified size.
	*/
	DiskSize *int64

	/* Info.

	   Info specification
	*/
	Info *models.Aggregate

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* Simulate.

	   If set to true, the PATCH operation runs a simulated aggregate expansion with the provided input disk count and returns the proposed size of the new aggregate along with any associated warnings.
	*/
	Simulate *bool

	/* UUID.

	   Aggregate UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the aggregate modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateModifyParams) WithDefaults() *AggregateModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the aggregate modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *AggregateModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := AggregateModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the aggregate modify params
func (o *AggregateModifyParams) WithTimeout(timeout time.Duration) *AggregateModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the aggregate modify params
func (o *AggregateModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the aggregate modify params
func (o *AggregateModifyParams) WithContext(ctx context.Context) *AggregateModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the aggregate modify params
func (o *AggregateModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the aggregate modify params
func (o *AggregateModifyParams) WithHTTPClient(client *http.Client) *AggregateModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the aggregate modify params
func (o *AggregateModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutoProvisionPolicy adds the autoProvisionPolicy to the aggregate modify params
func (o *AggregateModifyParams) WithAutoProvisionPolicy(autoProvisionPolicy *string) *AggregateModifyParams {
	o.SetAutoProvisionPolicy(autoProvisionPolicy)
	return o
}

// SetAutoProvisionPolicy adds the autoProvisionPolicy to the aggregate modify params
func (o *AggregateModifyParams) SetAutoProvisionPolicy(autoProvisionPolicy *string) {
	o.AutoProvisionPolicy = autoProvisionPolicy
}

// WithDiskSize adds the diskSize to the aggregate modify params
func (o *AggregateModifyParams) WithDiskSize(diskSize *int64) *AggregateModifyParams {
	o.SetDiskSize(diskSize)
	return o
}

// SetDiskSize adds the diskSize to the aggregate modify params
func (o *AggregateModifyParams) SetDiskSize(diskSize *int64) {
	o.DiskSize = diskSize
}

// WithInfo adds the info to the aggregate modify params
func (o *AggregateModifyParams) WithInfo(info *models.Aggregate) *AggregateModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the aggregate modify params
func (o *AggregateModifyParams) SetInfo(info *models.Aggregate) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the aggregate modify params
func (o *AggregateModifyParams) WithReturnTimeout(returnTimeout *int64) *AggregateModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the aggregate modify params
func (o *AggregateModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSimulate adds the simulate to the aggregate modify params
func (o *AggregateModifyParams) WithSimulate(simulate *bool) *AggregateModifyParams {
	o.SetSimulate(simulate)
	return o
}

// SetSimulate adds the simulate to the aggregate modify params
func (o *AggregateModifyParams) SetSimulate(simulate *bool) {
	o.Simulate = simulate
}

// WithUUID adds the uuid to the aggregate modify params
func (o *AggregateModifyParams) WithUUID(uuid string) *AggregateModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the aggregate modify params
func (o *AggregateModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *AggregateModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AutoProvisionPolicy != nil {

		// query param auto_provision_policy
		var qrAutoProvisionPolicy string

		if o.AutoProvisionPolicy != nil {
			qrAutoProvisionPolicy = *o.AutoProvisionPolicy
		}
		qAutoProvisionPolicy := qrAutoProvisionPolicy
		if qAutoProvisionPolicy != "" {

			if err := r.SetQueryParam("auto_provision_policy", qAutoProvisionPolicy); err != nil {
				return err
			}
		}
	}

	if o.DiskSize != nil {

		// query param disk_size
		var qrDiskSize int64

		if o.DiskSize != nil {
			qrDiskSize = *o.DiskSize
		}
		qDiskSize := swag.FormatInt64(qrDiskSize)
		if qDiskSize != "" {

			if err := r.SetQueryParam("disk_size", qDiskSize); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Simulate != nil {

		// query param simulate
		var qrSimulate bool

		if o.Simulate != nil {
			qrSimulate = *o.Simulate
		}
		qSimulate := swag.FormatBool(qrSimulate)
		if qSimulate != "" {

			if err := r.SetQueryParam("simulate", qSimulate); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
