// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// AggregateModifyReader is a Reader for the AggregateModify structure.
type AggregateModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AggregateModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAggregateModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewAggregateModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewAggregateModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewAggregateModifyOK creates a AggregateModifyOK with default headers values
func NewAggregateModifyOK() *AggregateModifyOK {
	return &AggregateModifyOK{}
}

/*
AggregateModifyOK describes a response with status code 200, with default header values.

OK
*/
type AggregateModifyOK struct {
	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate modify o k response has a 2xx status code
func (o *AggregateModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate modify o k response has a 3xx status code
func (o *AggregateModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate modify o k response has a 4xx status code
func (o *AggregateModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate modify o k response has a 5xx status code
func (o *AggregateModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate modify o k response a status code equal to that given
func (o *AggregateModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the aggregate modify o k response
func (o *AggregateModifyOK) Code() int {
	return 200
}

func (o *AggregateModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregateModifyOK %s", 200, payload)
}

func (o *AggregateModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregateModifyOK %s", 200, payload)
}

func (o *AggregateModifyOK) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateModifyAccepted creates a AggregateModifyAccepted with default headers values
func NewAggregateModifyAccepted() *AggregateModifyAccepted {
	return &AggregateModifyAccepted{}
}

/*
AggregateModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type AggregateModifyAccepted struct {
	Payload *models.AggregateSimulate
}

// IsSuccess returns true when this aggregate modify accepted response has a 2xx status code
func (o *AggregateModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this aggregate modify accepted response has a 3xx status code
func (o *AggregateModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this aggregate modify accepted response has a 4xx status code
func (o *AggregateModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this aggregate modify accepted response has a 5xx status code
func (o *AggregateModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this aggregate modify accepted response a status code equal to that given
func (o *AggregateModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the aggregate modify accepted response
func (o *AggregateModifyAccepted) Code() int {
	return 202
}

func (o *AggregateModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregateModifyAccepted %s", 202, payload)
}

func (o *AggregateModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregateModifyAccepted %s", 202, payload)
}

func (o *AggregateModifyAccepted) GetPayload() *models.AggregateSimulate {
	return o.Payload
}

func (o *AggregateModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.AggregateSimulate)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAggregateModifyDefault creates a AggregateModifyDefault with default headers values
func NewAggregateModifyDefault(code int) *AggregateModifyDefault {
	return &AggregateModifyDefault{
		_statusCode: code,
	}
}

/*
	AggregateModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 262247 | The value is invalid for the field. |
| 460777 | Failed to get information on the job. |
| 786434 | Cannot connect to node where the aggregate resides. |
| 786435 | Internal Error. Failed to create a communication handle. |
| 786439 | An aggregate already uses the specified name. |
| 786447 | Failed to modify the aggregate. |
| 786456 | Failed to add disks to the aggregate. |
| 786458 | Failed to rename aggregate. |
| 786465 | Failed to take aggregate offline because of the reason outlined in the message. |
| 786467 | Failed to take aggregate online because of the reason outlined in the message. |
| 786468 | VLDB is offline. |
| 786472 | Node that hosts the aggregate is offline. |
| 786479 | Cannot find node ID for the node. |
| 786491 | Not enough spares on the node. |
| 786730 | Internal Error |
| 786771 | Aggregate does not exist. |
| 786787 | Aggregate is not online. |
| 786808 | Aggregate mirror failed. |
| 786867 | Specified aggregate resides on the remote cluster. |
| 786911 | Not every node in the cluster has the Data ONTAP version required for the feature. |
| 786923 | This operation is not allowed during the pre-commit phase of a 7-mode to clustered Data ONTAP transition. |
| 786924 | Internal error for an aggregate that is in the pre-commit phase of a 7-mode to clustered Data ONTAP transition. |
| 786955 | Modifying raidtype to raid_tec requires a minimum of six disks in the RAID Group. |
| 786956 | Modifying raidtype to raid_dp requires a minimum of four disks in the RAID Group. |
| 786965 | Spare Selection in userspace failed. |
| 787046 | Mirroring of a FabricPool is not allowed. |
| 787092 | The target field cannot be specified for this operation. |
| 787144 | Aggregate is not a FabricPool. |
| 787156 | Modifying the attributes of mirror object store is not allowed. |
| 787169 | Only one field can be modified per operation. |
| 787170 | Failed to patch the \"block_storage.primary.disk_count\" because the disk count specified is smaller than existing disk count. |
| 787172 | This query is only allowed during the modification of the specified field. |
| 787178 | Unmirroring an aggregate with a PATCH operation is not supported. |
| 787187 | Internal error. Failed to check if the aggregate is a FabricPool. |
| 787266 | Invalid aggregate state. This state is not supported for a PATCH operation. |
| 787273 | Allocation unit count is not valid. |
| 787274 | Raidtype is not valid. |
| 787275 | Patch request with multiple records is not valid. |
| 787276 | Storage pool name and uuid do not match. |
| 787277 | Storage pool name and uuid are empty. |
| 787278 | Incorrect storage pool name specified. |
| 787279 | Incorrect storage pool uuid specified. |
| 787280 | Allocation unit count specified is smaller than the existing allocation unit count. |
| 787281 | Cannot modify RAID type of aggregate hybrid cache tier. |
| 787282 | RAID group must be specified on a disk addition to an aggregate with mixed RAID types. |
| 787283 | RAID group must be specified on a disk addition to a Flash Pool aggregate. |
| 787284 | The specified RAID group uses capacity from one or more storage pools. |
| 787287 | Cannot add physical SSD cache because aggregate uses cache capacity from a storage pool. |
| 787288 | Cannot add storage pool units because aggregate uses physical SSD cache. |
| 787289 | Incorrect raid_group specified during first time addition of physical SSD cache to an aggregate. |
| 787291 | Cannot specify RAID group which is located on the aggregate primary tier. |
| 787293 | Cannot specify RAID group which is located on the aggregate cache tier. |
| 787294 | This query is only allowed during the modification of the specific fields. |
| 787295 | The storage pool allocation units count is required. |
| 1258699 | Cannot use all the disks specified for the requested operation. |
| 1263500 | Operation will lead to creation of new raid group. |
| 1263501 | Operation will exceed half of the maximum volume sizes allowed on the node. |
| 1263502 | One spare data partition from at least one of the chosen root-data1-data2 disks will not be used. |
| 1263503 | Operation will lead to downsizing of one or more disks. |
| 1263504 | Operation will lead to a spares low condition. |
| 1263598 | One or more selected disks will be partitioned. |
| 1263624 | Operation will lead to a no sparecore condition. |
| 2425736 | No matching node found for the UUID provided. |
| 7208962 | Aggregate in an inconsistent state. |
| 7208993 | Failed to offline as the volume is being used. |
| 7209033 | CIFS open files prevent operation. |
| 7209049 | Cannot perform the operation because the aggregate is currently expanding. |
| 7209075 | Cannot perform the operation because the volume size limit for this system type would be exceeded. |
| 7209090 | Inconsistent state. |
| 7209183 | Volume is a partial volume. |
| 7209229 | This version of ONTAP does not recognize the filesystem. It is probably from a later version of the software and is being left offline. |
| 7209246 | The specified operation could not be completed as the volume is currently busy. |
| 7209247 | The volume was not found. |
| 7209263 | Container has failed. |
| 7209271 | wafliron is currently active. |
| 7209275 | Container was created in an unclustered ONTAP deployment. |
| 7209463 | Nvfile replay pending. |
| 7209966 | Another online request is already in progress for aggregate. The previous online request is waiting on a response from the licensing manager. |
| 11206666 | Storage pool is not healthy. |
| 11210659 | Aggregate is not online. |
| 11210662 | Adding capacity from storage pool to a mirrored aggregate is not supported. |
| 11210667 | Storage pool does not have enough spare allocation units. |
| 11210670 | Cannot add capacity from storage pool to aggregate, because currently allocated capacity to the aggregate does not span across all disks belonging to the storage pool. |
| 11210672 | Cannot grow aggregate as no capacity is allocated to it from storage pool. |
| 11210673 | Mixing of physical SSDs and capacity from a storage pool is not allowed in same aggregate. |
| 11210675 | Capacity in storage pool belongs to different fault isolation domain than aggregate. |
| 11210678 | Storage pool does not have enough disks to create RAID groups of same raid type as that of already allocated cache tier. |
| 11210679 | Storage pool does not have enough disks to create RAID groups of type RAID-DP. |
| 11210680 | Storage pool does not have enough disks to create RAID groups of same raid type as that of the aggregate. |
| 11210685 | Storage pool does not have enough disks to create RAID groups of type RAID-TEC. |
| 11210688 | Capacity from storage pool cannot be added to an SSD aggregate and a Flash Pool. |
| 13108106 | Cannot run aggregate relocation because volume expand is in progress. |
| 19726347 | There are a number of unassigned disks visible to the node that owns this aggregate. |
| 19726382 | Another provisioning operation is in progress on this cluster. Wait a few minutes, and try the operation again. |
| 19726390 | Unable to automatically expand this aggregate. |
| 19726391 | Too many unassigned disks visible to the node that owns this aggregate. |
| 19726392 | Layout of this aggregate is not a supported configuration. |
| 19726393 | Failed to expand the aggregate. Aggregate expansion is not supported on this system. |
| 19726394 | Automatic aggregate expansion is not supported on systems with multiple data aggregates. |
| 19726395 | Automatic aggregate expansion is not supported when MetroCluster is not configured. |
| 19726396 | Automatic aggregate expansion is not supported when the DR group is not in a normal state. |
| 19726397 | Aggregates must contain disks with identical disk-types and disk-sizes. |
| 19726402 | Internal error. Unable to determine the MetroCluster configuration state. |
| 19726538 | Cannot perform the operation because the aggregate is not in a healthy state. |
| 19726541 | Cannot perform the operation because the specified aggregate is a root aggregate. |
| 19726544 | PATCH on the aggregate endpoint is not supported on this version of ONTAP. |
| 26542083 | Destination node is at higher Data ONTAP version than source node. |
| 26542084 | Source node is at higher Data ONTAP version than destination node. |
| 26542097 | Unable to get D-blade ID of destination. |
| 26542101 | Unable to contact the source node. |
| 26542102 | Unable to contact the destination node. |
| 26542120 | An SVM migrate operation is in progress. When the migrate operation completes, try the operation again. |
| 26542121 | A MetroCluster disaster recovery operation is in progress. When the recovery operation completes, try the operation again. |
| 196608334 | Failed to modify the aggregate because it contains NAE volumes. |
| 196608335 | Failed to modify the aggregate because it contains non-encrypted volumes. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type AggregateModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this aggregate modify default response has a 2xx status code
func (o *AggregateModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this aggregate modify default response has a 3xx status code
func (o *AggregateModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this aggregate modify default response has a 4xx status code
func (o *AggregateModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this aggregate modify default response has a 5xx status code
func (o *AggregateModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this aggregate modify default response a status code equal to that given
func (o *AggregateModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the aggregate modify default response
func (o *AggregateModifyDefault) Code() int {
	return o._statusCode
}

func (o *AggregateModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregate_modify default %s", o._statusCode, payload)
}

func (o *AggregateModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{uuid}][%d] aggregate_modify default %s", o._statusCode, payload)
}

func (o *AggregateModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *AggregateModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
