// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewCloudStoreCreateParams creates a new CloudStoreCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudStoreCreateParams() *CloudStoreCreateParams {
	return &CloudStoreCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudStoreCreateParamsWithTimeout creates a new CloudStoreCreateParams object
// with the ability to set a timeout on a request.
func NewCloudStoreCreateParamsWithTimeout(timeout time.Duration) *CloudStoreCreateParams {
	return &CloudStoreCreateParams{
		timeout: timeout,
	}
}

// NewCloudStoreCreateParamsWithContext creates a new CloudStoreCreateParams object
// with the ability to set a context for a request.
func NewCloudStoreCreateParamsWithContext(ctx context.Context) *CloudStoreCreateParams {
	return &CloudStoreCreateParams{
		Context: ctx,
	}
}

// NewCloudStoreCreateParamsWithHTTPClient creates a new CloudStoreCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudStoreCreateParamsWithHTTPClient(client *http.Client) *CloudStoreCreateParams {
	return &CloudStoreCreateParams{
		HTTPClient: client,
	}
}

/*
CloudStoreCreateParams contains all the parameters to send to the API endpoint

	for the cloud store create operation.

	Typically these are written to a http.Request.
*/
type CloudStoreCreateParams struct {

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* AllowFlexgroups.

	   This optional parameter allows attaching object store to an aggregate containing FlexGroup constituents. The default value is false. Mixing FabricPools and non-FabricPools within a FlexGroup is not recommended. All aggregates hosting constituents of a FlexGroup should be attached to the object store.
	*/
	AllowFlexgroups *bool

	/* CheckOnly.

	   Validate only and do not add the cloud store.
	*/
	CheckOnly *bool

	/* Info.

	   Info specification
	*/
	Info *models.CloudStore

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud store create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreCreateParams) WithDefaults() *CloudStoreCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud store create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := CloudStoreCreateParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud store create params
func (o *CloudStoreCreateParams) WithTimeout(timeout time.Duration) *CloudStoreCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud store create params
func (o *CloudStoreCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud store create params
func (o *CloudStoreCreateParams) WithContext(ctx context.Context) *CloudStoreCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud store create params
func (o *CloudStoreCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud store create params
func (o *CloudStoreCreateParams) WithHTTPClient(client *http.Client) *CloudStoreCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud store create params
func (o *CloudStoreCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateUUID adds the aggregateUUID to the cloud store create params
func (o *CloudStoreCreateParams) WithAggregateUUID(aggregateUUID string) *CloudStoreCreateParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the cloud store create params
func (o *CloudStoreCreateParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithAllowFlexgroups adds the allowFlexgroups to the cloud store create params
func (o *CloudStoreCreateParams) WithAllowFlexgroups(allowFlexgroups *bool) *CloudStoreCreateParams {
	o.SetAllowFlexgroups(allowFlexgroups)
	return o
}

// SetAllowFlexgroups adds the allowFlexgroups to the cloud store create params
func (o *CloudStoreCreateParams) SetAllowFlexgroups(allowFlexgroups *bool) {
	o.AllowFlexgroups = allowFlexgroups
}

// WithCheckOnly adds the checkOnly to the cloud store create params
func (o *CloudStoreCreateParams) WithCheckOnly(checkOnly *bool) *CloudStoreCreateParams {
	o.SetCheckOnly(checkOnly)
	return o
}

// SetCheckOnly adds the checkOnly to the cloud store create params
func (o *CloudStoreCreateParams) SetCheckOnly(checkOnly *bool) {
	o.CheckOnly = checkOnly
}

// WithInfo adds the info to the cloud store create params
func (o *CloudStoreCreateParams) WithInfo(info *models.CloudStore) *CloudStoreCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cloud store create params
func (o *CloudStoreCreateParams) SetInfo(info *models.CloudStore) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the cloud store create params
func (o *CloudStoreCreateParams) WithReturnRecords(returnRecords *bool) *CloudStoreCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cloud store create params
func (o *CloudStoreCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cloud store create params
func (o *CloudStoreCreateParams) WithReturnTimeout(returnTimeout *int64) *CloudStoreCreateParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud store create params
func (o *CloudStoreCreateParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *CloudStoreCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.AllowFlexgroups != nil {

		// query param allow_flexgroups
		var qrAllowFlexgroups bool

		if o.AllowFlexgroups != nil {
			qrAllowFlexgroups = *o.AllowFlexgroups
		}
		qAllowFlexgroups := swag.FormatBool(qrAllowFlexgroups)
		if qAllowFlexgroups != "" {

			if err := r.SetQueryParam("allow_flexgroups", qAllowFlexgroups); err != nil {
				return err
			}
		}
	}

	if o.CheckOnly != nil {

		// query param check_only
		var qrCheckOnly bool

		if o.CheckOnly != nil {
			qrCheckOnly = *o.CheckOnly
		}
		qCheckOnly := swag.FormatBool(qrCheckOnly)
		if qCheckOnly != "" {

			if err := r.SetQueryParam("check_only", qCheckOnly); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
