// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudStoreDeleteCollectionReader is a Reader for the CloudStoreDeleteCollection structure.
type CloudStoreDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudStoreDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudStoreDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCloudStoreDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudStoreDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudStoreDeleteCollectionOK creates a CloudStoreDeleteCollectionOK with default headers values
func NewCloudStoreDeleteCollectionOK() *CloudStoreDeleteCollectionOK {
	return &CloudStoreDeleteCollectionOK{}
}

/*
CloudStoreDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CloudStoreDeleteCollectionOK struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store delete collection o k response has a 2xx status code
func (o *CloudStoreDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store delete collection o k response has a 3xx status code
func (o *CloudStoreDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store delete collection o k response has a 4xx status code
func (o *CloudStoreDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store delete collection o k response has a 5xx status code
func (o *CloudStoreDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store delete collection o k response a status code equal to that given
func (o *CloudStoreDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud store delete collection o k response
func (o *CloudStoreDeleteCollectionOK) Code() int {
	return 200
}

func (o *CloudStoreDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreDeleteCollectionOK %s", 200, payload)
}

func (o *CloudStoreDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreDeleteCollectionOK %s", 200, payload)
}

func (o *CloudStoreDeleteCollectionOK) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreDeleteCollectionAccepted creates a CloudStoreDeleteCollectionAccepted with default headers values
func NewCloudStoreDeleteCollectionAccepted() *CloudStoreDeleteCollectionAccepted {
	return &CloudStoreDeleteCollectionAccepted{}
}

/*
CloudStoreDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CloudStoreDeleteCollectionAccepted struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store delete collection accepted response has a 2xx status code
func (o *CloudStoreDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store delete collection accepted response has a 3xx status code
func (o *CloudStoreDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store delete collection accepted response has a 4xx status code
func (o *CloudStoreDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store delete collection accepted response has a 5xx status code
func (o *CloudStoreDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store delete collection accepted response a status code equal to that given
func (o *CloudStoreDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cloud store delete collection accepted response
func (o *CloudStoreDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *CloudStoreDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreDeleteCollectionAccepted %s", 202, payload)
}

func (o *CloudStoreDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreDeleteCollectionAccepted %s", 202, payload)
}

func (o *CloudStoreDeleteCollectionAccepted) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreDeleteCollectionDefault creates a CloudStoreDeleteCollectionDefault with default headers values
func NewCloudStoreDeleteCollectionDefault(code int) *CloudStoreDeleteCollectionDefault {
	return &CloudStoreDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	CloudStoreDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3 | Invalid operation |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CloudStoreDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud store delete collection default response has a 2xx status code
func (o *CloudStoreDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud store delete collection default response has a 3xx status code
func (o *CloudStoreDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud store delete collection default response has a 4xx status code
func (o *CloudStoreDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud store delete collection default response has a 5xx status code
func (o *CloudStoreDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud store delete collection default response a status code equal to that given
func (o *CloudStoreDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud store delete collection default response
func (o *CloudStoreDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CloudStoreDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloud_store_delete_collection default %s", o._statusCode, payload)
}

func (o *CloudStoreDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloud_store_delete_collection default %s", o._statusCode, payload)
}

func (o *CloudStoreDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudStoreDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CloudStoreDeleteCollectionBody cloud store delete collection body
swagger:model CloudStoreDeleteCollectionBody
*/
type CloudStoreDeleteCollectionBody struct {

	// cloud store response inline records
	CloudStoreResponseInlineRecords []*models.CloudStore `json:"records,omitempty"`
}

// Validate validates this cloud store delete collection body
func (o *CloudStoreDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateCloudStoreResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreDeleteCollectionBody) validateCloudStoreResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudStoreResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CloudStoreResponseInlineRecords); i++ {
		if swag.IsZero(o.CloudStoreResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CloudStoreResponseInlineRecords[i] != nil {
			if err := o.CloudStoreResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this cloud store delete collection body based on the context it is used
func (o *CloudStoreDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateCloudStoreResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreDeleteCollectionBody) contextValidateCloudStoreResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CloudStoreResponseInlineRecords); i++ {

		if o.CloudStoreResponseInlineRecords[i] != nil {
			if err := o.CloudStoreResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res CloudStoreDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
