// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudStoreDeleteParams creates a new CloudStoreDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudStoreDeleteParams() *CloudStoreDeleteParams {
	return &CloudStoreDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudStoreDeleteParamsWithTimeout creates a new CloudStoreDeleteParams object
// with the ability to set a timeout on a request.
func NewCloudStoreDeleteParamsWithTimeout(timeout time.Duration) *CloudStoreDeleteParams {
	return &CloudStoreDeleteParams{
		timeout: timeout,
	}
}

// NewCloudStoreDeleteParamsWithContext creates a new CloudStoreDeleteParams object
// with the ability to set a context for a request.
func NewCloudStoreDeleteParamsWithContext(ctx context.Context) *CloudStoreDeleteParams {
	return &CloudStoreDeleteParams{
		Context: ctx,
	}
}

// NewCloudStoreDeleteParamsWithHTTPClient creates a new CloudStoreDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudStoreDeleteParamsWithHTTPClient(client *http.Client) *CloudStoreDeleteParams {
	return &CloudStoreDeleteParams{
		HTTPClient: client,
	}
}

/*
CloudStoreDeleteParams contains all the parameters to send to the API endpoint

	for the cloud store delete operation.

	Typically these are written to a http.Request.
*/
type CloudStoreDeleteParams struct {

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* TargetUUID.

	   Cloud target UUID
	*/
	TargetUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud store delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreDeleteParams) WithDefaults() *CloudStoreDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud store delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := CloudStoreDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud store delete params
func (o *CloudStoreDeleteParams) WithTimeout(timeout time.Duration) *CloudStoreDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud store delete params
func (o *CloudStoreDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud store delete params
func (o *CloudStoreDeleteParams) WithContext(ctx context.Context) *CloudStoreDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud store delete params
func (o *CloudStoreDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud store delete params
func (o *CloudStoreDeleteParams) WithHTTPClient(client *http.Client) *CloudStoreDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud store delete params
func (o *CloudStoreDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateUUID adds the aggregateUUID to the cloud store delete params
func (o *CloudStoreDeleteParams) WithAggregateUUID(aggregateUUID string) *CloudStoreDeleteParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the cloud store delete params
func (o *CloudStoreDeleteParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithReturnTimeout adds the returnTimeout to the cloud store delete params
func (o *CloudStoreDeleteParams) WithReturnTimeout(returnTimeout *int64) *CloudStoreDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud store delete params
func (o *CloudStoreDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithTargetUUID adds the targetUUID to the cloud store delete params
func (o *CloudStoreDeleteParams) WithTargetUUID(targetUUID string) *CloudStoreDeleteParams {
	o.SetTargetUUID(targetUUID)
	return o
}

// SetTargetUUID adds the targetUuid to the cloud store delete params
func (o *CloudStoreDeleteParams) SetTargetUUID(targetUUID string) {
	o.TargetUUID = targetUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CloudStoreDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param target.uuid
	if err := r.SetPathParam("target.uuid", o.TargetUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
