// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudStoreDeleteReader is a Reader for the CloudStoreDelete structure.
type CloudStoreDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudStoreDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudStoreDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCloudStoreDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudStoreDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudStoreDeleteOK creates a CloudStoreDeleteOK with default headers values
func NewCloudStoreDeleteOK() *CloudStoreDeleteOK {
	return &CloudStoreDeleteOK{}
}

/*
CloudStoreDeleteOK describes a response with status code 200, with default header values.

OK
*/
type CloudStoreDeleteOK struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store delete o k response has a 2xx status code
func (o *CloudStoreDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store delete o k response has a 3xx status code
func (o *CloudStoreDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store delete o k response has a 4xx status code
func (o *CloudStoreDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store delete o k response has a 5xx status code
func (o *CloudStoreDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store delete o k response a status code equal to that given
func (o *CloudStoreDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud store delete o k response
func (o *CloudStoreDeleteOK) Code() int {
	return 200
}

func (o *CloudStoreDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloudStoreDeleteOK %s", 200, payload)
}

func (o *CloudStoreDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloudStoreDeleteOK %s", 200, payload)
}

func (o *CloudStoreDeleteOK) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreDeleteAccepted creates a CloudStoreDeleteAccepted with default headers values
func NewCloudStoreDeleteAccepted() *CloudStoreDeleteAccepted {
	return &CloudStoreDeleteAccepted{}
}

/*
CloudStoreDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CloudStoreDeleteAccepted struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store delete accepted response has a 2xx status code
func (o *CloudStoreDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store delete accepted response has a 3xx status code
func (o *CloudStoreDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store delete accepted response has a 4xx status code
func (o *CloudStoreDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store delete accepted response has a 5xx status code
func (o *CloudStoreDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store delete accepted response a status code equal to that given
func (o *CloudStoreDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cloud store delete accepted response
func (o *CloudStoreDeleteAccepted) Code() int {
	return 202
}

func (o *CloudStoreDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloudStoreDeleteAccepted %s", 202, payload)
}

func (o *CloudStoreDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloudStoreDeleteAccepted %s", 202, payload)
}

func (o *CloudStoreDeleteAccepted) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreDeleteDefault creates a CloudStoreDeleteDefault with default headers values
func NewCloudStoreDeleteDefault(code int) *CloudStoreDeleteDefault {
	return &CloudStoreDeleteDefault{
		_statusCode: code,
	}
}

/*
	CloudStoreDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 3 | Invalid operation |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CloudStoreDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud store delete default response has a 2xx status code
func (o *CloudStoreDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud store delete default response has a 3xx status code
func (o *CloudStoreDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud store delete default response has a 4xx status code
func (o *CloudStoreDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud store delete default response has a 5xx status code
func (o *CloudStoreDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud store delete default response a status code equal to that given
func (o *CloudStoreDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud store delete default response
func (o *CloudStoreDeleteDefault) Code() int {
	return o._statusCode
}

func (o *CloudStoreDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloud_store_delete default %s", o._statusCode, payload)
}

func (o *CloudStoreDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/aggregates/{aggregate.uuid}/cloud-stores/{target.uuid}][%d] cloud_store_delete default %s", o._statusCode, payload)
}

func (o *CloudStoreDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudStoreDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
