// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudStoreGetParams creates a new CloudStoreGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudStoreGetParams() *CloudStoreGetParams {
	return &CloudStoreGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudStoreGetParamsWithTimeout creates a new CloudStoreGetParams object
// with the ability to set a timeout on a request.
func NewCloudStoreGetParamsWithTimeout(timeout time.Duration) *CloudStoreGetParams {
	return &CloudStoreGetParams{
		timeout: timeout,
	}
}

// NewCloudStoreGetParamsWithContext creates a new CloudStoreGetParams object
// with the ability to set a context for a request.
func NewCloudStoreGetParamsWithContext(ctx context.Context) *CloudStoreGetParams {
	return &CloudStoreGetParams{
		Context: ctx,
	}
}

// NewCloudStoreGetParamsWithHTTPClient creates a new CloudStoreGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudStoreGetParamsWithHTTPClient(client *http.Client) *CloudStoreGetParams {
	return &CloudStoreGetParams{
		HTTPClient: client,
	}
}

/*
CloudStoreGetParams contains all the parameters to send to the API endpoint

	for the cloud store get operation.

	Typically these are written to a http.Request.
*/
type CloudStoreGetParams struct {

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* TargetUUID.

	   Cloud target UUID
	*/
	TargetUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud store get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreGetParams) WithDefaults() *CloudStoreGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud store get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the cloud store get params
func (o *CloudStoreGetParams) WithTimeout(timeout time.Duration) *CloudStoreGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud store get params
func (o *CloudStoreGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud store get params
func (o *CloudStoreGetParams) WithContext(ctx context.Context) *CloudStoreGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud store get params
func (o *CloudStoreGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud store get params
func (o *CloudStoreGetParams) WithHTTPClient(client *http.Client) *CloudStoreGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud store get params
func (o *CloudStoreGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateUUID adds the aggregateUUID to the cloud store get params
func (o *CloudStoreGetParams) WithAggregateUUID(aggregateUUID string) *CloudStoreGetParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the cloud store get params
func (o *CloudStoreGetParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithFields adds the fields to the cloud store get params
func (o *CloudStoreGetParams) WithFields(fields []string) *CloudStoreGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the cloud store get params
func (o *CloudStoreGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithTargetUUID adds the targetUUID to the cloud store get params
func (o *CloudStoreGetParams) WithTargetUUID(targetUUID string) *CloudStoreGetParams {
	o.SetTargetUUID(targetUUID)
	return o
}

// SetTargetUUID adds the targetUuid to the cloud store get params
func (o *CloudStoreGetParams) SetTargetUUID(targetUUID string) {
	o.TargetUUID = targetUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CloudStoreGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param target.uuid
	if err := r.SetPathParam("target.uuid", o.TargetUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamCloudStoreGet binds the parameter fields
func (o *CloudStoreGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
