// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewCloudStoreModifyCollectionParams creates a new CloudStoreModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudStoreModifyCollectionParams() *CloudStoreModifyCollectionParams {
	return &CloudStoreModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudStoreModifyCollectionParamsWithTimeout creates a new CloudStoreModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewCloudStoreModifyCollectionParamsWithTimeout(timeout time.Duration) *CloudStoreModifyCollectionParams {
	return &CloudStoreModifyCollectionParams{
		timeout: timeout,
	}
}

// NewCloudStoreModifyCollectionParamsWithContext creates a new CloudStoreModifyCollectionParams object
// with the ability to set a context for a request.
func NewCloudStoreModifyCollectionParamsWithContext(ctx context.Context) *CloudStoreModifyCollectionParams {
	return &CloudStoreModifyCollectionParams{
		Context: ctx,
	}
}

// NewCloudStoreModifyCollectionParamsWithHTTPClient creates a new CloudStoreModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudStoreModifyCollectionParamsWithHTTPClient(client *http.Client) *CloudStoreModifyCollectionParams {
	return &CloudStoreModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
CloudStoreModifyCollectionParams contains all the parameters to send to the API endpoint

	for the cloud store modify collection operation.

	Typically these are written to a http.Request.
*/
type CloudStoreModifyCollectionParams struct {

	/* AggregateName.

	   Filter by aggregate.name
	*/
	AggregateName *string

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* Availability.

	   Filter by availability
	*/
	Availability *string

	/* AvailabilityAtPartner.

	   Filter by availability_at_partner
	*/
	AvailabilityAtPartner *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info CloudStoreModifyCollectionBody

	/* MirrorDegraded.

	   Filter by mirror_degraded
	*/
	MirrorDegraded *bool

	/* Primary.

	   Filter by primary
	*/
	Primary *bool

	/* ResyncProgress.

	   Filter by resync-progress
	*/
	ResyncProgress *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* TargetName.

	   Filter by target.name
	*/
	TargetName *string

	/* TargetUUID.

	   Filter by target.uuid
	*/
	TargetUUID *string

	/* UnavailableReasonMessage.

	   Filter by unavailable_reason.message
	*/
	UnavailableReasonMessage *string

	/* UnreclaimedSpaceThreshold.

	   Filter by unreclaimed_space_threshold
	*/
	UnreclaimedSpaceThreshold *int64

	/* Used.

	   Filter by used
	*/
	Used *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud store modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreModifyCollectionParams) WithDefaults() *CloudStoreModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud store modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := CloudStoreModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithTimeout(timeout time.Duration) *CloudStoreModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithContext(ctx context.Context) *CloudStoreModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithHTTPClient(client *http.Client) *CloudStoreModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateName adds the aggregateName to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithAggregateName(aggregateName *string) *CloudStoreModifyCollectionParams {
	o.SetAggregateName(aggregateName)
	return o
}

// SetAggregateName adds the aggregateName to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetAggregateName(aggregateName *string) {
	o.AggregateName = aggregateName
}

// WithAggregateUUID adds the aggregateUUID to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithAggregateUUID(aggregateUUID string) *CloudStoreModifyCollectionParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithAvailability adds the availability to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithAvailability(availability *string) *CloudStoreModifyCollectionParams {
	o.SetAvailability(availability)
	return o
}

// SetAvailability adds the availability to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetAvailability(availability *string) {
	o.Availability = availability
}

// WithAvailabilityAtPartner adds the availabilityAtPartner to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithAvailabilityAtPartner(availabilityAtPartner *string) *CloudStoreModifyCollectionParams {
	o.SetAvailabilityAtPartner(availabilityAtPartner)
	return o
}

// SetAvailabilityAtPartner adds the availabilityAtPartner to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetAvailabilityAtPartner(availabilityAtPartner *string) {
	o.AvailabilityAtPartner = availabilityAtPartner
}

// WithContinueOnFailure adds the continueOnFailure to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *CloudStoreModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithInfo(info CloudStoreModifyCollectionBody) *CloudStoreModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetInfo(info CloudStoreModifyCollectionBody) {
	o.Info = info
}

// WithMirrorDegraded adds the mirrorDegraded to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithMirrorDegraded(mirrorDegraded *bool) *CloudStoreModifyCollectionParams {
	o.SetMirrorDegraded(mirrorDegraded)
	return o
}

// SetMirrorDegraded adds the mirrorDegraded to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetMirrorDegraded(mirrorDegraded *bool) {
	o.MirrorDegraded = mirrorDegraded
}

// WithPrimary adds the primary to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithPrimary(primary *bool) *CloudStoreModifyCollectionParams {
	o.SetPrimary(primary)
	return o
}

// SetPrimary adds the primary to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetPrimary(primary *bool) {
	o.Primary = primary
}

// WithResyncProgress adds the resyncProgress to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithResyncProgress(resyncProgress *int64) *CloudStoreModifyCollectionParams {
	o.SetResyncProgress(resyncProgress)
	return o
}

// SetResyncProgress adds the resyncProgress to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetResyncProgress(resyncProgress *int64) {
	o.ResyncProgress = resyncProgress
}

// WithReturnRecords adds the returnRecords to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithReturnRecords(returnRecords *bool) *CloudStoreModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *CloudStoreModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithSerialRecords(serialRecords *bool) *CloudStoreModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithTargetName adds the targetName to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithTargetName(targetName *string) *CloudStoreModifyCollectionParams {
	o.SetTargetName(targetName)
	return o
}

// SetTargetName adds the targetName to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetTargetName(targetName *string) {
	o.TargetName = targetName
}

// WithTargetUUID adds the targetUUID to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithTargetUUID(targetUUID *string) *CloudStoreModifyCollectionParams {
	o.SetTargetUUID(targetUUID)
	return o
}

// SetTargetUUID adds the targetUuid to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetTargetUUID(targetUUID *string) {
	o.TargetUUID = targetUUID
}

// WithUnavailableReasonMessage adds the unavailableReasonMessage to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithUnavailableReasonMessage(unavailableReasonMessage *string) *CloudStoreModifyCollectionParams {
	o.SetUnavailableReasonMessage(unavailableReasonMessage)
	return o
}

// SetUnavailableReasonMessage adds the unavailableReasonMessage to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetUnavailableReasonMessage(unavailableReasonMessage *string) {
	o.UnavailableReasonMessage = unavailableReasonMessage
}

// WithUnreclaimedSpaceThreshold adds the unreclaimedSpaceThreshold to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithUnreclaimedSpaceThreshold(unreclaimedSpaceThreshold *int64) *CloudStoreModifyCollectionParams {
	o.SetUnreclaimedSpaceThreshold(unreclaimedSpaceThreshold)
	return o
}

// SetUnreclaimedSpaceThreshold adds the unreclaimedSpaceThreshold to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetUnreclaimedSpaceThreshold(unreclaimedSpaceThreshold *int64) {
	o.UnreclaimedSpaceThreshold = unreclaimedSpaceThreshold
}

// WithUsed adds the used to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) WithUsed(used *int64) *CloudStoreModifyCollectionParams {
	o.SetUsed(used)
	return o
}

// SetUsed adds the used to the cloud store modify collection params
func (o *CloudStoreModifyCollectionParams) SetUsed(used *int64) {
	o.Used = used
}

// WriteToRequest writes these params to a swagger request
func (o *CloudStoreModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggregateName != nil {

		// query param aggregate.name
		var qrAggregateName string

		if o.AggregateName != nil {
			qrAggregateName = *o.AggregateName
		}
		qAggregateName := qrAggregateName
		if qAggregateName != "" {

			if err := r.SetQueryParam("aggregate.name", qAggregateName); err != nil {
				return err
			}
		}
	}

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.Availability != nil {

		// query param availability
		var qrAvailability string

		if o.Availability != nil {
			qrAvailability = *o.Availability
		}
		qAvailability := qrAvailability
		if qAvailability != "" {

			if err := r.SetQueryParam("availability", qAvailability); err != nil {
				return err
			}
		}
	}

	if o.AvailabilityAtPartner != nil {

		// query param availability_at_partner
		var qrAvailabilityAtPartner string

		if o.AvailabilityAtPartner != nil {
			qrAvailabilityAtPartner = *o.AvailabilityAtPartner
		}
		qAvailabilityAtPartner := qrAvailabilityAtPartner
		if qAvailabilityAtPartner != "" {

			if err := r.SetQueryParam("availability_at_partner", qAvailabilityAtPartner); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.MirrorDegraded != nil {

		// query param mirror_degraded
		var qrMirrorDegraded bool

		if o.MirrorDegraded != nil {
			qrMirrorDegraded = *o.MirrorDegraded
		}
		qMirrorDegraded := swag.FormatBool(qrMirrorDegraded)
		if qMirrorDegraded != "" {

			if err := r.SetQueryParam("mirror_degraded", qMirrorDegraded); err != nil {
				return err
			}
		}
	}

	if o.Primary != nil {

		// query param primary
		var qrPrimary bool

		if o.Primary != nil {
			qrPrimary = *o.Primary
		}
		qPrimary := swag.FormatBool(qrPrimary)
		if qPrimary != "" {

			if err := r.SetQueryParam("primary", qPrimary); err != nil {
				return err
			}
		}
	}

	if o.ResyncProgress != nil {

		// query param resync-progress
		var qrResyncProgress int64

		if o.ResyncProgress != nil {
			qrResyncProgress = *o.ResyncProgress
		}
		qResyncProgress := swag.FormatInt64(qrResyncProgress)
		if qResyncProgress != "" {

			if err := r.SetQueryParam("resync-progress", qResyncProgress); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.TargetName != nil {

		// query param target.name
		var qrTargetName string

		if o.TargetName != nil {
			qrTargetName = *o.TargetName
		}
		qTargetName := qrTargetName
		if qTargetName != "" {

			if err := r.SetQueryParam("target.name", qTargetName); err != nil {
				return err
			}
		}
	}

	if o.TargetUUID != nil {

		// query param target.uuid
		var qrTargetUUID string

		if o.TargetUUID != nil {
			qrTargetUUID = *o.TargetUUID
		}
		qTargetUUID := qrTargetUUID
		if qTargetUUID != "" {

			if err := r.SetQueryParam("target.uuid", qTargetUUID); err != nil {
				return err
			}
		}
	}

	if o.UnavailableReasonMessage != nil {

		// query param unavailable_reason.message
		var qrUnavailableReasonMessage string

		if o.UnavailableReasonMessage != nil {
			qrUnavailableReasonMessage = *o.UnavailableReasonMessage
		}
		qUnavailableReasonMessage := qrUnavailableReasonMessage
		if qUnavailableReasonMessage != "" {

			if err := r.SetQueryParam("unavailable_reason.message", qUnavailableReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.UnreclaimedSpaceThreshold != nil {

		// query param unreclaimed_space_threshold
		var qrUnreclaimedSpaceThreshold int64

		if o.UnreclaimedSpaceThreshold != nil {
			qrUnreclaimedSpaceThreshold = *o.UnreclaimedSpaceThreshold
		}
		qUnreclaimedSpaceThreshold := swag.FormatInt64(qrUnreclaimedSpaceThreshold)
		if qUnreclaimedSpaceThreshold != "" {

			if err := r.SetQueryParam("unreclaimed_space_threshold", qUnreclaimedSpaceThreshold); err != nil {
				return err
			}
		}
	}

	if o.Used != nil {

		// query param used
		var qrUsed int64

		if o.Used != nil {
			qrUsed = *o.Used
		}
		qUsed := swag.FormatInt64(qrUsed)
		if qUsed != "" {

			if err := r.SetQueryParam("used", qUsed); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
