// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// CloudStoreModifyCollectionReader is a Reader for the CloudStoreModifyCollection structure.
type CloudStoreModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CloudStoreModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCloudStoreModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewCloudStoreModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCloudStoreModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCloudStoreModifyCollectionOK creates a CloudStoreModifyCollectionOK with default headers values
func NewCloudStoreModifyCollectionOK() *CloudStoreModifyCollectionOK {
	return &CloudStoreModifyCollectionOK{}
}

/*
CloudStoreModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type CloudStoreModifyCollectionOK struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store modify collection o k response has a 2xx status code
func (o *CloudStoreModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store modify collection o k response has a 3xx status code
func (o *CloudStoreModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store modify collection o k response has a 4xx status code
func (o *CloudStoreModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store modify collection o k response has a 5xx status code
func (o *CloudStoreModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store modify collection o k response a status code equal to that given
func (o *CloudStoreModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cloud store modify collection o k response
func (o *CloudStoreModifyCollectionOK) Code() int {
	return 200
}

func (o *CloudStoreModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreModifyCollectionOK %s", 200, payload)
}

func (o *CloudStoreModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreModifyCollectionOK %s", 200, payload)
}

func (o *CloudStoreModifyCollectionOK) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreModifyCollectionAccepted creates a CloudStoreModifyCollectionAccepted with default headers values
func NewCloudStoreModifyCollectionAccepted() *CloudStoreModifyCollectionAccepted {
	return &CloudStoreModifyCollectionAccepted{}
}

/*
CloudStoreModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type CloudStoreModifyCollectionAccepted struct {
	Payload *models.CloudStoreJobLinkResponse
}

// IsSuccess returns true when this cloud store modify collection accepted response has a 2xx status code
func (o *CloudStoreModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cloud store modify collection accepted response has a 3xx status code
func (o *CloudStoreModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cloud store modify collection accepted response has a 4xx status code
func (o *CloudStoreModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cloud store modify collection accepted response has a 5xx status code
func (o *CloudStoreModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cloud store modify collection accepted response a status code equal to that given
func (o *CloudStoreModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cloud store modify collection accepted response
func (o *CloudStoreModifyCollectionAccepted) Code() int {
	return 202
}

func (o *CloudStoreModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreModifyCollectionAccepted %s", 202, payload)
}

func (o *CloudStoreModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloudStoreModifyCollectionAccepted %s", 202, payload)
}

func (o *CloudStoreModifyCollectionAccepted) GetPayload() *models.CloudStoreJobLinkResponse {
	return o.Payload
}

func (o *CloudStoreModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudStoreJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCloudStoreModifyCollectionDefault creates a CloudStoreModifyCollectionDefault with default headers values
func NewCloudStoreModifyCollectionDefault(code int) *CloudStoreModifyCollectionDefault {
	return &CloudStoreModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	CloudStoreModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 787154 | The Object stores are currently not synchronized. Check the mirror resync status. |
| 787156 | Modifying the attributes of a mirror object store is not allowed. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type CloudStoreModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cloud store modify collection default response has a 2xx status code
func (o *CloudStoreModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cloud store modify collection default response has a 3xx status code
func (o *CloudStoreModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cloud store modify collection default response has a 4xx status code
func (o *CloudStoreModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cloud store modify collection default response has a 5xx status code
func (o *CloudStoreModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cloud store modify collection default response a status code equal to that given
func (o *CloudStoreModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cloud store modify collection default response
func (o *CloudStoreModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *CloudStoreModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloud_store_modify_collection default %s", o._statusCode, payload)
}

func (o *CloudStoreModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/aggregates/{aggregate.uuid}/cloud-stores][%d] cloud_store_modify_collection default %s", o._statusCode, payload)
}

func (o *CloudStoreModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *CloudStoreModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CloudStoreModifyCollectionBody cloud store modify collection body
swagger:model CloudStoreModifyCollectionBody
*/
type CloudStoreModifyCollectionBody struct {

	// links
	Links *models.CloudStoreInlineLinks `json:"_links,omitempty"`

	// aggregate
	Aggregate *models.CloudStoreInlineAggregate `json:"aggregate,omitempty"`

	// Availability of the object store.
	// Read Only: true
	// Enum: ["available","unavailable"]
	Availability *string `json:"availability,omitempty"`

	// Availability of the object store at the HA partner.
	// Read Only: true
	// Enum: ["available","unavailable"]
	AvailabilityAtPartner *string `json:"availability_at_partner,omitempty"`

	// cloud store response inline records
	CloudStoreResponseInlineRecords []*models.CloudStore `json:"records,omitempty"`

	// This field identifies if the mirror cloud store is in sync with the primary cloud store of a FabricPool.
	// Read Only: true
	MirrorDegraded *bool `json:"mirror_degraded,omitempty"`

	// This field indicates whether the cloud store is the primary cloud store of a mirrored FabricPool.
	Primary *bool `json:"primary,omitempty"`

	// Resync progress of the mirror object store in percentage.
	// Read Only: true
	ResyncProgress *int64 `json:"resync-progress,omitempty"`

	// target
	Target *models.CloudStoreInlineTarget `json:"target,omitempty"`

	// unavailable reason
	UnavailableReason *models.CloudStoreInlineUnavailableReason `json:"unavailable_reason,omitempty"`

	// Usage threshold for reclaiming unused space in the cloud store. Valid values are 0 to 99. The default value depends on the provider type. This can be specified in PATCH but not POST.
	// Example: 20
	UnreclaimedSpaceThreshold *int64 `json:"unreclaimed_space_threshold,omitempty"`

	// The amount of object space used. Calculated every 5 minutes and cached.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this cloud store modify collection body
func (o *CloudStoreModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAvailability(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAvailabilityAtPartner(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCloudStoreResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTarget(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUnavailableReason(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) validateAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.Aggregate) { // not required
		return nil
	}

	if o.Aggregate != nil {
		if err := o.Aggregate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "aggregate")
			}
			return err
		}
	}

	return nil
}

var cloudStoreModifyCollectionBodyTypeAvailabilityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","unavailable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudStoreModifyCollectionBodyTypeAvailabilityPropEnum = append(cloudStoreModifyCollectionBodyTypeAvailabilityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudStoreModifyCollectionBody
	// CloudStoreModifyCollectionBody
	// availability
	// Availability
	// available
	// END DEBUGGING
	// CloudStoreModifyCollectionBodyAvailabilityAvailable captures enum value "available"
	CloudStoreModifyCollectionBodyAvailabilityAvailable string = "available"

	// BEGIN DEBUGGING
	// CloudStoreModifyCollectionBody
	// CloudStoreModifyCollectionBody
	// availability
	// Availability
	// unavailable
	// END DEBUGGING
	// CloudStoreModifyCollectionBodyAvailabilityUnavailable captures enum value "unavailable"
	CloudStoreModifyCollectionBodyAvailabilityUnavailable string = "unavailable"
)

// prop value enum
func (o *CloudStoreModifyCollectionBody) validateAvailabilityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudStoreModifyCollectionBodyTypeAvailabilityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudStoreModifyCollectionBody) validateAvailability(formats strfmt.Registry) error {
	if swag.IsZero(o.Availability) { // not required
		return nil
	}

	// value enum
	if err := o.validateAvailabilityEnum("info"+"."+"availability", "body", *o.Availability); err != nil {
		return err
	}

	return nil
}

var cloudStoreModifyCollectionBodyTypeAvailabilityAtPartnerPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["available","unavailable"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		cloudStoreModifyCollectionBodyTypeAvailabilityAtPartnerPropEnum = append(cloudStoreModifyCollectionBodyTypeAvailabilityAtPartnerPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// CloudStoreModifyCollectionBody
	// CloudStoreModifyCollectionBody
	// availability_at_partner
	// AvailabilityAtPartner
	// available
	// END DEBUGGING
	// CloudStoreModifyCollectionBodyAvailabilityAtPartnerAvailable captures enum value "available"
	CloudStoreModifyCollectionBodyAvailabilityAtPartnerAvailable string = "available"

	// BEGIN DEBUGGING
	// CloudStoreModifyCollectionBody
	// CloudStoreModifyCollectionBody
	// availability_at_partner
	// AvailabilityAtPartner
	// unavailable
	// END DEBUGGING
	// CloudStoreModifyCollectionBodyAvailabilityAtPartnerUnavailable captures enum value "unavailable"
	CloudStoreModifyCollectionBodyAvailabilityAtPartnerUnavailable string = "unavailable"
)

// prop value enum
func (o *CloudStoreModifyCollectionBody) validateAvailabilityAtPartnerEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, cloudStoreModifyCollectionBodyTypeAvailabilityAtPartnerPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *CloudStoreModifyCollectionBody) validateAvailabilityAtPartner(formats strfmt.Registry) error {
	if swag.IsZero(o.AvailabilityAtPartner) { // not required
		return nil
	}

	// value enum
	if err := o.validateAvailabilityAtPartnerEnum("info"+"."+"availability_at_partner", "body", *o.AvailabilityAtPartner); err != nil {
		return err
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) validateCloudStoreResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.CloudStoreResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.CloudStoreResponseInlineRecords); i++ {
		if swag.IsZero(o.CloudStoreResponseInlineRecords[i]) { // not required
			continue
		}

		if o.CloudStoreResponseInlineRecords[i] != nil {
			if err := o.CloudStoreResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) validateTarget(formats strfmt.Registry) error {
	if swag.IsZero(o.Target) { // not required
		return nil
	}

	if o.Target != nil {
		if err := o.Target.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) validateUnavailableReason(formats strfmt.Registry) error {
	if swag.IsZero(o.UnavailableReason) { // not required
		return nil
	}

	if o.UnavailableReason != nil {
		if err := o.UnavailableReason.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "unavailable_reason")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud store modify collection body based on the context it is used
func (o *CloudStoreModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAggregate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailability(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAvailabilityAtPartner(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCloudStoreResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMirrorDegraded(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateResyncProgress(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTarget(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUnavailableReason(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateAggregate(ctx context.Context, formats strfmt.Registry) error {

	if o.Aggregate != nil {
		if err := o.Aggregate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "aggregate")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateAvailability(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"availability", "body", o.Availability); err != nil {
		return err
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateAvailabilityAtPartner(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"availability_at_partner", "body", o.AvailabilityAtPartner); err != nil {
		return err
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateCloudStoreResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.CloudStoreResponseInlineRecords); i++ {

		if o.CloudStoreResponseInlineRecords[i] != nil {
			if err := o.CloudStoreResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateMirrorDegraded(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"mirror_degraded", "body", o.MirrorDegraded); err != nil {
		return err
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateResyncProgress(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"resync-progress", "body", o.ResyncProgress); err != nil {
		return err
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateTarget(ctx context.Context, formats strfmt.Registry) error {

	if o.Target != nil {
		if err := o.Target.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateUnavailableReason(ctx context.Context, formats strfmt.Registry) error {

	if o.UnavailableReason != nil {
		if err := o.UnavailableReason.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "unavailable_reason")
			}
			return err
		}
	}

	return nil
}

func (o *CloudStoreModifyCollectionBody) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res CloudStoreModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudStoreInlineLinks cloud store inline links
swagger:model cloud_store_inline__links
*/
type CloudStoreInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cloud store inline links
func (o *CloudStoreInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud store inline links based on the context it is used
func (o *CloudStoreInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudStoreInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudStoreInlineAggregate Aggregate
swagger:model cloud_store_inline_aggregate
*/
type CloudStoreInlineAggregate struct {

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`
}

// Validate validates this cloud store inline aggregate
func (o *CloudStoreInlineAggregate) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this cloud store inline aggregate based on context it is used
func (o *CloudStoreInlineAggregate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreInlineAggregate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreInlineAggregate) UnmarshalBinary(b []byte) error {
	var res CloudStoreInlineAggregate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudStoreInlineTarget Cloud target
swagger:model cloud_store_inline_target
*/
type CloudStoreInlineTarget struct {

	// links
	Links *models.CloudStoreInlineTargetInlineLinks `json:"_links,omitempty"`

	// name
	// Example: target1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this cloud store inline target
func (o *CloudStoreInlineTarget) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineTarget) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud store inline target based on the context it is used
func (o *CloudStoreInlineTarget) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineTarget) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreInlineTarget) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreInlineTarget) UnmarshalBinary(b []byte) error {
	var res CloudStoreInlineTarget
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudStoreInlineTargetInlineLinks cloud store inline target inline links
swagger:model cloud_store_inline_target_inline__links
*/
type CloudStoreInlineTargetInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this cloud store inline target inline links
func (o *CloudStoreInlineTargetInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineTargetInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this cloud store inline target inline links based on the context it is used
func (o *CloudStoreInlineTargetInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineTargetInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "target" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreInlineTargetInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreInlineTargetInlineLinks) UnmarshalBinary(b []byte) error {
	var res CloudStoreInlineTargetInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CloudStoreInlineUnavailableReason cloud store inline unavailable reason
swagger:model cloud_store_inline_unavailable_reason
*/
type CloudStoreInlineUnavailableReason struct {

	// Indicates why the object store is unavailable.
	// Read Only: true
	Message *string `json:"message,omitempty"`
}

// Validate validates this cloud store inline unavailable reason
func (o *CloudStoreInlineUnavailableReason) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this cloud store inline unavailable reason based on the context it is used
func (o *CloudStoreInlineUnavailableReason) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateMessage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CloudStoreInlineUnavailableReason) contextValidateMessage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"unavailable_reason"+"."+"message", "body", o.Message); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CloudStoreInlineUnavailableReason) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CloudStoreInlineUnavailableReason) UnmarshalBinary(b []byte) error {
	var res CloudStoreInlineUnavailableReason
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
