// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewCloudStoreModifyParams creates a new CloudStoreModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCloudStoreModifyParams() *CloudStoreModifyParams {
	return &CloudStoreModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCloudStoreModifyParamsWithTimeout creates a new CloudStoreModifyParams object
// with the ability to set a timeout on a request.
func NewCloudStoreModifyParamsWithTimeout(timeout time.Duration) *CloudStoreModifyParams {
	return &CloudStoreModifyParams{
		timeout: timeout,
	}
}

// NewCloudStoreModifyParamsWithContext creates a new CloudStoreModifyParams object
// with the ability to set a context for a request.
func NewCloudStoreModifyParamsWithContext(ctx context.Context) *CloudStoreModifyParams {
	return &CloudStoreModifyParams{
		Context: ctx,
	}
}

// NewCloudStoreModifyParamsWithHTTPClient creates a new CloudStoreModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewCloudStoreModifyParamsWithHTTPClient(client *http.Client) *CloudStoreModifyParams {
	return &CloudStoreModifyParams{
		HTTPClient: client,
	}
}

/*
CloudStoreModifyParams contains all the parameters to send to the API endpoint

	for the cloud store modify operation.

	Typically these are written to a http.Request.
*/
type CloudStoreModifyParams struct {

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* Info.

	   Info specification
	*/
	Info *models.CloudStore

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* TargetUUID.

	   Cloud target UUID
	*/
	TargetUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cloud store modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreModifyParams) WithDefaults() *CloudStoreModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cloud store modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CloudStoreModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := CloudStoreModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cloud store modify params
func (o *CloudStoreModifyParams) WithTimeout(timeout time.Duration) *CloudStoreModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cloud store modify params
func (o *CloudStoreModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cloud store modify params
func (o *CloudStoreModifyParams) WithContext(ctx context.Context) *CloudStoreModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cloud store modify params
func (o *CloudStoreModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cloud store modify params
func (o *CloudStoreModifyParams) WithHTTPClient(client *http.Client) *CloudStoreModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cloud store modify params
func (o *CloudStoreModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateUUID adds the aggregateUUID to the cloud store modify params
func (o *CloudStoreModifyParams) WithAggregateUUID(aggregateUUID string) *CloudStoreModifyParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the cloud store modify params
func (o *CloudStoreModifyParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithInfo adds the info to the cloud store modify params
func (o *CloudStoreModifyParams) WithInfo(info *models.CloudStore) *CloudStoreModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cloud store modify params
func (o *CloudStoreModifyParams) SetInfo(info *models.CloudStore) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the cloud store modify params
func (o *CloudStoreModifyParams) WithReturnTimeout(returnTimeout *int64) *CloudStoreModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cloud store modify params
func (o *CloudStoreModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithTargetUUID adds the targetUUID to the cloud store modify params
func (o *CloudStoreModifyParams) WithTargetUUID(targetUUID string) *CloudStoreModifyParams {
	o.SetTargetUUID(targetUUID)
	return o
}

// SetTargetUUID adds the targetUuid to the cloud store modify params
func (o *CloudStoreModifyParams) SetTargetUUID(targetUUID string) {
	o.TargetUUID = targetUUID
}

// WriteToRequest writes these params to a swagger request
func (o *CloudStoreModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param target.uuid
	if err := r.SetPathParam("target.uuid", o.TargetUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
