// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewClusterSpaceModifyParams creates a new ClusterSpaceModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewClusterSpaceModifyParams() *ClusterSpaceModifyParams {
	return &ClusterSpaceModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewClusterSpaceModifyParamsWithTimeout creates a new ClusterSpaceModifyParams object
// with the ability to set a timeout on a request.
func NewClusterSpaceModifyParamsWithTimeout(timeout time.Duration) *ClusterSpaceModifyParams {
	return &ClusterSpaceModifyParams{
		timeout: timeout,
	}
}

// NewClusterSpaceModifyParamsWithContext creates a new ClusterSpaceModifyParams object
// with the ability to set a context for a request.
func NewClusterSpaceModifyParamsWithContext(ctx context.Context) *ClusterSpaceModifyParams {
	return &ClusterSpaceModifyParams{
		Context: ctx,
	}
}

// NewClusterSpaceModifyParamsWithHTTPClient creates a new ClusterSpaceModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewClusterSpaceModifyParamsWithHTTPClient(client *http.Client) *ClusterSpaceModifyParams {
	return &ClusterSpaceModifyParams{
		HTTPClient: client,
	}
}

/*
ClusterSpaceModifyParams contains all the parameters to send to the API endpoint

	for the cluster space modify operation.

	Typically these are written to a http.Request.
*/
type ClusterSpaceModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.ClusterSpace

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the cluster space modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterSpaceModifyParams) WithDefaults() *ClusterSpaceModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the cluster space modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ClusterSpaceModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := ClusterSpaceModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the cluster space modify params
func (o *ClusterSpaceModifyParams) WithTimeout(timeout time.Duration) *ClusterSpaceModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the cluster space modify params
func (o *ClusterSpaceModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the cluster space modify params
func (o *ClusterSpaceModifyParams) WithContext(ctx context.Context) *ClusterSpaceModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the cluster space modify params
func (o *ClusterSpaceModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the cluster space modify params
func (o *ClusterSpaceModifyParams) WithHTTPClient(client *http.Client) *ClusterSpaceModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the cluster space modify params
func (o *ClusterSpaceModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the cluster space modify params
func (o *ClusterSpaceModifyParams) WithInfo(info *models.ClusterSpace) *ClusterSpaceModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the cluster space modify params
func (o *ClusterSpaceModifyParams) SetInfo(info *models.ClusterSpace) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the cluster space modify params
func (o *ClusterSpaceModifyParams) WithReturnTimeout(returnTimeout *int64) *ClusterSpaceModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the cluster space modify params
func (o *ClusterSpaceModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WriteToRequest writes these params to a swagger request
func (o *ClusterSpaceModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
