// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ClusterSpaceModifyReader is a Reader for the ClusterSpaceModify structure.
type ClusterSpaceModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ClusterSpaceModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewClusterSpaceModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewClusterSpaceModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewClusterSpaceModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewClusterSpaceModifyOK creates a ClusterSpaceModifyOK with default headers values
func NewClusterSpaceModifyOK() *ClusterSpaceModifyOK {
	return &ClusterSpaceModifyOK{}
}

/*
ClusterSpaceModifyOK describes a response with status code 200, with default header values.

OK
*/
type ClusterSpaceModifyOK struct {
	Payload *models.ClusterSpaceJobLinkResponse
}

// IsSuccess returns true when this cluster space modify o k response has a 2xx status code
func (o *ClusterSpaceModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster space modify o k response has a 3xx status code
func (o *ClusterSpaceModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster space modify o k response has a 4xx status code
func (o *ClusterSpaceModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster space modify o k response has a 5xx status code
func (o *ClusterSpaceModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster space modify o k response a status code equal to that given
func (o *ClusterSpaceModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the cluster space modify o k response
func (o *ClusterSpaceModifyOK) Code() int {
	return 200
}

func (o *ClusterSpaceModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] clusterSpaceModifyOK %s", 200, payload)
}

func (o *ClusterSpaceModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] clusterSpaceModifyOK %s", 200, payload)
}

func (o *ClusterSpaceModifyOK) GetPayload() *models.ClusterSpaceJobLinkResponse {
	return o.Payload
}

func (o *ClusterSpaceModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClusterSpaceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterSpaceModifyAccepted creates a ClusterSpaceModifyAccepted with default headers values
func NewClusterSpaceModifyAccepted() *ClusterSpaceModifyAccepted {
	return &ClusterSpaceModifyAccepted{}
}

/*
ClusterSpaceModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ClusterSpaceModifyAccepted struct {
	Payload *models.ClusterSpaceJobLinkResponse
}

// IsSuccess returns true when this cluster space modify accepted response has a 2xx status code
func (o *ClusterSpaceModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this cluster space modify accepted response has a 3xx status code
func (o *ClusterSpaceModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this cluster space modify accepted response has a 4xx status code
func (o *ClusterSpaceModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this cluster space modify accepted response has a 5xx status code
func (o *ClusterSpaceModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this cluster space modify accepted response a status code equal to that given
func (o *ClusterSpaceModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the cluster space modify accepted response
func (o *ClusterSpaceModifyAccepted) Code() int {
	return 202
}

func (o *ClusterSpaceModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] clusterSpaceModifyAccepted %s", 202, payload)
}

func (o *ClusterSpaceModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] clusterSpaceModifyAccepted %s", 202, payload)
}

func (o *ClusterSpaceModifyAccepted) GetPayload() *models.ClusterSpaceJobLinkResponse {
	return o.Payload
}

func (o *ClusterSpaceModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ClusterSpaceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewClusterSpaceModifyDefault creates a ClusterSpaceModifyDefault with default headers values
func NewClusterSpaceModifyDefault(code int) *ClusterSpaceModifyDefault {
	return &ClusterSpaceModifyDefault{
		_statusCode: code,
	}
}

/*
	ClusterSpaceModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 9240632 | The provided nearly full threshold percent cannot be greater than the full threshold percent. |
| 9240633 | The provided full threshold percent cannot be smaller than the nearly full threshold percent. |
| 9240634 | The provided storage availability zone UUID is not valid. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type ClusterSpaceModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this cluster space modify default response has a 2xx status code
func (o *ClusterSpaceModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this cluster space modify default response has a 3xx status code
func (o *ClusterSpaceModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this cluster space modify default response has a 4xx status code
func (o *ClusterSpaceModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this cluster space modify default response has a 5xx status code
func (o *ClusterSpaceModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this cluster space modify default response a status code equal to that given
func (o *ClusterSpaceModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the cluster space modify default response
func (o *ClusterSpaceModifyDefault) Code() int {
	return o._statusCode
}

func (o *ClusterSpaceModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] cluster_space_modify default %s", o._statusCode, payload)
}

func (o *ClusterSpaceModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/cluster][%d] cluster_space_modify default %s", o._statusCode, payload)
}

func (o *ClusterSpaceModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ClusterSpaceModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
