// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConnectionStatusCollectionGetParams creates a new ConnectionStatusCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConnectionStatusCollectionGetParams() *ConnectionStatusCollectionGetParams {
	return &ConnectionStatusCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConnectionStatusCollectionGetParamsWithTimeout creates a new ConnectionStatusCollectionGetParams object
// with the ability to set a timeout on a request.
func NewConnectionStatusCollectionGetParamsWithTimeout(timeout time.Duration) *ConnectionStatusCollectionGetParams {
	return &ConnectionStatusCollectionGetParams{
		timeout: timeout,
	}
}

// NewConnectionStatusCollectionGetParamsWithContext creates a new ConnectionStatusCollectionGetParams object
// with the ability to set a context for a request.
func NewConnectionStatusCollectionGetParamsWithContext(ctx context.Context) *ConnectionStatusCollectionGetParams {
	return &ConnectionStatusCollectionGetParams{
		Context: ctx,
	}
}

// NewConnectionStatusCollectionGetParamsWithHTTPClient creates a new ConnectionStatusCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewConnectionStatusCollectionGetParamsWithHTTPClient(client *http.Client) *ConnectionStatusCollectionGetParams {
	return &ConnectionStatusCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ConnectionStatusCollectionGetParams contains all the parameters to send to the API endpoint

	for the connection status collection get operation.

	Typically these are written to a http.Request.
*/
type ConnectionStatusCollectionGetParams struct {

	/* ConnState.

	   Filter by conn_state
	*/
	ConnState *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LastUpdateTime.

	   Filter by last_update_time
	*/
	LastUpdateTime *string

	/* LocalFgMsid.

	   Filter by local_fg_msid
	*/
	LocalFgMsid *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Node.

	   Filter by node
	*/
	Node *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RemoteCluster.

	   Filter by remote_cluster
	*/
	RemoteCluster *string

	/* RemoteEndpoint.

	   Filter by remote_endpoint
	*/
	RemoteEndpoint *string

	/* RemoteSvm.

	   Filter by remote_svm
	*/
	RemoteSvm *string

	/* RemoteSvmUUID.

	   Filter by remote_svm_uuid
	*/
	RemoteSvmUUID *string

	/* RemoteVolConstMsid.

	   Filter by remote_vol_const_msid
	*/
	RemoteVolConstMsid *int64

	/* RemoteVolume.

	   Filter by remote_volume
	*/
	RemoteVolume *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Svm.

	   Filter by svm
	*/
	Svm *string

	/* SvmUUID.

	   Filter by svm_uuid
	*/
	SvmUUID *string

	/* Volume.

	   Filter by volume
	*/
	Volume *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the connection status collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConnectionStatusCollectionGetParams) WithDefaults() *ConnectionStatusCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the connection status collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConnectionStatusCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ConnectionStatusCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithTimeout(timeout time.Duration) *ConnectionStatusCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithContext(ctx context.Context) *ConnectionStatusCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithHTTPClient(client *http.Client) *ConnectionStatusCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithConnState adds the connState to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithConnState(connState *string) *ConnectionStatusCollectionGetParams {
	o.SetConnState(connState)
	return o
}

// SetConnState adds the connState to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetConnState(connState *string) {
	o.ConnState = connState
}

// WithFields adds the fields to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithFields(fields []string) *ConnectionStatusCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLastUpdateTime adds the lastUpdateTime to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithLastUpdateTime(lastUpdateTime *string) *ConnectionStatusCollectionGetParams {
	o.SetLastUpdateTime(lastUpdateTime)
	return o
}

// SetLastUpdateTime adds the lastUpdateTime to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetLastUpdateTime(lastUpdateTime *string) {
	o.LastUpdateTime = lastUpdateTime
}

// WithLocalFgMsid adds the localFgMsid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithLocalFgMsid(localFgMsid *int64) *ConnectionStatusCollectionGetParams {
	o.SetLocalFgMsid(localFgMsid)
	return o
}

// SetLocalFgMsid adds the localFgMsid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetLocalFgMsid(localFgMsid *int64) {
	o.LocalFgMsid = localFgMsid
}

// WithMaxRecords adds the maxRecords to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithMaxRecords(maxRecords *int64) *ConnectionStatusCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithNode adds the node to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithNode(node *string) *ConnectionStatusCollectionGetParams {
	o.SetNode(node)
	return o
}

// SetNode adds the node to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetNode(node *string) {
	o.Node = node
}

// WithOrderBy adds the orderBy to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithOrderBy(orderBy []string) *ConnectionStatusCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRemoteCluster adds the remoteCluster to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteCluster(remoteCluster *string) *ConnectionStatusCollectionGetParams {
	o.SetRemoteCluster(remoteCluster)
	return o
}

// SetRemoteCluster adds the remoteCluster to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteCluster(remoteCluster *string) {
	o.RemoteCluster = remoteCluster
}

// WithRemoteEndpoint adds the remoteEndpoint to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteEndpoint(remoteEndpoint *string) *ConnectionStatusCollectionGetParams {
	o.SetRemoteEndpoint(remoteEndpoint)
	return o
}

// SetRemoteEndpoint adds the remoteEndpoint to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteEndpoint(remoteEndpoint *string) {
	o.RemoteEndpoint = remoteEndpoint
}

// WithRemoteSvm adds the remoteSvm to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteSvm(remoteSvm *string) *ConnectionStatusCollectionGetParams {
	o.SetRemoteSvm(remoteSvm)
	return o
}

// SetRemoteSvm adds the remoteSvm to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteSvm(remoteSvm *string) {
	o.RemoteSvm = remoteSvm
}

// WithRemoteSvmUUID adds the remoteSvmUUID to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteSvmUUID(remoteSvmUUID *string) *ConnectionStatusCollectionGetParams {
	o.SetRemoteSvmUUID(remoteSvmUUID)
	return o
}

// SetRemoteSvmUUID adds the remoteSvmUuid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteSvmUUID(remoteSvmUUID *string) {
	o.RemoteSvmUUID = remoteSvmUUID
}

// WithRemoteVolConstMsid adds the remoteVolConstMsid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteVolConstMsid(remoteVolConstMsid *int64) *ConnectionStatusCollectionGetParams {
	o.SetRemoteVolConstMsid(remoteVolConstMsid)
	return o
}

// SetRemoteVolConstMsid adds the remoteVolConstMsid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteVolConstMsid(remoteVolConstMsid *int64) {
	o.RemoteVolConstMsid = remoteVolConstMsid
}

// WithRemoteVolume adds the remoteVolume to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithRemoteVolume(remoteVolume *string) *ConnectionStatusCollectionGetParams {
	o.SetRemoteVolume(remoteVolume)
	return o
}

// SetRemoteVolume adds the remoteVolume to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetRemoteVolume(remoteVolume *string) {
	o.RemoteVolume = remoteVolume
}

// WithReturnRecords adds the returnRecords to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithReturnRecords(returnRecords *bool) *ConnectionStatusCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ConnectionStatusCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvm adds the svm to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithSvm(svm *string) *ConnectionStatusCollectionGetParams {
	o.SetSvm(svm)
	return o
}

// SetSvm adds the svm to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetSvm(svm *string) {
	o.Svm = svm
}

// WithSvmUUID adds the svmUUID to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithSvmUUID(svmUUID *string) *ConnectionStatusCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithVolume adds the volume to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) WithVolume(volume *string) *ConnectionStatusCollectionGetParams {
	o.SetVolume(volume)
	return o
}

// SetVolume adds the volume to the connection status collection get params
func (o *ConnectionStatusCollectionGetParams) SetVolume(volume *string) {
	o.Volume = volume
}

// WriteToRequest writes these params to a swagger request
func (o *ConnectionStatusCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ConnState != nil {

		// query param conn_state
		var qrConnState string

		if o.ConnState != nil {
			qrConnState = *o.ConnState
		}
		qConnState := qrConnState
		if qConnState != "" {

			if err := r.SetQueryParam("conn_state", qConnState); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.LastUpdateTime != nil {

		// query param last_update_time
		var qrLastUpdateTime string

		if o.LastUpdateTime != nil {
			qrLastUpdateTime = *o.LastUpdateTime
		}
		qLastUpdateTime := qrLastUpdateTime
		if qLastUpdateTime != "" {

			if err := r.SetQueryParam("last_update_time", qLastUpdateTime); err != nil {
				return err
			}
		}
	}

	if o.LocalFgMsid != nil {

		// query param local_fg_msid
		var qrLocalFgMsid int64

		if o.LocalFgMsid != nil {
			qrLocalFgMsid = *o.LocalFgMsid
		}
		qLocalFgMsid := swag.FormatInt64(qrLocalFgMsid)
		if qLocalFgMsid != "" {

			if err := r.SetQueryParam("local_fg_msid", qLocalFgMsid); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Node != nil {

		// query param node
		var qrNode string

		if o.Node != nil {
			qrNode = *o.Node
		}
		qNode := qrNode
		if qNode != "" {

			if err := r.SetQueryParam("node", qNode); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RemoteCluster != nil {

		// query param remote_cluster
		var qrRemoteCluster string

		if o.RemoteCluster != nil {
			qrRemoteCluster = *o.RemoteCluster
		}
		qRemoteCluster := qrRemoteCluster
		if qRemoteCluster != "" {

			if err := r.SetQueryParam("remote_cluster", qRemoteCluster); err != nil {
				return err
			}
		}
	}

	if o.RemoteEndpoint != nil {

		// query param remote_endpoint
		var qrRemoteEndpoint string

		if o.RemoteEndpoint != nil {
			qrRemoteEndpoint = *o.RemoteEndpoint
		}
		qRemoteEndpoint := qrRemoteEndpoint
		if qRemoteEndpoint != "" {

			if err := r.SetQueryParam("remote_endpoint", qRemoteEndpoint); err != nil {
				return err
			}
		}
	}

	if o.RemoteSvm != nil {

		// query param remote_svm
		var qrRemoteSvm string

		if o.RemoteSvm != nil {
			qrRemoteSvm = *o.RemoteSvm
		}
		qRemoteSvm := qrRemoteSvm
		if qRemoteSvm != "" {

			if err := r.SetQueryParam("remote_svm", qRemoteSvm); err != nil {
				return err
			}
		}
	}

	if o.RemoteSvmUUID != nil {

		// query param remote_svm_uuid
		var qrRemoteSvmUUID string

		if o.RemoteSvmUUID != nil {
			qrRemoteSvmUUID = *o.RemoteSvmUUID
		}
		qRemoteSvmUUID := qrRemoteSvmUUID
		if qRemoteSvmUUID != "" {

			if err := r.SetQueryParam("remote_svm_uuid", qRemoteSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.RemoteVolConstMsid != nil {

		// query param remote_vol_const_msid
		var qrRemoteVolConstMsid int64

		if o.RemoteVolConstMsid != nil {
			qrRemoteVolConstMsid = *o.RemoteVolConstMsid
		}
		qRemoteVolConstMsid := swag.FormatInt64(qrRemoteVolConstMsid)
		if qRemoteVolConstMsid != "" {

			if err := r.SetQueryParam("remote_vol_const_msid", qRemoteVolConstMsid); err != nil {
				return err
			}
		}
	}

	if o.RemoteVolume != nil {

		// query param remote_volume
		var qrRemoteVolume string

		if o.RemoteVolume != nil {
			qrRemoteVolume = *o.RemoteVolume
		}
		qRemoteVolume := qrRemoteVolume
		if qRemoteVolume != "" {

			if err := r.SetQueryParam("remote_volume", qRemoteVolume); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Svm != nil {

		// query param svm
		var qrSvm string

		if o.Svm != nil {
			qrSvm = *o.Svm
		}
		qSvm := qrSvm
		if qSvm != "" {

			if err := r.SetQueryParam("svm", qSvm); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm_uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm_uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.Volume != nil {

		// query param volume
		var qrVolume string

		if o.Volume != nil {
			qrVolume = *o.Volume
		}
		qVolume := qrVolume
		if qVolume != "" {

			if err := r.SetQueryParam("volume", qVolume); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamConnectionStatusCollectionGet binds the parameter fields
func (o *ConnectionStatusCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamConnectionStatusCollectionGet binds the parameter order_by
func (o *ConnectionStatusCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
