// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewConnectionStatusGetParams creates a new ConnectionStatusGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewConnectionStatusGetParams() *ConnectionStatusGetParams {
	return &ConnectionStatusGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewConnectionStatusGetParamsWithTimeout creates a new ConnectionStatusGetParams object
// with the ability to set a timeout on a request.
func NewConnectionStatusGetParamsWithTimeout(timeout time.Duration) *ConnectionStatusGetParams {
	return &ConnectionStatusGetParams{
		timeout: timeout,
	}
}

// NewConnectionStatusGetParamsWithContext creates a new ConnectionStatusGetParams object
// with the ability to set a context for a request.
func NewConnectionStatusGetParamsWithContext(ctx context.Context) *ConnectionStatusGetParams {
	return &ConnectionStatusGetParams{
		Context: ctx,
	}
}

// NewConnectionStatusGetParamsWithHTTPClient creates a new ConnectionStatusGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewConnectionStatusGetParamsWithHTTPClient(client *http.Client) *ConnectionStatusGetParams {
	return &ConnectionStatusGetParams{
		HTTPClient: client,
	}
}

/*
ConnectionStatusGetParams contains all the parameters to send to the API endpoint

	for the connection status get operation.

	Typically these are written to a http.Request.
*/
type ConnectionStatusGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* LocalFgMsid.

	   Local FG MSID
	*/
	LocalFgMsid int64

	/* Node.

	   Node Name
	*/
	Node string

	/* RemoteSvmUUID.

	   Remote SVM UUID
	*/
	RemoteSvmUUID string

	/* RemoteVolConstMsid.

	   Remote Constituent MSID
	*/
	RemoteVolConstMsid int64

	/* Svm.

	   SVM Name
	*/
	Svm string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the connection status get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConnectionStatusGetParams) WithDefaults() *ConnectionStatusGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the connection status get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ConnectionStatusGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the connection status get params
func (o *ConnectionStatusGetParams) WithTimeout(timeout time.Duration) *ConnectionStatusGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the connection status get params
func (o *ConnectionStatusGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the connection status get params
func (o *ConnectionStatusGetParams) WithContext(ctx context.Context) *ConnectionStatusGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the connection status get params
func (o *ConnectionStatusGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the connection status get params
func (o *ConnectionStatusGetParams) WithHTTPClient(client *http.Client) *ConnectionStatusGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the connection status get params
func (o *ConnectionStatusGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the connection status get params
func (o *ConnectionStatusGetParams) WithFields(fields []string) *ConnectionStatusGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the connection status get params
func (o *ConnectionStatusGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithLocalFgMsid adds the localFgMsid to the connection status get params
func (o *ConnectionStatusGetParams) WithLocalFgMsid(localFgMsid int64) *ConnectionStatusGetParams {
	o.SetLocalFgMsid(localFgMsid)
	return o
}

// SetLocalFgMsid adds the localFgMsid to the connection status get params
func (o *ConnectionStatusGetParams) SetLocalFgMsid(localFgMsid int64) {
	o.LocalFgMsid = localFgMsid
}

// WithNode adds the node to the connection status get params
func (o *ConnectionStatusGetParams) WithNode(node string) *ConnectionStatusGetParams {
	o.SetNode(node)
	return o
}

// SetNode adds the node to the connection status get params
func (o *ConnectionStatusGetParams) SetNode(node string) {
	o.Node = node
}

// WithRemoteSvmUUID adds the remoteSvmUUID to the connection status get params
func (o *ConnectionStatusGetParams) WithRemoteSvmUUID(remoteSvmUUID string) *ConnectionStatusGetParams {
	o.SetRemoteSvmUUID(remoteSvmUUID)
	return o
}

// SetRemoteSvmUUID adds the remoteSvmUuid to the connection status get params
func (o *ConnectionStatusGetParams) SetRemoteSvmUUID(remoteSvmUUID string) {
	o.RemoteSvmUUID = remoteSvmUUID
}

// WithRemoteVolConstMsid adds the remoteVolConstMsid to the connection status get params
func (o *ConnectionStatusGetParams) WithRemoteVolConstMsid(remoteVolConstMsid int64) *ConnectionStatusGetParams {
	o.SetRemoteVolConstMsid(remoteVolConstMsid)
	return o
}

// SetRemoteVolConstMsid adds the remoteVolConstMsid to the connection status get params
func (o *ConnectionStatusGetParams) SetRemoteVolConstMsid(remoteVolConstMsid int64) {
	o.RemoteVolConstMsid = remoteVolConstMsid
}

// WithSvm adds the svm to the connection status get params
func (o *ConnectionStatusGetParams) WithSvm(svm string) *ConnectionStatusGetParams {
	o.SetSvm(svm)
	return o
}

// SetSvm adds the svm to the connection status get params
func (o *ConnectionStatusGetParams) SetSvm(svm string) {
	o.Svm = svm
}

// WriteToRequest writes these params to a swagger request
func (o *ConnectionStatusGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param local_fg_msid
	if err := r.SetPathParam("local_fg_msid", swag.FormatInt64(o.LocalFgMsid)); err != nil {
		return err
	}

	// path param node
	if err := r.SetPathParam("node", o.Node); err != nil {
		return err
	}

	// path param remote_svm_uuid
	if err := r.SetPathParam("remote_svm_uuid", o.RemoteSvmUUID); err != nil {
		return err
	}

	// path param remote_vol_const_msid
	if err := r.SetPathParam("remote_vol_const_msid", swag.FormatInt64(o.RemoteVolConstMsid)); err != nil {
		return err
	}

	// path param svm
	if err := r.SetPathParam("svm", o.Svm); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamConnectionStatusGet binds the parameter fields
func (o *ConnectionStatusGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
