// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewDiskCollectionGetParams creates a new DiskCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDiskCollectionGetParams() *DiskCollectionGetParams {
	return &DiskCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDiskCollectionGetParamsWithTimeout creates a new DiskCollectionGetParams object
// with the ability to set a timeout on a request.
func NewDiskCollectionGetParamsWithTimeout(timeout time.Duration) *DiskCollectionGetParams {
	return &DiskCollectionGetParams{
		timeout: timeout,
	}
}

// NewDiskCollectionGetParamsWithContext creates a new DiskCollectionGetParams object
// with the ability to set a context for a request.
func NewDiskCollectionGetParamsWithContext(ctx context.Context) *DiskCollectionGetParams {
	return &DiskCollectionGetParams{
		Context: ctx,
	}
}

// NewDiskCollectionGetParamsWithHTTPClient creates a new DiskCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewDiskCollectionGetParamsWithHTTPClient(client *http.Client) *DiskCollectionGetParams {
	return &DiskCollectionGetParams{
		HTTPClient: client,
	}
}

/*
DiskCollectionGetParams contains all the parameters to send to the API endpoint

	for the disk collection get operation.

	Typically these are written to a http.Request.
*/
type DiskCollectionGetParams struct {

	/* AggregatesName.

	   Filter by aggregates.name
	*/
	AggregatesName *string

	/* AggregatesUUID.

	   Filter by aggregates.uuid
	*/
	AggregatesUUID *string

	/* Bay.

	   Filter by bay
	*/
	Bay *int64

	/* BytesPerSector.

	   Filter by bytes_per_sector
	*/
	BytesPerSector *int64

	/* Class.

	   Filter by class
	*/
	Class *string

	/* ComplianceStandard.

	   Filter by compliance_standard
	*/
	ComplianceStandard *string

	/* ContainerType.

	   Filter by container_type
	*/
	ContainerType *string

	/* ControlStandard.

	   Filter by control_standard
	*/
	ControlStandard *string

	/* DrNodeName.

	   Filter by dr_node.name
	*/
	DrNodeName *string

	/* DrNodeUUID.

	   Filter by dr_node.uuid
	*/
	DrNodeUUID *string

	/* DrawerID.

	   Filter by drawer.id
	*/
	DrawerID *int64

	/* DrawerSlot.

	   Filter by drawer.slot
	*/
	DrawerSlot *int64

	/* EffectiveType.

	   Filter by effective_type
	*/
	EffectiveType *string

	/* ErrorReasonArgumentsCode.

	   Filter by error.reason.arguments.code
	*/
	ErrorReasonArgumentsCode *string

	/* ErrorReasonArgumentsMessage.

	   Filter by error.reason.arguments.message
	*/
	ErrorReasonArgumentsMessage *string

	/* ErrorReasonCode.

	   Filter by error.reason.code
	*/
	ErrorReasonCode *string

	/* ErrorReasonMessage.

	   Filter by error.reason.message
	*/
	ErrorReasonMessage *string

	/* ErrorType.

	   Filter by error.type
	*/
	ErrorType *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FipsCertified.

	   Filter by fips_certified
	*/
	FipsCertified *bool

	/* FirmwareVersion.

	   Filter by firmware_version
	*/
	FirmwareVersion *string

	/* HomeNodeName.

	   Filter by home_node.name
	*/
	HomeNodeName *string

	/* HomeNodeUUID.

	   Filter by home_node.uuid
	*/
	HomeNodeUUID *string

	/* KeyIDData.

	   Filter by key_id.data
	*/
	KeyIDData *string

	/* KeyIDFips.

	   Filter by key_id.fips
	*/
	KeyIDFips *string

	/* Local.

	   Filter by local
	*/
	Local *bool

	/* Location.

	   Filter by location
	*/
	Location *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Model.

	   Filter by model
	*/
	Model *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OutagePersistentlyFailed.

	   Filter by outage.persistently_failed
	*/
	OutagePersistentlyFailed *bool

	/* OutageReasonArgumentsCode.

	   Filter by outage.reason.arguments.code
	*/
	OutageReasonArgumentsCode *string

	/* OutageReasonArgumentsMessage.

	   Filter by outage.reason.arguments.message
	*/
	OutageReasonArgumentsMessage *string

	/* OutageReasonCode.

	   Filter by outage.reason.code
	*/
	OutageReasonCode *string

	/* OutageReasonMessage.

	   Filter by outage.reason.message
	*/
	OutageReasonMessage *string

	/* OverallSecurity.

	   Filter by overall_security
	*/
	OverallSecurity *string

	/* PathsDiskPathName.

	   Filter by paths.disk_path_name
	*/
	PathsDiskPathName *string

	/* PathsInitiator.

	   Filter by paths.initiator
	*/
	PathsInitiator *string

	/* PathsNodeName.

	   Filter by paths.node.name
	*/
	PathsNodeName *string

	/* PathsNodeUUID.

	   Filter by paths.node.uuid
	*/
	PathsNodeUUID *string

	/* PathsPortName.

	   Filter by paths.port_name
	*/
	PathsPortName *string

	/* PathsPortType.

	   Filter by paths.port_type
	*/
	PathsPortType *string

	/* PathsVmdiskHypervisorFileName.

	   Filter by paths.vmdisk_hypervisor_file_name
	*/
	PathsVmdiskHypervisorFileName *string

	/* PathsWwnn.

	   Filter by paths.wwnn
	*/
	PathsWwnn *string

	/* PathsWwpn.

	   Filter by paths.wwpn
	*/
	PathsWwpn *string

	/* PhysicalSize.

	   Filter by physical_size
	*/
	PhysicalSize *int64

	/* Pool.

	   Filter by pool
	*/
	Pool *string

	/* ProtectionMode.

	   Filter by protection_mode
	*/
	ProtectionMode *string

	/* RatedLifeUsedPercent.

	   Filter by rated_life_used_percent
	*/
	RatedLifeUsedPercent *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RightSizeSectorCount.

	   Filter by right_size_sector_count
	*/
	RightSizeSectorCount *int64

	/* Rpm.

	   Filter by rpm
	*/
	Rpm *int64

	/* SectorCount.

	   Filter by sector_count
	*/
	SectorCount *int64

	/* SelfEncrypting.

	   Filter by self_encrypting
	*/
	SelfEncrypting *bool

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* ShelfUID.

	   Filter by shelf.uid
	*/
	ShelfUID *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatsAverageLatency.

	   Filter by stats.average_latency
	*/
	StatsAverageLatency *int64

	/* StatsIopsTotal.

	   Filter by stats.iops_total
	*/
	StatsIopsTotal *int64

	/* StatsPathErrorCount.

	   Filter by stats.path_error_count
	*/
	StatsPathErrorCount *int64

	/* StatsPowerOnHours.

	   Filter by stats.power_on_hours
	*/
	StatsPowerOnHours *int64

	/* StatsThroughput.

	   Filter by stats.throughput
	*/
	StatsThroughput *int64

	/* StorageAvailabilityZoneName.

	   Filter by storage_availability_zone.name
	*/
	StorageAvailabilityZoneName *string

	/* StorageAvailabilityZoneUUID.

	   Filter by storage_availability_zone.uuid
	*/
	StorageAvailabilityZoneUUID *string

	/* StoragePoolName.

	   Filter by storage_pool.name
	*/
	StoragePoolName *string

	/* StoragePoolUUID.

	   Filter by storage_pool.uuid
	*/
	StoragePoolUUID *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UID.

	   Filter by uid
	*/
	UID *string

	/* UsableSize.

	   Filter by usable_size
	*/
	UsableSize *int64

	/* Vendor.

	   Filter by vendor
	*/
	Vendor *string

	/* VirtualContainer.

	   Filter by virtual.container
	*/
	VirtualContainer *string

	/* VirtualObject.

	   Filter by virtual.object
	*/
	VirtualObject *string

	/* VirtualStorageAccount.

	   Filter by virtual.storage_account
	*/
	VirtualStorageAccount *string

	/* VirtualTargetAddress.

	   Filter by virtual.target_address
	*/
	VirtualTargetAddress *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the disk collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DiskCollectionGetParams) WithDefaults() *DiskCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the disk collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DiskCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := DiskCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the disk collection get params
func (o *DiskCollectionGetParams) WithTimeout(timeout time.Duration) *DiskCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the disk collection get params
func (o *DiskCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the disk collection get params
func (o *DiskCollectionGetParams) WithContext(ctx context.Context) *DiskCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the disk collection get params
func (o *DiskCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the disk collection get params
func (o *DiskCollectionGetParams) WithHTTPClient(client *http.Client) *DiskCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the disk collection get params
func (o *DiskCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregatesName adds the aggregatesName to the disk collection get params
func (o *DiskCollectionGetParams) WithAggregatesName(aggregatesName *string) *DiskCollectionGetParams {
	o.SetAggregatesName(aggregatesName)
	return o
}

// SetAggregatesName adds the aggregatesName to the disk collection get params
func (o *DiskCollectionGetParams) SetAggregatesName(aggregatesName *string) {
	o.AggregatesName = aggregatesName
}

// WithAggregatesUUID adds the aggregatesUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithAggregatesUUID(aggregatesUUID *string) *DiskCollectionGetParams {
	o.SetAggregatesUUID(aggregatesUUID)
	return o
}

// SetAggregatesUUID adds the aggregatesUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetAggregatesUUID(aggregatesUUID *string) {
	o.AggregatesUUID = aggregatesUUID
}

// WithBay adds the bay to the disk collection get params
func (o *DiskCollectionGetParams) WithBay(bay *int64) *DiskCollectionGetParams {
	o.SetBay(bay)
	return o
}

// SetBay adds the bay to the disk collection get params
func (o *DiskCollectionGetParams) SetBay(bay *int64) {
	o.Bay = bay
}

// WithBytesPerSector adds the bytesPerSector to the disk collection get params
func (o *DiskCollectionGetParams) WithBytesPerSector(bytesPerSector *int64) *DiskCollectionGetParams {
	o.SetBytesPerSector(bytesPerSector)
	return o
}

// SetBytesPerSector adds the bytesPerSector to the disk collection get params
func (o *DiskCollectionGetParams) SetBytesPerSector(bytesPerSector *int64) {
	o.BytesPerSector = bytesPerSector
}

// WithClass adds the class to the disk collection get params
func (o *DiskCollectionGetParams) WithClass(class *string) *DiskCollectionGetParams {
	o.SetClass(class)
	return o
}

// SetClass adds the class to the disk collection get params
func (o *DiskCollectionGetParams) SetClass(class *string) {
	o.Class = class
}

// WithComplianceStandard adds the complianceStandard to the disk collection get params
func (o *DiskCollectionGetParams) WithComplianceStandard(complianceStandard *string) *DiskCollectionGetParams {
	o.SetComplianceStandard(complianceStandard)
	return o
}

// SetComplianceStandard adds the complianceStandard to the disk collection get params
func (o *DiskCollectionGetParams) SetComplianceStandard(complianceStandard *string) {
	o.ComplianceStandard = complianceStandard
}

// WithContainerType adds the containerType to the disk collection get params
func (o *DiskCollectionGetParams) WithContainerType(containerType *string) *DiskCollectionGetParams {
	o.SetContainerType(containerType)
	return o
}

// SetContainerType adds the containerType to the disk collection get params
func (o *DiskCollectionGetParams) SetContainerType(containerType *string) {
	o.ContainerType = containerType
}

// WithControlStandard adds the controlStandard to the disk collection get params
func (o *DiskCollectionGetParams) WithControlStandard(controlStandard *string) *DiskCollectionGetParams {
	o.SetControlStandard(controlStandard)
	return o
}

// SetControlStandard adds the controlStandard to the disk collection get params
func (o *DiskCollectionGetParams) SetControlStandard(controlStandard *string) {
	o.ControlStandard = controlStandard
}

// WithDrNodeName adds the drNodeName to the disk collection get params
func (o *DiskCollectionGetParams) WithDrNodeName(drNodeName *string) *DiskCollectionGetParams {
	o.SetDrNodeName(drNodeName)
	return o
}

// SetDrNodeName adds the drNodeName to the disk collection get params
func (o *DiskCollectionGetParams) SetDrNodeName(drNodeName *string) {
	o.DrNodeName = drNodeName
}

// WithDrNodeUUID adds the drNodeUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithDrNodeUUID(drNodeUUID *string) *DiskCollectionGetParams {
	o.SetDrNodeUUID(drNodeUUID)
	return o
}

// SetDrNodeUUID adds the drNodeUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetDrNodeUUID(drNodeUUID *string) {
	o.DrNodeUUID = drNodeUUID
}

// WithDrawerID adds the drawerID to the disk collection get params
func (o *DiskCollectionGetParams) WithDrawerID(drawerID *int64) *DiskCollectionGetParams {
	o.SetDrawerID(drawerID)
	return o
}

// SetDrawerID adds the drawerId to the disk collection get params
func (o *DiskCollectionGetParams) SetDrawerID(drawerID *int64) {
	o.DrawerID = drawerID
}

// WithDrawerSlot adds the drawerSlot to the disk collection get params
func (o *DiskCollectionGetParams) WithDrawerSlot(drawerSlot *int64) *DiskCollectionGetParams {
	o.SetDrawerSlot(drawerSlot)
	return o
}

// SetDrawerSlot adds the drawerSlot to the disk collection get params
func (o *DiskCollectionGetParams) SetDrawerSlot(drawerSlot *int64) {
	o.DrawerSlot = drawerSlot
}

// WithEffectiveType adds the effectiveType to the disk collection get params
func (o *DiskCollectionGetParams) WithEffectiveType(effectiveType *string) *DiskCollectionGetParams {
	o.SetEffectiveType(effectiveType)
	return o
}

// SetEffectiveType adds the effectiveType to the disk collection get params
func (o *DiskCollectionGetParams) SetEffectiveType(effectiveType *string) {
	o.EffectiveType = effectiveType
}

// WithErrorReasonArgumentsCode adds the errorReasonArgumentsCode to the disk collection get params
func (o *DiskCollectionGetParams) WithErrorReasonArgumentsCode(errorReasonArgumentsCode *string) *DiskCollectionGetParams {
	o.SetErrorReasonArgumentsCode(errorReasonArgumentsCode)
	return o
}

// SetErrorReasonArgumentsCode adds the errorReasonArgumentsCode to the disk collection get params
func (o *DiskCollectionGetParams) SetErrorReasonArgumentsCode(errorReasonArgumentsCode *string) {
	o.ErrorReasonArgumentsCode = errorReasonArgumentsCode
}

// WithErrorReasonArgumentsMessage adds the errorReasonArgumentsMessage to the disk collection get params
func (o *DiskCollectionGetParams) WithErrorReasonArgumentsMessage(errorReasonArgumentsMessage *string) *DiskCollectionGetParams {
	o.SetErrorReasonArgumentsMessage(errorReasonArgumentsMessage)
	return o
}

// SetErrorReasonArgumentsMessage adds the errorReasonArgumentsMessage to the disk collection get params
func (o *DiskCollectionGetParams) SetErrorReasonArgumentsMessage(errorReasonArgumentsMessage *string) {
	o.ErrorReasonArgumentsMessage = errorReasonArgumentsMessage
}

// WithErrorReasonCode adds the errorReasonCode to the disk collection get params
func (o *DiskCollectionGetParams) WithErrorReasonCode(errorReasonCode *string) *DiskCollectionGetParams {
	o.SetErrorReasonCode(errorReasonCode)
	return o
}

// SetErrorReasonCode adds the errorReasonCode to the disk collection get params
func (o *DiskCollectionGetParams) SetErrorReasonCode(errorReasonCode *string) {
	o.ErrorReasonCode = errorReasonCode
}

// WithErrorReasonMessage adds the errorReasonMessage to the disk collection get params
func (o *DiskCollectionGetParams) WithErrorReasonMessage(errorReasonMessage *string) *DiskCollectionGetParams {
	o.SetErrorReasonMessage(errorReasonMessage)
	return o
}

// SetErrorReasonMessage adds the errorReasonMessage to the disk collection get params
func (o *DiskCollectionGetParams) SetErrorReasonMessage(errorReasonMessage *string) {
	o.ErrorReasonMessage = errorReasonMessage
}

// WithErrorType adds the errorType to the disk collection get params
func (o *DiskCollectionGetParams) WithErrorType(errorType *string) *DiskCollectionGetParams {
	o.SetErrorType(errorType)
	return o
}

// SetErrorType adds the errorType to the disk collection get params
func (o *DiskCollectionGetParams) SetErrorType(errorType *string) {
	o.ErrorType = errorType
}

// WithFields adds the fields to the disk collection get params
func (o *DiskCollectionGetParams) WithFields(fields []string) *DiskCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the disk collection get params
func (o *DiskCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFipsCertified adds the fipsCertified to the disk collection get params
func (o *DiskCollectionGetParams) WithFipsCertified(fipsCertified *bool) *DiskCollectionGetParams {
	o.SetFipsCertified(fipsCertified)
	return o
}

// SetFipsCertified adds the fipsCertified to the disk collection get params
func (o *DiskCollectionGetParams) SetFipsCertified(fipsCertified *bool) {
	o.FipsCertified = fipsCertified
}

// WithFirmwareVersion adds the firmwareVersion to the disk collection get params
func (o *DiskCollectionGetParams) WithFirmwareVersion(firmwareVersion *string) *DiskCollectionGetParams {
	o.SetFirmwareVersion(firmwareVersion)
	return o
}

// SetFirmwareVersion adds the firmwareVersion to the disk collection get params
func (o *DiskCollectionGetParams) SetFirmwareVersion(firmwareVersion *string) {
	o.FirmwareVersion = firmwareVersion
}

// WithHomeNodeName adds the homeNodeName to the disk collection get params
func (o *DiskCollectionGetParams) WithHomeNodeName(homeNodeName *string) *DiskCollectionGetParams {
	o.SetHomeNodeName(homeNodeName)
	return o
}

// SetHomeNodeName adds the homeNodeName to the disk collection get params
func (o *DiskCollectionGetParams) SetHomeNodeName(homeNodeName *string) {
	o.HomeNodeName = homeNodeName
}

// WithHomeNodeUUID adds the homeNodeUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithHomeNodeUUID(homeNodeUUID *string) *DiskCollectionGetParams {
	o.SetHomeNodeUUID(homeNodeUUID)
	return o
}

// SetHomeNodeUUID adds the homeNodeUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetHomeNodeUUID(homeNodeUUID *string) {
	o.HomeNodeUUID = homeNodeUUID
}

// WithKeyIDData adds the keyIDData to the disk collection get params
func (o *DiskCollectionGetParams) WithKeyIDData(keyIDData *string) *DiskCollectionGetParams {
	o.SetKeyIDData(keyIDData)
	return o
}

// SetKeyIDData adds the keyIdData to the disk collection get params
func (o *DiskCollectionGetParams) SetKeyIDData(keyIDData *string) {
	o.KeyIDData = keyIDData
}

// WithKeyIDFips adds the keyIDFips to the disk collection get params
func (o *DiskCollectionGetParams) WithKeyIDFips(keyIDFips *string) *DiskCollectionGetParams {
	o.SetKeyIDFips(keyIDFips)
	return o
}

// SetKeyIDFips adds the keyIdFips to the disk collection get params
func (o *DiskCollectionGetParams) SetKeyIDFips(keyIDFips *string) {
	o.KeyIDFips = keyIDFips
}

// WithLocal adds the local to the disk collection get params
func (o *DiskCollectionGetParams) WithLocal(local *bool) *DiskCollectionGetParams {
	o.SetLocal(local)
	return o
}

// SetLocal adds the local to the disk collection get params
func (o *DiskCollectionGetParams) SetLocal(local *bool) {
	o.Local = local
}

// WithLocation adds the location to the disk collection get params
func (o *DiskCollectionGetParams) WithLocation(location *string) *DiskCollectionGetParams {
	o.SetLocation(location)
	return o
}

// SetLocation adds the location to the disk collection get params
func (o *DiskCollectionGetParams) SetLocation(location *string) {
	o.Location = location
}

// WithMaxRecords adds the maxRecords to the disk collection get params
func (o *DiskCollectionGetParams) WithMaxRecords(maxRecords *int64) *DiskCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the disk collection get params
func (o *DiskCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithModel adds the model to the disk collection get params
func (o *DiskCollectionGetParams) WithModel(model *string) *DiskCollectionGetParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the disk collection get params
func (o *DiskCollectionGetParams) SetModel(model *string) {
	o.Model = model
}

// WithName adds the name to the disk collection get params
func (o *DiskCollectionGetParams) WithName(name *string) *DiskCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the disk collection get params
func (o *DiskCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNodeName adds the nodeName to the disk collection get params
func (o *DiskCollectionGetParams) WithNodeName(nodeName *string) *DiskCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the disk collection get params
func (o *DiskCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithNodeUUID(nodeUUID *string) *DiskCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the disk collection get params
func (o *DiskCollectionGetParams) WithOrderBy(orderBy []string) *DiskCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the disk collection get params
func (o *DiskCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOutagePersistentlyFailed adds the outagePersistentlyFailed to the disk collection get params
func (o *DiskCollectionGetParams) WithOutagePersistentlyFailed(outagePersistentlyFailed *bool) *DiskCollectionGetParams {
	o.SetOutagePersistentlyFailed(outagePersistentlyFailed)
	return o
}

// SetOutagePersistentlyFailed adds the outagePersistentlyFailed to the disk collection get params
func (o *DiskCollectionGetParams) SetOutagePersistentlyFailed(outagePersistentlyFailed *bool) {
	o.OutagePersistentlyFailed = outagePersistentlyFailed
}

// WithOutageReasonArgumentsCode adds the outageReasonArgumentsCode to the disk collection get params
func (o *DiskCollectionGetParams) WithOutageReasonArgumentsCode(outageReasonArgumentsCode *string) *DiskCollectionGetParams {
	o.SetOutageReasonArgumentsCode(outageReasonArgumentsCode)
	return o
}

// SetOutageReasonArgumentsCode adds the outageReasonArgumentsCode to the disk collection get params
func (o *DiskCollectionGetParams) SetOutageReasonArgumentsCode(outageReasonArgumentsCode *string) {
	o.OutageReasonArgumentsCode = outageReasonArgumentsCode
}

// WithOutageReasonArgumentsMessage adds the outageReasonArgumentsMessage to the disk collection get params
func (o *DiskCollectionGetParams) WithOutageReasonArgumentsMessage(outageReasonArgumentsMessage *string) *DiskCollectionGetParams {
	o.SetOutageReasonArgumentsMessage(outageReasonArgumentsMessage)
	return o
}

// SetOutageReasonArgumentsMessage adds the outageReasonArgumentsMessage to the disk collection get params
func (o *DiskCollectionGetParams) SetOutageReasonArgumentsMessage(outageReasonArgumentsMessage *string) {
	o.OutageReasonArgumentsMessage = outageReasonArgumentsMessage
}

// WithOutageReasonCode adds the outageReasonCode to the disk collection get params
func (o *DiskCollectionGetParams) WithOutageReasonCode(outageReasonCode *string) *DiskCollectionGetParams {
	o.SetOutageReasonCode(outageReasonCode)
	return o
}

// SetOutageReasonCode adds the outageReasonCode to the disk collection get params
func (o *DiskCollectionGetParams) SetOutageReasonCode(outageReasonCode *string) {
	o.OutageReasonCode = outageReasonCode
}

// WithOutageReasonMessage adds the outageReasonMessage to the disk collection get params
func (o *DiskCollectionGetParams) WithOutageReasonMessage(outageReasonMessage *string) *DiskCollectionGetParams {
	o.SetOutageReasonMessage(outageReasonMessage)
	return o
}

// SetOutageReasonMessage adds the outageReasonMessage to the disk collection get params
func (o *DiskCollectionGetParams) SetOutageReasonMessage(outageReasonMessage *string) {
	o.OutageReasonMessage = outageReasonMessage
}

// WithOverallSecurity adds the overallSecurity to the disk collection get params
func (o *DiskCollectionGetParams) WithOverallSecurity(overallSecurity *string) *DiskCollectionGetParams {
	o.SetOverallSecurity(overallSecurity)
	return o
}

// SetOverallSecurity adds the overallSecurity to the disk collection get params
func (o *DiskCollectionGetParams) SetOverallSecurity(overallSecurity *string) {
	o.OverallSecurity = overallSecurity
}

// WithPathsDiskPathName adds the pathsDiskPathName to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsDiskPathName(pathsDiskPathName *string) *DiskCollectionGetParams {
	o.SetPathsDiskPathName(pathsDiskPathName)
	return o
}

// SetPathsDiskPathName adds the pathsDiskPathName to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsDiskPathName(pathsDiskPathName *string) {
	o.PathsDiskPathName = pathsDiskPathName
}

// WithPathsInitiator adds the pathsInitiator to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsInitiator(pathsInitiator *string) *DiskCollectionGetParams {
	o.SetPathsInitiator(pathsInitiator)
	return o
}

// SetPathsInitiator adds the pathsInitiator to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsInitiator(pathsInitiator *string) {
	o.PathsInitiator = pathsInitiator
}

// WithPathsNodeName adds the pathsNodeName to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsNodeName(pathsNodeName *string) *DiskCollectionGetParams {
	o.SetPathsNodeName(pathsNodeName)
	return o
}

// SetPathsNodeName adds the pathsNodeName to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsNodeName(pathsNodeName *string) {
	o.PathsNodeName = pathsNodeName
}

// WithPathsNodeUUID adds the pathsNodeUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsNodeUUID(pathsNodeUUID *string) *DiskCollectionGetParams {
	o.SetPathsNodeUUID(pathsNodeUUID)
	return o
}

// SetPathsNodeUUID adds the pathsNodeUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsNodeUUID(pathsNodeUUID *string) {
	o.PathsNodeUUID = pathsNodeUUID
}

// WithPathsPortName adds the pathsPortName to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsPortName(pathsPortName *string) *DiskCollectionGetParams {
	o.SetPathsPortName(pathsPortName)
	return o
}

// SetPathsPortName adds the pathsPortName to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsPortName(pathsPortName *string) {
	o.PathsPortName = pathsPortName
}

// WithPathsPortType adds the pathsPortType to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsPortType(pathsPortType *string) *DiskCollectionGetParams {
	o.SetPathsPortType(pathsPortType)
	return o
}

// SetPathsPortType adds the pathsPortType to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsPortType(pathsPortType *string) {
	o.PathsPortType = pathsPortType
}

// WithPathsVmdiskHypervisorFileName adds the pathsVmdiskHypervisorFileName to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsVmdiskHypervisorFileName(pathsVmdiskHypervisorFileName *string) *DiskCollectionGetParams {
	o.SetPathsVmdiskHypervisorFileName(pathsVmdiskHypervisorFileName)
	return o
}

// SetPathsVmdiskHypervisorFileName adds the pathsVmdiskHypervisorFileName to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsVmdiskHypervisorFileName(pathsVmdiskHypervisorFileName *string) {
	o.PathsVmdiskHypervisorFileName = pathsVmdiskHypervisorFileName
}

// WithPathsWwnn adds the pathsWwnn to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsWwnn(pathsWwnn *string) *DiskCollectionGetParams {
	o.SetPathsWwnn(pathsWwnn)
	return o
}

// SetPathsWwnn adds the pathsWwnn to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsWwnn(pathsWwnn *string) {
	o.PathsWwnn = pathsWwnn
}

// WithPathsWwpn adds the pathsWwpn to the disk collection get params
func (o *DiskCollectionGetParams) WithPathsWwpn(pathsWwpn *string) *DiskCollectionGetParams {
	o.SetPathsWwpn(pathsWwpn)
	return o
}

// SetPathsWwpn adds the pathsWwpn to the disk collection get params
func (o *DiskCollectionGetParams) SetPathsWwpn(pathsWwpn *string) {
	o.PathsWwpn = pathsWwpn
}

// WithPhysicalSize adds the physicalSize to the disk collection get params
func (o *DiskCollectionGetParams) WithPhysicalSize(physicalSize *int64) *DiskCollectionGetParams {
	o.SetPhysicalSize(physicalSize)
	return o
}

// SetPhysicalSize adds the physicalSize to the disk collection get params
func (o *DiskCollectionGetParams) SetPhysicalSize(physicalSize *int64) {
	o.PhysicalSize = physicalSize
}

// WithPool adds the pool to the disk collection get params
func (o *DiskCollectionGetParams) WithPool(pool *string) *DiskCollectionGetParams {
	o.SetPool(pool)
	return o
}

// SetPool adds the pool to the disk collection get params
func (o *DiskCollectionGetParams) SetPool(pool *string) {
	o.Pool = pool
}

// WithProtectionMode adds the protectionMode to the disk collection get params
func (o *DiskCollectionGetParams) WithProtectionMode(protectionMode *string) *DiskCollectionGetParams {
	o.SetProtectionMode(protectionMode)
	return o
}

// SetProtectionMode adds the protectionMode to the disk collection get params
func (o *DiskCollectionGetParams) SetProtectionMode(protectionMode *string) {
	o.ProtectionMode = protectionMode
}

// WithRatedLifeUsedPercent adds the ratedLifeUsedPercent to the disk collection get params
func (o *DiskCollectionGetParams) WithRatedLifeUsedPercent(ratedLifeUsedPercent *int64) *DiskCollectionGetParams {
	o.SetRatedLifeUsedPercent(ratedLifeUsedPercent)
	return o
}

// SetRatedLifeUsedPercent adds the ratedLifeUsedPercent to the disk collection get params
func (o *DiskCollectionGetParams) SetRatedLifeUsedPercent(ratedLifeUsedPercent *int64) {
	o.RatedLifeUsedPercent = ratedLifeUsedPercent
}

// WithReturnRecords adds the returnRecords to the disk collection get params
func (o *DiskCollectionGetParams) WithReturnRecords(returnRecords *bool) *DiskCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the disk collection get params
func (o *DiskCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the disk collection get params
func (o *DiskCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *DiskCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the disk collection get params
func (o *DiskCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRightSizeSectorCount adds the rightSizeSectorCount to the disk collection get params
func (o *DiskCollectionGetParams) WithRightSizeSectorCount(rightSizeSectorCount *int64) *DiskCollectionGetParams {
	o.SetRightSizeSectorCount(rightSizeSectorCount)
	return o
}

// SetRightSizeSectorCount adds the rightSizeSectorCount to the disk collection get params
func (o *DiskCollectionGetParams) SetRightSizeSectorCount(rightSizeSectorCount *int64) {
	o.RightSizeSectorCount = rightSizeSectorCount
}

// WithRpm adds the rpm to the disk collection get params
func (o *DiskCollectionGetParams) WithRpm(rpm *int64) *DiskCollectionGetParams {
	o.SetRpm(rpm)
	return o
}

// SetRpm adds the rpm to the disk collection get params
func (o *DiskCollectionGetParams) SetRpm(rpm *int64) {
	o.Rpm = rpm
}

// WithSectorCount adds the sectorCount to the disk collection get params
func (o *DiskCollectionGetParams) WithSectorCount(sectorCount *int64) *DiskCollectionGetParams {
	o.SetSectorCount(sectorCount)
	return o
}

// SetSectorCount adds the sectorCount to the disk collection get params
func (o *DiskCollectionGetParams) SetSectorCount(sectorCount *int64) {
	o.SectorCount = sectorCount
}

// WithSelfEncrypting adds the selfEncrypting to the disk collection get params
func (o *DiskCollectionGetParams) WithSelfEncrypting(selfEncrypting *bool) *DiskCollectionGetParams {
	o.SetSelfEncrypting(selfEncrypting)
	return o
}

// SetSelfEncrypting adds the selfEncrypting to the disk collection get params
func (o *DiskCollectionGetParams) SetSelfEncrypting(selfEncrypting *bool) {
	o.SelfEncrypting = selfEncrypting
}

// WithSerialNumber adds the serialNumber to the disk collection get params
func (o *DiskCollectionGetParams) WithSerialNumber(serialNumber *string) *DiskCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the disk collection get params
func (o *DiskCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithShelfUID adds the shelfUID to the disk collection get params
func (o *DiskCollectionGetParams) WithShelfUID(shelfUID *string) *DiskCollectionGetParams {
	o.SetShelfUID(shelfUID)
	return o
}

// SetShelfUID adds the shelfUid to the disk collection get params
func (o *DiskCollectionGetParams) SetShelfUID(shelfUID *string) {
	o.ShelfUID = shelfUID
}

// WithState adds the state to the disk collection get params
func (o *DiskCollectionGetParams) WithState(state *string) *DiskCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the disk collection get params
func (o *DiskCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithStatsAverageLatency adds the statsAverageLatency to the disk collection get params
func (o *DiskCollectionGetParams) WithStatsAverageLatency(statsAverageLatency *int64) *DiskCollectionGetParams {
	o.SetStatsAverageLatency(statsAverageLatency)
	return o
}

// SetStatsAverageLatency adds the statsAverageLatency to the disk collection get params
func (o *DiskCollectionGetParams) SetStatsAverageLatency(statsAverageLatency *int64) {
	o.StatsAverageLatency = statsAverageLatency
}

// WithStatsIopsTotal adds the statsIopsTotal to the disk collection get params
func (o *DiskCollectionGetParams) WithStatsIopsTotal(statsIopsTotal *int64) *DiskCollectionGetParams {
	o.SetStatsIopsTotal(statsIopsTotal)
	return o
}

// SetStatsIopsTotal adds the statsIopsTotal to the disk collection get params
func (o *DiskCollectionGetParams) SetStatsIopsTotal(statsIopsTotal *int64) {
	o.StatsIopsTotal = statsIopsTotal
}

// WithStatsPathErrorCount adds the statsPathErrorCount to the disk collection get params
func (o *DiskCollectionGetParams) WithStatsPathErrorCount(statsPathErrorCount *int64) *DiskCollectionGetParams {
	o.SetStatsPathErrorCount(statsPathErrorCount)
	return o
}

// SetStatsPathErrorCount adds the statsPathErrorCount to the disk collection get params
func (o *DiskCollectionGetParams) SetStatsPathErrorCount(statsPathErrorCount *int64) {
	o.StatsPathErrorCount = statsPathErrorCount
}

// WithStatsPowerOnHours adds the statsPowerOnHours to the disk collection get params
func (o *DiskCollectionGetParams) WithStatsPowerOnHours(statsPowerOnHours *int64) *DiskCollectionGetParams {
	o.SetStatsPowerOnHours(statsPowerOnHours)
	return o
}

// SetStatsPowerOnHours adds the statsPowerOnHours to the disk collection get params
func (o *DiskCollectionGetParams) SetStatsPowerOnHours(statsPowerOnHours *int64) {
	o.StatsPowerOnHours = statsPowerOnHours
}

// WithStatsThroughput adds the statsThroughput to the disk collection get params
func (o *DiskCollectionGetParams) WithStatsThroughput(statsThroughput *int64) *DiskCollectionGetParams {
	o.SetStatsThroughput(statsThroughput)
	return o
}

// SetStatsThroughput adds the statsThroughput to the disk collection get params
func (o *DiskCollectionGetParams) SetStatsThroughput(statsThroughput *int64) {
	o.StatsThroughput = statsThroughput
}

// WithStorageAvailabilityZoneName adds the storageAvailabilityZoneName to the disk collection get params
func (o *DiskCollectionGetParams) WithStorageAvailabilityZoneName(storageAvailabilityZoneName *string) *DiskCollectionGetParams {
	o.SetStorageAvailabilityZoneName(storageAvailabilityZoneName)
	return o
}

// SetStorageAvailabilityZoneName adds the storageAvailabilityZoneName to the disk collection get params
func (o *DiskCollectionGetParams) SetStorageAvailabilityZoneName(storageAvailabilityZoneName *string) {
	o.StorageAvailabilityZoneName = storageAvailabilityZoneName
}

// WithStorageAvailabilityZoneUUID adds the storageAvailabilityZoneUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithStorageAvailabilityZoneUUID(storageAvailabilityZoneUUID *string) *DiskCollectionGetParams {
	o.SetStorageAvailabilityZoneUUID(storageAvailabilityZoneUUID)
	return o
}

// SetStorageAvailabilityZoneUUID adds the storageAvailabilityZoneUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetStorageAvailabilityZoneUUID(storageAvailabilityZoneUUID *string) {
	o.StorageAvailabilityZoneUUID = storageAvailabilityZoneUUID
}

// WithStoragePoolName adds the storagePoolName to the disk collection get params
func (o *DiskCollectionGetParams) WithStoragePoolName(storagePoolName *string) *DiskCollectionGetParams {
	o.SetStoragePoolName(storagePoolName)
	return o
}

// SetStoragePoolName adds the storagePoolName to the disk collection get params
func (o *DiskCollectionGetParams) SetStoragePoolName(storagePoolName *string) {
	o.StoragePoolName = storagePoolName
}

// WithStoragePoolUUID adds the storagePoolUUID to the disk collection get params
func (o *DiskCollectionGetParams) WithStoragePoolUUID(storagePoolUUID *string) *DiskCollectionGetParams {
	o.SetStoragePoolUUID(storagePoolUUID)
	return o
}

// SetStoragePoolUUID adds the storagePoolUuid to the disk collection get params
func (o *DiskCollectionGetParams) SetStoragePoolUUID(storagePoolUUID *string) {
	o.StoragePoolUUID = storagePoolUUID
}

// WithType adds the typeVar to the disk collection get params
func (o *DiskCollectionGetParams) WithType(typeVar *string) *DiskCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the disk collection get params
func (o *DiskCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUID adds the uid to the disk collection get params
func (o *DiskCollectionGetParams) WithUID(uid *string) *DiskCollectionGetParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the disk collection get params
func (o *DiskCollectionGetParams) SetUID(uid *string) {
	o.UID = uid
}

// WithUsableSize adds the usableSize to the disk collection get params
func (o *DiskCollectionGetParams) WithUsableSize(usableSize *int64) *DiskCollectionGetParams {
	o.SetUsableSize(usableSize)
	return o
}

// SetUsableSize adds the usableSize to the disk collection get params
func (o *DiskCollectionGetParams) SetUsableSize(usableSize *int64) {
	o.UsableSize = usableSize
}

// WithVendor adds the vendor to the disk collection get params
func (o *DiskCollectionGetParams) WithVendor(vendor *string) *DiskCollectionGetParams {
	o.SetVendor(vendor)
	return o
}

// SetVendor adds the vendor to the disk collection get params
func (o *DiskCollectionGetParams) SetVendor(vendor *string) {
	o.Vendor = vendor
}

// WithVirtualContainer adds the virtualContainer to the disk collection get params
func (o *DiskCollectionGetParams) WithVirtualContainer(virtualContainer *string) *DiskCollectionGetParams {
	o.SetVirtualContainer(virtualContainer)
	return o
}

// SetVirtualContainer adds the virtualContainer to the disk collection get params
func (o *DiskCollectionGetParams) SetVirtualContainer(virtualContainer *string) {
	o.VirtualContainer = virtualContainer
}

// WithVirtualObject adds the virtualObject to the disk collection get params
func (o *DiskCollectionGetParams) WithVirtualObject(virtualObject *string) *DiskCollectionGetParams {
	o.SetVirtualObject(virtualObject)
	return o
}

// SetVirtualObject adds the virtualObject to the disk collection get params
func (o *DiskCollectionGetParams) SetVirtualObject(virtualObject *string) {
	o.VirtualObject = virtualObject
}

// WithVirtualStorageAccount adds the virtualStorageAccount to the disk collection get params
func (o *DiskCollectionGetParams) WithVirtualStorageAccount(virtualStorageAccount *string) *DiskCollectionGetParams {
	o.SetVirtualStorageAccount(virtualStorageAccount)
	return o
}

// SetVirtualStorageAccount adds the virtualStorageAccount to the disk collection get params
func (o *DiskCollectionGetParams) SetVirtualStorageAccount(virtualStorageAccount *string) {
	o.VirtualStorageAccount = virtualStorageAccount
}

// WithVirtualTargetAddress adds the virtualTargetAddress to the disk collection get params
func (o *DiskCollectionGetParams) WithVirtualTargetAddress(virtualTargetAddress *string) *DiskCollectionGetParams {
	o.SetVirtualTargetAddress(virtualTargetAddress)
	return o
}

// SetVirtualTargetAddress adds the virtualTargetAddress to the disk collection get params
func (o *DiskCollectionGetParams) SetVirtualTargetAddress(virtualTargetAddress *string) {
	o.VirtualTargetAddress = virtualTargetAddress
}

// WriteToRequest writes these params to a swagger request
func (o *DiskCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggregatesName != nil {

		// query param aggregates.name
		var qrAggregatesName string

		if o.AggregatesName != nil {
			qrAggregatesName = *o.AggregatesName
		}
		qAggregatesName := qrAggregatesName
		if qAggregatesName != "" {

			if err := r.SetQueryParam("aggregates.name", qAggregatesName); err != nil {
				return err
			}
		}
	}

	if o.AggregatesUUID != nil {

		// query param aggregates.uuid
		var qrAggregatesUUID string

		if o.AggregatesUUID != nil {
			qrAggregatesUUID = *o.AggregatesUUID
		}
		qAggregatesUUID := qrAggregatesUUID
		if qAggregatesUUID != "" {

			if err := r.SetQueryParam("aggregates.uuid", qAggregatesUUID); err != nil {
				return err
			}
		}
	}

	if o.Bay != nil {

		// query param bay
		var qrBay int64

		if o.Bay != nil {
			qrBay = *o.Bay
		}
		qBay := swag.FormatInt64(qrBay)
		if qBay != "" {

			if err := r.SetQueryParam("bay", qBay); err != nil {
				return err
			}
		}
	}

	if o.BytesPerSector != nil {

		// query param bytes_per_sector
		var qrBytesPerSector int64

		if o.BytesPerSector != nil {
			qrBytesPerSector = *o.BytesPerSector
		}
		qBytesPerSector := swag.FormatInt64(qrBytesPerSector)
		if qBytesPerSector != "" {

			if err := r.SetQueryParam("bytes_per_sector", qBytesPerSector); err != nil {
				return err
			}
		}
	}

	if o.Class != nil {

		// query param class
		var qrClass string

		if o.Class != nil {
			qrClass = *o.Class
		}
		qClass := qrClass
		if qClass != "" {

			if err := r.SetQueryParam("class", qClass); err != nil {
				return err
			}
		}
	}

	if o.ComplianceStandard != nil {

		// query param compliance_standard
		var qrComplianceStandard string

		if o.ComplianceStandard != nil {
			qrComplianceStandard = *o.ComplianceStandard
		}
		qComplianceStandard := qrComplianceStandard
		if qComplianceStandard != "" {

			if err := r.SetQueryParam("compliance_standard", qComplianceStandard); err != nil {
				return err
			}
		}
	}

	if o.ContainerType != nil {

		// query param container_type
		var qrContainerType string

		if o.ContainerType != nil {
			qrContainerType = *o.ContainerType
		}
		qContainerType := qrContainerType
		if qContainerType != "" {

			if err := r.SetQueryParam("container_type", qContainerType); err != nil {
				return err
			}
		}
	}

	if o.ControlStandard != nil {

		// query param control_standard
		var qrControlStandard string

		if o.ControlStandard != nil {
			qrControlStandard = *o.ControlStandard
		}
		qControlStandard := qrControlStandard
		if qControlStandard != "" {

			if err := r.SetQueryParam("control_standard", qControlStandard); err != nil {
				return err
			}
		}
	}

	if o.DrNodeName != nil {

		// query param dr_node.name
		var qrDrNodeName string

		if o.DrNodeName != nil {
			qrDrNodeName = *o.DrNodeName
		}
		qDrNodeName := qrDrNodeName
		if qDrNodeName != "" {

			if err := r.SetQueryParam("dr_node.name", qDrNodeName); err != nil {
				return err
			}
		}
	}

	if o.DrNodeUUID != nil {

		// query param dr_node.uuid
		var qrDrNodeUUID string

		if o.DrNodeUUID != nil {
			qrDrNodeUUID = *o.DrNodeUUID
		}
		qDrNodeUUID := qrDrNodeUUID
		if qDrNodeUUID != "" {

			if err := r.SetQueryParam("dr_node.uuid", qDrNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.DrawerID != nil {

		// query param drawer.id
		var qrDrawerID int64

		if o.DrawerID != nil {
			qrDrawerID = *o.DrawerID
		}
		qDrawerID := swag.FormatInt64(qrDrawerID)
		if qDrawerID != "" {

			if err := r.SetQueryParam("drawer.id", qDrawerID); err != nil {
				return err
			}
		}
	}

	if o.DrawerSlot != nil {

		// query param drawer.slot
		var qrDrawerSlot int64

		if o.DrawerSlot != nil {
			qrDrawerSlot = *o.DrawerSlot
		}
		qDrawerSlot := swag.FormatInt64(qrDrawerSlot)
		if qDrawerSlot != "" {

			if err := r.SetQueryParam("drawer.slot", qDrawerSlot); err != nil {
				return err
			}
		}
	}

	if o.EffectiveType != nil {

		// query param effective_type
		var qrEffectiveType string

		if o.EffectiveType != nil {
			qrEffectiveType = *o.EffectiveType
		}
		qEffectiveType := qrEffectiveType
		if qEffectiveType != "" {

			if err := r.SetQueryParam("effective_type", qEffectiveType); err != nil {
				return err
			}
		}
	}

	if o.ErrorReasonArgumentsCode != nil {

		// query param error.reason.arguments.code
		var qrErrorReasonArgumentsCode string

		if o.ErrorReasonArgumentsCode != nil {
			qrErrorReasonArgumentsCode = *o.ErrorReasonArgumentsCode
		}
		qErrorReasonArgumentsCode := qrErrorReasonArgumentsCode
		if qErrorReasonArgumentsCode != "" {

			if err := r.SetQueryParam("error.reason.arguments.code", qErrorReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorReasonArgumentsMessage != nil {

		// query param error.reason.arguments.message
		var qrErrorReasonArgumentsMessage string

		if o.ErrorReasonArgumentsMessage != nil {
			qrErrorReasonArgumentsMessage = *o.ErrorReasonArgumentsMessage
		}
		qErrorReasonArgumentsMessage := qrErrorReasonArgumentsMessage
		if qErrorReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("error.reason.arguments.message", qErrorReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorReasonCode != nil {

		// query param error.reason.code
		var qrErrorReasonCode string

		if o.ErrorReasonCode != nil {
			qrErrorReasonCode = *o.ErrorReasonCode
		}
		qErrorReasonCode := qrErrorReasonCode
		if qErrorReasonCode != "" {

			if err := r.SetQueryParam("error.reason.code", qErrorReasonCode); err != nil {
				return err
			}
		}
	}

	if o.ErrorReasonMessage != nil {

		// query param error.reason.message
		var qrErrorReasonMessage string

		if o.ErrorReasonMessage != nil {
			qrErrorReasonMessage = *o.ErrorReasonMessage
		}
		qErrorReasonMessage := qrErrorReasonMessage
		if qErrorReasonMessage != "" {

			if err := r.SetQueryParam("error.reason.message", qErrorReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.ErrorType != nil {

		// query param error.type
		var qrErrorType string

		if o.ErrorType != nil {
			qrErrorType = *o.ErrorType
		}
		qErrorType := qrErrorType
		if qErrorType != "" {

			if err := r.SetQueryParam("error.type", qErrorType); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FipsCertified != nil {

		// query param fips_certified
		var qrFipsCertified bool

		if o.FipsCertified != nil {
			qrFipsCertified = *o.FipsCertified
		}
		qFipsCertified := swag.FormatBool(qrFipsCertified)
		if qFipsCertified != "" {

			if err := r.SetQueryParam("fips_certified", qFipsCertified); err != nil {
				return err
			}
		}
	}

	if o.FirmwareVersion != nil {

		// query param firmware_version
		var qrFirmwareVersion string

		if o.FirmwareVersion != nil {
			qrFirmwareVersion = *o.FirmwareVersion
		}
		qFirmwareVersion := qrFirmwareVersion
		if qFirmwareVersion != "" {

			if err := r.SetQueryParam("firmware_version", qFirmwareVersion); err != nil {
				return err
			}
		}
	}

	if o.HomeNodeName != nil {

		// query param home_node.name
		var qrHomeNodeName string

		if o.HomeNodeName != nil {
			qrHomeNodeName = *o.HomeNodeName
		}
		qHomeNodeName := qrHomeNodeName
		if qHomeNodeName != "" {

			if err := r.SetQueryParam("home_node.name", qHomeNodeName); err != nil {
				return err
			}
		}
	}

	if o.HomeNodeUUID != nil {

		// query param home_node.uuid
		var qrHomeNodeUUID string

		if o.HomeNodeUUID != nil {
			qrHomeNodeUUID = *o.HomeNodeUUID
		}
		qHomeNodeUUID := qrHomeNodeUUID
		if qHomeNodeUUID != "" {

			if err := r.SetQueryParam("home_node.uuid", qHomeNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.KeyIDData != nil {

		// query param key_id.data
		var qrKeyIDData string

		if o.KeyIDData != nil {
			qrKeyIDData = *o.KeyIDData
		}
		qKeyIDData := qrKeyIDData
		if qKeyIDData != "" {

			if err := r.SetQueryParam("key_id.data", qKeyIDData); err != nil {
				return err
			}
		}
	}

	if o.KeyIDFips != nil {

		// query param key_id.fips
		var qrKeyIDFips string

		if o.KeyIDFips != nil {
			qrKeyIDFips = *o.KeyIDFips
		}
		qKeyIDFips := qrKeyIDFips
		if qKeyIDFips != "" {

			if err := r.SetQueryParam("key_id.fips", qKeyIDFips); err != nil {
				return err
			}
		}
	}

	if o.Local != nil {

		// query param local
		var qrLocal bool

		if o.Local != nil {
			qrLocal = *o.Local
		}
		qLocal := swag.FormatBool(qrLocal)
		if qLocal != "" {

			if err := r.SetQueryParam("local", qLocal); err != nil {
				return err
			}
		}
	}

	if o.Location != nil {

		// query param location
		var qrLocation string

		if o.Location != nil {
			qrLocation = *o.Location
		}
		qLocation := qrLocation
		if qLocation != "" {

			if err := r.SetQueryParam("location", qLocation); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OutagePersistentlyFailed != nil {

		// query param outage.persistently_failed
		var qrOutagePersistentlyFailed bool

		if o.OutagePersistentlyFailed != nil {
			qrOutagePersistentlyFailed = *o.OutagePersistentlyFailed
		}
		qOutagePersistentlyFailed := swag.FormatBool(qrOutagePersistentlyFailed)
		if qOutagePersistentlyFailed != "" {

			if err := r.SetQueryParam("outage.persistently_failed", qOutagePersistentlyFailed); err != nil {
				return err
			}
		}
	}

	if o.OutageReasonArgumentsCode != nil {

		// query param outage.reason.arguments.code
		var qrOutageReasonArgumentsCode string

		if o.OutageReasonArgumentsCode != nil {
			qrOutageReasonArgumentsCode = *o.OutageReasonArgumentsCode
		}
		qOutageReasonArgumentsCode := qrOutageReasonArgumentsCode
		if qOutageReasonArgumentsCode != "" {

			if err := r.SetQueryParam("outage.reason.arguments.code", qOutageReasonArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.OutageReasonArgumentsMessage != nil {

		// query param outage.reason.arguments.message
		var qrOutageReasonArgumentsMessage string

		if o.OutageReasonArgumentsMessage != nil {
			qrOutageReasonArgumentsMessage = *o.OutageReasonArgumentsMessage
		}
		qOutageReasonArgumentsMessage := qrOutageReasonArgumentsMessage
		if qOutageReasonArgumentsMessage != "" {

			if err := r.SetQueryParam("outage.reason.arguments.message", qOutageReasonArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.OutageReasonCode != nil {

		// query param outage.reason.code
		var qrOutageReasonCode string

		if o.OutageReasonCode != nil {
			qrOutageReasonCode = *o.OutageReasonCode
		}
		qOutageReasonCode := qrOutageReasonCode
		if qOutageReasonCode != "" {

			if err := r.SetQueryParam("outage.reason.code", qOutageReasonCode); err != nil {
				return err
			}
		}
	}

	if o.OutageReasonMessage != nil {

		// query param outage.reason.message
		var qrOutageReasonMessage string

		if o.OutageReasonMessage != nil {
			qrOutageReasonMessage = *o.OutageReasonMessage
		}
		qOutageReasonMessage := qrOutageReasonMessage
		if qOutageReasonMessage != "" {

			if err := r.SetQueryParam("outage.reason.message", qOutageReasonMessage); err != nil {
				return err
			}
		}
	}

	if o.OverallSecurity != nil {

		// query param overall_security
		var qrOverallSecurity string

		if o.OverallSecurity != nil {
			qrOverallSecurity = *o.OverallSecurity
		}
		qOverallSecurity := qrOverallSecurity
		if qOverallSecurity != "" {

			if err := r.SetQueryParam("overall_security", qOverallSecurity); err != nil {
				return err
			}
		}
	}

	if o.PathsDiskPathName != nil {

		// query param paths.disk_path_name
		var qrPathsDiskPathName string

		if o.PathsDiskPathName != nil {
			qrPathsDiskPathName = *o.PathsDiskPathName
		}
		qPathsDiskPathName := qrPathsDiskPathName
		if qPathsDiskPathName != "" {

			if err := r.SetQueryParam("paths.disk_path_name", qPathsDiskPathName); err != nil {
				return err
			}
		}
	}

	if o.PathsInitiator != nil {

		// query param paths.initiator
		var qrPathsInitiator string

		if o.PathsInitiator != nil {
			qrPathsInitiator = *o.PathsInitiator
		}
		qPathsInitiator := qrPathsInitiator
		if qPathsInitiator != "" {

			if err := r.SetQueryParam("paths.initiator", qPathsInitiator); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeName != nil {

		// query param paths.node.name
		var qrPathsNodeName string

		if o.PathsNodeName != nil {
			qrPathsNodeName = *o.PathsNodeName
		}
		qPathsNodeName := qrPathsNodeName
		if qPathsNodeName != "" {

			if err := r.SetQueryParam("paths.node.name", qPathsNodeName); err != nil {
				return err
			}
		}
	}

	if o.PathsNodeUUID != nil {

		// query param paths.node.uuid
		var qrPathsNodeUUID string

		if o.PathsNodeUUID != nil {
			qrPathsNodeUUID = *o.PathsNodeUUID
		}
		qPathsNodeUUID := qrPathsNodeUUID
		if qPathsNodeUUID != "" {

			if err := r.SetQueryParam("paths.node.uuid", qPathsNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.PathsPortName != nil {

		// query param paths.port_name
		var qrPathsPortName string

		if o.PathsPortName != nil {
			qrPathsPortName = *o.PathsPortName
		}
		qPathsPortName := qrPathsPortName
		if qPathsPortName != "" {

			if err := r.SetQueryParam("paths.port_name", qPathsPortName); err != nil {
				return err
			}
		}
	}

	if o.PathsPortType != nil {

		// query param paths.port_type
		var qrPathsPortType string

		if o.PathsPortType != nil {
			qrPathsPortType = *o.PathsPortType
		}
		qPathsPortType := qrPathsPortType
		if qPathsPortType != "" {

			if err := r.SetQueryParam("paths.port_type", qPathsPortType); err != nil {
				return err
			}
		}
	}

	if o.PathsVmdiskHypervisorFileName != nil {

		// query param paths.vmdisk_hypervisor_file_name
		var qrPathsVmdiskHypervisorFileName string

		if o.PathsVmdiskHypervisorFileName != nil {
			qrPathsVmdiskHypervisorFileName = *o.PathsVmdiskHypervisorFileName
		}
		qPathsVmdiskHypervisorFileName := qrPathsVmdiskHypervisorFileName
		if qPathsVmdiskHypervisorFileName != "" {

			if err := r.SetQueryParam("paths.vmdisk_hypervisor_file_name", qPathsVmdiskHypervisorFileName); err != nil {
				return err
			}
		}
	}

	if o.PathsWwnn != nil {

		// query param paths.wwnn
		var qrPathsWwnn string

		if o.PathsWwnn != nil {
			qrPathsWwnn = *o.PathsWwnn
		}
		qPathsWwnn := qrPathsWwnn
		if qPathsWwnn != "" {

			if err := r.SetQueryParam("paths.wwnn", qPathsWwnn); err != nil {
				return err
			}
		}
	}

	if o.PathsWwpn != nil {

		// query param paths.wwpn
		var qrPathsWwpn string

		if o.PathsWwpn != nil {
			qrPathsWwpn = *o.PathsWwpn
		}
		qPathsWwpn := qrPathsWwpn
		if qPathsWwpn != "" {

			if err := r.SetQueryParam("paths.wwpn", qPathsWwpn); err != nil {
				return err
			}
		}
	}

	if o.PhysicalSize != nil {

		// query param physical_size
		var qrPhysicalSize int64

		if o.PhysicalSize != nil {
			qrPhysicalSize = *o.PhysicalSize
		}
		qPhysicalSize := swag.FormatInt64(qrPhysicalSize)
		if qPhysicalSize != "" {

			if err := r.SetQueryParam("physical_size", qPhysicalSize); err != nil {
				return err
			}
		}
	}

	if o.Pool != nil {

		// query param pool
		var qrPool string

		if o.Pool != nil {
			qrPool = *o.Pool
		}
		qPool := qrPool
		if qPool != "" {

			if err := r.SetQueryParam("pool", qPool); err != nil {
				return err
			}
		}
	}

	if o.ProtectionMode != nil {

		// query param protection_mode
		var qrProtectionMode string

		if o.ProtectionMode != nil {
			qrProtectionMode = *o.ProtectionMode
		}
		qProtectionMode := qrProtectionMode
		if qProtectionMode != "" {

			if err := r.SetQueryParam("protection_mode", qProtectionMode); err != nil {
				return err
			}
		}
	}

	if o.RatedLifeUsedPercent != nil {

		// query param rated_life_used_percent
		var qrRatedLifeUsedPercent int64

		if o.RatedLifeUsedPercent != nil {
			qrRatedLifeUsedPercent = *o.RatedLifeUsedPercent
		}
		qRatedLifeUsedPercent := swag.FormatInt64(qrRatedLifeUsedPercent)
		if qRatedLifeUsedPercent != "" {

			if err := r.SetQueryParam("rated_life_used_percent", qRatedLifeUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RightSizeSectorCount != nil {

		// query param right_size_sector_count
		var qrRightSizeSectorCount int64

		if o.RightSizeSectorCount != nil {
			qrRightSizeSectorCount = *o.RightSizeSectorCount
		}
		qRightSizeSectorCount := swag.FormatInt64(qrRightSizeSectorCount)
		if qRightSizeSectorCount != "" {

			if err := r.SetQueryParam("right_size_sector_count", qRightSizeSectorCount); err != nil {
				return err
			}
		}
	}

	if o.Rpm != nil {

		// query param rpm
		var qrRpm int64

		if o.Rpm != nil {
			qrRpm = *o.Rpm
		}
		qRpm := swag.FormatInt64(qrRpm)
		if qRpm != "" {

			if err := r.SetQueryParam("rpm", qRpm); err != nil {
				return err
			}
		}
	}

	if o.SectorCount != nil {

		// query param sector_count
		var qrSectorCount int64

		if o.SectorCount != nil {
			qrSectorCount = *o.SectorCount
		}
		qSectorCount := swag.FormatInt64(qrSectorCount)
		if qSectorCount != "" {

			if err := r.SetQueryParam("sector_count", qSectorCount); err != nil {
				return err
			}
		}
	}

	if o.SelfEncrypting != nil {

		// query param self_encrypting
		var qrSelfEncrypting bool

		if o.SelfEncrypting != nil {
			qrSelfEncrypting = *o.SelfEncrypting
		}
		qSelfEncrypting := swag.FormatBool(qrSelfEncrypting)
		if qSelfEncrypting != "" {

			if err := r.SetQueryParam("self_encrypting", qSelfEncrypting); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.ShelfUID != nil {

		// query param shelf.uid
		var qrShelfUID string

		if o.ShelfUID != nil {
			qrShelfUID = *o.ShelfUID
		}
		qShelfUID := qrShelfUID
		if qShelfUID != "" {

			if err := r.SetQueryParam("shelf.uid", qShelfUID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatsAverageLatency != nil {

		// query param stats.average_latency
		var qrStatsAverageLatency int64

		if o.StatsAverageLatency != nil {
			qrStatsAverageLatency = *o.StatsAverageLatency
		}
		qStatsAverageLatency := swag.FormatInt64(qrStatsAverageLatency)
		if qStatsAverageLatency != "" {

			if err := r.SetQueryParam("stats.average_latency", qStatsAverageLatency); err != nil {
				return err
			}
		}
	}

	if o.StatsIopsTotal != nil {

		// query param stats.iops_total
		var qrStatsIopsTotal int64

		if o.StatsIopsTotal != nil {
			qrStatsIopsTotal = *o.StatsIopsTotal
		}
		qStatsIopsTotal := swag.FormatInt64(qrStatsIopsTotal)
		if qStatsIopsTotal != "" {

			if err := r.SetQueryParam("stats.iops_total", qStatsIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.StatsPathErrorCount != nil {

		// query param stats.path_error_count
		var qrStatsPathErrorCount int64

		if o.StatsPathErrorCount != nil {
			qrStatsPathErrorCount = *o.StatsPathErrorCount
		}
		qStatsPathErrorCount := swag.FormatInt64(qrStatsPathErrorCount)
		if qStatsPathErrorCount != "" {

			if err := r.SetQueryParam("stats.path_error_count", qStatsPathErrorCount); err != nil {
				return err
			}
		}
	}

	if o.StatsPowerOnHours != nil {

		// query param stats.power_on_hours
		var qrStatsPowerOnHours int64

		if o.StatsPowerOnHours != nil {
			qrStatsPowerOnHours = *o.StatsPowerOnHours
		}
		qStatsPowerOnHours := swag.FormatInt64(qrStatsPowerOnHours)
		if qStatsPowerOnHours != "" {

			if err := r.SetQueryParam("stats.power_on_hours", qStatsPowerOnHours); err != nil {
				return err
			}
		}
	}

	if o.StatsThroughput != nil {

		// query param stats.throughput
		var qrStatsThroughput int64

		if o.StatsThroughput != nil {
			qrStatsThroughput = *o.StatsThroughput
		}
		qStatsThroughput := swag.FormatInt64(qrStatsThroughput)
		if qStatsThroughput != "" {

			if err := r.SetQueryParam("stats.throughput", qStatsThroughput); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZoneName != nil {

		// query param storage_availability_zone.name
		var qrStorageAvailabilityZoneName string

		if o.StorageAvailabilityZoneName != nil {
			qrStorageAvailabilityZoneName = *o.StorageAvailabilityZoneName
		}
		qStorageAvailabilityZoneName := qrStorageAvailabilityZoneName
		if qStorageAvailabilityZoneName != "" {

			if err := r.SetQueryParam("storage_availability_zone.name", qStorageAvailabilityZoneName); err != nil {
				return err
			}
		}
	}

	if o.StorageAvailabilityZoneUUID != nil {

		// query param storage_availability_zone.uuid
		var qrStorageAvailabilityZoneUUID string

		if o.StorageAvailabilityZoneUUID != nil {
			qrStorageAvailabilityZoneUUID = *o.StorageAvailabilityZoneUUID
		}
		qStorageAvailabilityZoneUUID := qrStorageAvailabilityZoneUUID
		if qStorageAvailabilityZoneUUID != "" {

			if err := r.SetQueryParam("storage_availability_zone.uuid", qStorageAvailabilityZoneUUID); err != nil {
				return err
			}
		}
	}

	if o.StoragePoolName != nil {

		// query param storage_pool.name
		var qrStoragePoolName string

		if o.StoragePoolName != nil {
			qrStoragePoolName = *o.StoragePoolName
		}
		qStoragePoolName := qrStoragePoolName
		if qStoragePoolName != "" {

			if err := r.SetQueryParam("storage_pool.name", qStoragePoolName); err != nil {
				return err
			}
		}
	}

	if o.StoragePoolUUID != nil {

		// query param storage_pool.uuid
		var qrStoragePoolUUID string

		if o.StoragePoolUUID != nil {
			qrStoragePoolUUID = *o.StoragePoolUUID
		}
		qStoragePoolUUID := qrStoragePoolUUID
		if qStoragePoolUUID != "" {

			if err := r.SetQueryParam("storage_pool.uuid", qStoragePoolUUID); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UID != nil {

		// query param uid
		var qrUID string

		if o.UID != nil {
			qrUID = *o.UID
		}
		qUID := qrUID
		if qUID != "" {

			if err := r.SetQueryParam("uid", qUID); err != nil {
				return err
			}
		}
	}

	if o.UsableSize != nil {

		// query param usable_size
		var qrUsableSize int64

		if o.UsableSize != nil {
			qrUsableSize = *o.UsableSize
		}
		qUsableSize := swag.FormatInt64(qrUsableSize)
		if qUsableSize != "" {

			if err := r.SetQueryParam("usable_size", qUsableSize); err != nil {
				return err
			}
		}
	}

	if o.Vendor != nil {

		// query param vendor
		var qrVendor string

		if o.Vendor != nil {
			qrVendor = *o.Vendor
		}
		qVendor := qrVendor
		if qVendor != "" {

			if err := r.SetQueryParam("vendor", qVendor); err != nil {
				return err
			}
		}
	}

	if o.VirtualContainer != nil {

		// query param virtual.container
		var qrVirtualContainer string

		if o.VirtualContainer != nil {
			qrVirtualContainer = *o.VirtualContainer
		}
		qVirtualContainer := qrVirtualContainer
		if qVirtualContainer != "" {

			if err := r.SetQueryParam("virtual.container", qVirtualContainer); err != nil {
				return err
			}
		}
	}

	if o.VirtualObject != nil {

		// query param virtual.object
		var qrVirtualObject string

		if o.VirtualObject != nil {
			qrVirtualObject = *o.VirtualObject
		}
		qVirtualObject := qrVirtualObject
		if qVirtualObject != "" {

			if err := r.SetQueryParam("virtual.object", qVirtualObject); err != nil {
				return err
			}
		}
	}

	if o.VirtualStorageAccount != nil {

		// query param virtual.storage_account
		var qrVirtualStorageAccount string

		if o.VirtualStorageAccount != nil {
			qrVirtualStorageAccount = *o.VirtualStorageAccount
		}
		qVirtualStorageAccount := qrVirtualStorageAccount
		if qVirtualStorageAccount != "" {

			if err := r.SetQueryParam("virtual.storage_account", qVirtualStorageAccount); err != nil {
				return err
			}
		}
	}

	if o.VirtualTargetAddress != nil {

		// query param virtual.target_address
		var qrVirtualTargetAddress string

		if o.VirtualTargetAddress != nil {
			qrVirtualTargetAddress = *o.VirtualTargetAddress
		}
		qVirtualTargetAddress := qrVirtualTargetAddress
		if qVirtualTargetAddress != "" {

			if err := r.SetQueryParam("virtual.target_address", qVirtualTargetAddress); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamDiskCollectionGet binds the parameter fields
func (o *DiskCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamDiskCollectionGet binds the parameter order_by
func (o *DiskCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
