// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// DiskGetReader is a Reader for the DiskGet structure.
type DiskGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DiskGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDiskGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDiskGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDiskGetOK creates a DiskGetOK with default headers values
func NewDiskGetOK() *DiskGetOK {
	return &DiskGetOK{}
}

/*
DiskGetOK describes a response with status code 200, with default header values.

OK
*/
type DiskGetOK struct {
	Payload *models.Disk
}

// IsSuccess returns true when this disk get o k response has a 2xx status code
func (o *DiskGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this disk get o k response has a 3xx status code
func (o *DiskGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this disk get o k response has a 4xx status code
func (o *DiskGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this disk get o k response has a 5xx status code
func (o *DiskGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this disk get o k response a status code equal to that given
func (o *DiskGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the disk get o k response
func (o *DiskGetOK) Code() int {
	return 200
}

func (o *DiskGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/disks/{name}][%d] diskGetOK %s", 200, payload)
}

func (o *DiskGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/disks/{name}][%d] diskGetOK %s", 200, payload)
}

func (o *DiskGetOK) GetPayload() *models.Disk {
	return o.Payload
}

func (o *DiskGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Disk)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDiskGetDefault creates a DiskGetDefault with default headers values
func NewDiskGetDefault(code int) *DiskGetDefault {
	return &DiskGetDefault{
		_statusCode: code,
	}
}

/*
DiskGetDefault describes a response with status code -1, with default header values.

Error
*/
type DiskGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this disk get default response has a 2xx status code
func (o *DiskGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this disk get default response has a 3xx status code
func (o *DiskGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this disk get default response has a 4xx status code
func (o *DiskGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this disk get default response has a 5xx status code
func (o *DiskGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this disk get default response a status code equal to that given
func (o *DiskGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the disk get default response
func (o *DiskGetDefault) Code() int {
	return o._statusCode
}

func (o *DiskGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/disks/{name}][%d] disk_get default %s", o._statusCode, payload)
}

func (o *DiskGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/disks/{name}][%d] disk_get default %s", o._statusCode, payload)
}

func (o *DiskGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *DiskGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
