// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewDiskModifyParams creates a new DiskModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewDiskModifyParams() *DiskModifyParams {
	return &DiskModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewDiskModifyParamsWithTimeout creates a new DiskModifyParams object
// with the ability to set a timeout on a request.
func NewDiskModifyParamsWithTimeout(timeout time.Duration) *DiskModifyParams {
	return &DiskModifyParams{
		timeout: timeout,
	}
}

// NewDiskModifyParamsWithContext creates a new DiskModifyParams object
// with the ability to set a context for a request.
func NewDiskModifyParamsWithContext(ctx context.Context) *DiskModifyParams {
	return &DiskModifyParams{
		Context: ctx,
	}
}

// NewDiskModifyParamsWithHTTPClient creates a new DiskModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewDiskModifyParamsWithHTTPClient(client *http.Client) *DiskModifyParams {
	return &DiskModifyParams{
		HTTPClient: client,
	}
}

/*
DiskModifyParams contains all the parameters to send to the API endpoint

	for the disk modify operation.

	Typically these are written to a http.Request.
*/
type DiskModifyParams struct {

	/* EncryptionOperation.

	     Name of the operation to apply to encrypting disks.
	* rekey_data_default changes the data authentication key (AK) to the drive-unique Manufacture Secure ID (MSID) value. Allows the drive to be attached to other clusters. Disables data-at-rest protection without erasing the data.
	* rekey_data_auto_id changes the data authentication key (AK) to an AK the cluster selects automatically. Enables data-at-rest protection.
	* sanitize_disk cryptographically erases all user data from a spare or broken drive by altering the data encryption key. Resets the data AK to the drive-unique MSID value and disables data-at-rest protection. Used when a drive is being repurposed or returned.

	*/
	EncryptionOperation *string

	/* Info.

	   Information section for disk
	*/
	Info *models.Disk

	/* Name.

	   Disk name
	*/
	Name *string

	/* Node.

	   Node to assign disk. This property is not supported on the ASA r2 platform.
	*/
	Node *string

	/* Pool.

	   Pool to assign disk to
	*/
	Pool *string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* SanitizeSpare.

	   Confirms spare disk sanitization (non-cryptographically).
	*/
	SanitizeSpare *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the disk modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DiskModifyParams) WithDefaults() *DiskModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the disk modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *DiskModifyParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := DiskModifyParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the disk modify params
func (o *DiskModifyParams) WithTimeout(timeout time.Duration) *DiskModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the disk modify params
func (o *DiskModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the disk modify params
func (o *DiskModifyParams) WithContext(ctx context.Context) *DiskModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the disk modify params
func (o *DiskModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the disk modify params
func (o *DiskModifyParams) WithHTTPClient(client *http.Client) *DiskModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the disk modify params
func (o *DiskModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithEncryptionOperation adds the encryptionOperation to the disk modify params
func (o *DiskModifyParams) WithEncryptionOperation(encryptionOperation *string) *DiskModifyParams {
	o.SetEncryptionOperation(encryptionOperation)
	return o
}

// SetEncryptionOperation adds the encryptionOperation to the disk modify params
func (o *DiskModifyParams) SetEncryptionOperation(encryptionOperation *string) {
	o.EncryptionOperation = encryptionOperation
}

// WithInfo adds the info to the disk modify params
func (o *DiskModifyParams) WithInfo(info *models.Disk) *DiskModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the disk modify params
func (o *DiskModifyParams) SetInfo(info *models.Disk) {
	o.Info = info
}

// WithName adds the name to the disk modify params
func (o *DiskModifyParams) WithName(name *string) *DiskModifyParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the disk modify params
func (o *DiskModifyParams) SetName(name *string) {
	o.Name = name
}

// WithNode adds the node to the disk modify params
func (o *DiskModifyParams) WithNode(node *string) *DiskModifyParams {
	o.SetNode(node)
	return o
}

// SetNode adds the node to the disk modify params
func (o *DiskModifyParams) SetNode(node *string) {
	o.Node = node
}

// WithPool adds the pool to the disk modify params
func (o *DiskModifyParams) WithPool(pool *string) *DiskModifyParams {
	o.SetPool(pool)
	return o
}

// SetPool adds the pool to the disk modify params
func (o *DiskModifyParams) SetPool(pool *string) {
	o.Pool = pool
}

// WithReturnRecords adds the returnRecords to the disk modify params
func (o *DiskModifyParams) WithReturnRecords(returnRecords *bool) *DiskModifyParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the disk modify params
func (o *DiskModifyParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithSanitizeSpare adds the sanitizeSpare to the disk modify params
func (o *DiskModifyParams) WithSanitizeSpare(sanitizeSpare *bool) *DiskModifyParams {
	o.SetSanitizeSpare(sanitizeSpare)
	return o
}

// SetSanitizeSpare adds the sanitizeSpare to the disk modify params
func (o *DiskModifyParams) SetSanitizeSpare(sanitizeSpare *bool) {
	o.SanitizeSpare = sanitizeSpare
}

// WriteToRequest writes these params to a swagger request
func (o *DiskModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.EncryptionOperation != nil {

		// query param encryption_operation
		var qrEncryptionOperation string

		if o.EncryptionOperation != nil {
			qrEncryptionOperation = *o.EncryptionOperation
		}
		qEncryptionOperation := qrEncryptionOperation
		if qEncryptionOperation != "" {

			if err := r.SetQueryParam("encryption_operation", qEncryptionOperation); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Node != nil {

		// query param node
		var qrNode string

		if o.Node != nil {
			qrNode = *o.Node
		}
		qNode := qrNode
		if qNode != "" {

			if err := r.SetQueryParam("node", qNode); err != nil {
				return err
			}
		}
	}

	if o.Pool != nil {

		// query param pool
		var qrPool string

		if o.Pool != nil {
			qrPool = *o.Pool
		}
		qPool := qrPool
		if qPool != "" {

			if err := r.SetQueryParam("pool", qPool); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.SanitizeSpare != nil {

		// query param sanitize_spare
		var qrSanitizeSpare bool

		if o.SanitizeSpare != nil {
			qrSanitizeSpare = *o.SanitizeSpare
		}
		qSanitizeSpare := swag.FormatBool(qrSanitizeSpare)
		if qSanitizeSpare != "" {

			if err := r.SetQueryParam("sanitize_spare", qSanitizeSpare); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
