// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileDeleteParams creates a new FileDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileDeleteParams() *FileDeleteParams {
	return &FileDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileDeleteParamsWithTimeout creates a new FileDeleteParams object
// with the ability to set a timeout on a request.
func NewFileDeleteParamsWithTimeout(timeout time.Duration) *FileDeleteParams {
	return &FileDeleteParams{
		timeout: timeout,
	}
}

// NewFileDeleteParamsWithContext creates a new FileDeleteParams object
// with the ability to set a context for a request.
func NewFileDeleteParamsWithContext(ctx context.Context) *FileDeleteParams {
	return &FileDeleteParams{
		Context: ctx,
	}
}

// NewFileDeleteParamsWithHTTPClient creates a new FileDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileDeleteParamsWithHTTPClient(client *http.Client) *FileDeleteParams {
	return &FileDeleteParams{
		HTTPClient: client,
	}
}

/*
FileDeleteParams contains all the parameters to send to the API endpoint

	for the file delete operation.

	Typically these are written to a http.Request.
*/
type FileDeleteParams struct {

	/* Path.

	   The relative path of a directory in the volume. The path field requires using "%2E" to represent ".", "%2E%2E" to represent ".." and "%2F" to represent "/" for the path provided. Refer to "relative reference resolution" section in [Getting started with the ONTAP REST API](#Getting_started_with_the_ONTAP_REST_API) for considerations when using "..".
	*/
	Path string

	/* Recurse.

	   Delete an entire directory. The behavior of this call is equivalent to rm -rf.
	*/
	Recurse *bool

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* ThrottleDeletion.

	   The maximum number of directory delete operations per second. A valid throttle_deletion number is an integer from 10 to 100000.
	*/
	ThrottleDeletion *int64

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileDeleteParams) WithDefaults() *FileDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileDeleteParams) SetDefaults() {
	var (
		recurseDefault = bool(false)

		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := FileDeleteParams{
		Recurse:       &recurseDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file delete params
func (o *FileDeleteParams) WithTimeout(timeout time.Duration) *FileDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file delete params
func (o *FileDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file delete params
func (o *FileDeleteParams) WithContext(ctx context.Context) *FileDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file delete params
func (o *FileDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file delete params
func (o *FileDeleteParams) WithHTTPClient(client *http.Client) *FileDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file delete params
func (o *FileDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPath adds the path to the file delete params
func (o *FileDeleteParams) WithPath(path string) *FileDeleteParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the file delete params
func (o *FileDeleteParams) SetPath(path string) {
	o.Path = path
}

// WithRecurse adds the recurse to the file delete params
func (o *FileDeleteParams) WithRecurse(recurse *bool) *FileDeleteParams {
	o.SetRecurse(recurse)
	return o
}

// SetRecurse adds the recurse to the file delete params
func (o *FileDeleteParams) SetRecurse(recurse *bool) {
	o.Recurse = recurse
}

// WithReturnRecords adds the returnRecords to the file delete params
func (o *FileDeleteParams) WithReturnRecords(returnRecords *bool) *FileDeleteParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file delete params
func (o *FileDeleteParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the file delete params
func (o *FileDeleteParams) WithReturnTimeout(returnTimeout *int64) *FileDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the file delete params
func (o *FileDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithThrottleDeletion adds the throttleDeletion to the file delete params
func (o *FileDeleteParams) WithThrottleDeletion(throttleDeletion *int64) *FileDeleteParams {
	o.SetThrottleDeletion(throttleDeletion)
	return o
}

// SetThrottleDeletion adds the throttleDeletion to the file delete params
func (o *FileDeleteParams) SetThrottleDeletion(throttleDeletion *int64) {
	o.ThrottleDeletion = throttleDeletion
}

// WithVolumeUUID adds the volumeUUID to the file delete params
func (o *FileDeleteParams) WithVolumeUUID(volumeUUID string) *FileDeleteParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the file delete params
func (o *FileDeleteParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.Recurse != nil {

		// query param recurse
		var qrRecurse bool

		if o.Recurse != nil {
			qrRecurse = *o.Recurse
		}
		qRecurse := swag.FormatBool(qrRecurse)
		if qRecurse != "" {

			if err := r.SetQueryParam("recurse", qRecurse); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ThrottleDeletion != nil {

		// query param throttle_deletion
		var qrThrottleDeletion int64

		if o.ThrottleDeletion != nil {
			qrThrottleDeletion = *o.ThrottleDeletion
		}
		qThrottleDeletion := swag.FormatInt64(qrThrottleDeletion)
		if qThrottleDeletion != "" {

			if err := r.SetQueryParam("throttle_deletion", qThrottleDeletion); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
