// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileFormDataDeleteParams creates a new FileFormDataDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileFormDataDeleteParams() *FileFormDataDeleteParams {
	return &FileFormDataDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileFormDataDeleteParamsWithTimeout creates a new FileFormDataDeleteParams object
// with the ability to set a timeout on a request.
func NewFileFormDataDeleteParamsWithTimeout(timeout time.Duration) *FileFormDataDeleteParams {
	return &FileFormDataDeleteParams{
		timeout: timeout,
	}
}

// NewFileFormDataDeleteParamsWithContext creates a new FileFormDataDeleteParams object
// with the ability to set a context for a request.
func NewFileFormDataDeleteParamsWithContext(ctx context.Context) *FileFormDataDeleteParams {
	return &FileFormDataDeleteParams{
		Context: ctx,
	}
}

// NewFileFormDataDeleteParamsWithHTTPClient creates a new FileFormDataDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileFormDataDeleteParamsWithHTTPClient(client *http.Client) *FileFormDataDeleteParams {
	return &FileFormDataDeleteParams{
		HTTPClient: client,
	}
}

/*
FileFormDataDeleteParams contains all the parameters to send to the API endpoint

	for the file form data delete operation.

	Typically these are written to a http.Request.
*/
type FileFormDataDeleteParams struct {

	/* Path.

	   The relative path of a directory in the volume. The path field requires using "%2E" to represent ".", "%2E%2E" to represent ".." and "%2F" to represent "/" for the path provided. Refer to "relative reference resolution" section in [Getting started with the ONTAP REST API](#Getting_started_with_the_ONTAP_REST_API) for considerations when using "..".
	*/
	Path string

	/* Recurse.

	   Delete an entire directory. The behavior of this call is equivalent to rm -rf.
	*/
	Recurse *bool

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* ThrottleDeletion.

	   The maximum number of directory delete operations per second. A valid throttle_deletion number is an integer from 10 to 100000.
	*/
	ThrottleDeletion *int64

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file form data delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileFormDataDeleteParams) WithDefaults() *FileFormDataDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file form data delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileFormDataDeleteParams) SetDefaults() {
	var (
		recurseDefault = bool(false)

		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := FileFormDataDeleteParams{
		Recurse:       &recurseDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file form data delete params
func (o *FileFormDataDeleteParams) WithTimeout(timeout time.Duration) *FileFormDataDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file form data delete params
func (o *FileFormDataDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file form data delete params
func (o *FileFormDataDeleteParams) WithContext(ctx context.Context) *FileFormDataDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file form data delete params
func (o *FileFormDataDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file form data delete params
func (o *FileFormDataDeleteParams) WithHTTPClient(client *http.Client) *FileFormDataDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file form data delete params
func (o *FileFormDataDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPath adds the path to the file form data delete params
func (o *FileFormDataDeleteParams) WithPath(path string) *FileFormDataDeleteParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the file form data delete params
func (o *FileFormDataDeleteParams) SetPath(path string) {
	o.Path = path
}

// WithRecurse adds the recurse to the file form data delete params
func (o *FileFormDataDeleteParams) WithRecurse(recurse *bool) *FileFormDataDeleteParams {
	o.SetRecurse(recurse)
	return o
}

// SetRecurse adds the recurse to the file form data delete params
func (o *FileFormDataDeleteParams) SetRecurse(recurse *bool) {
	o.Recurse = recurse
}

// WithReturnRecords adds the returnRecords to the file form data delete params
func (o *FileFormDataDeleteParams) WithReturnRecords(returnRecords *bool) *FileFormDataDeleteParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file form data delete params
func (o *FileFormDataDeleteParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the file form data delete params
func (o *FileFormDataDeleteParams) WithReturnTimeout(returnTimeout *int64) *FileFormDataDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the file form data delete params
func (o *FileFormDataDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithThrottleDeletion adds the throttleDeletion to the file form data delete params
func (o *FileFormDataDeleteParams) WithThrottleDeletion(throttleDeletion *int64) *FileFormDataDeleteParams {
	o.SetThrottleDeletion(throttleDeletion)
	return o
}

// SetThrottleDeletion adds the throttleDeletion to the file form data delete params
func (o *FileFormDataDeleteParams) SetThrottleDeletion(throttleDeletion *int64) {
	o.ThrottleDeletion = throttleDeletion
}

// WithVolumeUUID adds the volumeUUID to the file form data delete params
func (o *FileFormDataDeleteParams) WithVolumeUUID(volumeUUID string) *FileFormDataDeleteParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the file form data delete params
func (o *FileFormDataDeleteParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileFormDataDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.Recurse != nil {

		// query param recurse
		var qrRecurse bool

		if o.Recurse != nil {
			qrRecurse = *o.Recurse
		}
		qRecurse := swag.FormatBool(qrRecurse)
		if qRecurse != "" {

			if err := r.SetQueryParam("recurse", qRecurse); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ThrottleDeletion != nil {

		// query param throttle_deletion
		var qrThrottleDeletion int64

		if o.ThrottleDeletion != nil {
			qrThrottleDeletion = *o.ThrottleDeletion
		}
		qThrottleDeletion := swag.FormatInt64(qrThrottleDeletion)
		if qThrottleDeletion != "" {

			if err := r.SetQueryParam("throttle_deletion", qThrottleDeletion); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
