// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FileInfoCollectionFormDataGetReader is a Reader for the FileInfoCollectionFormDataGet structure.
type FileInfoCollectionFormDataGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FileInfoCollectionFormDataGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFileInfoCollectionFormDataGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFileInfoCollectionFormDataGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFileInfoCollectionFormDataGetOK creates a FileInfoCollectionFormDataGetOK with default headers values
func NewFileInfoCollectionFormDataGetOK() *FileInfoCollectionFormDataGetOK {
	return &FileInfoCollectionFormDataGetOK{}
}

/*
FileInfoCollectionFormDataGetOK describes a response with status code 200, with default header values.

OK
*/
type FileInfoCollectionFormDataGetOK struct {
	Payload *models.FileInfoResponse
}

// IsSuccess returns true when this file info collection form data get o k response has a 2xx status code
func (o *FileInfoCollectionFormDataGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this file info collection form data get o k response has a 3xx status code
func (o *FileInfoCollectionFormDataGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this file info collection form data get o k response has a 4xx status code
func (o *FileInfoCollectionFormDataGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this file info collection form data get o k response has a 5xx status code
func (o *FileInfoCollectionFormDataGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this file info collection form data get o k response a status code equal to that given
func (o *FileInfoCollectionFormDataGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the file info collection form data get o k response
func (o *FileInfoCollectionFormDataGetOK) Code() int {
	return 200
}

func (o *FileInfoCollectionFormDataGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/volumes/{volume.uuid}/files/{path}][%d] fileInfoCollectionFormDataGetOK %s", 200, payload)
}

func (o *FileInfoCollectionFormDataGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/volumes/{volume.uuid}/files/{path}][%d] fileInfoCollectionFormDataGetOK %s", 200, payload)
}

func (o *FileInfoCollectionFormDataGetOK) GetPayload() *models.FileInfoResponse {
	return o.Payload
}

func (o *FileInfoCollectionFormDataGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FileInfoResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFileInfoCollectionFormDataGetDefault creates a FileInfoCollectionFormDataGetDefault with default headers values
func NewFileInfoCollectionFormDataGetDefault(code int) *FileInfoCollectionFormDataGetDefault {
	return &FileInfoCollectionFormDataGetDefault{
		_statusCode: code,
	}
}

/*
	FileInfoCollectionFormDataGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 917752 | Volume is offline. |
| 918235 | A volume with the specified UUID was not found. |
| 6488109 | Operation not supported on FlexCache volumes. |
| 6684674 | No such file or directory. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type FileInfoCollectionFormDataGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this file info collection form data get default response has a 2xx status code
func (o *FileInfoCollectionFormDataGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this file info collection form data get default response has a 3xx status code
func (o *FileInfoCollectionFormDataGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this file info collection form data get default response has a 4xx status code
func (o *FileInfoCollectionFormDataGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this file info collection form data get default response has a 5xx status code
func (o *FileInfoCollectionFormDataGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this file info collection form data get default response a status code equal to that given
func (o *FileInfoCollectionFormDataGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the file info collection form data get default response
func (o *FileInfoCollectionFormDataGetDefault) Code() int {
	return o._statusCode
}

func (o *FileInfoCollectionFormDataGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/volumes/{volume.uuid}/files/{path}][%d] file_info_collection_form_data_get default %s", o._statusCode, payload)
}

func (o *FileInfoCollectionFormDataGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET //storage/volumes/{volume.uuid}/files/{path}][%d] file_info_collection_form_data_get default %s", o._statusCode, payload)
}

func (o *FileInfoCollectionFormDataGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FileInfoCollectionFormDataGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
