// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileInfoCollectionGetParams creates a new FileInfoCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileInfoCollectionGetParams() *FileInfoCollectionGetParams {
	return &FileInfoCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileInfoCollectionGetParamsWithTimeout creates a new FileInfoCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFileInfoCollectionGetParamsWithTimeout(timeout time.Duration) *FileInfoCollectionGetParams {
	return &FileInfoCollectionGetParams{
		timeout: timeout,
	}
}

// NewFileInfoCollectionGetParamsWithContext creates a new FileInfoCollectionGetParams object
// with the ability to set a context for a request.
func NewFileInfoCollectionGetParamsWithContext(ctx context.Context) *FileInfoCollectionGetParams {
	return &FileInfoCollectionGetParams{
		Context: ctx,
	}
}

// NewFileInfoCollectionGetParamsWithHTTPClient creates a new FileInfoCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileInfoCollectionGetParamsWithHTTPClient(client *http.Client) *FileInfoCollectionGetParams {
	return &FileInfoCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FileInfoCollectionGetParams contains all the parameters to send to the API endpoint

	for the file info collection get operation.

	Typically these are written to a http.Request.
*/
type FileInfoCollectionGetParams struct {

	/* AccessedTime.

	   Filter by accessed_time
	*/
	AccessedTime *string

	/* AnalyticsByAccessedTimeBytesUsedAgedDataMetric.

	   Filter by analytics.by_accessed_time.bytes_used.aged_data_metric
	*/
	AnalyticsByAccessedTimeBytesUsedAgedDataMetric *float64

	/* AnalyticsByAccessedTimeBytesUsedLabels.

	   Filter by analytics.by_accessed_time.bytes_used.labels
	*/
	AnalyticsByAccessedTimeBytesUsedLabels *string

	/* AnalyticsByAccessedTimeBytesUsedNewestLabel.

	   Filter by analytics.by_accessed_time.bytes_used.newest_label
	*/
	AnalyticsByAccessedTimeBytesUsedNewestLabel *string

	/* AnalyticsByAccessedTimeBytesUsedOldestLabel.

	   Filter by analytics.by_accessed_time.bytes_used.oldest_label
	*/
	AnalyticsByAccessedTimeBytesUsedOldestLabel *string

	/* AnalyticsByAccessedTimeBytesUsedPercentages.

	   Filter by analytics.by_accessed_time.bytes_used.percentages
	*/
	AnalyticsByAccessedTimeBytesUsedPercentages *float64

	/* AnalyticsByAccessedTimeBytesUsedValues.

	   Filter by analytics.by_accessed_time.bytes_used.values
	*/
	AnalyticsByAccessedTimeBytesUsedValues *int64

	/* AnalyticsByModifiedTimeBytesUsedAgedDataMetric.

	   Filter by analytics.by_modified_time.bytes_used.aged_data_metric
	*/
	AnalyticsByModifiedTimeBytesUsedAgedDataMetric *float64

	/* AnalyticsByModifiedTimeBytesUsedLabels.

	   Filter by analytics.by_modified_time.bytes_used.labels
	*/
	AnalyticsByModifiedTimeBytesUsedLabels *string

	/* AnalyticsByModifiedTimeBytesUsedNewestLabel.

	   Filter by analytics.by_modified_time.bytes_used.newest_label
	*/
	AnalyticsByModifiedTimeBytesUsedNewestLabel *string

	/* AnalyticsByModifiedTimeBytesUsedOldestLabel.

	   Filter by analytics.by_modified_time.bytes_used.oldest_label
	*/
	AnalyticsByModifiedTimeBytesUsedOldestLabel *string

	/* AnalyticsByModifiedTimeBytesUsedPercentages.

	   Filter by analytics.by_modified_time.bytes_used.percentages
	*/
	AnalyticsByModifiedTimeBytesUsedPercentages *float64

	/* AnalyticsByModifiedTimeBytesUsedValues.

	   Filter by analytics.by_modified_time.bytes_used.values
	*/
	AnalyticsByModifiedTimeBytesUsedValues *int64

	/* AnalyticsBytesUsed.

	   Filter by analytics.bytes_used
	*/
	AnalyticsBytesUsed *int64

	/* AnalyticsFileCount.

	   Filter by analytics.file_count
	*/
	AnalyticsFileCount *int64

	/* AnalyticsHistogramByTimeLabels.

	     Request that returned [`analytics_histogram_by_time`](#model-analytics_histogram_by_time) objects including values associated with the specified labels. <br/>
	As described in the object description, the labels may take the following forms:<ul>
	<li><i>partial-date</i></li>
	<li><tt><span>-</span>-</tt><i>partial-date</i></li>
	<li><i>partial-date</i><tt><span>-</span>-</tt></li>
	<li><i>partial-date</i><span><tt>-</span>-</tt><i>partial-date</i></li>
	<li><tt>unknown</tt></li>
	</ul>Intervals that the system would not normally return may be specified.  In this case, the appropriate values and percentages summarizing all files with a time-based attribute within the indicated period of time are calculated and returned in the response.  However, there are some restrictions:<ul>
	<li>Any <i>partial-date</i> specified as the beginning or end of an interval must be tracked by the system.  Valid <i>partial-date</i>s may be determined by making an OPTIONS request to the <tt>/storage/volumes/{volume.uuid}/files/{path}</tt> endpoint.</li>
	<li>Intervals may not mix week-based <i>partial-date</i>s in the form <i>yyyy</i>-W<i>ww</i> with other types of <i>partial-date</i>s.</li>
	</ul>

	*/
	AnalyticsHistogramByTimeLabels []string

	/* AnalyticsIncompleteData.

	   Filter by analytics.incomplete_data
	*/
	AnalyticsIncompleteData *bool

	/* AnalyticsReportTime.

	   Filter by analytics.report_time
	*/
	AnalyticsReportTime *string

	/* AnalyticsSubdirCount.

	   Filter by analytics.subdir_count
	*/
	AnalyticsSubdirCount *int64

	/* ByteOffset.

	   The file offset to start reading from.
	*/
	ByteOffset *int64

	/* BytesUsed.

	   Filter by bytes_used
	*/
	BytesUsed *int64

	/* ChangedTime.

	   Filter by changed_time
	*/
	ChangedTime *string

	/* ConstituentName.

	   Filter by constituent.name
	*/
	ConstituentName *string

	/* ConstituentUUID.

	   Filter by constituent.uuid
	*/
	ConstituentUUID *string

	/* CreationTime.

	   Filter by creation_time
	*/
	CreationTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FillEnabled.

	   Filter by fill_enabled
	*/
	FillEnabled *bool

	/* GroupID.

	   Filter by group_id
	*/
	GroupID *int64

	/* HardLinksCount.

	   Filter by hard_links_count
	*/
	HardLinksCount *int64

	/* InodeGeneration.

	   Filter by inode_generation
	*/
	InodeGeneration *int64

	/* InodeNumber.

	   Filter by inode_number
	*/
	InodeNumber *int64

	/* IsEmpty.

	   Filter by is_empty
	*/
	IsEmpty *bool

	/* IsJunction.

	   Filter by is_junction
	*/
	IsJunction *bool

	/* IsSnapshot.

	   Filter by is_snapshot
	*/
	IsSnapshot *bool

	/* IsVMAligned.

	   Filter by is_vm_aligned
	*/
	IsVMAligned *bool

	/* Length.

	   Length of the range in bytes.
	*/
	Length *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* ModifiedTime.

	   Filter by modified_time
	*/
	ModifiedTime *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* OverwriteEnabled.

	   Filter by overwrite_enabled
	*/
	OverwriteEnabled *bool

	/* OwnerID.

	   Filter by owner_id
	*/
	OwnerID *int64

	/* Path.

	   Relative path of a file or directory in the volume. The path field requires using "%2E" to represent "." and "%2F" to represent "/" for the path provided.
	*/
	Path string

	/* QosPolicyName.

	   Filter by qos_policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter by qos_policy.uuid
	*/
	QosPolicyUUID *string

	/* ReturnMetadata.

	   If true, the request returns metadata for the the directory or file specified in the path.
	*/
	ReturnMetadata *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* Target.

	   Filter by target
	*/
	Target *string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UniqueBytes.

	   Filter by unique_bytes
	*/
	UniqueBytes *int64

	/* UnixPermissions.

	   Filter by unix_permissions
	*/
	UnixPermissions *int64

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file info collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileInfoCollectionGetParams) WithDefaults() *FileInfoCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file info collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileInfoCollectionGetParams) SetDefaults() {
	var (
		returnMetadataDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FileInfoCollectionGetParams{
		ReturnMetadata: &returnMetadataDefault,
		ReturnRecords:  &returnRecordsDefault,
		ReturnTimeout:  &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file info collection get params
func (o *FileInfoCollectionGetParams) WithTimeout(timeout time.Duration) *FileInfoCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file info collection get params
func (o *FileInfoCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file info collection get params
func (o *FileInfoCollectionGetParams) WithContext(ctx context.Context) *FileInfoCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file info collection get params
func (o *FileInfoCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file info collection get params
func (o *FileInfoCollectionGetParams) WithHTTPClient(client *http.Client) *FileInfoCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file info collection get params
func (o *FileInfoCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAccessedTime adds the accessedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAccessedTime(accessedTime *string) *FileInfoCollectionGetParams {
	o.SetAccessedTime(accessedTime)
	return o
}

// SetAccessedTime adds the accessedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAccessedTime(accessedTime *string) {
	o.AccessedTime = accessedTime
}

// WithAnalyticsByAccessedTimeBytesUsedAgedDataMetric adds the analyticsByAccessedTimeBytesUsedAgedDataMetric to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric *float64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric adds the analyticsByAccessedTimeBytesUsedAgedDataMetric to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedAgedDataMetric(analyticsByAccessedTimeBytesUsedAgedDataMetric *float64) {
	o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric = analyticsByAccessedTimeBytesUsedAgedDataMetric
}

// WithAnalyticsByAccessedTimeBytesUsedLabels adds the analyticsByAccessedTimeBytesUsedLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedLabels adds the analyticsByAccessedTimeBytesUsedLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedLabels(analyticsByAccessedTimeBytesUsedLabels *string) {
	o.AnalyticsByAccessedTimeBytesUsedLabels = analyticsByAccessedTimeBytesUsedLabels
}

// WithAnalyticsByAccessedTimeBytesUsedNewestLabel adds the analyticsByAccessedTimeBytesUsedNewestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedNewestLabel adds the analyticsByAccessedTimeBytesUsedNewestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedNewestLabel(analyticsByAccessedTimeBytesUsedNewestLabel *string) {
	o.AnalyticsByAccessedTimeBytesUsedNewestLabel = analyticsByAccessedTimeBytesUsedNewestLabel
}

// WithAnalyticsByAccessedTimeBytesUsedOldestLabel adds the analyticsByAccessedTimeBytesUsedOldestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedOldestLabel adds the analyticsByAccessedTimeBytesUsedOldestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedOldestLabel(analyticsByAccessedTimeBytesUsedOldestLabel *string) {
	o.AnalyticsByAccessedTimeBytesUsedOldestLabel = analyticsByAccessedTimeBytesUsedOldestLabel
}

// WithAnalyticsByAccessedTimeBytesUsedPercentages adds the analyticsByAccessedTimeBytesUsedPercentages to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages *float64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedPercentages adds the analyticsByAccessedTimeBytesUsedPercentages to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedPercentages(analyticsByAccessedTimeBytesUsedPercentages *float64) {
	o.AnalyticsByAccessedTimeBytesUsedPercentages = analyticsByAccessedTimeBytesUsedPercentages
}

// WithAnalyticsByAccessedTimeBytesUsedValues adds the analyticsByAccessedTimeBytesUsedValues to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues *int64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues)
	return o
}

// SetAnalyticsByAccessedTimeBytesUsedValues adds the analyticsByAccessedTimeBytesUsedValues to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByAccessedTimeBytesUsedValues(analyticsByAccessedTimeBytesUsedValues *int64) {
	o.AnalyticsByAccessedTimeBytesUsedValues = analyticsByAccessedTimeBytesUsedValues
}

// WithAnalyticsByModifiedTimeBytesUsedAgedDataMetric adds the analyticsByModifiedTimeBytesUsedAgedDataMetric to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric *float64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric adds the analyticsByModifiedTimeBytesUsedAgedDataMetric to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedAgedDataMetric(analyticsByModifiedTimeBytesUsedAgedDataMetric *float64) {
	o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric = analyticsByModifiedTimeBytesUsedAgedDataMetric
}

// WithAnalyticsByModifiedTimeBytesUsedLabels adds the analyticsByModifiedTimeBytesUsedLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedLabels adds the analyticsByModifiedTimeBytesUsedLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedLabels(analyticsByModifiedTimeBytesUsedLabels *string) {
	o.AnalyticsByModifiedTimeBytesUsedLabels = analyticsByModifiedTimeBytesUsedLabels
}

// WithAnalyticsByModifiedTimeBytesUsedNewestLabel adds the analyticsByModifiedTimeBytesUsedNewestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedNewestLabel adds the analyticsByModifiedTimeBytesUsedNewestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedNewestLabel(analyticsByModifiedTimeBytesUsedNewestLabel *string) {
	o.AnalyticsByModifiedTimeBytesUsedNewestLabel = analyticsByModifiedTimeBytesUsedNewestLabel
}

// WithAnalyticsByModifiedTimeBytesUsedOldestLabel adds the analyticsByModifiedTimeBytesUsedOldestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedOldestLabel adds the analyticsByModifiedTimeBytesUsedOldestLabel to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedOldestLabel(analyticsByModifiedTimeBytesUsedOldestLabel *string) {
	o.AnalyticsByModifiedTimeBytesUsedOldestLabel = analyticsByModifiedTimeBytesUsedOldestLabel
}

// WithAnalyticsByModifiedTimeBytesUsedPercentages adds the analyticsByModifiedTimeBytesUsedPercentages to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages *float64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedPercentages adds the analyticsByModifiedTimeBytesUsedPercentages to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedPercentages(analyticsByModifiedTimeBytesUsedPercentages *float64) {
	o.AnalyticsByModifiedTimeBytesUsedPercentages = analyticsByModifiedTimeBytesUsedPercentages
}

// WithAnalyticsByModifiedTimeBytesUsedValues adds the analyticsByModifiedTimeBytesUsedValues to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues *int64) *FileInfoCollectionGetParams {
	o.SetAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues)
	return o
}

// SetAnalyticsByModifiedTimeBytesUsedValues adds the analyticsByModifiedTimeBytesUsedValues to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsByModifiedTimeBytesUsedValues(analyticsByModifiedTimeBytesUsedValues *int64) {
	o.AnalyticsByModifiedTimeBytesUsedValues = analyticsByModifiedTimeBytesUsedValues
}

// WithAnalyticsBytesUsed adds the analyticsBytesUsed to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsBytesUsed(analyticsBytesUsed *int64) *FileInfoCollectionGetParams {
	o.SetAnalyticsBytesUsed(analyticsBytesUsed)
	return o
}

// SetAnalyticsBytesUsed adds the analyticsBytesUsed to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsBytesUsed(analyticsBytesUsed *int64) {
	o.AnalyticsBytesUsed = analyticsBytesUsed
}

// WithAnalyticsFileCount adds the analyticsFileCount to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsFileCount(analyticsFileCount *int64) *FileInfoCollectionGetParams {
	o.SetAnalyticsFileCount(analyticsFileCount)
	return o
}

// SetAnalyticsFileCount adds the analyticsFileCount to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsFileCount(analyticsFileCount *int64) {
	o.AnalyticsFileCount = analyticsFileCount
}

// WithAnalyticsHistogramByTimeLabels adds the analyticsHistogramByTimeLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsHistogramByTimeLabels(analyticsHistogramByTimeLabels []string) *FileInfoCollectionGetParams {
	o.SetAnalyticsHistogramByTimeLabels(analyticsHistogramByTimeLabels)
	return o
}

// SetAnalyticsHistogramByTimeLabels adds the analyticsHistogramByTimeLabels to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsHistogramByTimeLabels(analyticsHistogramByTimeLabels []string) {
	o.AnalyticsHistogramByTimeLabels = analyticsHistogramByTimeLabels
}

// WithAnalyticsIncompleteData adds the analyticsIncompleteData to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsIncompleteData(analyticsIncompleteData *bool) *FileInfoCollectionGetParams {
	o.SetAnalyticsIncompleteData(analyticsIncompleteData)
	return o
}

// SetAnalyticsIncompleteData adds the analyticsIncompleteData to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsIncompleteData(analyticsIncompleteData *bool) {
	o.AnalyticsIncompleteData = analyticsIncompleteData
}

// WithAnalyticsReportTime adds the analyticsReportTime to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsReportTime(analyticsReportTime *string) *FileInfoCollectionGetParams {
	o.SetAnalyticsReportTime(analyticsReportTime)
	return o
}

// SetAnalyticsReportTime adds the analyticsReportTime to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsReportTime(analyticsReportTime *string) {
	o.AnalyticsReportTime = analyticsReportTime
}

// WithAnalyticsSubdirCount adds the analyticsSubdirCount to the file info collection get params
func (o *FileInfoCollectionGetParams) WithAnalyticsSubdirCount(analyticsSubdirCount *int64) *FileInfoCollectionGetParams {
	o.SetAnalyticsSubdirCount(analyticsSubdirCount)
	return o
}

// SetAnalyticsSubdirCount adds the analyticsSubdirCount to the file info collection get params
func (o *FileInfoCollectionGetParams) SetAnalyticsSubdirCount(analyticsSubdirCount *int64) {
	o.AnalyticsSubdirCount = analyticsSubdirCount
}

// WithByteOffset adds the byteOffset to the file info collection get params
func (o *FileInfoCollectionGetParams) WithByteOffset(byteOffset *int64) *FileInfoCollectionGetParams {
	o.SetByteOffset(byteOffset)
	return o
}

// SetByteOffset adds the byteOffset to the file info collection get params
func (o *FileInfoCollectionGetParams) SetByteOffset(byteOffset *int64) {
	o.ByteOffset = byteOffset
}

// WithBytesUsed adds the bytesUsed to the file info collection get params
func (o *FileInfoCollectionGetParams) WithBytesUsed(bytesUsed *int64) *FileInfoCollectionGetParams {
	o.SetBytesUsed(bytesUsed)
	return o
}

// SetBytesUsed adds the bytesUsed to the file info collection get params
func (o *FileInfoCollectionGetParams) SetBytesUsed(bytesUsed *int64) {
	o.BytesUsed = bytesUsed
}

// WithChangedTime adds the changedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) WithChangedTime(changedTime *string) *FileInfoCollectionGetParams {
	o.SetChangedTime(changedTime)
	return o
}

// SetChangedTime adds the changedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) SetChangedTime(changedTime *string) {
	o.ChangedTime = changedTime
}

// WithConstituentName adds the constituentName to the file info collection get params
func (o *FileInfoCollectionGetParams) WithConstituentName(constituentName *string) *FileInfoCollectionGetParams {
	o.SetConstituentName(constituentName)
	return o
}

// SetConstituentName adds the constituentName to the file info collection get params
func (o *FileInfoCollectionGetParams) SetConstituentName(constituentName *string) {
	o.ConstituentName = constituentName
}

// WithConstituentUUID adds the constituentUUID to the file info collection get params
func (o *FileInfoCollectionGetParams) WithConstituentUUID(constituentUUID *string) *FileInfoCollectionGetParams {
	o.SetConstituentUUID(constituentUUID)
	return o
}

// SetConstituentUUID adds the constituentUuid to the file info collection get params
func (o *FileInfoCollectionGetParams) SetConstituentUUID(constituentUUID *string) {
	o.ConstituentUUID = constituentUUID
}

// WithCreationTime adds the creationTime to the file info collection get params
func (o *FileInfoCollectionGetParams) WithCreationTime(creationTime *string) *FileInfoCollectionGetParams {
	o.SetCreationTime(creationTime)
	return o
}

// SetCreationTime adds the creationTime to the file info collection get params
func (o *FileInfoCollectionGetParams) SetCreationTime(creationTime *string) {
	o.CreationTime = creationTime
}

// WithFields adds the fields to the file info collection get params
func (o *FileInfoCollectionGetParams) WithFields(fields []string) *FileInfoCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the file info collection get params
func (o *FileInfoCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFillEnabled adds the fillEnabled to the file info collection get params
func (o *FileInfoCollectionGetParams) WithFillEnabled(fillEnabled *bool) *FileInfoCollectionGetParams {
	o.SetFillEnabled(fillEnabled)
	return o
}

// SetFillEnabled adds the fillEnabled to the file info collection get params
func (o *FileInfoCollectionGetParams) SetFillEnabled(fillEnabled *bool) {
	o.FillEnabled = fillEnabled
}

// WithGroupID adds the groupID to the file info collection get params
func (o *FileInfoCollectionGetParams) WithGroupID(groupID *int64) *FileInfoCollectionGetParams {
	o.SetGroupID(groupID)
	return o
}

// SetGroupID adds the groupId to the file info collection get params
func (o *FileInfoCollectionGetParams) SetGroupID(groupID *int64) {
	o.GroupID = groupID
}

// WithHardLinksCount adds the hardLinksCount to the file info collection get params
func (o *FileInfoCollectionGetParams) WithHardLinksCount(hardLinksCount *int64) *FileInfoCollectionGetParams {
	o.SetHardLinksCount(hardLinksCount)
	return o
}

// SetHardLinksCount adds the hardLinksCount to the file info collection get params
func (o *FileInfoCollectionGetParams) SetHardLinksCount(hardLinksCount *int64) {
	o.HardLinksCount = hardLinksCount
}

// WithInodeGeneration adds the inodeGeneration to the file info collection get params
func (o *FileInfoCollectionGetParams) WithInodeGeneration(inodeGeneration *int64) *FileInfoCollectionGetParams {
	o.SetInodeGeneration(inodeGeneration)
	return o
}

// SetInodeGeneration adds the inodeGeneration to the file info collection get params
func (o *FileInfoCollectionGetParams) SetInodeGeneration(inodeGeneration *int64) {
	o.InodeGeneration = inodeGeneration
}

// WithInodeNumber adds the inodeNumber to the file info collection get params
func (o *FileInfoCollectionGetParams) WithInodeNumber(inodeNumber *int64) *FileInfoCollectionGetParams {
	o.SetInodeNumber(inodeNumber)
	return o
}

// SetInodeNumber adds the inodeNumber to the file info collection get params
func (o *FileInfoCollectionGetParams) SetInodeNumber(inodeNumber *int64) {
	o.InodeNumber = inodeNumber
}

// WithIsEmpty adds the isEmpty to the file info collection get params
func (o *FileInfoCollectionGetParams) WithIsEmpty(isEmpty *bool) *FileInfoCollectionGetParams {
	o.SetIsEmpty(isEmpty)
	return o
}

// SetIsEmpty adds the isEmpty to the file info collection get params
func (o *FileInfoCollectionGetParams) SetIsEmpty(isEmpty *bool) {
	o.IsEmpty = isEmpty
}

// WithIsJunction adds the isJunction to the file info collection get params
func (o *FileInfoCollectionGetParams) WithIsJunction(isJunction *bool) *FileInfoCollectionGetParams {
	o.SetIsJunction(isJunction)
	return o
}

// SetIsJunction adds the isJunction to the file info collection get params
func (o *FileInfoCollectionGetParams) SetIsJunction(isJunction *bool) {
	o.IsJunction = isJunction
}

// WithIsSnapshot adds the isSnapshot to the file info collection get params
func (o *FileInfoCollectionGetParams) WithIsSnapshot(isSnapshot *bool) *FileInfoCollectionGetParams {
	o.SetIsSnapshot(isSnapshot)
	return o
}

// SetIsSnapshot adds the isSnapshot to the file info collection get params
func (o *FileInfoCollectionGetParams) SetIsSnapshot(isSnapshot *bool) {
	o.IsSnapshot = isSnapshot
}

// WithIsVMAligned adds the isVMAligned to the file info collection get params
func (o *FileInfoCollectionGetParams) WithIsVMAligned(isVMAligned *bool) *FileInfoCollectionGetParams {
	o.SetIsVMAligned(isVMAligned)
	return o
}

// SetIsVMAligned adds the isVmAligned to the file info collection get params
func (o *FileInfoCollectionGetParams) SetIsVMAligned(isVMAligned *bool) {
	o.IsVMAligned = isVMAligned
}

// WithLength adds the length to the file info collection get params
func (o *FileInfoCollectionGetParams) WithLength(length *int64) *FileInfoCollectionGetParams {
	o.SetLength(length)
	return o
}

// SetLength adds the length to the file info collection get params
func (o *FileInfoCollectionGetParams) SetLength(length *int64) {
	o.Length = length
}

// WithMaxRecords adds the maxRecords to the file info collection get params
func (o *FileInfoCollectionGetParams) WithMaxRecords(maxRecords *int64) *FileInfoCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the file info collection get params
func (o *FileInfoCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithModifiedTime adds the modifiedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) WithModifiedTime(modifiedTime *string) *FileInfoCollectionGetParams {
	o.SetModifiedTime(modifiedTime)
	return o
}

// SetModifiedTime adds the modifiedTime to the file info collection get params
func (o *FileInfoCollectionGetParams) SetModifiedTime(modifiedTime *string) {
	o.ModifiedTime = modifiedTime
}

// WithName adds the name to the file info collection get params
func (o *FileInfoCollectionGetParams) WithName(name *string) *FileInfoCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the file info collection get params
func (o *FileInfoCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the file info collection get params
func (o *FileInfoCollectionGetParams) WithOrderBy(orderBy []string) *FileInfoCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the file info collection get params
func (o *FileInfoCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithOverwriteEnabled adds the overwriteEnabled to the file info collection get params
func (o *FileInfoCollectionGetParams) WithOverwriteEnabled(overwriteEnabled *bool) *FileInfoCollectionGetParams {
	o.SetOverwriteEnabled(overwriteEnabled)
	return o
}

// SetOverwriteEnabled adds the overwriteEnabled to the file info collection get params
func (o *FileInfoCollectionGetParams) SetOverwriteEnabled(overwriteEnabled *bool) {
	o.OverwriteEnabled = overwriteEnabled
}

// WithOwnerID adds the ownerID to the file info collection get params
func (o *FileInfoCollectionGetParams) WithOwnerID(ownerID *int64) *FileInfoCollectionGetParams {
	o.SetOwnerID(ownerID)
	return o
}

// SetOwnerID adds the ownerId to the file info collection get params
func (o *FileInfoCollectionGetParams) SetOwnerID(ownerID *int64) {
	o.OwnerID = ownerID
}

// WithPath adds the path to the file info collection get params
func (o *FileInfoCollectionGetParams) WithPath(path string) *FileInfoCollectionGetParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the file info collection get params
func (o *FileInfoCollectionGetParams) SetPath(path string) {
	o.Path = path
}

// WithQosPolicyName adds the qosPolicyName to the file info collection get params
func (o *FileInfoCollectionGetParams) WithQosPolicyName(qosPolicyName *string) *FileInfoCollectionGetParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the file info collection get params
func (o *FileInfoCollectionGetParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the file info collection get params
func (o *FileInfoCollectionGetParams) WithQosPolicyUUID(qosPolicyUUID *string) *FileInfoCollectionGetParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the file info collection get params
func (o *FileInfoCollectionGetParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithReturnMetadata adds the returnMetadata to the file info collection get params
func (o *FileInfoCollectionGetParams) WithReturnMetadata(returnMetadata *bool) *FileInfoCollectionGetParams {
	o.SetReturnMetadata(returnMetadata)
	return o
}

// SetReturnMetadata adds the returnMetadata to the file info collection get params
func (o *FileInfoCollectionGetParams) SetReturnMetadata(returnMetadata *bool) {
	o.ReturnMetadata = returnMetadata
}

// WithReturnRecords adds the returnRecords to the file info collection get params
func (o *FileInfoCollectionGetParams) WithReturnRecords(returnRecords *bool) *FileInfoCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file info collection get params
func (o *FileInfoCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the file info collection get params
func (o *FileInfoCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FileInfoCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the file info collection get params
func (o *FileInfoCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSize adds the size to the file info collection get params
func (o *FileInfoCollectionGetParams) WithSize(size *int64) *FileInfoCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the file info collection get params
func (o *FileInfoCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithTarget adds the target to the file info collection get params
func (o *FileInfoCollectionGetParams) WithTarget(target *string) *FileInfoCollectionGetParams {
	o.SetTarget(target)
	return o
}

// SetTarget adds the target to the file info collection get params
func (o *FileInfoCollectionGetParams) SetTarget(target *string) {
	o.Target = target
}

// WithType adds the typeVar to the file info collection get params
func (o *FileInfoCollectionGetParams) WithType(typeVar *string) *FileInfoCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the file info collection get params
func (o *FileInfoCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUniqueBytes adds the uniqueBytes to the file info collection get params
func (o *FileInfoCollectionGetParams) WithUniqueBytes(uniqueBytes *int64) *FileInfoCollectionGetParams {
	o.SetUniqueBytes(uniqueBytes)
	return o
}

// SetUniqueBytes adds the uniqueBytes to the file info collection get params
func (o *FileInfoCollectionGetParams) SetUniqueBytes(uniqueBytes *int64) {
	o.UniqueBytes = uniqueBytes
}

// WithUnixPermissions adds the unixPermissions to the file info collection get params
func (o *FileInfoCollectionGetParams) WithUnixPermissions(unixPermissions *int64) *FileInfoCollectionGetParams {
	o.SetUnixPermissions(unixPermissions)
	return o
}

// SetUnixPermissions adds the unixPermissions to the file info collection get params
func (o *FileInfoCollectionGetParams) SetUnixPermissions(unixPermissions *int64) {
	o.UnixPermissions = unixPermissions
}

// WithVolumeName adds the volumeName to the file info collection get params
func (o *FileInfoCollectionGetParams) WithVolumeName(volumeName *string) *FileInfoCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the file info collection get params
func (o *FileInfoCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the file info collection get params
func (o *FileInfoCollectionGetParams) WithVolumeUUID(volumeUUID string) *FileInfoCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the file info collection get params
func (o *FileInfoCollectionGetParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileInfoCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AccessedTime != nil {

		// query param accessed_time
		var qrAccessedTime string

		if o.AccessedTime != nil {
			qrAccessedTime = *o.AccessedTime
		}
		qAccessedTime := qrAccessedTime
		if qAccessedTime != "" {

			if err := r.SetQueryParam("accessed_time", qAccessedTime); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric != nil {

		// query param analytics.by_accessed_time.bytes_used.aged_data_metric
		var qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric float64

		if o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric != nil {
			qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric = *o.AnalyticsByAccessedTimeBytesUsedAgedDataMetric
		}
		qAnalyticsByAccessedTimeBytesUsedAgedDataMetric := swag.FormatFloat64(qrAnalyticsByAccessedTimeBytesUsedAgedDataMetric)
		if qAnalyticsByAccessedTimeBytesUsedAgedDataMetric != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.aged_data_metric", qAnalyticsByAccessedTimeBytesUsedAgedDataMetric); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedLabels != nil {

		// query param analytics.by_accessed_time.bytes_used.labels
		var qrAnalyticsByAccessedTimeBytesUsedLabels string

		if o.AnalyticsByAccessedTimeBytesUsedLabels != nil {
			qrAnalyticsByAccessedTimeBytesUsedLabels = *o.AnalyticsByAccessedTimeBytesUsedLabels
		}
		qAnalyticsByAccessedTimeBytesUsedLabels := qrAnalyticsByAccessedTimeBytesUsedLabels
		if qAnalyticsByAccessedTimeBytesUsedLabels != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.labels", qAnalyticsByAccessedTimeBytesUsedLabels); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedNewestLabel != nil {

		// query param analytics.by_accessed_time.bytes_used.newest_label
		var qrAnalyticsByAccessedTimeBytesUsedNewestLabel string

		if o.AnalyticsByAccessedTimeBytesUsedNewestLabel != nil {
			qrAnalyticsByAccessedTimeBytesUsedNewestLabel = *o.AnalyticsByAccessedTimeBytesUsedNewestLabel
		}
		qAnalyticsByAccessedTimeBytesUsedNewestLabel := qrAnalyticsByAccessedTimeBytesUsedNewestLabel
		if qAnalyticsByAccessedTimeBytesUsedNewestLabel != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.newest_label", qAnalyticsByAccessedTimeBytesUsedNewestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedOldestLabel != nil {

		// query param analytics.by_accessed_time.bytes_used.oldest_label
		var qrAnalyticsByAccessedTimeBytesUsedOldestLabel string

		if o.AnalyticsByAccessedTimeBytesUsedOldestLabel != nil {
			qrAnalyticsByAccessedTimeBytesUsedOldestLabel = *o.AnalyticsByAccessedTimeBytesUsedOldestLabel
		}
		qAnalyticsByAccessedTimeBytesUsedOldestLabel := qrAnalyticsByAccessedTimeBytesUsedOldestLabel
		if qAnalyticsByAccessedTimeBytesUsedOldestLabel != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.oldest_label", qAnalyticsByAccessedTimeBytesUsedOldestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedPercentages != nil {

		// query param analytics.by_accessed_time.bytes_used.percentages
		var qrAnalyticsByAccessedTimeBytesUsedPercentages float64

		if o.AnalyticsByAccessedTimeBytesUsedPercentages != nil {
			qrAnalyticsByAccessedTimeBytesUsedPercentages = *o.AnalyticsByAccessedTimeBytesUsedPercentages
		}
		qAnalyticsByAccessedTimeBytesUsedPercentages := swag.FormatFloat64(qrAnalyticsByAccessedTimeBytesUsedPercentages)
		if qAnalyticsByAccessedTimeBytesUsedPercentages != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.percentages", qAnalyticsByAccessedTimeBytesUsedPercentages); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByAccessedTimeBytesUsedValues != nil {

		// query param analytics.by_accessed_time.bytes_used.values
		var qrAnalyticsByAccessedTimeBytesUsedValues int64

		if o.AnalyticsByAccessedTimeBytesUsedValues != nil {
			qrAnalyticsByAccessedTimeBytesUsedValues = *o.AnalyticsByAccessedTimeBytesUsedValues
		}
		qAnalyticsByAccessedTimeBytesUsedValues := swag.FormatInt64(qrAnalyticsByAccessedTimeBytesUsedValues)
		if qAnalyticsByAccessedTimeBytesUsedValues != "" {

			if err := r.SetQueryParam("analytics.by_accessed_time.bytes_used.values", qAnalyticsByAccessedTimeBytesUsedValues); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric != nil {

		// query param analytics.by_modified_time.bytes_used.aged_data_metric
		var qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric float64

		if o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric != nil {
			qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric = *o.AnalyticsByModifiedTimeBytesUsedAgedDataMetric
		}
		qAnalyticsByModifiedTimeBytesUsedAgedDataMetric := swag.FormatFloat64(qrAnalyticsByModifiedTimeBytesUsedAgedDataMetric)
		if qAnalyticsByModifiedTimeBytesUsedAgedDataMetric != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.aged_data_metric", qAnalyticsByModifiedTimeBytesUsedAgedDataMetric); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedLabels != nil {

		// query param analytics.by_modified_time.bytes_used.labels
		var qrAnalyticsByModifiedTimeBytesUsedLabels string

		if o.AnalyticsByModifiedTimeBytesUsedLabels != nil {
			qrAnalyticsByModifiedTimeBytesUsedLabels = *o.AnalyticsByModifiedTimeBytesUsedLabels
		}
		qAnalyticsByModifiedTimeBytesUsedLabels := qrAnalyticsByModifiedTimeBytesUsedLabels
		if qAnalyticsByModifiedTimeBytesUsedLabels != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.labels", qAnalyticsByModifiedTimeBytesUsedLabels); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedNewestLabel != nil {

		// query param analytics.by_modified_time.bytes_used.newest_label
		var qrAnalyticsByModifiedTimeBytesUsedNewestLabel string

		if o.AnalyticsByModifiedTimeBytesUsedNewestLabel != nil {
			qrAnalyticsByModifiedTimeBytesUsedNewestLabel = *o.AnalyticsByModifiedTimeBytesUsedNewestLabel
		}
		qAnalyticsByModifiedTimeBytesUsedNewestLabel := qrAnalyticsByModifiedTimeBytesUsedNewestLabel
		if qAnalyticsByModifiedTimeBytesUsedNewestLabel != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.newest_label", qAnalyticsByModifiedTimeBytesUsedNewestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedOldestLabel != nil {

		// query param analytics.by_modified_time.bytes_used.oldest_label
		var qrAnalyticsByModifiedTimeBytesUsedOldestLabel string

		if o.AnalyticsByModifiedTimeBytesUsedOldestLabel != nil {
			qrAnalyticsByModifiedTimeBytesUsedOldestLabel = *o.AnalyticsByModifiedTimeBytesUsedOldestLabel
		}
		qAnalyticsByModifiedTimeBytesUsedOldestLabel := qrAnalyticsByModifiedTimeBytesUsedOldestLabel
		if qAnalyticsByModifiedTimeBytesUsedOldestLabel != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.oldest_label", qAnalyticsByModifiedTimeBytesUsedOldestLabel); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedPercentages != nil {

		// query param analytics.by_modified_time.bytes_used.percentages
		var qrAnalyticsByModifiedTimeBytesUsedPercentages float64

		if o.AnalyticsByModifiedTimeBytesUsedPercentages != nil {
			qrAnalyticsByModifiedTimeBytesUsedPercentages = *o.AnalyticsByModifiedTimeBytesUsedPercentages
		}
		qAnalyticsByModifiedTimeBytesUsedPercentages := swag.FormatFloat64(qrAnalyticsByModifiedTimeBytesUsedPercentages)
		if qAnalyticsByModifiedTimeBytesUsedPercentages != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.percentages", qAnalyticsByModifiedTimeBytesUsedPercentages); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsByModifiedTimeBytesUsedValues != nil {

		// query param analytics.by_modified_time.bytes_used.values
		var qrAnalyticsByModifiedTimeBytesUsedValues int64

		if o.AnalyticsByModifiedTimeBytesUsedValues != nil {
			qrAnalyticsByModifiedTimeBytesUsedValues = *o.AnalyticsByModifiedTimeBytesUsedValues
		}
		qAnalyticsByModifiedTimeBytesUsedValues := swag.FormatInt64(qrAnalyticsByModifiedTimeBytesUsedValues)
		if qAnalyticsByModifiedTimeBytesUsedValues != "" {

			if err := r.SetQueryParam("analytics.by_modified_time.bytes_used.values", qAnalyticsByModifiedTimeBytesUsedValues); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsBytesUsed != nil {

		// query param analytics.bytes_used
		var qrAnalyticsBytesUsed int64

		if o.AnalyticsBytesUsed != nil {
			qrAnalyticsBytesUsed = *o.AnalyticsBytesUsed
		}
		qAnalyticsBytesUsed := swag.FormatInt64(qrAnalyticsBytesUsed)
		if qAnalyticsBytesUsed != "" {

			if err := r.SetQueryParam("analytics.bytes_used", qAnalyticsBytesUsed); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsFileCount != nil {

		// query param analytics.file_count
		var qrAnalyticsFileCount int64

		if o.AnalyticsFileCount != nil {
			qrAnalyticsFileCount = *o.AnalyticsFileCount
		}
		qAnalyticsFileCount := swag.FormatInt64(qrAnalyticsFileCount)
		if qAnalyticsFileCount != "" {

			if err := r.SetQueryParam("analytics.file_count", qAnalyticsFileCount); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsHistogramByTimeLabels != nil {

		// binding items for analytics.histogram_by_time_labels
		joinedAnalyticsHistogramByTimeLabels := o.bindParamAnalyticsHistogramByTimeLabels(reg)

		// query array param analytics.histogram_by_time_labels
		if err := r.SetQueryParam("analytics.histogram_by_time_labels", joinedAnalyticsHistogramByTimeLabels...); err != nil {
			return err
		}
	}

	if o.AnalyticsIncompleteData != nil {

		// query param analytics.incomplete_data
		var qrAnalyticsIncompleteData bool

		if o.AnalyticsIncompleteData != nil {
			qrAnalyticsIncompleteData = *o.AnalyticsIncompleteData
		}
		qAnalyticsIncompleteData := swag.FormatBool(qrAnalyticsIncompleteData)
		if qAnalyticsIncompleteData != "" {

			if err := r.SetQueryParam("analytics.incomplete_data", qAnalyticsIncompleteData); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsReportTime != nil {

		// query param analytics.report_time
		var qrAnalyticsReportTime string

		if o.AnalyticsReportTime != nil {
			qrAnalyticsReportTime = *o.AnalyticsReportTime
		}
		qAnalyticsReportTime := qrAnalyticsReportTime
		if qAnalyticsReportTime != "" {

			if err := r.SetQueryParam("analytics.report_time", qAnalyticsReportTime); err != nil {
				return err
			}
		}
	}

	if o.AnalyticsSubdirCount != nil {

		// query param analytics.subdir_count
		var qrAnalyticsSubdirCount int64

		if o.AnalyticsSubdirCount != nil {
			qrAnalyticsSubdirCount = *o.AnalyticsSubdirCount
		}
		qAnalyticsSubdirCount := swag.FormatInt64(qrAnalyticsSubdirCount)
		if qAnalyticsSubdirCount != "" {

			if err := r.SetQueryParam("analytics.subdir_count", qAnalyticsSubdirCount); err != nil {
				return err
			}
		}
	}

	if o.ByteOffset != nil {

		// query param byte_offset
		var qrByteOffset int64

		if o.ByteOffset != nil {
			qrByteOffset = *o.ByteOffset
		}
		qByteOffset := swag.FormatInt64(qrByteOffset)
		if qByteOffset != "" {

			if err := r.SetQueryParam("byte_offset", qByteOffset); err != nil {
				return err
			}
		}
	}

	if o.BytesUsed != nil {

		// query param bytes_used
		var qrBytesUsed int64

		if o.BytesUsed != nil {
			qrBytesUsed = *o.BytesUsed
		}
		qBytesUsed := swag.FormatInt64(qrBytesUsed)
		if qBytesUsed != "" {

			if err := r.SetQueryParam("bytes_used", qBytesUsed); err != nil {
				return err
			}
		}
	}

	if o.ChangedTime != nil {

		// query param changed_time
		var qrChangedTime string

		if o.ChangedTime != nil {
			qrChangedTime = *o.ChangedTime
		}
		qChangedTime := qrChangedTime
		if qChangedTime != "" {

			if err := r.SetQueryParam("changed_time", qChangedTime); err != nil {
				return err
			}
		}
	}

	if o.ConstituentName != nil {

		// query param constituent.name
		var qrConstituentName string

		if o.ConstituentName != nil {
			qrConstituentName = *o.ConstituentName
		}
		qConstituentName := qrConstituentName
		if qConstituentName != "" {

			if err := r.SetQueryParam("constituent.name", qConstituentName); err != nil {
				return err
			}
		}
	}

	if o.ConstituentUUID != nil {

		// query param constituent.uuid
		var qrConstituentUUID string

		if o.ConstituentUUID != nil {
			qrConstituentUUID = *o.ConstituentUUID
		}
		qConstituentUUID := qrConstituentUUID
		if qConstituentUUID != "" {

			if err := r.SetQueryParam("constituent.uuid", qConstituentUUID); err != nil {
				return err
			}
		}
	}

	if o.CreationTime != nil {

		// query param creation_time
		var qrCreationTime string

		if o.CreationTime != nil {
			qrCreationTime = *o.CreationTime
		}
		qCreationTime := qrCreationTime
		if qCreationTime != "" {

			if err := r.SetQueryParam("creation_time", qCreationTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FillEnabled != nil {

		// query param fill_enabled
		var qrFillEnabled bool

		if o.FillEnabled != nil {
			qrFillEnabled = *o.FillEnabled
		}
		qFillEnabled := swag.FormatBool(qrFillEnabled)
		if qFillEnabled != "" {

			if err := r.SetQueryParam("fill_enabled", qFillEnabled); err != nil {
				return err
			}
		}
	}

	if o.GroupID != nil {

		// query param group_id
		var qrGroupID int64

		if o.GroupID != nil {
			qrGroupID = *o.GroupID
		}
		qGroupID := swag.FormatInt64(qrGroupID)
		if qGroupID != "" {

			if err := r.SetQueryParam("group_id", qGroupID); err != nil {
				return err
			}
		}
	}

	if o.HardLinksCount != nil {

		// query param hard_links_count
		var qrHardLinksCount int64

		if o.HardLinksCount != nil {
			qrHardLinksCount = *o.HardLinksCount
		}
		qHardLinksCount := swag.FormatInt64(qrHardLinksCount)
		if qHardLinksCount != "" {

			if err := r.SetQueryParam("hard_links_count", qHardLinksCount); err != nil {
				return err
			}
		}
	}

	if o.InodeGeneration != nil {

		// query param inode_generation
		var qrInodeGeneration int64

		if o.InodeGeneration != nil {
			qrInodeGeneration = *o.InodeGeneration
		}
		qInodeGeneration := swag.FormatInt64(qrInodeGeneration)
		if qInodeGeneration != "" {

			if err := r.SetQueryParam("inode_generation", qInodeGeneration); err != nil {
				return err
			}
		}
	}

	if o.InodeNumber != nil {

		// query param inode_number
		var qrInodeNumber int64

		if o.InodeNumber != nil {
			qrInodeNumber = *o.InodeNumber
		}
		qInodeNumber := swag.FormatInt64(qrInodeNumber)
		if qInodeNumber != "" {

			if err := r.SetQueryParam("inode_number", qInodeNumber); err != nil {
				return err
			}
		}
	}

	if o.IsEmpty != nil {

		// query param is_empty
		var qrIsEmpty bool

		if o.IsEmpty != nil {
			qrIsEmpty = *o.IsEmpty
		}
		qIsEmpty := swag.FormatBool(qrIsEmpty)
		if qIsEmpty != "" {

			if err := r.SetQueryParam("is_empty", qIsEmpty); err != nil {
				return err
			}
		}
	}

	if o.IsJunction != nil {

		// query param is_junction
		var qrIsJunction bool

		if o.IsJunction != nil {
			qrIsJunction = *o.IsJunction
		}
		qIsJunction := swag.FormatBool(qrIsJunction)
		if qIsJunction != "" {

			if err := r.SetQueryParam("is_junction", qIsJunction); err != nil {
				return err
			}
		}
	}

	if o.IsSnapshot != nil {

		// query param is_snapshot
		var qrIsSnapshot bool

		if o.IsSnapshot != nil {
			qrIsSnapshot = *o.IsSnapshot
		}
		qIsSnapshot := swag.FormatBool(qrIsSnapshot)
		if qIsSnapshot != "" {

			if err := r.SetQueryParam("is_snapshot", qIsSnapshot); err != nil {
				return err
			}
		}
	}

	if o.IsVMAligned != nil {

		// query param is_vm_aligned
		var qrIsVMAligned bool

		if o.IsVMAligned != nil {
			qrIsVMAligned = *o.IsVMAligned
		}
		qIsVMAligned := swag.FormatBool(qrIsVMAligned)
		if qIsVMAligned != "" {

			if err := r.SetQueryParam("is_vm_aligned", qIsVMAligned); err != nil {
				return err
			}
		}
	}

	if o.Length != nil {

		// query param length
		var qrLength int64

		if o.Length != nil {
			qrLength = *o.Length
		}
		qLength := swag.FormatInt64(qrLength)
		if qLength != "" {

			if err := r.SetQueryParam("length", qLength); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.ModifiedTime != nil {

		// query param modified_time
		var qrModifiedTime string

		if o.ModifiedTime != nil {
			qrModifiedTime = *o.ModifiedTime
		}
		qModifiedTime := qrModifiedTime
		if qModifiedTime != "" {

			if err := r.SetQueryParam("modified_time", qModifiedTime); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.OverwriteEnabled != nil {

		// query param overwrite_enabled
		var qrOverwriteEnabled bool

		if o.OverwriteEnabled != nil {
			qrOverwriteEnabled = *o.OverwriteEnabled
		}
		qOverwriteEnabled := swag.FormatBool(qrOverwriteEnabled)
		if qOverwriteEnabled != "" {

			if err := r.SetQueryParam("overwrite_enabled", qOverwriteEnabled); err != nil {
				return err
			}
		}
	}

	if o.OwnerID != nil {

		// query param owner_id
		var qrOwnerID int64

		if o.OwnerID != nil {
			qrOwnerID = *o.OwnerID
		}
		qOwnerID := swag.FormatInt64(qrOwnerID)
		if qOwnerID != "" {

			if err := r.SetQueryParam("owner_id", qOwnerID); err != nil {
				return err
			}
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.QosPolicyName != nil {

		// query param qos_policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos_policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos_policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos_policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnMetadata != nil {

		// query param return_metadata
		var qrReturnMetadata bool

		if o.ReturnMetadata != nil {
			qrReturnMetadata = *o.ReturnMetadata
		}
		qReturnMetadata := swag.FormatBool(qrReturnMetadata)
		if qReturnMetadata != "" {

			if err := r.SetQueryParam("return_metadata", qReturnMetadata); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.Target != nil {

		// query param target
		var qrTarget string

		if o.Target != nil {
			qrTarget = *o.Target
		}
		qTarget := qrTarget
		if qTarget != "" {

			if err := r.SetQueryParam("target", qTarget); err != nil {
				return err
			}
		}
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UniqueBytes != nil {

		// query param unique_bytes
		var qrUniqueBytes int64

		if o.UniqueBytes != nil {
			qrUniqueBytes = *o.UniqueBytes
		}
		qUniqueBytes := swag.FormatInt64(qrUniqueBytes)
		if qUniqueBytes != "" {

			if err := r.SetQueryParam("unique_bytes", qUniqueBytes); err != nil {
				return err
			}
		}
	}

	if o.UnixPermissions != nil {

		// query param unix_permissions
		var qrUnixPermissions int64

		if o.UnixPermissions != nil {
			qrUnixPermissions = *o.UnixPermissions
		}
		qUnixPermissions := swag.FormatInt64(qrUnixPermissions)
		if qUnixPermissions != "" {

			if err := r.SetQueryParam("unix_permissions", qUnixPermissions); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFileInfoCollectionGet binds the parameter analytics.histogram_by_time_labels
func (o *FileInfoCollectionGetParams) bindParamAnalyticsHistogramByTimeLabels(formats strfmt.Registry) []string {
	analyticsHistogramByTimeLabelsIR := o.AnalyticsHistogramByTimeLabels

	var analyticsHistogramByTimeLabelsIC []string
	for _, analyticsHistogramByTimeLabelsIIR := range analyticsHistogramByTimeLabelsIR { // explode []string

		analyticsHistogramByTimeLabelsIIV := analyticsHistogramByTimeLabelsIIR // string as string
		analyticsHistogramByTimeLabelsIC = append(analyticsHistogramByTimeLabelsIC, analyticsHistogramByTimeLabelsIIV)
	}

	// items.CollectionFormat: "csv"
	analyticsHistogramByTimeLabelsIS := swag.JoinByFormat(analyticsHistogramByTimeLabelsIC, "csv")

	return analyticsHistogramByTimeLabelsIS
}

// bindParamFileInfoCollectionGet binds the parameter fields
func (o *FileInfoCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFileInfoCollectionGet binds the parameter order_by
func (o *FileInfoCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
