// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileInfoFormDataCreateParams creates a new FileInfoFormDataCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileInfoFormDataCreateParams() *FileInfoFormDataCreateParams {
	return &FileInfoFormDataCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileInfoFormDataCreateParamsWithTimeout creates a new FileInfoFormDataCreateParams object
// with the ability to set a timeout on a request.
func NewFileInfoFormDataCreateParamsWithTimeout(timeout time.Duration) *FileInfoFormDataCreateParams {
	return &FileInfoFormDataCreateParams{
		timeout: timeout,
	}
}

// NewFileInfoFormDataCreateParamsWithContext creates a new FileInfoFormDataCreateParams object
// with the ability to set a context for a request.
func NewFileInfoFormDataCreateParamsWithContext(ctx context.Context) *FileInfoFormDataCreateParams {
	return &FileInfoFormDataCreateParams{
		Context: ctx,
	}
}

// NewFileInfoFormDataCreateParamsWithHTTPClient creates a new FileInfoFormDataCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileInfoFormDataCreateParamsWithHTTPClient(client *http.Client) *FileInfoFormDataCreateParams {
	return &FileInfoFormDataCreateParams{
		HTTPClient: client,
	}
}

/*
FileInfoFormDataCreateParams contains all the parameters to send to the API endpoint

	for the file info form data create operation.

	Typically these are written to a http.Request.
*/
type FileInfoFormDataCreateParams struct {

	/* ByteOffset.

	   Indicates the number of bytes into the file to begin writing. Use "-1" to append (default). Note that the byte-offset field is only supported for writing to a new or existing file, which requires specifying the Content-Type as 'multipart/form-data'.
	*/
	ByteOffset *int64

	/* Data.

	   Data to write to the file.
	*/
	Data *string

	/* Overwrite.

	   If false, and the file exists, the write will fail. Default is false.
	*/
	Overwrite *bool

	/* Path.

	   Relative path of a new file, directory or symlink. The path field requires using "%2E" to represent "." and "%2F" to represent "/" for the path provided.
	*/
	Path string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* StreamName.

	   Name of stream associated with the file to write data to.
	*/
	StreamName *string

	/* VolumeUUID.

	   Volume UUID
	*/
	VolumeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file info form data create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileInfoFormDataCreateParams) WithDefaults() *FileInfoFormDataCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file info form data create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileInfoFormDataCreateParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)
	)

	val := FileInfoFormDataCreateParams{
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithTimeout(timeout time.Duration) *FileInfoFormDataCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithContext(ctx context.Context) *FileInfoFormDataCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithHTTPClient(client *http.Client) *FileInfoFormDataCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithByteOffset adds the byteOffset to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithByteOffset(byteOffset *int64) *FileInfoFormDataCreateParams {
	o.SetByteOffset(byteOffset)
	return o
}

// SetByteOffset adds the byteOffset to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetByteOffset(byteOffset *int64) {
	o.ByteOffset = byteOffset
}

// WithData adds the data to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithData(data *string) *FileInfoFormDataCreateParams {
	o.SetData(data)
	return o
}

// SetData adds the data to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetData(data *string) {
	o.Data = data
}

// WithOverwrite adds the overwrite to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithOverwrite(overwrite *bool) *FileInfoFormDataCreateParams {
	o.SetOverwrite(overwrite)
	return o
}

// SetOverwrite adds the overwrite to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetOverwrite(overwrite *bool) {
	o.Overwrite = overwrite
}

// WithPath adds the path to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithPath(path string) *FileInfoFormDataCreateParams {
	o.SetPath(path)
	return o
}

// SetPath adds the path to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetPath(path string) {
	o.Path = path
}

// WithReturnRecords adds the returnRecords to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithReturnRecords(returnRecords *bool) *FileInfoFormDataCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithStreamName adds the streamName to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithStreamName(streamName *string) *FileInfoFormDataCreateParams {
	o.SetStreamName(streamName)
	return o
}

// SetStreamName adds the streamName to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetStreamName(streamName *string) {
	o.StreamName = streamName
}

// WithVolumeUUID adds the volumeUUID to the file info form data create params
func (o *FileInfoFormDataCreateParams) WithVolumeUUID(volumeUUID string) *FileInfoFormDataCreateParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the file info form data create params
func (o *FileInfoFormDataCreateParams) SetVolumeUUID(volumeUUID string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileInfoFormDataCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ByteOffset != nil {

		// query param byte_offset
		var qrByteOffset int64

		if o.ByteOffset != nil {
			qrByteOffset = *o.ByteOffset
		}
		qByteOffset := swag.FormatInt64(qrByteOffset)
		if qByteOffset != "" {

			if err := r.SetQueryParam("byte_offset", qByteOffset); err != nil {
				return err
			}
		}
	}

	if o.Data != nil {

		// form param data
		var frData string
		if o.Data != nil {
			frData = *o.Data
		}
		fData := frData
		if fData != "" {
			if err := r.SetFormParam("data", fData); err != nil {
				return err
			}
		}
	}

	if o.Overwrite != nil {

		// query param overwrite
		var qrOverwrite bool

		if o.Overwrite != nil {
			qrOverwrite = *o.Overwrite
		}
		qOverwrite := swag.FormatBool(qrOverwrite)
		if qOverwrite != "" {

			if err := r.SetQueryParam("overwrite", qOverwrite); err != nil {
				return err
			}
		}
	}

	// path param path
	if err := r.SetPathParam("path", o.Path); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.StreamName != nil {

		// query param stream_name
		var qrStreamName string

		if o.StreamName != nil {
			qrStreamName = *o.StreamName
		}
		qStreamName := qrStreamName
		if qStreamName != "" {

			if err := r.SetQueryParam("stream_name", qStreamName); err != nil {
				return err
			}
		}
	}

	// path param volume.uuid
	if err := r.SetPathParam("volume.uuid", o.VolumeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
