// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileMoveCollectionGetParams creates a new FileMoveCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileMoveCollectionGetParams() *FileMoveCollectionGetParams {
	return &FileMoveCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileMoveCollectionGetParamsWithTimeout creates a new FileMoveCollectionGetParams object
// with the ability to set a timeout on a request.
func NewFileMoveCollectionGetParamsWithTimeout(timeout time.Duration) *FileMoveCollectionGetParams {
	return &FileMoveCollectionGetParams{
		timeout: timeout,
	}
}

// NewFileMoveCollectionGetParamsWithContext creates a new FileMoveCollectionGetParams object
// with the ability to set a context for a request.
func NewFileMoveCollectionGetParamsWithContext(ctx context.Context) *FileMoveCollectionGetParams {
	return &FileMoveCollectionGetParams{
		Context: ctx,
	}
}

// NewFileMoveCollectionGetParamsWithHTTPClient creates a new FileMoveCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileMoveCollectionGetParamsWithHTTPClient(client *http.Client) *FileMoveCollectionGetParams {
	return &FileMoveCollectionGetParams{
		HTTPClient: client,
	}
}

/*
FileMoveCollectionGetParams contains all the parameters to send to the API endpoint

	for the file move collection get operation.

	Typically these are written to a http.Request.
*/
type FileMoveCollectionGetParams struct {

	/* CutoverTime.

	   Filter by cutover_time
	*/
	CutoverTime *int64

	/* DestinationPath.

	   Filter by destination.path
	*/
	DestinationPath *string

	/* DestinationSvmName.

	   Filter by destination.svm.name
	*/
	DestinationSvmName *string

	/* DestinationSvmUUID.

	   Filter by destination.svm.uuid
	*/
	DestinationSvmUUID *string

	/* DestinationVolumeName.

	   Filter by destination.volume.name
	*/
	DestinationVolumeName *string

	/* DestinationVolumeUUID.

	   Filter by destination.volume.uuid
	*/
	DestinationVolumeUUID *string

	/* ElapsedTime.

	   Filter by elapsed_time
	*/
	ElapsedTime *int64

	/* FailureArgumentsCode.

	   Filter by failure.arguments.code
	*/
	FailureArgumentsCode *string

	/* FailureArgumentsMessage.

	   Filter by failure.arguments.message
	*/
	FailureArgumentsMessage *string

	/* FailureCode.

	   Filter by failure.code
	*/
	FailureCode *string

	/* FailureMessage.

	   Filter by failure.message
	*/
	FailureMessage *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   Filter by index
	*/
	Index *int64

	/* IsDestinationReady.

	   Filter by is_destination_ready
	*/
	IsDestinationReady *bool

	/* IsFlexgroup.

	   Filter by is_flexgroup
	*/
	IsFlexgroup *bool

	/* IsSnapshotFenced.

	   Filter by is_snapshot_fenced
	*/
	IsSnapshotFenced *bool

	/* MaxCutoverTime.

	   Filter by max_cutover_time
	*/
	MaxCutoverTime *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MaxThroughput.

	   Filter by max_throughput
	*/
	MaxThroughput *int64

	/* NodeName.

	   Filter by node.name
	*/
	NodeName *string

	/* NodeUUID.

	   Filter by node.uuid
	*/
	NodeUUID *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* ScannerPercent.

	   Filter by scanner.percent
	*/
	ScannerPercent *int64

	/* ScannerProgress.

	   Filter by scanner.progress
	*/
	ScannerProgress *int64

	/* ScannerState.

	   Filter by scanner.state
	*/
	ScannerState *string

	/* ScannerTotal.

	   Filter by scanner.total
	*/
	ScannerTotal *int64

	/* SourcePath.

	   Filter by source.path
	*/
	SourcePath *string

	/* SourceSvmName.

	   Filter by source.svm.name
	*/
	SourceSvmName *string

	/* SourceSvmUUID.

	   Filter by source.svm.uuid
	*/
	SourceSvmUUID *string

	/* SourceVolumeName.

	   Filter by source.volume.name
	*/
	SourceVolumeName *string

	/* SourceVolumeUUID.

	   Filter by source.volume.uuid
	*/
	SourceVolumeUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file move collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveCollectionGetParams) WithDefaults() *FileMoveCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file move collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := FileMoveCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file move collection get params
func (o *FileMoveCollectionGetParams) WithTimeout(timeout time.Duration) *FileMoveCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file move collection get params
func (o *FileMoveCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file move collection get params
func (o *FileMoveCollectionGetParams) WithContext(ctx context.Context) *FileMoveCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file move collection get params
func (o *FileMoveCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file move collection get params
func (o *FileMoveCollectionGetParams) WithHTTPClient(client *http.Client) *FileMoveCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file move collection get params
func (o *FileMoveCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCutoverTime adds the cutoverTime to the file move collection get params
func (o *FileMoveCollectionGetParams) WithCutoverTime(cutoverTime *int64) *FileMoveCollectionGetParams {
	o.SetCutoverTime(cutoverTime)
	return o
}

// SetCutoverTime adds the cutoverTime to the file move collection get params
func (o *FileMoveCollectionGetParams) SetCutoverTime(cutoverTime *int64) {
	o.CutoverTime = cutoverTime
}

// WithDestinationPath adds the destinationPath to the file move collection get params
func (o *FileMoveCollectionGetParams) WithDestinationPath(destinationPath *string) *FileMoveCollectionGetParams {
	o.SetDestinationPath(destinationPath)
	return o
}

// SetDestinationPath adds the destinationPath to the file move collection get params
func (o *FileMoveCollectionGetParams) SetDestinationPath(destinationPath *string) {
	o.DestinationPath = destinationPath
}

// WithDestinationSvmName adds the destinationSvmName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithDestinationSvmName(destinationSvmName *string) *FileMoveCollectionGetParams {
	o.SetDestinationSvmName(destinationSvmName)
	return o
}

// SetDestinationSvmName adds the destinationSvmName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetDestinationSvmName(destinationSvmName *string) {
	o.DestinationSvmName = destinationSvmName
}

// WithDestinationSvmUUID adds the destinationSvmUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithDestinationSvmUUID(destinationSvmUUID *string) *FileMoveCollectionGetParams {
	o.SetDestinationSvmUUID(destinationSvmUUID)
	return o
}

// SetDestinationSvmUUID adds the destinationSvmUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetDestinationSvmUUID(destinationSvmUUID *string) {
	o.DestinationSvmUUID = destinationSvmUUID
}

// WithDestinationVolumeName adds the destinationVolumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithDestinationVolumeName(destinationVolumeName *string) *FileMoveCollectionGetParams {
	o.SetDestinationVolumeName(destinationVolumeName)
	return o
}

// SetDestinationVolumeName adds the destinationVolumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetDestinationVolumeName(destinationVolumeName *string) {
	o.DestinationVolumeName = destinationVolumeName
}

// WithDestinationVolumeUUID adds the destinationVolumeUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithDestinationVolumeUUID(destinationVolumeUUID *string) *FileMoveCollectionGetParams {
	o.SetDestinationVolumeUUID(destinationVolumeUUID)
	return o
}

// SetDestinationVolumeUUID adds the destinationVolumeUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetDestinationVolumeUUID(destinationVolumeUUID *string) {
	o.DestinationVolumeUUID = destinationVolumeUUID
}

// WithElapsedTime adds the elapsedTime to the file move collection get params
func (o *FileMoveCollectionGetParams) WithElapsedTime(elapsedTime *int64) *FileMoveCollectionGetParams {
	o.SetElapsedTime(elapsedTime)
	return o
}

// SetElapsedTime adds the elapsedTime to the file move collection get params
func (o *FileMoveCollectionGetParams) SetElapsedTime(elapsedTime *int64) {
	o.ElapsedTime = elapsedTime
}

// WithFailureArgumentsCode adds the failureArgumentsCode to the file move collection get params
func (o *FileMoveCollectionGetParams) WithFailureArgumentsCode(failureArgumentsCode *string) *FileMoveCollectionGetParams {
	o.SetFailureArgumentsCode(failureArgumentsCode)
	return o
}

// SetFailureArgumentsCode adds the failureArgumentsCode to the file move collection get params
func (o *FileMoveCollectionGetParams) SetFailureArgumentsCode(failureArgumentsCode *string) {
	o.FailureArgumentsCode = failureArgumentsCode
}

// WithFailureArgumentsMessage adds the failureArgumentsMessage to the file move collection get params
func (o *FileMoveCollectionGetParams) WithFailureArgumentsMessage(failureArgumentsMessage *string) *FileMoveCollectionGetParams {
	o.SetFailureArgumentsMessage(failureArgumentsMessage)
	return o
}

// SetFailureArgumentsMessage adds the failureArgumentsMessage to the file move collection get params
func (o *FileMoveCollectionGetParams) SetFailureArgumentsMessage(failureArgumentsMessage *string) {
	o.FailureArgumentsMessage = failureArgumentsMessage
}

// WithFailureCode adds the failureCode to the file move collection get params
func (o *FileMoveCollectionGetParams) WithFailureCode(failureCode *string) *FileMoveCollectionGetParams {
	o.SetFailureCode(failureCode)
	return o
}

// SetFailureCode adds the failureCode to the file move collection get params
func (o *FileMoveCollectionGetParams) SetFailureCode(failureCode *string) {
	o.FailureCode = failureCode
}

// WithFailureMessage adds the failureMessage to the file move collection get params
func (o *FileMoveCollectionGetParams) WithFailureMessage(failureMessage *string) *FileMoveCollectionGetParams {
	o.SetFailureMessage(failureMessage)
	return o
}

// SetFailureMessage adds the failureMessage to the file move collection get params
func (o *FileMoveCollectionGetParams) SetFailureMessage(failureMessage *string) {
	o.FailureMessage = failureMessage
}

// WithFields adds the fields to the file move collection get params
func (o *FileMoveCollectionGetParams) WithFields(fields []string) *FileMoveCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the file move collection get params
func (o *FileMoveCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the file move collection get params
func (o *FileMoveCollectionGetParams) WithIndex(index *int64) *FileMoveCollectionGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the file move collection get params
func (o *FileMoveCollectionGetParams) SetIndex(index *int64) {
	o.Index = index
}

// WithIsDestinationReady adds the isDestinationReady to the file move collection get params
func (o *FileMoveCollectionGetParams) WithIsDestinationReady(isDestinationReady *bool) *FileMoveCollectionGetParams {
	o.SetIsDestinationReady(isDestinationReady)
	return o
}

// SetIsDestinationReady adds the isDestinationReady to the file move collection get params
func (o *FileMoveCollectionGetParams) SetIsDestinationReady(isDestinationReady *bool) {
	o.IsDestinationReady = isDestinationReady
}

// WithIsFlexgroup adds the isFlexgroup to the file move collection get params
func (o *FileMoveCollectionGetParams) WithIsFlexgroup(isFlexgroup *bool) *FileMoveCollectionGetParams {
	o.SetIsFlexgroup(isFlexgroup)
	return o
}

// SetIsFlexgroup adds the isFlexgroup to the file move collection get params
func (o *FileMoveCollectionGetParams) SetIsFlexgroup(isFlexgroup *bool) {
	o.IsFlexgroup = isFlexgroup
}

// WithIsSnapshotFenced adds the isSnapshotFenced to the file move collection get params
func (o *FileMoveCollectionGetParams) WithIsSnapshotFenced(isSnapshotFenced *bool) *FileMoveCollectionGetParams {
	o.SetIsSnapshotFenced(isSnapshotFenced)
	return o
}

// SetIsSnapshotFenced adds the isSnapshotFenced to the file move collection get params
func (o *FileMoveCollectionGetParams) SetIsSnapshotFenced(isSnapshotFenced *bool) {
	o.IsSnapshotFenced = isSnapshotFenced
}

// WithMaxCutoverTime adds the maxCutoverTime to the file move collection get params
func (o *FileMoveCollectionGetParams) WithMaxCutoverTime(maxCutoverTime *int64) *FileMoveCollectionGetParams {
	o.SetMaxCutoverTime(maxCutoverTime)
	return o
}

// SetMaxCutoverTime adds the maxCutoverTime to the file move collection get params
func (o *FileMoveCollectionGetParams) SetMaxCutoverTime(maxCutoverTime *int64) {
	o.MaxCutoverTime = maxCutoverTime
}

// WithMaxRecords adds the maxRecords to the file move collection get params
func (o *FileMoveCollectionGetParams) WithMaxRecords(maxRecords *int64) *FileMoveCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the file move collection get params
func (o *FileMoveCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMaxThroughput adds the maxThroughput to the file move collection get params
func (o *FileMoveCollectionGetParams) WithMaxThroughput(maxThroughput *int64) *FileMoveCollectionGetParams {
	o.SetMaxThroughput(maxThroughput)
	return o
}

// SetMaxThroughput adds the maxThroughput to the file move collection get params
func (o *FileMoveCollectionGetParams) SetMaxThroughput(maxThroughput *int64) {
	o.MaxThroughput = maxThroughput
}

// WithNodeName adds the nodeName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithNodeName(nodeName *string) *FileMoveCollectionGetParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetNodeName(nodeName *string) {
	o.NodeName = nodeName
}

// WithNodeUUID adds the nodeUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithNodeUUID(nodeUUID *string) *FileMoveCollectionGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetNodeUUID(nodeUUID *string) {
	o.NodeUUID = nodeUUID
}

// WithOrderBy adds the orderBy to the file move collection get params
func (o *FileMoveCollectionGetParams) WithOrderBy(orderBy []string) *FileMoveCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the file move collection get params
func (o *FileMoveCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the file move collection get params
func (o *FileMoveCollectionGetParams) WithReturnRecords(returnRecords *bool) *FileMoveCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file move collection get params
func (o *FileMoveCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the file move collection get params
func (o *FileMoveCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *FileMoveCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the file move collection get params
func (o *FileMoveCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScannerPercent adds the scannerPercent to the file move collection get params
func (o *FileMoveCollectionGetParams) WithScannerPercent(scannerPercent *int64) *FileMoveCollectionGetParams {
	o.SetScannerPercent(scannerPercent)
	return o
}

// SetScannerPercent adds the scannerPercent to the file move collection get params
func (o *FileMoveCollectionGetParams) SetScannerPercent(scannerPercent *int64) {
	o.ScannerPercent = scannerPercent
}

// WithScannerProgress adds the scannerProgress to the file move collection get params
func (o *FileMoveCollectionGetParams) WithScannerProgress(scannerProgress *int64) *FileMoveCollectionGetParams {
	o.SetScannerProgress(scannerProgress)
	return o
}

// SetScannerProgress adds the scannerProgress to the file move collection get params
func (o *FileMoveCollectionGetParams) SetScannerProgress(scannerProgress *int64) {
	o.ScannerProgress = scannerProgress
}

// WithScannerState adds the scannerState to the file move collection get params
func (o *FileMoveCollectionGetParams) WithScannerState(scannerState *string) *FileMoveCollectionGetParams {
	o.SetScannerState(scannerState)
	return o
}

// SetScannerState adds the scannerState to the file move collection get params
func (o *FileMoveCollectionGetParams) SetScannerState(scannerState *string) {
	o.ScannerState = scannerState
}

// WithScannerTotal adds the scannerTotal to the file move collection get params
func (o *FileMoveCollectionGetParams) WithScannerTotal(scannerTotal *int64) *FileMoveCollectionGetParams {
	o.SetScannerTotal(scannerTotal)
	return o
}

// SetScannerTotal adds the scannerTotal to the file move collection get params
func (o *FileMoveCollectionGetParams) SetScannerTotal(scannerTotal *int64) {
	o.ScannerTotal = scannerTotal
}

// WithSourcePath adds the sourcePath to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSourcePath(sourcePath *string) *FileMoveCollectionGetParams {
	o.SetSourcePath(sourcePath)
	return o
}

// SetSourcePath adds the sourcePath to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSourcePath(sourcePath *string) {
	o.SourcePath = sourcePath
}

// WithSourceSvmName adds the sourceSvmName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSourceSvmName(sourceSvmName *string) *FileMoveCollectionGetParams {
	o.SetSourceSvmName(sourceSvmName)
	return o
}

// SetSourceSvmName adds the sourceSvmName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSourceSvmName(sourceSvmName *string) {
	o.SourceSvmName = sourceSvmName
}

// WithSourceSvmUUID adds the sourceSvmUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSourceSvmUUID(sourceSvmUUID *string) *FileMoveCollectionGetParams {
	o.SetSourceSvmUUID(sourceSvmUUID)
	return o
}

// SetSourceSvmUUID adds the sourceSvmUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSourceSvmUUID(sourceSvmUUID *string) {
	o.SourceSvmUUID = sourceSvmUUID
}

// WithSourceVolumeName adds the sourceVolumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSourceVolumeName(sourceVolumeName *string) *FileMoveCollectionGetParams {
	o.SetSourceVolumeName(sourceVolumeName)
	return o
}

// SetSourceVolumeName adds the sourceVolumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSourceVolumeName(sourceVolumeName *string) {
	o.SourceVolumeName = sourceVolumeName
}

// WithSourceVolumeUUID adds the sourceVolumeUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSourceVolumeUUID(sourceVolumeUUID *string) *FileMoveCollectionGetParams {
	o.SetSourceVolumeUUID(sourceVolumeUUID)
	return o
}

// SetSourceVolumeUUID adds the sourceVolumeUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSourceVolumeUUID(sourceVolumeUUID *string) {
	o.SourceVolumeUUID = sourceVolumeUUID
}

// WithSvmName adds the svmName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSvmName(svmName *string) *FileMoveCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithSvmUUID(svmUUID *string) *FileMoveCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the file move collection get params
func (o *FileMoveCollectionGetParams) WithUUID(uuid *string) *FileMoveCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVolumeName adds the volumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) WithVolumeName(volumeName *string) *FileMoveCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the file move collection get params
func (o *FileMoveCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the file move collection get params
func (o *FileMoveCollectionGetParams) WithVolumeUUID(volumeUUID *string) *FileMoveCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the file move collection get params
func (o *FileMoveCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *FileMoveCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.CutoverTime != nil {

		// query param cutover_time
		var qrCutoverTime int64

		if o.CutoverTime != nil {
			qrCutoverTime = *o.CutoverTime
		}
		qCutoverTime := swag.FormatInt64(qrCutoverTime)
		if qCutoverTime != "" {

			if err := r.SetQueryParam("cutover_time", qCutoverTime); err != nil {
				return err
			}
		}
	}

	if o.DestinationPath != nil {

		// query param destination.path
		var qrDestinationPath string

		if o.DestinationPath != nil {
			qrDestinationPath = *o.DestinationPath
		}
		qDestinationPath := qrDestinationPath
		if qDestinationPath != "" {

			if err := r.SetQueryParam("destination.path", qDestinationPath); err != nil {
				return err
			}
		}
	}

	if o.DestinationSvmName != nil {

		// query param destination.svm.name
		var qrDestinationSvmName string

		if o.DestinationSvmName != nil {
			qrDestinationSvmName = *o.DestinationSvmName
		}
		qDestinationSvmName := qrDestinationSvmName
		if qDestinationSvmName != "" {

			if err := r.SetQueryParam("destination.svm.name", qDestinationSvmName); err != nil {
				return err
			}
		}
	}

	if o.DestinationSvmUUID != nil {

		// query param destination.svm.uuid
		var qrDestinationSvmUUID string

		if o.DestinationSvmUUID != nil {
			qrDestinationSvmUUID = *o.DestinationSvmUUID
		}
		qDestinationSvmUUID := qrDestinationSvmUUID
		if qDestinationSvmUUID != "" {

			if err := r.SetQueryParam("destination.svm.uuid", qDestinationSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.DestinationVolumeName != nil {

		// query param destination.volume.name
		var qrDestinationVolumeName string

		if o.DestinationVolumeName != nil {
			qrDestinationVolumeName = *o.DestinationVolumeName
		}
		qDestinationVolumeName := qrDestinationVolumeName
		if qDestinationVolumeName != "" {

			if err := r.SetQueryParam("destination.volume.name", qDestinationVolumeName); err != nil {
				return err
			}
		}
	}

	if o.DestinationVolumeUUID != nil {

		// query param destination.volume.uuid
		var qrDestinationVolumeUUID string

		if o.DestinationVolumeUUID != nil {
			qrDestinationVolumeUUID = *o.DestinationVolumeUUID
		}
		qDestinationVolumeUUID := qrDestinationVolumeUUID
		if qDestinationVolumeUUID != "" {

			if err := r.SetQueryParam("destination.volume.uuid", qDestinationVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.ElapsedTime != nil {

		// query param elapsed_time
		var qrElapsedTime int64

		if o.ElapsedTime != nil {
			qrElapsedTime = *o.ElapsedTime
		}
		qElapsedTime := swag.FormatInt64(qrElapsedTime)
		if qElapsedTime != "" {

			if err := r.SetQueryParam("elapsed_time", qElapsedTime); err != nil {
				return err
			}
		}
	}

	if o.FailureArgumentsCode != nil {

		// query param failure.arguments.code
		var qrFailureArgumentsCode string

		if o.FailureArgumentsCode != nil {
			qrFailureArgumentsCode = *o.FailureArgumentsCode
		}
		qFailureArgumentsCode := qrFailureArgumentsCode
		if qFailureArgumentsCode != "" {

			if err := r.SetQueryParam("failure.arguments.code", qFailureArgumentsCode); err != nil {
				return err
			}
		}
	}

	if o.FailureArgumentsMessage != nil {

		// query param failure.arguments.message
		var qrFailureArgumentsMessage string

		if o.FailureArgumentsMessage != nil {
			qrFailureArgumentsMessage = *o.FailureArgumentsMessage
		}
		qFailureArgumentsMessage := qrFailureArgumentsMessage
		if qFailureArgumentsMessage != "" {

			if err := r.SetQueryParam("failure.arguments.message", qFailureArgumentsMessage); err != nil {
				return err
			}
		}
	}

	if o.FailureCode != nil {

		// query param failure.code
		var qrFailureCode string

		if o.FailureCode != nil {
			qrFailureCode = *o.FailureCode
		}
		qFailureCode := qrFailureCode
		if qFailureCode != "" {

			if err := r.SetQueryParam("failure.code", qFailureCode); err != nil {
				return err
			}
		}
	}

	if o.FailureMessage != nil {

		// query param failure.message
		var qrFailureMessage string

		if o.FailureMessage != nil {
			qrFailureMessage = *o.FailureMessage
		}
		qFailureMessage := qrFailureMessage
		if qFailureMessage != "" {

			if err := r.SetQueryParam("failure.message", qFailureMessage); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Index != nil {

		// query param index
		var qrIndex int64

		if o.Index != nil {
			qrIndex = *o.Index
		}
		qIndex := swag.FormatInt64(qrIndex)
		if qIndex != "" {

			if err := r.SetQueryParam("index", qIndex); err != nil {
				return err
			}
		}
	}

	if o.IsDestinationReady != nil {

		// query param is_destination_ready
		var qrIsDestinationReady bool

		if o.IsDestinationReady != nil {
			qrIsDestinationReady = *o.IsDestinationReady
		}
		qIsDestinationReady := swag.FormatBool(qrIsDestinationReady)
		if qIsDestinationReady != "" {

			if err := r.SetQueryParam("is_destination_ready", qIsDestinationReady); err != nil {
				return err
			}
		}
	}

	if o.IsFlexgroup != nil {

		// query param is_flexgroup
		var qrIsFlexgroup bool

		if o.IsFlexgroup != nil {
			qrIsFlexgroup = *o.IsFlexgroup
		}
		qIsFlexgroup := swag.FormatBool(qrIsFlexgroup)
		if qIsFlexgroup != "" {

			if err := r.SetQueryParam("is_flexgroup", qIsFlexgroup); err != nil {
				return err
			}
		}
	}

	if o.IsSnapshotFenced != nil {

		// query param is_snapshot_fenced
		var qrIsSnapshotFenced bool

		if o.IsSnapshotFenced != nil {
			qrIsSnapshotFenced = *o.IsSnapshotFenced
		}
		qIsSnapshotFenced := swag.FormatBool(qrIsSnapshotFenced)
		if qIsSnapshotFenced != "" {

			if err := r.SetQueryParam("is_snapshot_fenced", qIsSnapshotFenced); err != nil {
				return err
			}
		}
	}

	if o.MaxCutoverTime != nil {

		// query param max_cutover_time
		var qrMaxCutoverTime int64

		if o.MaxCutoverTime != nil {
			qrMaxCutoverTime = *o.MaxCutoverTime
		}
		qMaxCutoverTime := swag.FormatInt64(qrMaxCutoverTime)
		if qMaxCutoverTime != "" {

			if err := r.SetQueryParam("max_cutover_time", qMaxCutoverTime); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MaxThroughput != nil {

		// query param max_throughput
		var qrMaxThroughput int64

		if o.MaxThroughput != nil {
			qrMaxThroughput = *o.MaxThroughput
		}
		qMaxThroughput := swag.FormatInt64(qrMaxThroughput)
		if qMaxThroughput != "" {

			if err := r.SetQueryParam("max_throughput", qMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.NodeName != nil {

		// query param node.name
		var qrNodeName string

		if o.NodeName != nil {
			qrNodeName = *o.NodeName
		}
		qNodeName := qrNodeName
		if qNodeName != "" {

			if err := r.SetQueryParam("node.name", qNodeName); err != nil {
				return err
			}
		}
	}

	if o.NodeUUID != nil {

		// query param node.uuid
		var qrNodeUUID string

		if o.NodeUUID != nil {
			qrNodeUUID = *o.NodeUUID
		}
		qNodeUUID := qrNodeUUID
		if qNodeUUID != "" {

			if err := r.SetQueryParam("node.uuid", qNodeUUID); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.ScannerPercent != nil {

		// query param scanner.percent
		var qrScannerPercent int64

		if o.ScannerPercent != nil {
			qrScannerPercent = *o.ScannerPercent
		}
		qScannerPercent := swag.FormatInt64(qrScannerPercent)
		if qScannerPercent != "" {

			if err := r.SetQueryParam("scanner.percent", qScannerPercent); err != nil {
				return err
			}
		}
	}

	if o.ScannerProgress != nil {

		// query param scanner.progress
		var qrScannerProgress int64

		if o.ScannerProgress != nil {
			qrScannerProgress = *o.ScannerProgress
		}
		qScannerProgress := swag.FormatInt64(qrScannerProgress)
		if qScannerProgress != "" {

			if err := r.SetQueryParam("scanner.progress", qScannerProgress); err != nil {
				return err
			}
		}
	}

	if o.ScannerState != nil {

		// query param scanner.state
		var qrScannerState string

		if o.ScannerState != nil {
			qrScannerState = *o.ScannerState
		}
		qScannerState := qrScannerState
		if qScannerState != "" {

			if err := r.SetQueryParam("scanner.state", qScannerState); err != nil {
				return err
			}
		}
	}

	if o.ScannerTotal != nil {

		// query param scanner.total
		var qrScannerTotal int64

		if o.ScannerTotal != nil {
			qrScannerTotal = *o.ScannerTotal
		}
		qScannerTotal := swag.FormatInt64(qrScannerTotal)
		if qScannerTotal != "" {

			if err := r.SetQueryParam("scanner.total", qScannerTotal); err != nil {
				return err
			}
		}
	}

	if o.SourcePath != nil {

		// query param source.path
		var qrSourcePath string

		if o.SourcePath != nil {
			qrSourcePath = *o.SourcePath
		}
		qSourcePath := qrSourcePath
		if qSourcePath != "" {

			if err := r.SetQueryParam("source.path", qSourcePath); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmName != nil {

		// query param source.svm.name
		var qrSourceSvmName string

		if o.SourceSvmName != nil {
			qrSourceSvmName = *o.SourceSvmName
		}
		qSourceSvmName := qrSourceSvmName
		if qSourceSvmName != "" {

			if err := r.SetQueryParam("source.svm.name", qSourceSvmName); err != nil {
				return err
			}
		}
	}

	if o.SourceSvmUUID != nil {

		// query param source.svm.uuid
		var qrSourceSvmUUID string

		if o.SourceSvmUUID != nil {
			qrSourceSvmUUID = *o.SourceSvmUUID
		}
		qSourceSvmUUID := qrSourceSvmUUID
		if qSourceSvmUUID != "" {

			if err := r.SetQueryParam("source.svm.uuid", qSourceSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.SourceVolumeName != nil {

		// query param source.volume.name
		var qrSourceVolumeName string

		if o.SourceVolumeName != nil {
			qrSourceVolumeName = *o.SourceVolumeName
		}
		qSourceVolumeName := qrSourceVolumeName
		if qSourceVolumeName != "" {

			if err := r.SetQueryParam("source.volume.name", qSourceVolumeName); err != nil {
				return err
			}
		}
	}

	if o.SourceVolumeUUID != nil {

		// query param source.volume.uuid
		var qrSourceVolumeUUID string

		if o.SourceVolumeUUID != nil {
			qrSourceVolumeUUID = *o.SourceVolumeUUID
		}
		qSourceVolumeUUID := qrSourceVolumeUUID
		if qSourceVolumeUUID != "" {

			if err := r.SetQueryParam("source.volume.uuid", qSourceVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFileMoveCollectionGet binds the parameter fields
func (o *FileMoveCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamFileMoveCollectionGet binds the parameter order_by
func (o *FileMoveCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
