// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewFileMoveCreateParams creates a new FileMoveCreateParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileMoveCreateParams() *FileMoveCreateParams {
	return &FileMoveCreateParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileMoveCreateParamsWithTimeout creates a new FileMoveCreateParams object
// with the ability to set a timeout on a request.
func NewFileMoveCreateParamsWithTimeout(timeout time.Duration) *FileMoveCreateParams {
	return &FileMoveCreateParams{
		timeout: timeout,
	}
}

// NewFileMoveCreateParamsWithContext creates a new FileMoveCreateParams object
// with the ability to set a context for a request.
func NewFileMoveCreateParamsWithContext(ctx context.Context) *FileMoveCreateParams {
	return &FileMoveCreateParams{
		Context: ctx,
	}
}

// NewFileMoveCreateParamsWithHTTPClient creates a new FileMoveCreateParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileMoveCreateParamsWithHTTPClient(client *http.Client) *FileMoveCreateParams {
	return &FileMoveCreateParams{
		HTTPClient: client,
	}
}

/*
FileMoveCreateParams contains all the parameters to send to the API endpoint

	for the file move create operation.

	Typically these are written to a http.Request.
*/
type FileMoveCreateParams struct {

	/* Automatic.

	   If true, the FlexGroup volume file move operation selects the destination constituent automatically.
	*/
	Automatic *bool

	/* Disruptive.

	   If true, the FlexGroup volume file move operation is disruptive to the clients. The file handle of the file being moved changes. If false, the file handle remains the same. The non-disruptive file move operation is only available on FlexGroup volumes with granular data property enabled.
	*/
	Disruptive *bool

	/* Force.

	   If true, the FlexGroup volume file move operation breaks the existing lock state on the file being moved. Breaking the lock state may cause a disruption for some client applications.
	*/
	Force *bool

	/* Info.

	   Info specification
	*/
	Info *models.FileMove

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file move create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveCreateParams) WithDefaults() *FileMoveCreateParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file move create params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveCreateParams) SetDefaults() {
	var (
		automaticDefault = bool(false)

		disruptiveDefault = bool(false)

		forceDefault = bool(false)

		returnRecordsDefault = bool(false)
	)

	val := FileMoveCreateParams{
		Automatic:     &automaticDefault,
		Disruptive:    &disruptiveDefault,
		Force:         &forceDefault,
		ReturnRecords: &returnRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the file move create params
func (o *FileMoveCreateParams) WithTimeout(timeout time.Duration) *FileMoveCreateParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file move create params
func (o *FileMoveCreateParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file move create params
func (o *FileMoveCreateParams) WithContext(ctx context.Context) *FileMoveCreateParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file move create params
func (o *FileMoveCreateParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file move create params
func (o *FileMoveCreateParams) WithHTTPClient(client *http.Client) *FileMoveCreateParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file move create params
func (o *FileMoveCreateParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAutomatic adds the automatic to the file move create params
func (o *FileMoveCreateParams) WithAutomatic(automatic *bool) *FileMoveCreateParams {
	o.SetAutomatic(automatic)
	return o
}

// SetAutomatic adds the automatic to the file move create params
func (o *FileMoveCreateParams) SetAutomatic(automatic *bool) {
	o.Automatic = automatic
}

// WithDisruptive adds the disruptive to the file move create params
func (o *FileMoveCreateParams) WithDisruptive(disruptive *bool) *FileMoveCreateParams {
	o.SetDisruptive(disruptive)
	return o
}

// SetDisruptive adds the disruptive to the file move create params
func (o *FileMoveCreateParams) SetDisruptive(disruptive *bool) {
	o.Disruptive = disruptive
}

// WithForce adds the force to the file move create params
func (o *FileMoveCreateParams) WithForce(force *bool) *FileMoveCreateParams {
	o.SetForce(force)
	return o
}

// SetForce adds the force to the file move create params
func (o *FileMoveCreateParams) SetForce(force *bool) {
	o.Force = force
}

// WithInfo adds the info to the file move create params
func (o *FileMoveCreateParams) WithInfo(info *models.FileMove) *FileMoveCreateParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the file move create params
func (o *FileMoveCreateParams) SetInfo(info *models.FileMove) {
	o.Info = info
}

// WithReturnRecords adds the returnRecords to the file move create params
func (o *FileMoveCreateParams) WithReturnRecords(returnRecords *bool) *FileMoveCreateParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the file move create params
func (o *FileMoveCreateParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WriteToRequest writes these params to a swagger request
func (o *FileMoveCreateParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Automatic != nil {

		// query param automatic
		var qrAutomatic bool

		if o.Automatic != nil {
			qrAutomatic = *o.Automatic
		}
		qAutomatic := swag.FormatBool(qrAutomatic)
		if qAutomatic != "" {

			if err := r.SetQueryParam("automatic", qAutomatic); err != nil {
				return err
			}
		}
	}

	if o.Disruptive != nil {

		// query param disruptive
		var qrDisruptive bool

		if o.Disruptive != nil {
			qrDisruptive = *o.Disruptive
		}
		qDisruptive := swag.FormatBool(qrDisruptive)
		if qDisruptive != "" {

			if err := r.SetQueryParam("disruptive", qDisruptive); err != nil {
				return err
			}
		}
	}

	if o.Force != nil {

		// query param force
		var qrForce bool

		if o.Force != nil {
			qrForce = *o.Force
		}
		qForce := swag.FormatBool(qrForce)
		if qForce != "" {

			if err := r.SetQueryParam("force", qForce); err != nil {
				return err
			}
		}
	}
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
