// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFileMoveGetParams creates a new FileMoveGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFileMoveGetParams() *FileMoveGetParams {
	return &FileMoveGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFileMoveGetParamsWithTimeout creates a new FileMoveGetParams object
// with the ability to set a timeout on a request.
func NewFileMoveGetParamsWithTimeout(timeout time.Duration) *FileMoveGetParams {
	return &FileMoveGetParams{
		timeout: timeout,
	}
}

// NewFileMoveGetParamsWithContext creates a new FileMoveGetParams object
// with the ability to set a context for a request.
func NewFileMoveGetParamsWithContext(ctx context.Context) *FileMoveGetParams {
	return &FileMoveGetParams{
		Context: ctx,
	}
}

// NewFileMoveGetParamsWithHTTPClient creates a new FileMoveGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewFileMoveGetParamsWithHTTPClient(client *http.Client) *FileMoveGetParams {
	return &FileMoveGetParams{
		HTTPClient: client,
	}
}

/*
FileMoveGetParams contains all the parameters to send to the API endpoint

	for the file move get operation.

	Typically these are written to a http.Request.
*/
type FileMoveGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Index.

	   The index of the file move within the overall operation
	*/
	Index int64

	/* NodeUUID.

	   Unique identifier of the node.
	*/
	NodeUUID string

	/* UUID.

	   Unique identifier of the file move operation.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the file move get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveGetParams) WithDefaults() *FileMoveGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the file move get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FileMoveGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the file move get params
func (o *FileMoveGetParams) WithTimeout(timeout time.Duration) *FileMoveGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the file move get params
func (o *FileMoveGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the file move get params
func (o *FileMoveGetParams) WithContext(ctx context.Context) *FileMoveGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the file move get params
func (o *FileMoveGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the file move get params
func (o *FileMoveGetParams) WithHTTPClient(client *http.Client) *FileMoveGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the file move get params
func (o *FileMoveGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the file move get params
func (o *FileMoveGetParams) WithFields(fields []string) *FileMoveGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the file move get params
func (o *FileMoveGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIndex adds the index to the file move get params
func (o *FileMoveGetParams) WithIndex(index int64) *FileMoveGetParams {
	o.SetIndex(index)
	return o
}

// SetIndex adds the index to the file move get params
func (o *FileMoveGetParams) SetIndex(index int64) {
	o.Index = index
}

// WithNodeUUID adds the nodeUUID to the file move get params
func (o *FileMoveGetParams) WithNodeUUID(nodeUUID string) *FileMoveGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the file move get params
func (o *FileMoveGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WithUUID adds the uuid to the file move get params
func (o *FileMoveGetParams) WithUUID(uuid string) *FileMoveGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the file move get params
func (o *FileMoveGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *FileMoveGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param index
	if err := r.SetPathParam("index", swag.FormatInt64(o.Index)); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamFileMoveGet binds the parameter fields
func (o *FileMoveGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
