// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FileMoveGetReader is a Reader for the FileMoveGet structure.
type FileMoveGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FileMoveGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFileMoveGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFileMoveGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFileMoveGetOK creates a FileMoveGetOK with default headers values
func NewFileMoveGetOK() *FileMoveGetOK {
	return &FileMoveGetOK{}
}

/*
FileMoveGetOK describes a response with status code 200, with default header values.

OK
*/
type FileMoveGetOK struct {
	Payload *models.FileMove
}

// IsSuccess returns true when this file move get o k response has a 2xx status code
func (o *FileMoveGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this file move get o k response has a 3xx status code
func (o *FileMoveGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this file move get o k response has a 4xx status code
func (o *FileMoveGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this file move get o k response has a 5xx status code
func (o *FileMoveGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this file move get o k response a status code equal to that given
func (o *FileMoveGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the file move get o k response
func (o *FileMoveGetOK) Code() int {
	return 200
}

func (o *FileMoveGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/moves/{node.uuid}/{uuid}/{index}][%d] fileMoveGetOK %s", 200, payload)
}

func (o *FileMoveGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/moves/{node.uuid}/{uuid}/{index}][%d] fileMoveGetOK %s", 200, payload)
}

func (o *FileMoveGetOK) GetPayload() *models.FileMove {
	return o.Payload
}

func (o *FileMoveGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FileMove)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFileMoveGetDefault creates a FileMoveGetDefault with default headers values
func NewFileMoveGetDefault(code int) *FileMoveGetDefault {
	return &FileMoveGetDefault{
		_statusCode: code,
	}
}

/*
	FileMoveGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 6521       | Cannot quiesce source file. Source file \"file.name\" is under construction and is being used by either a file copy or move operation. Wait a few minutes and try the operation again.|
| 6522       | Volume is not VM aligned.|
| 6523       | File suffix not VM aligned.|
| 6524       | Completion interface not specified.|
| 6525       | Maximum simultaneous file operations reached.|
| 6526       | Lock conflict.|
| 6527       | Permission denied.|
| 6528       | Waiting for an I/O fence to be released.|
| 6529       | Waiting for space to become available.|
| 6530       | Waiting for an external process to complete.|
| 6531       | Source volume was deleted.|
| 6532       | Slowed due to resource constraints.|
| 6533       | Volume does not support block reallocation.|
| 6534       | File operation not supported.|
*/
type FileMoveGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this file move get default response has a 2xx status code
func (o *FileMoveGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this file move get default response has a 3xx status code
func (o *FileMoveGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this file move get default response has a 4xx status code
func (o *FileMoveGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this file move get default response has a 5xx status code
func (o *FileMoveGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this file move get default response a status code equal to that given
func (o *FileMoveGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the file move get default response
func (o *FileMoveGetDefault) Code() int {
	return o._statusCode
}

func (o *FileMoveGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/moves/{node.uuid}/{uuid}/{index}][%d] file_move_get default %s", o._statusCode, payload)
}

func (o *FileMoveGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/file/moves/{node.uuid}/{uuid}/{index}][%d] file_move_get default %s", o._statusCode, payload)
}

func (o *FileMoveGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FileMoveGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
