// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FlexcacheModifyCollectionReader is a Reader for the FlexcacheModifyCollection structure.
type FlexcacheModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FlexcacheModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFlexcacheModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewFlexcacheModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFlexcacheModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFlexcacheModifyCollectionOK creates a FlexcacheModifyCollectionOK with default headers values
func NewFlexcacheModifyCollectionOK() *FlexcacheModifyCollectionOK {
	return &FlexcacheModifyCollectionOK{}
}

/*
FlexcacheModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FlexcacheModifyCollectionOK struct {
	Payload *models.FlexcacheJobLinkResponse
}

// IsSuccess returns true when this flexcache modify collection o k response has a 2xx status code
func (o *FlexcacheModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache modify collection o k response has a 3xx status code
func (o *FlexcacheModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache modify collection o k response has a 4xx status code
func (o *FlexcacheModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache modify collection o k response has a 5xx status code
func (o *FlexcacheModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache modify collection o k response a status code equal to that given
func (o *FlexcacheModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the flexcache modify collection o k response
func (o *FlexcacheModifyCollectionOK) Code() int {
	return 200
}

func (o *FlexcacheModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcacheModifyCollectionOK %s", 200, payload)
}

func (o *FlexcacheModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcacheModifyCollectionOK %s", 200, payload)
}

func (o *FlexcacheModifyCollectionOK) GetPayload() *models.FlexcacheJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheModifyCollectionAccepted creates a FlexcacheModifyCollectionAccepted with default headers values
func NewFlexcacheModifyCollectionAccepted() *FlexcacheModifyCollectionAccepted {
	return &FlexcacheModifyCollectionAccepted{}
}

/*
FlexcacheModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type FlexcacheModifyCollectionAccepted struct {
	Payload *models.FlexcacheJobLinkResponse
}

// IsSuccess returns true when this flexcache modify collection accepted response has a 2xx status code
func (o *FlexcacheModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache modify collection accepted response has a 3xx status code
func (o *FlexcacheModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache modify collection accepted response has a 4xx status code
func (o *FlexcacheModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache modify collection accepted response has a 5xx status code
func (o *FlexcacheModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache modify collection accepted response a status code equal to that given
func (o *FlexcacheModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the flexcache modify collection accepted response
func (o *FlexcacheModifyCollectionAccepted) Code() int {
	return 202
}

func (o *FlexcacheModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcacheModifyCollectionAccepted %s", 202, payload)
}

func (o *FlexcacheModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcacheModifyCollectionAccepted %s", 202, payload)
}

func (o *FlexcacheModifyCollectionAccepted) GetPayload() *models.FlexcacheJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheModifyCollectionDefault creates a FlexcacheModifyCollectionDefault with default headers values
func NewFlexcacheModifyCollectionDefault(code int) *FlexcacheModifyCollectionDefault {
	return &FlexcacheModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FlexcacheModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66846921   | Failed to prepopulate. Empty path list |
| 66846922   | FlexCache volume does not exist in the SVM |
| 66846923   | Failed to prepopulate FlexCache volume because the origin volume is not reachable |
| 66846924   | FlexCache volume is offline |
| 66846925   | FlexCache volume is not mounted or the junction-path is not active |
| 66846926   | The junction-path of FlexCache volume is not active |
| 66846927   | FlexCache volume does not have an origin volume |
| 66846928   | FlexCache volume does not exist |
| 66846929   | Using FlexCache prepopulate requires an effective cluster version of 9.8.0 or later |
| 66846930   | Using FlexCache prepopulate in a MetroCluster configuration requires an effective cluster version of 9.8.0 or later on both the local and remote clusters |
| 66846931   | Internal Error. FlexCache prepopulate job queue failed. Wait a few minutes, and then try the operation again |
| 66846936   | Failed to lookup root file handle for origin of FlexCache volume. Wait a few minutes, and then try the operation again |
| 66846937   | Internal error. Failed to initialize thread |
| 66846939   | Internal error. Failed to get the MSID of the origin volume for FlexCache volume |
| 66846943   | Failed to prepopulate because dir_path does not exist |
| 66846944   | Failed to get root constituent for FlexCache volume |
| 66846945   | Origin of FlexCache volume is not mounted or the junction-path is not active |
| 66846946   | The junction-path of origin of FlexCache volume is not active |
| 66846947   | FlexCache prepopulate job for FlexCache volume already exists |
| 66846948   | FlexCache prepopulate job for FlexCache volume could not be queued because the node is offline |
| 66846958   | Exclude path(s) does not exist in origin volume |
| 66846988   | Cannot enable writeback for FlexCache volume because the origin is a data protection volume. Writeback is only supported on FlexCache volumes with origins that are read-write volumes |
| 66846995   | Using FlexCache relative-size requires an effective cluster version of 9.13.1 or later |
| 66846997   | Failed to modify the relative-size-percentage property of the FlexCache volume because the used size of the FlexCache Volume is greater than the newly calculated size based on the value of the relative-size-percentage property |
| 66846997   | Failed to modify the relative-size-percentage property of FlexCache volume because the relative-size-percentage property is not valid |
| 66846998   | Failed to modify the relative-size-percentage property of FlexCache volume because the is-relative-size-enabled property is false |
| 66847010   | Failed to modify the relative-size-percentage property of FlexCache volume because autosize is enabled on the FlexCache volume |
| 66847026   | Failed to enable the atime-scrub-enabled property for the FlexCache volume because the atime-update-property is false |
| 66847027   | Failed to modify atime-scrub-period property of the FlexCache volume because the atime-scrub-enabled property is false |
| 66846720   | Using FlexCache nfsv4 access requires an effective cluster version of 9.10.0 or later |
| 66846720   | Using FlexCache cifs access requires an effective cluster version of 9.8.0 or later |
| 66847093   | Using FlexCache S3 access requires an effective cluster version of 9.18.1 or later |
*/
type FlexcacheModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this flexcache modify collection default response has a 2xx status code
func (o *FlexcacheModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this flexcache modify collection default response has a 3xx status code
func (o *FlexcacheModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this flexcache modify collection default response has a 4xx status code
func (o *FlexcacheModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this flexcache modify collection default response has a 5xx status code
func (o *FlexcacheModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this flexcache modify collection default response a status code equal to that given
func (o *FlexcacheModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the flexcache modify collection default response
func (o *FlexcacheModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FlexcacheModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcache_modify_collection default %s", o._statusCode, payload)
}

func (o *FlexcacheModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/flexcaches][%d] flexcache_modify_collection default %s", o._statusCode, payload)
}

func (o *FlexcacheModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FlexcacheModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FlexcacheModifyCollectionBody flexcache modify collection body
swagger:model FlexcacheModifyCollectionBody
*/
type FlexcacheModifyCollectionBody struct {

	// links
	Links *models.FlexcacheInlineLinks `json:"_links,omitempty"`

	// atime scrub
	AtimeScrub *models.FlexcacheInlineAtimeScrub `json:"atime_scrub,omitempty"`

	// cifs
	Cifs *models.FlexcacheInlineCifs `json:"cifs,omitempty"`

	// cifs change notify
	CifsChangeNotify *models.FlexcacheInlineCifsChangeNotify `json:"cifs_change_notify,omitempty"`

	// Specifies the number of constituents in the FlexGroup volume upon FlexCache create (POST).
	// Example: 8
	// Minimum: 1
	ConstituentCount *int64 `json:"constituent_count,omitempty"`

	// Number of FlexCache constituents per aggregate when the 'aggregates' field is mentioned.
	// Example: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// If set to true, a DR cache is created.
	DrCache *bool `json:"dr_cache,omitempty"`

	// flexcache inline aggregates
	FlexcacheInlineAggregates []*models.FlexcacheInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// flexcache inline origins
	FlexcacheInlineOrigins []*models.FlexcacheRelationship `json:"origins,omitempty"`

	// flexcache response inline records
	FlexcacheResponseInlineRecords []*models.Flexcache `json:"records,omitempty"`

	// Specifies whether or not a FlexCache volume has global file locking mode enabled. Global file locking mode is a mode where protocol read locking semantics are enforced across all FlexCaches and origins of a FlexCache volume. When global file locking mode is enabled, the "is_disconnected_mode_off_for_locks" flag is always set to "true".
	GlobalFileLockingEnabled *bool `json:"global_file_locking_enabled,omitempty"`

	// guarantee
	Guarantee *models.FlexcacheInlineGuarantee `json:"guarantee,omitempty"`

	// FlexCache name
	// Example: vol1
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// nfsv4
	Nfsv4 *models.FlexcacheInlineNfsv4 `json:"nfsv4,omitempty"`

	// If set to true, a plaintext FlexCache volume for an encrypted origin volume is created.
	OverrideEncryption *bool `json:"override_encryption,omitempty"`

	// The fully-qualified path in the owning SVM's namespace at which the FlexCache is mounted. The path is case insensitive and must be unique within a SVM's namespace. Path must begin with '/' and must not end with '/'. Only one FlexCache be mounted at any given junction path.
	// Example: /user/my_fc
	Path *string `json:"path,omitempty"`

	// prepopulate
	Prepopulate *models.FlexcacheInlinePrepopulate `json:"prepopulate,omitempty"`

	// relative size
	RelativeSize *models.FlexcacheInlineRelativeSize `json:"relative_size,omitempty"`

	// s3
	S3 *models.FlexcacheInlineS3 `json:"s3,omitempty"`

	// Physical size of the FlexCache. The recommended size for a FlexCache is 10% of the origin volume. The minimum FlexCache constituent size is 1GB.
	Size *int64 `json:"size,omitempty"`

	// svm
	Svm *models.FlexcacheInlineSvm `json:"svm,omitempty"`

	// Specifies whether or not a Fabricpool-enabled aggregate can be used in FlexCache creation. The use_tiered_aggregate is only used when auto-provisioning a FlexCache volume.
	UseTieredAggregate *bool `json:"use_tiered_aggregate,omitempty"`

	// FlexCache UUID. Unique identifier for the FlexCache.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// writeback
	Writeback *models.FlexcacheInlineWriteback `json:"writeback,omitempty"`
}

// Validate validates this flexcache modify collection body
func (o *FlexcacheModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAtimeScrub(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCifsChangeNotify(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConstituentCount(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheInlineOrigins(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateGuarantee(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNfsv4(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePrepopulate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRelativeSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateWriteback(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateAtimeScrub(formats strfmt.Registry) error {
	if swag.IsZero(o.AtimeScrub) { // not required
		return nil
	}

	if o.AtimeScrub != nil {
		if err := o.AtimeScrub.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "atime_scrub")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateCifs(formats strfmt.Registry) error {
	if swag.IsZero(o.Cifs) { // not required
		return nil
	}

	if o.Cifs != nil {
		if err := o.Cifs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateCifsChangeNotify(formats strfmt.Registry) error {
	if swag.IsZero(o.CifsChangeNotify) { // not required
		return nil
	}

	if o.CifsChangeNotify != nil {
		if err := o.CifsChangeNotify.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs_change_notify")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateConstituentCount(formats strfmt.Registry) error {
	if swag.IsZero(o.ConstituentCount) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"constituent_count", "body", *o.ConstituentCount, 1, false); err != nil {
		return err
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateFlexcacheInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.FlexcacheInlineAggregates); i++ {
		if swag.IsZero(o.FlexcacheInlineAggregates[i]) { // not required
			continue
		}

		if o.FlexcacheInlineAggregates[i] != nil {
			if err := o.FlexcacheInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateFlexcacheInlineOrigins(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheInlineOrigins) { // not required
		return nil
	}

	for i := 0; i < len(o.FlexcacheInlineOrigins); i++ {
		if swag.IsZero(o.FlexcacheInlineOrigins[i]) { // not required
			continue
		}

		if o.FlexcacheInlineOrigins[i] != nil {
			if err := o.FlexcacheInlineOrigins[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateFlexcacheResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FlexcacheResponseInlineRecords); i++ {
		if swag.IsZero(o.FlexcacheResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FlexcacheResponseInlineRecords[i] != nil {
			if err := o.FlexcacheResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateGuarantee(formats strfmt.Registry) error {
	if swag.IsZero(o.Guarantee) { // not required
		return nil
	}

	if o.Guarantee != nil {
		if err := o.Guarantee.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateNfsv4(formats strfmt.Registry) error {
	if swag.IsZero(o.Nfsv4) { // not required
		return nil
	}

	if o.Nfsv4 != nil {
		if err := o.Nfsv4.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfsv4")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validatePrepopulate(formats strfmt.Registry) error {
	if swag.IsZero(o.Prepopulate) { // not required
		return nil
	}

	if o.Prepopulate != nil {
		if err := o.Prepopulate.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "prepopulate")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateRelativeSize(formats strfmt.Registry) error {
	if swag.IsZero(o.RelativeSize) { // not required
		return nil
	}

	if o.RelativeSize != nil {
		if err := o.RelativeSize.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relative_size")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateS3(formats strfmt.Registry) error {
	if swag.IsZero(o.S3) { // not required
		return nil
	}

	if o.S3 != nil {
		if err := o.S3.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) validateWriteback(formats strfmt.Registry) error {
	if swag.IsZero(o.Writeback) { // not required
		return nil
	}

	if o.Writeback != nil {
		if err := o.Writeback.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache modify collection body based on the context it is used
func (o *FlexcacheModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAtimeScrub(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCifsChangeNotify(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheInlineOrigins(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGuarantee(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNfsv4(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePrepopulate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRelativeSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateWriteback(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateAtimeScrub(ctx context.Context, formats strfmt.Registry) error {

	if o.AtimeScrub != nil {
		if err := o.AtimeScrub.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "atime_scrub")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateCifs(ctx context.Context, formats strfmt.Registry) error {

	if o.Cifs != nil {
		if err := o.Cifs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateCifsChangeNotify(ctx context.Context, formats strfmt.Registry) error {

	if o.CifsChangeNotify != nil {
		if err := o.CifsChangeNotify.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cifs_change_notify")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateFlexcacheInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FlexcacheInlineAggregates); i++ {

		if o.FlexcacheInlineAggregates[i] != nil {
			if err := o.FlexcacheInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateFlexcacheInlineOrigins(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FlexcacheInlineOrigins); i++ {

		if o.FlexcacheInlineOrigins[i] != nil {
			if err := o.FlexcacheInlineOrigins[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "origins" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateFlexcacheResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FlexcacheResponseInlineRecords); i++ {

		if o.FlexcacheResponseInlineRecords[i] != nil {
			if err := o.FlexcacheResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateGuarantee(ctx context.Context, formats strfmt.Registry) error {

	if o.Guarantee != nil {
		if err := o.Guarantee.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "guarantee")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateNfsv4(ctx context.Context, formats strfmt.Registry) error {

	if o.Nfsv4 != nil {
		if err := o.Nfsv4.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nfsv4")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidatePrepopulate(ctx context.Context, formats strfmt.Registry) error {

	if o.Prepopulate != nil {
		if err := o.Prepopulate.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "prepopulate")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateRelativeSize(ctx context.Context, formats strfmt.Registry) error {

	if o.RelativeSize != nil {
		if err := o.RelativeSize.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "relative_size")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateS3(ctx context.Context, formats strfmt.Registry) error {

	if o.S3 != nil {
		if err := o.S3.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *FlexcacheModifyCollectionBody) contextValidateWriteback(ctx context.Context, formats strfmt.Registry) error {

	if o.Writeback != nil {
		if err := o.Writeback.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "writeback")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FlexcacheModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineLinks flexcache inline links
swagger:model flexcache_inline__links
*/
type FlexcacheInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline links
func (o *FlexcacheInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline links based on the context it is used
func (o *FlexcacheInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineAggregatesInlineArrayItem Aggregate
swagger:model flexcache_inline_aggregates_inline_array_item
*/
type FlexcacheInlineAggregatesInlineArrayItem struct {

	// links
	Links *models.FlexcacheInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache inline aggregates inline array item
func (o *FlexcacheInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline aggregates inline array item based on the context it is used
func (o *FlexcacheInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineAggregatesInlineArrayItemInlineLinks flexcache inline aggregates inline array item inline links
swagger:model flexcache_inline_aggregates_inline_array_item_inline__links
*/
type FlexcacheInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline aggregates inline array item inline links
func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline aggregates inline array item inline links based on the context it is used
func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineAtimeScrub FlexCache volume atime-based scrub
swagger:model flexcache_inline_atime_scrub
*/
type FlexcacheInlineAtimeScrub struct {

	// Specifies whether scrubbing of inactive files based on atime is enabled for the FlexCache volume. When scrubbing is enabled, files whose atime is older than the specified duration are evicted from the cache volume. The scrubber runs once a day and looks for files whose atime has exceeded the provisioned value.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the atime duration in days after which a cached file is considered inactive. Inactive files are purged from the FlexCache volumes when the scrubber runs once a day.
	Period *int16 `json:"period,omitempty"`
}

// Validate validates this flexcache inline atime scrub
func (o *FlexcacheInlineAtimeScrub) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline atime scrub based on context it is used
func (o *FlexcacheInlineAtimeScrub) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineAtimeScrub) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineAtimeScrub) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineAtimeScrub
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineCifs FlexCache CIFS
swagger:model flexcache_inline_cifs
*/
type FlexcacheInlineCifs struct {

	// Specifies whether CIFS access is enabled on the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline cifs
func (o *FlexcacheInlineCifs) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline cifs based on context it is used
func (o *FlexcacheInlineCifs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineCifs) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineCifs) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineCifs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineCifsChangeNotify Notifies that a change has been made to the FlexCache volume CIFS.
swagger:model flexcache_inline_cifs_change_notify
*/
type FlexcacheInlineCifsChangeNotify struct {

	// Specifies whether a CIFS change notification is enabled for the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline cifs change notify
func (o *FlexcacheInlineCifsChangeNotify) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline cifs change notify based on context it is used
func (o *FlexcacheInlineCifsChangeNotify) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineCifsChangeNotify) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineCifsChangeNotify) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineCifsChangeNotify
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineGuarantee flexcache inline guarantee
swagger:model flexcache_inline_guarantee
*/
type FlexcacheInlineGuarantee struct {

	// The type of space guarantee of this volume in the aggregate.
	// Enum: ["volume","none"]
	Type *string `json:"type,omitempty"`
}

// Validate validates this flexcache inline guarantee
func (o *FlexcacheInlineGuarantee) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var flexcacheInlineGuaranteeTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["volume","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		flexcacheInlineGuaranteeTypeTypePropEnum = append(flexcacheInlineGuaranteeTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// flexcache_inline_guarantee
	// FlexcacheInlineGuarantee
	// type
	// Type
	// volume
	// END DEBUGGING
	// FlexcacheInlineGuaranteeTypeVolume captures enum value "volume"
	FlexcacheInlineGuaranteeTypeVolume string = "volume"

	// BEGIN DEBUGGING
	// flexcache_inline_guarantee
	// FlexcacheInlineGuarantee
	// type
	// Type
	// none
	// END DEBUGGING
	// FlexcacheInlineGuaranteeTypeNone captures enum value "none"
	FlexcacheInlineGuaranteeTypeNone string = "none"
)

// prop value enum
func (o *FlexcacheInlineGuarantee) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, flexcacheInlineGuaranteeTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *FlexcacheInlineGuarantee) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"guarantee"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this flexcache inline guarantee based on context it is used
func (o *FlexcacheInlineGuarantee) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineGuarantee) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineGuarantee) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineGuarantee
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineNfsv4 FlexCache NFSv4
swagger:model flexcache_inline_nfsv4
*/
type FlexcacheInlineNfsv4 struct {

	// Specifies whether NFSv4 access is enabled on the FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline nfsv4
func (o *FlexcacheInlineNfsv4) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline nfsv4 based on context it is used
func (o *FlexcacheInlineNfsv4) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineNfsv4) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineNfsv4) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineNfsv4
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlinePrepopulate FlexCache prepopulate
swagger:model flexcache_inline_prepopulate
*/
type FlexcacheInlinePrepopulate struct {

	// dir paths
	DirPaths []*string `json:"dir_paths,omitempty"`

	// exclude dir paths
	ExcludeDirPaths []*string `json:"exclude_dir_paths,omitempty"`

	// Specifies whether or not the prepopulate action should search through the `dir_paths` recursively. If not set, the default value _true_ is used.
	Recurse *bool `json:"recurse,omitempty"`
}

// Validate validates this flexcache inline prepopulate
func (o *FlexcacheInlinePrepopulate) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline prepopulate based on context it is used
func (o *FlexcacheInlinePrepopulate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlinePrepopulate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlinePrepopulate) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlinePrepopulate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineRelativeSize FlexCache Relative Size
swagger:model flexcache_inline_relative_size
*/
type FlexcacheInlineRelativeSize struct {

	// Specifies whether the relative sizing is enabled for the FlexCache volume. Relative sizing is introduced as a part of follow the origin feature. When relative sizing is enabled, it blocks any modifications done manually in the absolute size of the FlexCache volume. The size of the FlexCache volume is calculated and entered automatically based on the size of the origin volume.
	Enabled *bool `json:"enabled,omitempty"`

	// Specifies the percent size the FlexCache volume should have relative to the total size of the origin volume. This property is only relevant to a FlexCache volume that has the relative size property enabled.
	Percentage *int16 `json:"percentage,omitempty"`
}

// Validate validates this flexcache inline relative size
func (o *FlexcacheInlineRelativeSize) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline relative size based on context it is used
func (o *FlexcacheInlineRelativeSize) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineRelativeSize) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineRelativeSize) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineRelativeSize
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineS3 Flexcache S3
swagger:model flexcache_inline_s3
*/
type FlexcacheInlineS3 struct {

	// Indicates whether S3 access is enabled on the Flexcache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline s3
func (o *FlexcacheInlineS3) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline s3 based on context it is used
func (o *FlexcacheInlineS3) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineS3) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineS3) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineS3
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineSvm FlexCache SVM
swagger:model flexcache_inline_svm
*/
type FlexcacheInlineSvm struct {

	// links
	Links *models.FlexcacheInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache inline svm
func (o *FlexcacheInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline svm based on the context it is used
func (o *FlexcacheInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineSvm) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineSvmInlineLinks flexcache inline svm inline links
swagger:model flexcache_inline_svm_inline__links
*/
type FlexcacheInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this flexcache inline svm inline links
func (o *FlexcacheInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache inline svm inline links based on the context it is used
func (o *FlexcacheInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheInlineWriteback FlexCache Writeback
swagger:model flexcache_inline_writeback
*/
type FlexcacheInlineWriteback struct {

	// Indicates whether or not writeback is enabled for the FlexCache volume. Writeback is a storage method where data is first written to the FlexCache volume and then written to the origin of a FlexCache volume.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this flexcache inline writeback
func (o *FlexcacheInlineWriteback) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this flexcache inline writeback based on context it is used
func (o *FlexcacheInlineWriteback) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheInlineWriteback) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheInlineWriteback) UnmarshalBinary(b []byte) error {
	var res FlexcacheInlineWriteback
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
