// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FlexcacheOriginCollectionGetReader is a Reader for the FlexcacheOriginCollectionGet structure.
type FlexcacheOriginCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FlexcacheOriginCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFlexcacheOriginCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFlexcacheOriginCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFlexcacheOriginCollectionGetOK creates a FlexcacheOriginCollectionGetOK with default headers values
func NewFlexcacheOriginCollectionGetOK() *FlexcacheOriginCollectionGetOK {
	return &FlexcacheOriginCollectionGetOK{}
}

/*
FlexcacheOriginCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type FlexcacheOriginCollectionGetOK struct {
	Payload *models.FlexcacheOriginResponse
}

// IsSuccess returns true when this flexcache origin collection get o k response has a 2xx status code
func (o *FlexcacheOriginCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache origin collection get o k response has a 3xx status code
func (o *FlexcacheOriginCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache origin collection get o k response has a 4xx status code
func (o *FlexcacheOriginCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache origin collection get o k response has a 5xx status code
func (o *FlexcacheOriginCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache origin collection get o k response a status code equal to that given
func (o *FlexcacheOriginCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the flexcache origin collection get o k response
func (o *FlexcacheOriginCollectionGetOK) Code() int {
	return 200
}

func (o *FlexcacheOriginCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/flexcache/origins][%d] flexcacheOriginCollectionGetOK %s", 200, payload)
}

func (o *FlexcacheOriginCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/flexcache/origins][%d] flexcacheOriginCollectionGetOK %s", 200, payload)
}

func (o *FlexcacheOriginCollectionGetOK) GetPayload() *models.FlexcacheOriginResponse {
	return o.Payload
}

func (o *FlexcacheOriginCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheOriginResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheOriginCollectionGetDefault creates a FlexcacheOriginCollectionGetDefault with default headers values
func NewFlexcacheOriginCollectionGetDefault(code int) *FlexcacheOriginCollectionGetDefault {
	return &FlexcacheOriginCollectionGetDefault{
		_statusCode: code,
	}
}

/*
FlexcacheOriginCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type FlexcacheOriginCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this flexcache origin collection get default response has a 2xx status code
func (o *FlexcacheOriginCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this flexcache origin collection get default response has a 3xx status code
func (o *FlexcacheOriginCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this flexcache origin collection get default response has a 4xx status code
func (o *FlexcacheOriginCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this flexcache origin collection get default response has a 5xx status code
func (o *FlexcacheOriginCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this flexcache origin collection get default response a status code equal to that given
func (o *FlexcacheOriginCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the flexcache origin collection get default response
func (o *FlexcacheOriginCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *FlexcacheOriginCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/flexcache/origins][%d] flexcache_origin_collection_get default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/flexcache/origins][%d] flexcache_origin_collection_get default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FlexcacheOriginCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
