// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewFlexcacheOriginModifyCollectionParams creates a new FlexcacheOriginModifyCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFlexcacheOriginModifyCollectionParams() *FlexcacheOriginModifyCollectionParams {
	return &FlexcacheOriginModifyCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFlexcacheOriginModifyCollectionParamsWithTimeout creates a new FlexcacheOriginModifyCollectionParams object
// with the ability to set a timeout on a request.
func NewFlexcacheOriginModifyCollectionParamsWithTimeout(timeout time.Duration) *FlexcacheOriginModifyCollectionParams {
	return &FlexcacheOriginModifyCollectionParams{
		timeout: timeout,
	}
}

// NewFlexcacheOriginModifyCollectionParamsWithContext creates a new FlexcacheOriginModifyCollectionParams object
// with the ability to set a context for a request.
func NewFlexcacheOriginModifyCollectionParamsWithContext(ctx context.Context) *FlexcacheOriginModifyCollectionParams {
	return &FlexcacheOriginModifyCollectionParams{
		Context: ctx,
	}
}

// NewFlexcacheOriginModifyCollectionParamsWithHTTPClient creates a new FlexcacheOriginModifyCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewFlexcacheOriginModifyCollectionParamsWithHTTPClient(client *http.Client) *FlexcacheOriginModifyCollectionParams {
	return &FlexcacheOriginModifyCollectionParams{
		HTTPClient: client,
	}
}

/*
FlexcacheOriginModifyCollectionParams contains all the parameters to send to the API endpoint

	for the flexcache origin modify collection operation.

	Typically these are written to a http.Request.
*/
type FlexcacheOriginModifyCollectionParams struct {

	/* BlockLevelInvalidation.

	   Filter by block_level_invalidation
	*/
	BlockLevelInvalidation *bool

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* FlexcachesClusterName.

	   Filter by flexcaches.cluster.name
	*/
	FlexcachesClusterName *string

	/* FlexcachesClusterUUID.

	   Filter by flexcaches.cluster.uuid
	*/
	FlexcachesClusterUUID *string

	/* FlexcachesCreateTime.

	   Filter by flexcaches.create_time
	*/
	FlexcachesCreateTime *string

	/* FlexcachesIPAddress.

	   Filter by flexcaches.ip_address
	*/
	FlexcachesIPAddress *string

	/* FlexcachesSize.

	   Filter by flexcaches.size
	*/
	FlexcachesSize *int64

	/* FlexcachesState.

	   Filter by flexcaches.state
	*/
	FlexcachesState *string

	/* FlexcachesSvmName.

	   Filter by flexcaches.svm.name
	*/
	FlexcachesSvmName *string

	/* FlexcachesSvmUUID.

	   Filter by flexcaches.svm.uuid
	*/
	FlexcachesSvmUUID *string

	/* FlexcachesVolumeName.

	   Filter by flexcaches.volume.name
	*/
	FlexcachesVolumeName *string

	/* FlexcachesVolumeUUID.

	   Filter by flexcaches.volume.uuid
	*/
	FlexcachesVolumeUUID *string

	/* GlobalFileLockingEnabled.

	   Filter by global_file_locking_enabled
	*/
	GlobalFileLockingEnabled *bool

	/* Info.

	   Info specification
	*/
	Info FlexcacheOriginModifyCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the flexcache origin modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FlexcacheOriginModifyCollectionParams) WithDefaults() *FlexcacheOriginModifyCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the flexcache origin modify collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FlexcacheOriginModifyCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := FlexcacheOriginModifyCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithTimeout(timeout time.Duration) *FlexcacheOriginModifyCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithContext(ctx context.Context) *FlexcacheOriginModifyCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithHTTPClient(client *http.Client) *FlexcacheOriginModifyCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBlockLevelInvalidation adds the blockLevelInvalidation to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithBlockLevelInvalidation(blockLevelInvalidation *bool) *FlexcacheOriginModifyCollectionParams {
	o.SetBlockLevelInvalidation(blockLevelInvalidation)
	return o
}

// SetBlockLevelInvalidation adds the blockLevelInvalidation to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetBlockLevelInvalidation(blockLevelInvalidation *bool) {
	o.BlockLevelInvalidation = blockLevelInvalidation
}

// WithContinueOnFailure adds the continueOnFailure to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *FlexcacheOriginModifyCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithFlexcachesClusterName adds the flexcachesClusterName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesClusterName(flexcachesClusterName *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesClusterName(flexcachesClusterName)
	return o
}

// SetFlexcachesClusterName adds the flexcachesClusterName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesClusterName(flexcachesClusterName *string) {
	o.FlexcachesClusterName = flexcachesClusterName
}

// WithFlexcachesClusterUUID adds the flexcachesClusterUUID to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesClusterUUID(flexcachesClusterUUID *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesClusterUUID(flexcachesClusterUUID)
	return o
}

// SetFlexcachesClusterUUID adds the flexcachesClusterUuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesClusterUUID(flexcachesClusterUUID *string) {
	o.FlexcachesClusterUUID = flexcachesClusterUUID
}

// WithFlexcachesCreateTime adds the flexcachesCreateTime to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesCreateTime(flexcachesCreateTime *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesCreateTime(flexcachesCreateTime)
	return o
}

// SetFlexcachesCreateTime adds the flexcachesCreateTime to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesCreateTime(flexcachesCreateTime *string) {
	o.FlexcachesCreateTime = flexcachesCreateTime
}

// WithFlexcachesIPAddress adds the flexcachesIPAddress to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesIPAddress(flexcachesIPAddress *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesIPAddress(flexcachesIPAddress)
	return o
}

// SetFlexcachesIPAddress adds the flexcachesIpAddress to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesIPAddress(flexcachesIPAddress *string) {
	o.FlexcachesIPAddress = flexcachesIPAddress
}

// WithFlexcachesSize adds the flexcachesSize to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesSize(flexcachesSize *int64) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesSize(flexcachesSize)
	return o
}

// SetFlexcachesSize adds the flexcachesSize to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesSize(flexcachesSize *int64) {
	o.FlexcachesSize = flexcachesSize
}

// WithFlexcachesState adds the flexcachesState to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesState(flexcachesState *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesState(flexcachesState)
	return o
}

// SetFlexcachesState adds the flexcachesState to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesState(flexcachesState *string) {
	o.FlexcachesState = flexcachesState
}

// WithFlexcachesSvmName adds the flexcachesSvmName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesSvmName(flexcachesSvmName *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesSvmName(flexcachesSvmName)
	return o
}

// SetFlexcachesSvmName adds the flexcachesSvmName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesSvmName(flexcachesSvmName *string) {
	o.FlexcachesSvmName = flexcachesSvmName
}

// WithFlexcachesSvmUUID adds the flexcachesSvmUUID to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesSvmUUID(flexcachesSvmUUID *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesSvmUUID(flexcachesSvmUUID)
	return o
}

// SetFlexcachesSvmUUID adds the flexcachesSvmUuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesSvmUUID(flexcachesSvmUUID *string) {
	o.FlexcachesSvmUUID = flexcachesSvmUUID
}

// WithFlexcachesVolumeName adds the flexcachesVolumeName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesVolumeName(flexcachesVolumeName *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesVolumeName(flexcachesVolumeName)
	return o
}

// SetFlexcachesVolumeName adds the flexcachesVolumeName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesVolumeName(flexcachesVolumeName *string) {
	o.FlexcachesVolumeName = flexcachesVolumeName
}

// WithFlexcachesVolumeUUID adds the flexcachesVolumeUUID to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithFlexcachesVolumeUUID(flexcachesVolumeUUID *string) *FlexcacheOriginModifyCollectionParams {
	o.SetFlexcachesVolumeUUID(flexcachesVolumeUUID)
	return o
}

// SetFlexcachesVolumeUUID adds the flexcachesVolumeUuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetFlexcachesVolumeUUID(flexcachesVolumeUUID *string) {
	o.FlexcachesVolumeUUID = flexcachesVolumeUUID
}

// WithGlobalFileLockingEnabled adds the globalFileLockingEnabled to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithGlobalFileLockingEnabled(globalFileLockingEnabled *bool) *FlexcacheOriginModifyCollectionParams {
	o.SetGlobalFileLockingEnabled(globalFileLockingEnabled)
	return o
}

// SetGlobalFileLockingEnabled adds the globalFileLockingEnabled to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetGlobalFileLockingEnabled(globalFileLockingEnabled *bool) {
	o.GlobalFileLockingEnabled = globalFileLockingEnabled
}

// WithInfo adds the info to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithInfo(info FlexcacheOriginModifyCollectionBody) *FlexcacheOriginModifyCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetInfo(info FlexcacheOriginModifyCollectionBody) {
	o.Info = info
}

// WithName adds the name to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithName(name *string) *FlexcacheOriginModifyCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithReturnRecords(returnRecords *bool) *FlexcacheOriginModifyCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithReturnTimeout(returnTimeout *int64) *FlexcacheOriginModifyCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithSerialRecords(serialRecords *bool) *FlexcacheOriginModifyCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithSvmName(svmName *string) *FlexcacheOriginModifyCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithSvmUUID(svmUUID *string) *FlexcacheOriginModifyCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) WithUUID(uuid *string) *FlexcacheOriginModifyCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the flexcache origin modify collection params
func (o *FlexcacheOriginModifyCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *FlexcacheOriginModifyCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BlockLevelInvalidation != nil {

		// query param block_level_invalidation
		var qrBlockLevelInvalidation bool

		if o.BlockLevelInvalidation != nil {
			qrBlockLevelInvalidation = *o.BlockLevelInvalidation
		}
		qBlockLevelInvalidation := swag.FormatBool(qrBlockLevelInvalidation)
		if qBlockLevelInvalidation != "" {

			if err := r.SetQueryParam("block_level_invalidation", qBlockLevelInvalidation); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesClusterName != nil {

		// query param flexcaches.cluster.name
		var qrFlexcachesClusterName string

		if o.FlexcachesClusterName != nil {
			qrFlexcachesClusterName = *o.FlexcachesClusterName
		}
		qFlexcachesClusterName := qrFlexcachesClusterName
		if qFlexcachesClusterName != "" {

			if err := r.SetQueryParam("flexcaches.cluster.name", qFlexcachesClusterName); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesClusterUUID != nil {

		// query param flexcaches.cluster.uuid
		var qrFlexcachesClusterUUID string

		if o.FlexcachesClusterUUID != nil {
			qrFlexcachesClusterUUID = *o.FlexcachesClusterUUID
		}
		qFlexcachesClusterUUID := qrFlexcachesClusterUUID
		if qFlexcachesClusterUUID != "" {

			if err := r.SetQueryParam("flexcaches.cluster.uuid", qFlexcachesClusterUUID); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesCreateTime != nil {

		// query param flexcaches.create_time
		var qrFlexcachesCreateTime string

		if o.FlexcachesCreateTime != nil {
			qrFlexcachesCreateTime = *o.FlexcachesCreateTime
		}
		qFlexcachesCreateTime := qrFlexcachesCreateTime
		if qFlexcachesCreateTime != "" {

			if err := r.SetQueryParam("flexcaches.create_time", qFlexcachesCreateTime); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesIPAddress != nil {

		// query param flexcaches.ip_address
		var qrFlexcachesIPAddress string

		if o.FlexcachesIPAddress != nil {
			qrFlexcachesIPAddress = *o.FlexcachesIPAddress
		}
		qFlexcachesIPAddress := qrFlexcachesIPAddress
		if qFlexcachesIPAddress != "" {

			if err := r.SetQueryParam("flexcaches.ip_address", qFlexcachesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesSize != nil {

		// query param flexcaches.size
		var qrFlexcachesSize int64

		if o.FlexcachesSize != nil {
			qrFlexcachesSize = *o.FlexcachesSize
		}
		qFlexcachesSize := swag.FormatInt64(qrFlexcachesSize)
		if qFlexcachesSize != "" {

			if err := r.SetQueryParam("flexcaches.size", qFlexcachesSize); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesState != nil {

		// query param flexcaches.state
		var qrFlexcachesState string

		if o.FlexcachesState != nil {
			qrFlexcachesState = *o.FlexcachesState
		}
		qFlexcachesState := qrFlexcachesState
		if qFlexcachesState != "" {

			if err := r.SetQueryParam("flexcaches.state", qFlexcachesState); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesSvmName != nil {

		// query param flexcaches.svm.name
		var qrFlexcachesSvmName string

		if o.FlexcachesSvmName != nil {
			qrFlexcachesSvmName = *o.FlexcachesSvmName
		}
		qFlexcachesSvmName := qrFlexcachesSvmName
		if qFlexcachesSvmName != "" {

			if err := r.SetQueryParam("flexcaches.svm.name", qFlexcachesSvmName); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesSvmUUID != nil {

		// query param flexcaches.svm.uuid
		var qrFlexcachesSvmUUID string

		if o.FlexcachesSvmUUID != nil {
			qrFlexcachesSvmUUID = *o.FlexcachesSvmUUID
		}
		qFlexcachesSvmUUID := qrFlexcachesSvmUUID
		if qFlexcachesSvmUUID != "" {

			if err := r.SetQueryParam("flexcaches.svm.uuid", qFlexcachesSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesVolumeName != nil {

		// query param flexcaches.volume.name
		var qrFlexcachesVolumeName string

		if o.FlexcachesVolumeName != nil {
			qrFlexcachesVolumeName = *o.FlexcachesVolumeName
		}
		qFlexcachesVolumeName := qrFlexcachesVolumeName
		if qFlexcachesVolumeName != "" {

			if err := r.SetQueryParam("flexcaches.volume.name", qFlexcachesVolumeName); err != nil {
				return err
			}
		}
	}

	if o.FlexcachesVolumeUUID != nil {

		// query param flexcaches.volume.uuid
		var qrFlexcachesVolumeUUID string

		if o.FlexcachesVolumeUUID != nil {
			qrFlexcachesVolumeUUID = *o.FlexcachesVolumeUUID
		}
		qFlexcachesVolumeUUID := qrFlexcachesVolumeUUID
		if qFlexcachesVolumeUUID != "" {

			if err := r.SetQueryParam("flexcaches.volume.uuid", qFlexcachesVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.GlobalFileLockingEnabled != nil {

		// query param global_file_locking_enabled
		var qrGlobalFileLockingEnabled bool

		if o.GlobalFileLockingEnabled != nil {
			qrGlobalFileLockingEnabled = *o.GlobalFileLockingEnabled
		}
		qGlobalFileLockingEnabled := swag.FormatBool(qrGlobalFileLockingEnabled)
		if qGlobalFileLockingEnabled != "" {

			if err := r.SetQueryParam("global_file_locking_enabled", qGlobalFileLockingEnabled); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
