// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FlexcacheOriginModifyCollectionReader is a Reader for the FlexcacheOriginModifyCollection structure.
type FlexcacheOriginModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FlexcacheOriginModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFlexcacheOriginModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewFlexcacheOriginModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFlexcacheOriginModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFlexcacheOriginModifyCollectionOK creates a FlexcacheOriginModifyCollectionOK with default headers values
func NewFlexcacheOriginModifyCollectionOK() *FlexcacheOriginModifyCollectionOK {
	return &FlexcacheOriginModifyCollectionOK{}
}

/*
FlexcacheOriginModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type FlexcacheOriginModifyCollectionOK struct {
	Payload *models.FlexcacheOriginJobLinkResponse
}

// IsSuccess returns true when this flexcache origin modify collection o k response has a 2xx status code
func (o *FlexcacheOriginModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache origin modify collection o k response has a 3xx status code
func (o *FlexcacheOriginModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache origin modify collection o k response has a 4xx status code
func (o *FlexcacheOriginModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache origin modify collection o k response has a 5xx status code
func (o *FlexcacheOriginModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache origin modify collection o k response a status code equal to that given
func (o *FlexcacheOriginModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the flexcache origin modify collection o k response
func (o *FlexcacheOriginModifyCollectionOK) Code() int {
	return 200
}

func (o *FlexcacheOriginModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcacheOriginModifyCollectionOK %s", 200, payload)
}

func (o *FlexcacheOriginModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcacheOriginModifyCollectionOK %s", 200, payload)
}

func (o *FlexcacheOriginModifyCollectionOK) GetPayload() *models.FlexcacheOriginJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheOriginJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheOriginModifyCollectionAccepted creates a FlexcacheOriginModifyCollectionAccepted with default headers values
func NewFlexcacheOriginModifyCollectionAccepted() *FlexcacheOriginModifyCollectionAccepted {
	return &FlexcacheOriginModifyCollectionAccepted{}
}

/*
FlexcacheOriginModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type FlexcacheOriginModifyCollectionAccepted struct {
	Payload *models.FlexcacheOriginJobLinkResponse
}

// IsSuccess returns true when this flexcache origin modify collection accepted response has a 2xx status code
func (o *FlexcacheOriginModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache origin modify collection accepted response has a 3xx status code
func (o *FlexcacheOriginModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache origin modify collection accepted response has a 4xx status code
func (o *FlexcacheOriginModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache origin modify collection accepted response has a 5xx status code
func (o *FlexcacheOriginModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache origin modify collection accepted response a status code equal to that given
func (o *FlexcacheOriginModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the flexcache origin modify collection accepted response
func (o *FlexcacheOriginModifyCollectionAccepted) Code() int {
	return 202
}

func (o *FlexcacheOriginModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcacheOriginModifyCollectionAccepted %s", 202, payload)
}

func (o *FlexcacheOriginModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcacheOriginModifyCollectionAccepted %s", 202, payload)
}

func (o *FlexcacheOriginModifyCollectionAccepted) GetPayload() *models.FlexcacheOriginJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheOriginJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheOriginModifyCollectionDefault creates a FlexcacheOriginModifyCollectionDefault with default headers values
func NewFlexcacheOriginModifyCollectionDefault(code int) *FlexcacheOriginModifyCollectionDefault {
	return &FlexcacheOriginModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	FlexcacheOriginModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66846870   | Either origin volume uuid or BLI option value is missing |
| 66847020   | Failed to get origin volume details using volume uuid |
| 66847021   | Failed to modify origin volume options |
*/
type FlexcacheOriginModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this flexcache origin modify collection default response has a 2xx status code
func (o *FlexcacheOriginModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this flexcache origin modify collection default response has a 3xx status code
func (o *FlexcacheOriginModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this flexcache origin modify collection default response has a 4xx status code
func (o *FlexcacheOriginModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this flexcache origin modify collection default response has a 5xx status code
func (o *FlexcacheOriginModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this flexcache origin modify collection default response a status code equal to that given
func (o *FlexcacheOriginModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the flexcache origin modify collection default response
func (o *FlexcacheOriginModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *FlexcacheOriginModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcache_origin_modify_collection default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins][%d] flexcache_origin_modify_collection default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
FlexcacheOriginModifyCollectionBody flexcache origin modify collection body
swagger:model FlexcacheOriginModifyCollectionBody
*/
type FlexcacheOriginModifyCollectionBody struct {

	// links
	Links *models.FlexcacheOriginInlineLinks `json:"_links,omitempty"`

	// Block level invalidation enables the FlexCache volume to retain blocks that are not changed at the FlexCache volume without having to evict them. This means that the FlexCache volume does not have to again incur the computational cost of fetching blocks over the WAN from the FlexCache volume origin on the next client access. Block level invalidation is a property of the origin volume. Without block level invalidation, any write at the origin volume would evict the whole file at the FlexCache volume, since by default, origin volume does a file level invalidation.
	BlockLevelInvalidation *bool `json:"block_level_invalidation,omitempty"`

	// flexcache origin inline flexcaches
	FlexcacheOriginInlineFlexcaches []*models.FlexcacheRelationship `json:"flexcaches,omitempty"`

	// flexcache origin response inline records
	FlexcacheOriginResponseInlineRecords []*models.FlexcacheOrigin `json:"records,omitempty"`

	// Specifies whether a global file locking option is enabled for an origin volume of a FlexCache volume.
	// Read Only: true
	GlobalFileLockingEnabled *bool `json:"global_file_locking_enabled,omitempty"`

	// Origin volume name
	// Example: vol1, vol_2
	// Max Length: 203
	// Min Length: 1
	Name *string `json:"name,omitempty"`

	// svm
	Svm *models.FlexcacheOriginInlineSvm `json:"svm,omitempty"`

	// Origin volume UUID. Unique identifier for origin of FlexCache.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563512
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache origin modify collection body
func (o *FlexcacheOriginModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheOriginInlineFlexcaches(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFlexcacheOriginResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) validateFlexcacheOriginInlineFlexcaches(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheOriginInlineFlexcaches) { // not required
		return nil
	}

	for i := 0; i < len(o.FlexcacheOriginInlineFlexcaches); i++ {
		if swag.IsZero(o.FlexcacheOriginInlineFlexcaches[i]) { // not required
			continue
		}

		if o.FlexcacheOriginInlineFlexcaches[i] != nil {
			if err := o.FlexcacheOriginInlineFlexcaches[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "flexcaches" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) validateFlexcacheOriginResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.FlexcacheOriginResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.FlexcacheOriginResponseInlineRecords); i++ {
		if swag.IsZero(o.FlexcacheOriginResponseInlineRecords[i]) { // not required
			continue
		}

		if o.FlexcacheOriginResponseInlineRecords[i] != nil {
			if err := o.FlexcacheOriginResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 203); err != nil {
		return err
	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache origin modify collection body based on the context it is used
func (o *FlexcacheOriginModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheOriginInlineFlexcaches(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFlexcacheOriginResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGlobalFileLockingEnabled(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateFlexcacheOriginInlineFlexcaches(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FlexcacheOriginInlineFlexcaches); i++ {

		if o.FlexcacheOriginInlineFlexcaches[i] != nil {
			if err := o.FlexcacheOriginInlineFlexcaches[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "flexcaches" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateFlexcacheOriginResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.FlexcacheOriginResponseInlineRecords); i++ {

		if o.FlexcacheOriginResponseInlineRecords[i] != nil {
			if err := o.FlexcacheOriginResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateGlobalFileLockingEnabled(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"global_file_locking_enabled", "body", o.GlobalFileLockingEnabled); err != nil {
		return err
	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *FlexcacheOriginModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheOriginModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheOriginModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res FlexcacheOriginModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheOriginInlineLinks flexcache origin inline links
swagger:model flexcache_origin_inline__links
*/
type FlexcacheOriginInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this flexcache origin inline links
func (o *FlexcacheOriginInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache origin inline links based on the context it is used
func (o *FlexcacheOriginInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheOriginInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheOriginInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheOriginInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheOriginInlineSvm Origin volume SVM
swagger:model flexcache_origin_inline_svm
*/
type FlexcacheOriginInlineSvm struct {

	// links
	Links *models.FlexcacheOriginInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this flexcache origin inline svm
func (o *FlexcacheOriginInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache origin inline svm based on the context it is used
func (o *FlexcacheOriginInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheOriginInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheOriginInlineSvm) UnmarshalBinary(b []byte) error {
	var res FlexcacheOriginInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
FlexcacheOriginInlineSvmInlineLinks flexcache origin inline svm inline links
swagger:model flexcache_origin_inline_svm_inline__links
*/
type FlexcacheOriginInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this flexcache origin inline svm inline links
func (o *FlexcacheOriginInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this flexcache origin inline svm inline links based on the context it is used
func (o *FlexcacheOriginInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *FlexcacheOriginInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *FlexcacheOriginInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *FlexcacheOriginInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res FlexcacheOriginInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
