// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewFlexcacheOriginModifyParams creates a new FlexcacheOriginModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewFlexcacheOriginModifyParams() *FlexcacheOriginModifyParams {
	return &FlexcacheOriginModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewFlexcacheOriginModifyParamsWithTimeout creates a new FlexcacheOriginModifyParams object
// with the ability to set a timeout on a request.
func NewFlexcacheOriginModifyParamsWithTimeout(timeout time.Duration) *FlexcacheOriginModifyParams {
	return &FlexcacheOriginModifyParams{
		timeout: timeout,
	}
}

// NewFlexcacheOriginModifyParamsWithContext creates a new FlexcacheOriginModifyParams object
// with the ability to set a context for a request.
func NewFlexcacheOriginModifyParamsWithContext(ctx context.Context) *FlexcacheOriginModifyParams {
	return &FlexcacheOriginModifyParams{
		Context: ctx,
	}
}

// NewFlexcacheOriginModifyParamsWithHTTPClient creates a new FlexcacheOriginModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewFlexcacheOriginModifyParamsWithHTTPClient(client *http.Client) *FlexcacheOriginModifyParams {
	return &FlexcacheOriginModifyParams{
		HTTPClient: client,
	}
}

/*
FlexcacheOriginModifyParams contains all the parameters to send to the API endpoint

	for the flexcache origin modify operation.

	Typically these are written to a http.Request.
*/
type FlexcacheOriginModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.FlexcacheOrigin

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Unique identifier of the origin of the FlexCache volume.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the flexcache origin modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FlexcacheOriginModifyParams) WithDefaults() *FlexcacheOriginModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the flexcache origin modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *FlexcacheOriginModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := FlexcacheOriginModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithTimeout(timeout time.Duration) *FlexcacheOriginModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithContext(ctx context.Context) *FlexcacheOriginModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithHTTPClient(client *http.Client) *FlexcacheOriginModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithInfo(info *models.FlexcacheOrigin) *FlexcacheOriginModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetInfo(info *models.FlexcacheOrigin) {
	o.Info = info
}

// WithReturnTimeout adds the returnTimeout to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithReturnTimeout(returnTimeout *int64) *FlexcacheOriginModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) WithUUID(uuid string) *FlexcacheOriginModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the flexcache origin modify params
func (o *FlexcacheOriginModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *FlexcacheOriginModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
