// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// FlexcacheOriginModifyReader is a Reader for the FlexcacheOriginModify structure.
type FlexcacheOriginModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *FlexcacheOriginModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewFlexcacheOriginModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewFlexcacheOriginModifyAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewFlexcacheOriginModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewFlexcacheOriginModifyOK creates a FlexcacheOriginModifyOK with default headers values
func NewFlexcacheOriginModifyOK() *FlexcacheOriginModifyOK {
	return &FlexcacheOriginModifyOK{}
}

/*
FlexcacheOriginModifyOK describes a response with status code 200, with default header values.

OK
*/
type FlexcacheOriginModifyOK struct {
	Payload *models.FlexcacheOriginJobLinkResponse
}

// IsSuccess returns true when this flexcache origin modify o k response has a 2xx status code
func (o *FlexcacheOriginModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache origin modify o k response has a 3xx status code
func (o *FlexcacheOriginModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache origin modify o k response has a 4xx status code
func (o *FlexcacheOriginModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache origin modify o k response has a 5xx status code
func (o *FlexcacheOriginModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache origin modify o k response a status code equal to that given
func (o *FlexcacheOriginModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the flexcache origin modify o k response
func (o *FlexcacheOriginModifyOK) Code() int {
	return 200
}

func (o *FlexcacheOriginModifyOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcacheOriginModifyOK %s", 200, payload)
}

func (o *FlexcacheOriginModifyOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcacheOriginModifyOK %s", 200, payload)
}

func (o *FlexcacheOriginModifyOK) GetPayload() *models.FlexcacheOriginJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheOriginJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheOriginModifyAccepted creates a FlexcacheOriginModifyAccepted with default headers values
func NewFlexcacheOriginModifyAccepted() *FlexcacheOriginModifyAccepted {
	return &FlexcacheOriginModifyAccepted{}
}

/*
FlexcacheOriginModifyAccepted describes a response with status code 202, with default header values.

Accepted
*/
type FlexcacheOriginModifyAccepted struct {
	Payload *models.FlexcacheOriginJobLinkResponse
}

// IsSuccess returns true when this flexcache origin modify accepted response has a 2xx status code
func (o *FlexcacheOriginModifyAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this flexcache origin modify accepted response has a 3xx status code
func (o *FlexcacheOriginModifyAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this flexcache origin modify accepted response has a 4xx status code
func (o *FlexcacheOriginModifyAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this flexcache origin modify accepted response has a 5xx status code
func (o *FlexcacheOriginModifyAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this flexcache origin modify accepted response a status code equal to that given
func (o *FlexcacheOriginModifyAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the flexcache origin modify accepted response
func (o *FlexcacheOriginModifyAccepted) Code() int {
	return 202
}

func (o *FlexcacheOriginModifyAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcacheOriginModifyAccepted %s", 202, payload)
}

func (o *FlexcacheOriginModifyAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcacheOriginModifyAccepted %s", 202, payload)
}

func (o *FlexcacheOriginModifyAccepted) GetPayload() *models.FlexcacheOriginJobLinkResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.FlexcacheOriginJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewFlexcacheOriginModifyDefault creates a FlexcacheOriginModifyDefault with default headers values
func NewFlexcacheOriginModifyDefault(code int) *FlexcacheOriginModifyDefault {
	return &FlexcacheOriginModifyDefault{
		_statusCode: code,
	}
}

/*
	FlexcacheOriginModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 66846870   | Either origin volume uuid or BLI option value is missing |
| 66847020   | Failed to get origin volume details using volume uuid |
| 66847021   | Failed to modify origin volume options |
*/
type FlexcacheOriginModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this flexcache origin modify default response has a 2xx status code
func (o *FlexcacheOriginModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this flexcache origin modify default response has a 3xx status code
func (o *FlexcacheOriginModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this flexcache origin modify default response has a 4xx status code
func (o *FlexcacheOriginModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this flexcache origin modify default response has a 5xx status code
func (o *FlexcacheOriginModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this flexcache origin modify default response a status code equal to that given
func (o *FlexcacheOriginModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the flexcache origin modify default response
func (o *FlexcacheOriginModifyDefault) Code() int {
	return o._statusCode
}

func (o *FlexcacheOriginModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcache_origin_modify default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/flexcache/origins/{uuid}][%d] flexcache_origin_modify default %s", o._statusCode, payload)
}

func (o *FlexcacheOriginModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *FlexcacheOriginModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
