// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceQtreeMetricCollectionGetReader is a Reader for the PerformanceQtreeMetricCollectionGet structure.
type PerformanceQtreeMetricCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceQtreeMetricCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceQtreeMetricCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceQtreeMetricCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceQtreeMetricCollectionGetOK creates a PerformanceQtreeMetricCollectionGetOK with default headers values
func NewPerformanceQtreeMetricCollectionGetOK() *PerformanceQtreeMetricCollectionGetOK {
	return &PerformanceQtreeMetricCollectionGetOK{}
}

/*
PerformanceQtreeMetricCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceQtreeMetricCollectionGetOK struct {
	Payload *models.PerformanceQtreeMetricResponse
}

// IsSuccess returns true when this performance qtree metric collection get o k response has a 2xx status code
func (o *PerformanceQtreeMetricCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance qtree metric collection get o k response has a 3xx status code
func (o *PerformanceQtreeMetricCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance qtree metric collection get o k response has a 4xx status code
func (o *PerformanceQtreeMetricCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance qtree metric collection get o k response has a 5xx status code
func (o *PerformanceQtreeMetricCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance qtree metric collection get o k response a status code equal to that given
func (o *PerformanceQtreeMetricCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance qtree metric collection get o k response
func (o *PerformanceQtreeMetricCollectionGetOK) Code() int {
	return 200
}

func (o *PerformanceQtreeMetricCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qtrees/{volume.uuid}/{qtree.id}/metrics][%d] performanceQtreeMetricCollectionGetOK %s", 200, payload)
}

func (o *PerformanceQtreeMetricCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qtrees/{volume.uuid}/{qtree.id}/metrics][%d] performanceQtreeMetricCollectionGetOK %s", 200, payload)
}

func (o *PerformanceQtreeMetricCollectionGetOK) GetPayload() *models.PerformanceQtreeMetricResponse {
	return o.Payload
}

func (o *PerformanceQtreeMetricCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceQtreeMetricResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceQtreeMetricCollectionGetDefault creates a PerformanceQtreeMetricCollectionGetDefault with default headers values
func NewPerformanceQtreeMetricCollectionGetDefault(code int) *PerformanceQtreeMetricCollectionGetDefault {
	return &PerformanceQtreeMetricCollectionGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceQtreeMetricCollectionGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 918235 | A volume with UUID was not found. |
| 2621462 | The specified SVM does not exist. |
| 5242956 | Failed to obtain a qtree with ID. |
| 5242986 | Extended performance monitoring is not enabled on the qtree. |
| 8586227 | Interval not supported for this object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceQtreeMetricCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance qtree metric collection get default response has a 2xx status code
func (o *PerformanceQtreeMetricCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance qtree metric collection get default response has a 3xx status code
func (o *PerformanceQtreeMetricCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance qtree metric collection get default response has a 4xx status code
func (o *PerformanceQtreeMetricCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance qtree metric collection get default response has a 5xx status code
func (o *PerformanceQtreeMetricCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance qtree metric collection get default response a status code equal to that given
func (o *PerformanceQtreeMetricCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance qtree metric collection get default response
func (o *PerformanceQtreeMetricCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceQtreeMetricCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qtrees/{volume.uuid}/{qtree.id}/metrics][%d] performance_qtree_metric_collection_get default %s", o._statusCode, payload)
}

func (o *PerformanceQtreeMetricCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qtrees/{volume.uuid}/{qtree.id}/metrics][%d] performance_qtree_metric_collection_get default %s", o._statusCode, payload)
}

func (o *PerformanceQtreeMetricCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceQtreeMetricCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
