// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPlexCollectionGetParams creates a new PlexCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPlexCollectionGetParams() *PlexCollectionGetParams {
	return &PlexCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPlexCollectionGetParamsWithTimeout creates a new PlexCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPlexCollectionGetParamsWithTimeout(timeout time.Duration) *PlexCollectionGetParams {
	return &PlexCollectionGetParams{
		timeout: timeout,
	}
}

// NewPlexCollectionGetParamsWithContext creates a new PlexCollectionGetParams object
// with the ability to set a context for a request.
func NewPlexCollectionGetParamsWithContext(ctx context.Context) *PlexCollectionGetParams {
	return &PlexCollectionGetParams{
		Context: ctx,
	}
}

// NewPlexCollectionGetParamsWithHTTPClient creates a new PlexCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPlexCollectionGetParamsWithHTTPClient(client *http.Client) *PlexCollectionGetParams {
	return &PlexCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PlexCollectionGetParams contains all the parameters to send to the API endpoint

	for the plex collection get operation.

	Typically these are written to a http.Request.
*/
type PlexCollectionGetParams struct {

	/* AggregateName.

	   Filter by aggregate.name
	*/
	AggregateName *string

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Online.

	   Filter by online
	*/
	Online *bool

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Pool.

	   Filter by pool
	*/
	Pool *string

	/* RaidGroupsCacheTier.

	   Filter by raid_groups.cache_tier
	*/
	RaidGroupsCacheTier *bool

	/* RaidGroupsDegraded.

	   Filter by raid_groups.degraded
	*/
	RaidGroupsDegraded *bool

	/* RaidGroupsDisksDiskName.

	   Filter by raid_groups.disks.disk.name
	*/
	RaidGroupsDisksDiskName *string

	/* RaidGroupsDisksPosition.

	   Filter by raid_groups.disks.position
	*/
	RaidGroupsDisksPosition *string

	/* RaidGroupsDisksState.

	   Filter by raid_groups.disks.state
	*/
	RaidGroupsDisksState *string

	/* RaidGroupsDisksType.

	   Filter by raid_groups.disks.type
	*/
	RaidGroupsDisksType *string

	/* RaidGroupsDisksUsableSize.

	   Filter by raid_groups.disks.usable_size
	*/
	RaidGroupsDisksUsableSize *int64

	/* RaidGroupsName.

	   Filter by raid_groups.name
	*/
	RaidGroupsName *string

	/* RaidGroupsRaidType.

	   Filter by raid_groups.raid_type
	*/
	RaidGroupsRaidType *string

	/* RaidGroupsRecomputingParityActive.

	   Filter by raid_groups.recomputing_parity.active
	*/
	RaidGroupsRecomputingParityActive *bool

	/* RaidGroupsRecomputingParityPercent.

	   Filter by raid_groups.recomputing_parity.percent
	*/
	RaidGroupsRecomputingParityPercent *int64

	/* RaidGroupsReconstructActive.

	   Filter by raid_groups.reconstruct.active
	*/
	RaidGroupsReconstructActive *bool

	/* RaidGroupsReconstructPercent.

	   Filter by raid_groups.reconstruct.percent
	*/
	RaidGroupsReconstructPercent *int64

	/* ResyncActive.

	   Filter by resync.active
	*/
	ResyncActive *bool

	/* ResyncLevel.

	   Filter by resync.level
	*/
	ResyncLevel *string

	/* ResyncPercent.

	   Filter by resync.percent
	*/
	ResyncPercent *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* State.

	   Filter by state
	*/
	State *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the plex collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlexCollectionGetParams) WithDefaults() *PlexCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the plex collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlexCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PlexCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the plex collection get params
func (o *PlexCollectionGetParams) WithTimeout(timeout time.Duration) *PlexCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the plex collection get params
func (o *PlexCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the plex collection get params
func (o *PlexCollectionGetParams) WithContext(ctx context.Context) *PlexCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the plex collection get params
func (o *PlexCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the plex collection get params
func (o *PlexCollectionGetParams) WithHTTPClient(client *http.Client) *PlexCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the plex collection get params
func (o *PlexCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateName adds the aggregateName to the plex collection get params
func (o *PlexCollectionGetParams) WithAggregateName(aggregateName *string) *PlexCollectionGetParams {
	o.SetAggregateName(aggregateName)
	return o
}

// SetAggregateName adds the aggregateName to the plex collection get params
func (o *PlexCollectionGetParams) SetAggregateName(aggregateName *string) {
	o.AggregateName = aggregateName
}

// WithAggregateUUID adds the aggregateUUID to the plex collection get params
func (o *PlexCollectionGetParams) WithAggregateUUID(aggregateUUID string) *PlexCollectionGetParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the plex collection get params
func (o *PlexCollectionGetParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithFields adds the fields to the plex collection get params
func (o *PlexCollectionGetParams) WithFields(fields []string) *PlexCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the plex collection get params
func (o *PlexCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the plex collection get params
func (o *PlexCollectionGetParams) WithMaxRecords(maxRecords *int64) *PlexCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the plex collection get params
func (o *PlexCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the plex collection get params
func (o *PlexCollectionGetParams) WithName(name *string) *PlexCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the plex collection get params
func (o *PlexCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOnline adds the online to the plex collection get params
func (o *PlexCollectionGetParams) WithOnline(online *bool) *PlexCollectionGetParams {
	o.SetOnline(online)
	return o
}

// SetOnline adds the online to the plex collection get params
func (o *PlexCollectionGetParams) SetOnline(online *bool) {
	o.Online = online
}

// WithOrderBy adds the orderBy to the plex collection get params
func (o *PlexCollectionGetParams) WithOrderBy(orderBy []string) *PlexCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the plex collection get params
func (o *PlexCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPool adds the pool to the plex collection get params
func (o *PlexCollectionGetParams) WithPool(pool *string) *PlexCollectionGetParams {
	o.SetPool(pool)
	return o
}

// SetPool adds the pool to the plex collection get params
func (o *PlexCollectionGetParams) SetPool(pool *string) {
	o.Pool = pool
}

// WithRaidGroupsCacheTier adds the raidGroupsCacheTier to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsCacheTier(raidGroupsCacheTier *bool) *PlexCollectionGetParams {
	o.SetRaidGroupsCacheTier(raidGroupsCacheTier)
	return o
}

// SetRaidGroupsCacheTier adds the raidGroupsCacheTier to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsCacheTier(raidGroupsCacheTier *bool) {
	o.RaidGroupsCacheTier = raidGroupsCacheTier
}

// WithRaidGroupsDegraded adds the raidGroupsDegraded to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDegraded(raidGroupsDegraded *bool) *PlexCollectionGetParams {
	o.SetRaidGroupsDegraded(raidGroupsDegraded)
	return o
}

// SetRaidGroupsDegraded adds the raidGroupsDegraded to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDegraded(raidGroupsDegraded *bool) {
	o.RaidGroupsDegraded = raidGroupsDegraded
}

// WithRaidGroupsDisksDiskName adds the raidGroupsDisksDiskName to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDisksDiskName(raidGroupsDisksDiskName *string) *PlexCollectionGetParams {
	o.SetRaidGroupsDisksDiskName(raidGroupsDisksDiskName)
	return o
}

// SetRaidGroupsDisksDiskName adds the raidGroupsDisksDiskName to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDisksDiskName(raidGroupsDisksDiskName *string) {
	o.RaidGroupsDisksDiskName = raidGroupsDisksDiskName
}

// WithRaidGroupsDisksPosition adds the raidGroupsDisksPosition to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDisksPosition(raidGroupsDisksPosition *string) *PlexCollectionGetParams {
	o.SetRaidGroupsDisksPosition(raidGroupsDisksPosition)
	return o
}

// SetRaidGroupsDisksPosition adds the raidGroupsDisksPosition to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDisksPosition(raidGroupsDisksPosition *string) {
	o.RaidGroupsDisksPosition = raidGroupsDisksPosition
}

// WithRaidGroupsDisksState adds the raidGroupsDisksState to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDisksState(raidGroupsDisksState *string) *PlexCollectionGetParams {
	o.SetRaidGroupsDisksState(raidGroupsDisksState)
	return o
}

// SetRaidGroupsDisksState adds the raidGroupsDisksState to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDisksState(raidGroupsDisksState *string) {
	o.RaidGroupsDisksState = raidGroupsDisksState
}

// WithRaidGroupsDisksType adds the raidGroupsDisksType to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDisksType(raidGroupsDisksType *string) *PlexCollectionGetParams {
	o.SetRaidGroupsDisksType(raidGroupsDisksType)
	return o
}

// SetRaidGroupsDisksType adds the raidGroupsDisksType to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDisksType(raidGroupsDisksType *string) {
	o.RaidGroupsDisksType = raidGroupsDisksType
}

// WithRaidGroupsDisksUsableSize adds the raidGroupsDisksUsableSize to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsDisksUsableSize(raidGroupsDisksUsableSize *int64) *PlexCollectionGetParams {
	o.SetRaidGroupsDisksUsableSize(raidGroupsDisksUsableSize)
	return o
}

// SetRaidGroupsDisksUsableSize adds the raidGroupsDisksUsableSize to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsDisksUsableSize(raidGroupsDisksUsableSize *int64) {
	o.RaidGroupsDisksUsableSize = raidGroupsDisksUsableSize
}

// WithRaidGroupsName adds the raidGroupsName to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsName(raidGroupsName *string) *PlexCollectionGetParams {
	o.SetRaidGroupsName(raidGroupsName)
	return o
}

// SetRaidGroupsName adds the raidGroupsName to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsName(raidGroupsName *string) {
	o.RaidGroupsName = raidGroupsName
}

// WithRaidGroupsRaidType adds the raidGroupsRaidType to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsRaidType(raidGroupsRaidType *string) *PlexCollectionGetParams {
	o.SetRaidGroupsRaidType(raidGroupsRaidType)
	return o
}

// SetRaidGroupsRaidType adds the raidGroupsRaidType to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsRaidType(raidGroupsRaidType *string) {
	o.RaidGroupsRaidType = raidGroupsRaidType
}

// WithRaidGroupsRecomputingParityActive adds the raidGroupsRecomputingParityActive to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsRecomputingParityActive(raidGroupsRecomputingParityActive *bool) *PlexCollectionGetParams {
	o.SetRaidGroupsRecomputingParityActive(raidGroupsRecomputingParityActive)
	return o
}

// SetRaidGroupsRecomputingParityActive adds the raidGroupsRecomputingParityActive to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsRecomputingParityActive(raidGroupsRecomputingParityActive *bool) {
	o.RaidGroupsRecomputingParityActive = raidGroupsRecomputingParityActive
}

// WithRaidGroupsRecomputingParityPercent adds the raidGroupsRecomputingParityPercent to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsRecomputingParityPercent(raidGroupsRecomputingParityPercent *int64) *PlexCollectionGetParams {
	o.SetRaidGroupsRecomputingParityPercent(raidGroupsRecomputingParityPercent)
	return o
}

// SetRaidGroupsRecomputingParityPercent adds the raidGroupsRecomputingParityPercent to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsRecomputingParityPercent(raidGroupsRecomputingParityPercent *int64) {
	o.RaidGroupsRecomputingParityPercent = raidGroupsRecomputingParityPercent
}

// WithRaidGroupsReconstructActive adds the raidGroupsReconstructActive to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsReconstructActive(raidGroupsReconstructActive *bool) *PlexCollectionGetParams {
	o.SetRaidGroupsReconstructActive(raidGroupsReconstructActive)
	return o
}

// SetRaidGroupsReconstructActive adds the raidGroupsReconstructActive to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsReconstructActive(raidGroupsReconstructActive *bool) {
	o.RaidGroupsReconstructActive = raidGroupsReconstructActive
}

// WithRaidGroupsReconstructPercent adds the raidGroupsReconstructPercent to the plex collection get params
func (o *PlexCollectionGetParams) WithRaidGroupsReconstructPercent(raidGroupsReconstructPercent *int64) *PlexCollectionGetParams {
	o.SetRaidGroupsReconstructPercent(raidGroupsReconstructPercent)
	return o
}

// SetRaidGroupsReconstructPercent adds the raidGroupsReconstructPercent to the plex collection get params
func (o *PlexCollectionGetParams) SetRaidGroupsReconstructPercent(raidGroupsReconstructPercent *int64) {
	o.RaidGroupsReconstructPercent = raidGroupsReconstructPercent
}

// WithResyncActive adds the resyncActive to the plex collection get params
func (o *PlexCollectionGetParams) WithResyncActive(resyncActive *bool) *PlexCollectionGetParams {
	o.SetResyncActive(resyncActive)
	return o
}

// SetResyncActive adds the resyncActive to the plex collection get params
func (o *PlexCollectionGetParams) SetResyncActive(resyncActive *bool) {
	o.ResyncActive = resyncActive
}

// WithResyncLevel adds the resyncLevel to the plex collection get params
func (o *PlexCollectionGetParams) WithResyncLevel(resyncLevel *string) *PlexCollectionGetParams {
	o.SetResyncLevel(resyncLevel)
	return o
}

// SetResyncLevel adds the resyncLevel to the plex collection get params
func (o *PlexCollectionGetParams) SetResyncLevel(resyncLevel *string) {
	o.ResyncLevel = resyncLevel
}

// WithResyncPercent adds the resyncPercent to the plex collection get params
func (o *PlexCollectionGetParams) WithResyncPercent(resyncPercent *int64) *PlexCollectionGetParams {
	o.SetResyncPercent(resyncPercent)
	return o
}

// SetResyncPercent adds the resyncPercent to the plex collection get params
func (o *PlexCollectionGetParams) SetResyncPercent(resyncPercent *int64) {
	o.ResyncPercent = resyncPercent
}

// WithReturnRecords adds the returnRecords to the plex collection get params
func (o *PlexCollectionGetParams) WithReturnRecords(returnRecords *bool) *PlexCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the plex collection get params
func (o *PlexCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the plex collection get params
func (o *PlexCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PlexCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the plex collection get params
func (o *PlexCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithState adds the state to the plex collection get params
func (o *PlexCollectionGetParams) WithState(state *string) *PlexCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the plex collection get params
func (o *PlexCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WriteToRequest writes these params to a swagger request
func (o *PlexCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AggregateName != nil {

		// query param aggregate.name
		var qrAggregateName string

		if o.AggregateName != nil {
			qrAggregateName = *o.AggregateName
		}
		qAggregateName := qrAggregateName
		if qAggregateName != "" {

			if err := r.SetQueryParam("aggregate.name", qAggregateName); err != nil {
				return err
			}
		}
	}

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Online != nil {

		// query param online
		var qrOnline bool

		if o.Online != nil {
			qrOnline = *o.Online
		}
		qOnline := swag.FormatBool(qrOnline)
		if qOnline != "" {

			if err := r.SetQueryParam("online", qOnline); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Pool != nil {

		// query param pool
		var qrPool string

		if o.Pool != nil {
			qrPool = *o.Pool
		}
		qPool := qrPool
		if qPool != "" {

			if err := r.SetQueryParam("pool", qPool); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsCacheTier != nil {

		// query param raid_groups.cache_tier
		var qrRaidGroupsCacheTier bool

		if o.RaidGroupsCacheTier != nil {
			qrRaidGroupsCacheTier = *o.RaidGroupsCacheTier
		}
		qRaidGroupsCacheTier := swag.FormatBool(qrRaidGroupsCacheTier)
		if qRaidGroupsCacheTier != "" {

			if err := r.SetQueryParam("raid_groups.cache_tier", qRaidGroupsCacheTier); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDegraded != nil {

		// query param raid_groups.degraded
		var qrRaidGroupsDegraded bool

		if o.RaidGroupsDegraded != nil {
			qrRaidGroupsDegraded = *o.RaidGroupsDegraded
		}
		qRaidGroupsDegraded := swag.FormatBool(qrRaidGroupsDegraded)
		if qRaidGroupsDegraded != "" {

			if err := r.SetQueryParam("raid_groups.degraded", qRaidGroupsDegraded); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDisksDiskName != nil {

		// query param raid_groups.disks.disk.name
		var qrRaidGroupsDisksDiskName string

		if o.RaidGroupsDisksDiskName != nil {
			qrRaidGroupsDisksDiskName = *o.RaidGroupsDisksDiskName
		}
		qRaidGroupsDisksDiskName := qrRaidGroupsDisksDiskName
		if qRaidGroupsDisksDiskName != "" {

			if err := r.SetQueryParam("raid_groups.disks.disk.name", qRaidGroupsDisksDiskName); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDisksPosition != nil {

		// query param raid_groups.disks.position
		var qrRaidGroupsDisksPosition string

		if o.RaidGroupsDisksPosition != nil {
			qrRaidGroupsDisksPosition = *o.RaidGroupsDisksPosition
		}
		qRaidGroupsDisksPosition := qrRaidGroupsDisksPosition
		if qRaidGroupsDisksPosition != "" {

			if err := r.SetQueryParam("raid_groups.disks.position", qRaidGroupsDisksPosition); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDisksState != nil {

		// query param raid_groups.disks.state
		var qrRaidGroupsDisksState string

		if o.RaidGroupsDisksState != nil {
			qrRaidGroupsDisksState = *o.RaidGroupsDisksState
		}
		qRaidGroupsDisksState := qrRaidGroupsDisksState
		if qRaidGroupsDisksState != "" {

			if err := r.SetQueryParam("raid_groups.disks.state", qRaidGroupsDisksState); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDisksType != nil {

		// query param raid_groups.disks.type
		var qrRaidGroupsDisksType string

		if o.RaidGroupsDisksType != nil {
			qrRaidGroupsDisksType = *o.RaidGroupsDisksType
		}
		qRaidGroupsDisksType := qrRaidGroupsDisksType
		if qRaidGroupsDisksType != "" {

			if err := r.SetQueryParam("raid_groups.disks.type", qRaidGroupsDisksType); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsDisksUsableSize != nil {

		// query param raid_groups.disks.usable_size
		var qrRaidGroupsDisksUsableSize int64

		if o.RaidGroupsDisksUsableSize != nil {
			qrRaidGroupsDisksUsableSize = *o.RaidGroupsDisksUsableSize
		}
		qRaidGroupsDisksUsableSize := swag.FormatInt64(qrRaidGroupsDisksUsableSize)
		if qRaidGroupsDisksUsableSize != "" {

			if err := r.SetQueryParam("raid_groups.disks.usable_size", qRaidGroupsDisksUsableSize); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsName != nil {

		// query param raid_groups.name
		var qrRaidGroupsName string

		if o.RaidGroupsName != nil {
			qrRaidGroupsName = *o.RaidGroupsName
		}
		qRaidGroupsName := qrRaidGroupsName
		if qRaidGroupsName != "" {

			if err := r.SetQueryParam("raid_groups.name", qRaidGroupsName); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsRaidType != nil {

		// query param raid_groups.raid_type
		var qrRaidGroupsRaidType string

		if o.RaidGroupsRaidType != nil {
			qrRaidGroupsRaidType = *o.RaidGroupsRaidType
		}
		qRaidGroupsRaidType := qrRaidGroupsRaidType
		if qRaidGroupsRaidType != "" {

			if err := r.SetQueryParam("raid_groups.raid_type", qRaidGroupsRaidType); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsRecomputingParityActive != nil {

		// query param raid_groups.recomputing_parity.active
		var qrRaidGroupsRecomputingParityActive bool

		if o.RaidGroupsRecomputingParityActive != nil {
			qrRaidGroupsRecomputingParityActive = *o.RaidGroupsRecomputingParityActive
		}
		qRaidGroupsRecomputingParityActive := swag.FormatBool(qrRaidGroupsRecomputingParityActive)
		if qRaidGroupsRecomputingParityActive != "" {

			if err := r.SetQueryParam("raid_groups.recomputing_parity.active", qRaidGroupsRecomputingParityActive); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsRecomputingParityPercent != nil {

		// query param raid_groups.recomputing_parity.percent
		var qrRaidGroupsRecomputingParityPercent int64

		if o.RaidGroupsRecomputingParityPercent != nil {
			qrRaidGroupsRecomputingParityPercent = *o.RaidGroupsRecomputingParityPercent
		}
		qRaidGroupsRecomputingParityPercent := swag.FormatInt64(qrRaidGroupsRecomputingParityPercent)
		if qRaidGroupsRecomputingParityPercent != "" {

			if err := r.SetQueryParam("raid_groups.recomputing_parity.percent", qRaidGroupsRecomputingParityPercent); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsReconstructActive != nil {

		// query param raid_groups.reconstruct.active
		var qrRaidGroupsReconstructActive bool

		if o.RaidGroupsReconstructActive != nil {
			qrRaidGroupsReconstructActive = *o.RaidGroupsReconstructActive
		}
		qRaidGroupsReconstructActive := swag.FormatBool(qrRaidGroupsReconstructActive)
		if qRaidGroupsReconstructActive != "" {

			if err := r.SetQueryParam("raid_groups.reconstruct.active", qRaidGroupsReconstructActive); err != nil {
				return err
			}
		}
	}

	if o.RaidGroupsReconstructPercent != nil {

		// query param raid_groups.reconstruct.percent
		var qrRaidGroupsReconstructPercent int64

		if o.RaidGroupsReconstructPercent != nil {
			qrRaidGroupsReconstructPercent = *o.RaidGroupsReconstructPercent
		}
		qRaidGroupsReconstructPercent := swag.FormatInt64(qrRaidGroupsReconstructPercent)
		if qRaidGroupsReconstructPercent != "" {

			if err := r.SetQueryParam("raid_groups.reconstruct.percent", qRaidGroupsReconstructPercent); err != nil {
				return err
			}
		}
	}

	if o.ResyncActive != nil {

		// query param resync.active
		var qrResyncActive bool

		if o.ResyncActive != nil {
			qrResyncActive = *o.ResyncActive
		}
		qResyncActive := swag.FormatBool(qrResyncActive)
		if qResyncActive != "" {

			if err := r.SetQueryParam("resync.active", qResyncActive); err != nil {
				return err
			}
		}
	}

	if o.ResyncLevel != nil {

		// query param resync.level
		var qrResyncLevel string

		if o.ResyncLevel != nil {
			qrResyncLevel = *o.ResyncLevel
		}
		qResyncLevel := qrResyncLevel
		if qResyncLevel != "" {

			if err := r.SetQueryParam("resync.level", qResyncLevel); err != nil {
				return err
			}
		}
	}

	if o.ResyncPercent != nil {

		// query param resync.percent
		var qrResyncPercent int64

		if o.ResyncPercent != nil {
			qrResyncPercent = *o.ResyncPercent
		}
		qResyncPercent := swag.FormatInt64(qrResyncPercent)
		if qResyncPercent != "" {

			if err := r.SetQueryParam("resync.percent", qResyncPercent); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPlexCollectionGet binds the parameter fields
func (o *PlexCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPlexCollectionGet binds the parameter order_by
func (o *PlexCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
