// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPlexGetParams creates a new PlexGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPlexGetParams() *PlexGetParams {
	return &PlexGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPlexGetParamsWithTimeout creates a new PlexGetParams object
// with the ability to set a timeout on a request.
func NewPlexGetParamsWithTimeout(timeout time.Duration) *PlexGetParams {
	return &PlexGetParams{
		timeout: timeout,
	}
}

// NewPlexGetParamsWithContext creates a new PlexGetParams object
// with the ability to set a context for a request.
func NewPlexGetParamsWithContext(ctx context.Context) *PlexGetParams {
	return &PlexGetParams{
		Context: ctx,
	}
}

// NewPlexGetParamsWithHTTPClient creates a new PlexGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPlexGetParamsWithHTTPClient(client *http.Client) *PlexGetParams {
	return &PlexGetParams{
		HTTPClient: client,
	}
}

/*
PlexGetParams contains all the parameters to send to the API endpoint

	for the plex get operation.

	Typically these are written to a http.Request.
*/
type PlexGetParams struct {

	/* AggregateUUID.

	   Aggregate UUID
	*/
	AggregateUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   Plex name
	*/
	Name string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the plex get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlexGetParams) WithDefaults() *PlexGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the plex get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PlexGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the plex get params
func (o *PlexGetParams) WithTimeout(timeout time.Duration) *PlexGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the plex get params
func (o *PlexGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the plex get params
func (o *PlexGetParams) WithContext(ctx context.Context) *PlexGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the plex get params
func (o *PlexGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the plex get params
func (o *PlexGetParams) WithHTTPClient(client *http.Client) *PlexGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the plex get params
func (o *PlexGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAggregateUUID adds the aggregateUUID to the plex get params
func (o *PlexGetParams) WithAggregateUUID(aggregateUUID string) *PlexGetParams {
	o.SetAggregateUUID(aggregateUUID)
	return o
}

// SetAggregateUUID adds the aggregateUuid to the plex get params
func (o *PlexGetParams) SetAggregateUUID(aggregateUUID string) {
	o.AggregateUUID = aggregateUUID
}

// WithFields adds the fields to the plex get params
func (o *PlexGetParams) WithFields(fields []string) *PlexGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the plex get params
func (o *PlexGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the plex get params
func (o *PlexGetParams) WithName(name string) *PlexGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the plex get params
func (o *PlexGetParams) SetName(name string) {
	o.Name = name
}

// WriteToRequest writes these params to a swagger request
func (o *PlexGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param aggregate.uuid
	if err := r.SetPathParam("aggregate.uuid", o.AggregateUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPlexGet binds the parameter fields
func (o *PlexGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
