// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPortGetParams creates a new PortGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPortGetParams() *PortGetParams {
	return &PortGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPortGetParamsWithTimeout creates a new PortGetParams object
// with the ability to set a timeout on a request.
func NewPortGetParamsWithTimeout(timeout time.Duration) *PortGetParams {
	return &PortGetParams{
		timeout: timeout,
	}
}

// NewPortGetParamsWithContext creates a new PortGetParams object
// with the ability to set a context for a request.
func NewPortGetParamsWithContext(ctx context.Context) *PortGetParams {
	return &PortGetParams{
		Context: ctx,
	}
}

// NewPortGetParamsWithHTTPClient creates a new PortGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPortGetParamsWithHTTPClient(client *http.Client) *PortGetParams {
	return &PortGetParams{
		HTTPClient: client,
	}
}

/*
PortGetParams contains all the parameters to send to the API endpoint

	for the port get operation.

	Typically these are written to a http.Request.
*/
type PortGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Name.

	   Port name
	*/
	Name string

	/* NodeUUID.

	   Node UUID
	*/
	NodeUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the port get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortGetParams) WithDefaults() *PortGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the port get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the port get params
func (o *PortGetParams) WithTimeout(timeout time.Duration) *PortGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the port get params
func (o *PortGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the port get params
func (o *PortGetParams) WithContext(ctx context.Context) *PortGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the port get params
func (o *PortGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the port get params
func (o *PortGetParams) WithHTTPClient(client *http.Client) *PortGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the port get params
func (o *PortGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the port get params
func (o *PortGetParams) WithFields(fields []string) *PortGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the port get params
func (o *PortGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithName adds the name to the port get params
func (o *PortGetParams) WithName(name string) *PortGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the port get params
func (o *PortGetParams) SetName(name string) {
	o.Name = name
}

// WithNodeUUID adds the nodeUUID to the port get params
func (o *PortGetParams) WithNodeUUID(nodeUUID string) *PortGetParams {
	o.SetNodeUUID(nodeUUID)
	return o
}

// SetNodeUUID adds the nodeUuid to the port get params
func (o *PortGetParams) SetNodeUUID(nodeUUID string) {
	o.NodeUUID = nodeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *PortGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param node.uuid
	if err := r.SetPathParam("node.uuid", o.NodeUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPortGet binds the parameter fields
func (o *PortGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
