// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQosOptionGetParams creates a new QosOptionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQosOptionGetParams() *QosOptionGetParams {
	return &QosOptionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQosOptionGetParamsWithTimeout creates a new QosOptionGetParams object
// with the ability to set a timeout on a request.
func NewQosOptionGetParamsWithTimeout(timeout time.Duration) *QosOptionGetParams {
	return &QosOptionGetParams{
		timeout: timeout,
	}
}

// NewQosOptionGetParamsWithContext creates a new QosOptionGetParams object
// with the ability to set a context for a request.
func NewQosOptionGetParamsWithContext(ctx context.Context) *QosOptionGetParams {
	return &QosOptionGetParams{
		Context: ctx,
	}
}

// NewQosOptionGetParamsWithHTTPClient creates a new QosOptionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQosOptionGetParamsWithHTTPClient(client *http.Client) *QosOptionGetParams {
	return &QosOptionGetParams{
		HTTPClient: client,
	}
}

/*
QosOptionGetParams contains all the parameters to send to the API endpoint

	for the qos option get operation.

	Typically these are written to a http.Request.
*/
type QosOptionGetParams struct {

	/* BackgroundTaskReserve.

	   Filter by background_task_reserve
	*/
	BackgroundTaskReserve *int64

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qos option get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosOptionGetParams) WithDefaults() *QosOptionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qos option get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosOptionGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the qos option get params
func (o *QosOptionGetParams) WithTimeout(timeout time.Duration) *QosOptionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qos option get params
func (o *QosOptionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qos option get params
func (o *QosOptionGetParams) WithContext(ctx context.Context) *QosOptionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qos option get params
func (o *QosOptionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qos option get params
func (o *QosOptionGetParams) WithHTTPClient(client *http.Client) *QosOptionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qos option get params
func (o *QosOptionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBackgroundTaskReserve adds the backgroundTaskReserve to the qos option get params
func (o *QosOptionGetParams) WithBackgroundTaskReserve(backgroundTaskReserve *int64) *QosOptionGetParams {
	o.SetBackgroundTaskReserve(backgroundTaskReserve)
	return o
}

// SetBackgroundTaskReserve adds the backgroundTaskReserve to the qos option get params
func (o *QosOptionGetParams) SetBackgroundTaskReserve(backgroundTaskReserve *int64) {
	o.BackgroundTaskReserve = backgroundTaskReserve
}

// WithFields adds the fields to the qos option get params
func (o *QosOptionGetParams) WithFields(fields []string) *QosOptionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qos option get params
func (o *QosOptionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WriteToRequest writes these params to a swagger request
func (o *QosOptionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BackgroundTaskReserve != nil {

		// query param background_task_reserve
		var qrBackgroundTaskReserve int64

		if o.BackgroundTaskReserve != nil {
			qrBackgroundTaskReserve = *o.BackgroundTaskReserve
		}
		qBackgroundTaskReserve := swag.FormatInt64(qrBackgroundTaskReserve)
		if qBackgroundTaskReserve != "" {

			if err := r.SetQueryParam("background_task_reserve", qBackgroundTaskReserve); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQosOptionGet binds the parameter fields
func (o *QosOptionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
