// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosOptionGetReader is a Reader for the QosOptionGet structure.
type QosOptionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosOptionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosOptionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosOptionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosOptionGetOK creates a QosOptionGetOK with default headers values
func NewQosOptionGetOK() *QosOptionGetOK {
	return &QosOptionGetOK{}
}

/*
QosOptionGetOK describes a response with status code 200, with default header values.

OK
*/
type QosOptionGetOK struct {
	Payload *models.QosOption
}

// IsSuccess returns true when this qos option get o k response has a 2xx status code
func (o *QosOptionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos option get o k response has a 3xx status code
func (o *QosOptionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos option get o k response has a 4xx status code
func (o *QosOptionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos option get o k response has a 5xx status code
func (o *QosOptionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos option get o k response a status code equal to that given
func (o *QosOptionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos option get o k response
func (o *QosOptionGetOK) Code() int {
	return 200
}

func (o *QosOptionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/qos-options][%d] qosOptionGetOK %s", 200, payload)
}

func (o *QosOptionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/qos-options][%d] qosOptionGetOK %s", 200, payload)
}

func (o *QosOptionGetOK) GetPayload() *models.QosOption {
	return o.Payload
}

func (o *QosOptionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QosOption)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQosOptionGetDefault creates a QosOptionGetDefault with default headers values
func NewQosOptionGetDefault(code int) *QosOptionGetDefault {
	return &QosOptionGetDefault{
		_statusCode: code,
	}
}

/*
QosOptionGetDefault describes a response with status code -1, with default header values.

Error
*/
type QosOptionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos option get default response has a 2xx status code
func (o *QosOptionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos option get default response has a 3xx status code
func (o *QosOptionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos option get default response has a 4xx status code
func (o *QosOptionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos option get default response has a 5xx status code
func (o *QosOptionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos option get default response a status code equal to that given
func (o *QosOptionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos option get default response
func (o *QosOptionGetDefault) Code() int {
	return o._statusCode
}

func (o *QosOptionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/qos-options][%d] qos_option_get default %s", o._statusCode, payload)
}

func (o *QosOptionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/qos-options][%d] qos_option_get default %s", o._statusCode, payload)
}

func (o *QosOptionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosOptionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
