// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosOptionModifyReader is a Reader for the QosOptionModify structure.
type QosOptionModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosOptionModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosOptionModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosOptionModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosOptionModifyOK creates a QosOptionModifyOK with default headers values
func NewQosOptionModifyOK() *QosOptionModifyOK {
	return &QosOptionModifyOK{}
}

/*
QosOptionModifyOK describes a response with status code 200, with default header values.

OK
*/
type QosOptionModifyOK struct {
}

// IsSuccess returns true when this qos option modify o k response has a 2xx status code
func (o *QosOptionModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos option modify o k response has a 3xx status code
func (o *QosOptionModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos option modify o k response has a 4xx status code
func (o *QosOptionModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos option modify o k response has a 5xx status code
func (o *QosOptionModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos option modify o k response a status code equal to that given
func (o *QosOptionModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos option modify o k response
func (o *QosOptionModifyOK) Code() int {
	return 200
}

func (o *QosOptionModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /storage/qos/qos-options][%d] qosOptionModifyOK", 200)
}

func (o *QosOptionModifyOK) String() string {
	return fmt.Sprintf("[PATCH /storage/qos/qos-options][%d] qosOptionModifyOK", 200)
}

func (o *QosOptionModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewQosOptionModifyDefault creates a QosOptionModifyDefault with default headers values
func NewQosOptionModifyDefault(code int) *QosOptionModifyDefault {
	return &QosOptionModifyDefault{
		_statusCode: code,
	}
}

/*
	QosOptionModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8454377 | This command is not supported on this platform. |
| 8454378 | Unsupported value specified for background-task-reserve. Supported values are 0 to 99. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QosOptionModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos option modify default response has a 2xx status code
func (o *QosOptionModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos option modify default response has a 3xx status code
func (o *QosOptionModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos option modify default response has a 4xx status code
func (o *QosOptionModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos option modify default response has a 5xx status code
func (o *QosOptionModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos option modify default response a status code equal to that given
func (o *QosOptionModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos option modify default response
func (o *QosOptionModifyDefault) Code() int {
	return o._statusCode
}

func (o *QosOptionModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/qos-options][%d] qos_option_modify default %s", o._statusCode, payload)
}

func (o *QosOptionModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/qos-options][%d] qos_option_modify default %s", o._statusCode, payload)
}

func (o *QosOptionModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosOptionModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
