// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQosPolicyCollectionGetParams creates a new QosPolicyCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQosPolicyCollectionGetParams() *QosPolicyCollectionGetParams {
	return &QosPolicyCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQosPolicyCollectionGetParamsWithTimeout creates a new QosPolicyCollectionGetParams object
// with the ability to set a timeout on a request.
func NewQosPolicyCollectionGetParamsWithTimeout(timeout time.Duration) *QosPolicyCollectionGetParams {
	return &QosPolicyCollectionGetParams{
		timeout: timeout,
	}
}

// NewQosPolicyCollectionGetParamsWithContext creates a new QosPolicyCollectionGetParams object
// with the ability to set a context for a request.
func NewQosPolicyCollectionGetParamsWithContext(ctx context.Context) *QosPolicyCollectionGetParams {
	return &QosPolicyCollectionGetParams{
		Context: ctx,
	}
}

// NewQosPolicyCollectionGetParamsWithHTTPClient creates a new QosPolicyCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQosPolicyCollectionGetParamsWithHTTPClient(client *http.Client) *QosPolicyCollectionGetParams {
	return &QosPolicyCollectionGetParams{
		HTTPClient: client,
	}
}

/*
QosPolicyCollectionGetParams contains all the parameters to send to the API endpoint

	for the qos policy collection get operation.

	Typically these are written to a http.Request.
*/
type QosPolicyCollectionGetParams struct {

	/* AdaptiveAbsoluteMinIops.

	   Filter by adaptive.absolute_min_iops
	*/
	AdaptiveAbsoluteMinIops *int64

	/* AdaptiveBlockSize.

	   Filter by adaptive.block_size
	*/
	AdaptiveBlockSize *string

	/* AdaptiveExpectedIops.

	   Filter by adaptive.expected_iops
	*/
	AdaptiveExpectedIops *int64

	/* AdaptiveExpectedIopsAllocation.

	   Filter by adaptive.expected_iops_allocation
	*/
	AdaptiveExpectedIopsAllocation *string

	/* AdaptivePeakIops.

	   Filter by adaptive.peak_iops
	*/
	AdaptivePeakIops *int64

	/* AdaptivePeakIopsAllocation.

	   Filter by adaptive.peak_iops_allocation
	*/
	AdaptivePeakIopsAllocation *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* FixedCapacityShared.

	   Filter by fixed.capacity_shared
	*/
	FixedCapacityShared *bool

	/* FixedMaxThroughput.

	   Filter by fixed.max_throughput
	*/
	FixedMaxThroughput *string

	/* FixedMaxThroughputIops.

	   Filter by fixed.max_throughput_iops
	*/
	FixedMaxThroughputIops *int64

	/* FixedMaxThroughputMbps.

	   Filter by fixed.max_throughput_mbps
	*/
	FixedMaxThroughputMbps *int64

	/* FixedMinThroughput.

	   Filter by fixed.min_throughput
	*/
	FixedMinThroughput *string

	/* FixedMinThroughputIops.

	   Filter by fixed.min_throughput_iops
	*/
	FixedMinThroughputIops *int64

	/* FixedMinThroughputMbps.

	   Filter by fixed.min_throughput_mbps
	*/
	FixedMinThroughputMbps *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ObjectCount.

	   Filter by object_count
	*/
	ObjectCount *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Pgid.

	   Filter by pgid
	*/
	Pgid *int64

	/* PolicyClass.

	   Filter by policy_class
	*/
	PolicyClass *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qos policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosPolicyCollectionGetParams) WithDefaults() *QosPolicyCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qos policy collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosPolicyCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := QosPolicyCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithTimeout(timeout time.Duration) *QosPolicyCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithContext(ctx context.Context) *QosPolicyCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithHTTPClient(client *http.Client) *QosPolicyCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAdaptiveAbsoluteMinIops adds the adaptiveAbsoluteMinIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptiveAbsoluteMinIops(adaptiveAbsoluteMinIops *int64) *QosPolicyCollectionGetParams {
	o.SetAdaptiveAbsoluteMinIops(adaptiveAbsoluteMinIops)
	return o
}

// SetAdaptiveAbsoluteMinIops adds the adaptiveAbsoluteMinIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptiveAbsoluteMinIops(adaptiveAbsoluteMinIops *int64) {
	o.AdaptiveAbsoluteMinIops = adaptiveAbsoluteMinIops
}

// WithAdaptiveBlockSize adds the adaptiveBlockSize to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptiveBlockSize(adaptiveBlockSize *string) *QosPolicyCollectionGetParams {
	o.SetAdaptiveBlockSize(adaptiveBlockSize)
	return o
}

// SetAdaptiveBlockSize adds the adaptiveBlockSize to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptiveBlockSize(adaptiveBlockSize *string) {
	o.AdaptiveBlockSize = adaptiveBlockSize
}

// WithAdaptiveExpectedIops adds the adaptiveExpectedIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptiveExpectedIops(adaptiveExpectedIops *int64) *QosPolicyCollectionGetParams {
	o.SetAdaptiveExpectedIops(adaptiveExpectedIops)
	return o
}

// SetAdaptiveExpectedIops adds the adaptiveExpectedIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptiveExpectedIops(adaptiveExpectedIops *int64) {
	o.AdaptiveExpectedIops = adaptiveExpectedIops
}

// WithAdaptiveExpectedIopsAllocation adds the adaptiveExpectedIopsAllocation to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptiveExpectedIopsAllocation(adaptiveExpectedIopsAllocation *string) *QosPolicyCollectionGetParams {
	o.SetAdaptiveExpectedIopsAllocation(adaptiveExpectedIopsAllocation)
	return o
}

// SetAdaptiveExpectedIopsAllocation adds the adaptiveExpectedIopsAllocation to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptiveExpectedIopsAllocation(adaptiveExpectedIopsAllocation *string) {
	o.AdaptiveExpectedIopsAllocation = adaptiveExpectedIopsAllocation
}

// WithAdaptivePeakIops adds the adaptivePeakIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptivePeakIops(adaptivePeakIops *int64) *QosPolicyCollectionGetParams {
	o.SetAdaptivePeakIops(adaptivePeakIops)
	return o
}

// SetAdaptivePeakIops adds the adaptivePeakIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptivePeakIops(adaptivePeakIops *int64) {
	o.AdaptivePeakIops = adaptivePeakIops
}

// WithAdaptivePeakIopsAllocation adds the adaptivePeakIopsAllocation to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithAdaptivePeakIopsAllocation(adaptivePeakIopsAllocation *string) *QosPolicyCollectionGetParams {
	o.SetAdaptivePeakIopsAllocation(adaptivePeakIopsAllocation)
	return o
}

// SetAdaptivePeakIopsAllocation adds the adaptivePeakIopsAllocation to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetAdaptivePeakIopsAllocation(adaptivePeakIopsAllocation *string) {
	o.AdaptivePeakIopsAllocation = adaptivePeakIopsAllocation
}

// WithFields adds the fields to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFields(fields []string) *QosPolicyCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFixedCapacityShared adds the fixedCapacityShared to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedCapacityShared(fixedCapacityShared *bool) *QosPolicyCollectionGetParams {
	o.SetFixedCapacityShared(fixedCapacityShared)
	return o
}

// SetFixedCapacityShared adds the fixedCapacityShared to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedCapacityShared(fixedCapacityShared *bool) {
	o.FixedCapacityShared = fixedCapacityShared
}

// WithFixedMaxThroughput adds the fixedMaxThroughput to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMaxThroughput(fixedMaxThroughput *string) *QosPolicyCollectionGetParams {
	o.SetFixedMaxThroughput(fixedMaxThroughput)
	return o
}

// SetFixedMaxThroughput adds the fixedMaxThroughput to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMaxThroughput(fixedMaxThroughput *string) {
	o.FixedMaxThroughput = fixedMaxThroughput
}

// WithFixedMaxThroughputIops adds the fixedMaxThroughputIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMaxThroughputIops(fixedMaxThroughputIops *int64) *QosPolicyCollectionGetParams {
	o.SetFixedMaxThroughputIops(fixedMaxThroughputIops)
	return o
}

// SetFixedMaxThroughputIops adds the fixedMaxThroughputIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMaxThroughputIops(fixedMaxThroughputIops *int64) {
	o.FixedMaxThroughputIops = fixedMaxThroughputIops
}

// WithFixedMaxThroughputMbps adds the fixedMaxThroughputMbps to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMaxThroughputMbps(fixedMaxThroughputMbps *int64) *QosPolicyCollectionGetParams {
	o.SetFixedMaxThroughputMbps(fixedMaxThroughputMbps)
	return o
}

// SetFixedMaxThroughputMbps adds the fixedMaxThroughputMbps to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMaxThroughputMbps(fixedMaxThroughputMbps *int64) {
	o.FixedMaxThroughputMbps = fixedMaxThroughputMbps
}

// WithFixedMinThroughput adds the fixedMinThroughput to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMinThroughput(fixedMinThroughput *string) *QosPolicyCollectionGetParams {
	o.SetFixedMinThroughput(fixedMinThroughput)
	return o
}

// SetFixedMinThroughput adds the fixedMinThroughput to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMinThroughput(fixedMinThroughput *string) {
	o.FixedMinThroughput = fixedMinThroughput
}

// WithFixedMinThroughputIops adds the fixedMinThroughputIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMinThroughputIops(fixedMinThroughputIops *int64) *QosPolicyCollectionGetParams {
	o.SetFixedMinThroughputIops(fixedMinThroughputIops)
	return o
}

// SetFixedMinThroughputIops adds the fixedMinThroughputIops to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMinThroughputIops(fixedMinThroughputIops *int64) {
	o.FixedMinThroughputIops = fixedMinThroughputIops
}

// WithFixedMinThroughputMbps adds the fixedMinThroughputMbps to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithFixedMinThroughputMbps(fixedMinThroughputMbps *int64) *QosPolicyCollectionGetParams {
	o.SetFixedMinThroughputMbps(fixedMinThroughputMbps)
	return o
}

// SetFixedMinThroughputMbps adds the fixedMinThroughputMbps to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetFixedMinThroughputMbps(fixedMinThroughputMbps *int64) {
	o.FixedMinThroughputMbps = fixedMinThroughputMbps
}

// WithMaxRecords adds the maxRecords to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithMaxRecords(maxRecords *int64) *QosPolicyCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithName(name *string) *QosPolicyCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithObjectCount adds the objectCount to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithObjectCount(objectCount *int64) *QosPolicyCollectionGetParams {
	o.SetObjectCount(objectCount)
	return o
}

// SetObjectCount adds the objectCount to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetObjectCount(objectCount *int64) {
	o.ObjectCount = objectCount
}

// WithOrderBy adds the orderBy to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithOrderBy(orderBy []string) *QosPolicyCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPgid adds the pgid to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithPgid(pgid *int64) *QosPolicyCollectionGetParams {
	o.SetPgid(pgid)
	return o
}

// SetPgid adds the pgid to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetPgid(pgid *int64) {
	o.Pgid = pgid
}

// WithPolicyClass adds the policyClass to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithPolicyClass(policyClass *string) *QosPolicyCollectionGetParams {
	o.SetPolicyClass(policyClass)
	return o
}

// SetPolicyClass adds the policyClass to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetPolicyClass(policyClass *string) {
	o.PolicyClass = policyClass
}

// WithReturnRecords adds the returnRecords to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithReturnRecords(returnRecords *bool) *QosPolicyCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *QosPolicyCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithScope(scope *string) *QosPolicyCollectionGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithSvmName(svmName *string) *QosPolicyCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithSvmUUID(svmUUID *string) *QosPolicyCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) WithUUID(uuid *string) *QosPolicyCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the qos policy collection get params
func (o *QosPolicyCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *QosPolicyCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AdaptiveAbsoluteMinIops != nil {

		// query param adaptive.absolute_min_iops
		var qrAdaptiveAbsoluteMinIops int64

		if o.AdaptiveAbsoluteMinIops != nil {
			qrAdaptiveAbsoluteMinIops = *o.AdaptiveAbsoluteMinIops
		}
		qAdaptiveAbsoluteMinIops := swag.FormatInt64(qrAdaptiveAbsoluteMinIops)
		if qAdaptiveAbsoluteMinIops != "" {

			if err := r.SetQueryParam("adaptive.absolute_min_iops", qAdaptiveAbsoluteMinIops); err != nil {
				return err
			}
		}
	}

	if o.AdaptiveBlockSize != nil {

		// query param adaptive.block_size
		var qrAdaptiveBlockSize string

		if o.AdaptiveBlockSize != nil {
			qrAdaptiveBlockSize = *o.AdaptiveBlockSize
		}
		qAdaptiveBlockSize := qrAdaptiveBlockSize
		if qAdaptiveBlockSize != "" {

			if err := r.SetQueryParam("adaptive.block_size", qAdaptiveBlockSize); err != nil {
				return err
			}
		}
	}

	if o.AdaptiveExpectedIops != nil {

		// query param adaptive.expected_iops
		var qrAdaptiveExpectedIops int64

		if o.AdaptiveExpectedIops != nil {
			qrAdaptiveExpectedIops = *o.AdaptiveExpectedIops
		}
		qAdaptiveExpectedIops := swag.FormatInt64(qrAdaptiveExpectedIops)
		if qAdaptiveExpectedIops != "" {

			if err := r.SetQueryParam("adaptive.expected_iops", qAdaptiveExpectedIops); err != nil {
				return err
			}
		}
	}

	if o.AdaptiveExpectedIopsAllocation != nil {

		// query param adaptive.expected_iops_allocation
		var qrAdaptiveExpectedIopsAllocation string

		if o.AdaptiveExpectedIopsAllocation != nil {
			qrAdaptiveExpectedIopsAllocation = *o.AdaptiveExpectedIopsAllocation
		}
		qAdaptiveExpectedIopsAllocation := qrAdaptiveExpectedIopsAllocation
		if qAdaptiveExpectedIopsAllocation != "" {

			if err := r.SetQueryParam("adaptive.expected_iops_allocation", qAdaptiveExpectedIopsAllocation); err != nil {
				return err
			}
		}
	}

	if o.AdaptivePeakIops != nil {

		// query param adaptive.peak_iops
		var qrAdaptivePeakIops int64

		if o.AdaptivePeakIops != nil {
			qrAdaptivePeakIops = *o.AdaptivePeakIops
		}
		qAdaptivePeakIops := swag.FormatInt64(qrAdaptivePeakIops)
		if qAdaptivePeakIops != "" {

			if err := r.SetQueryParam("adaptive.peak_iops", qAdaptivePeakIops); err != nil {
				return err
			}
		}
	}

	if o.AdaptivePeakIopsAllocation != nil {

		// query param adaptive.peak_iops_allocation
		var qrAdaptivePeakIopsAllocation string

		if o.AdaptivePeakIopsAllocation != nil {
			qrAdaptivePeakIopsAllocation = *o.AdaptivePeakIopsAllocation
		}
		qAdaptivePeakIopsAllocation := qrAdaptivePeakIopsAllocation
		if qAdaptivePeakIopsAllocation != "" {

			if err := r.SetQueryParam("adaptive.peak_iops_allocation", qAdaptivePeakIopsAllocation); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.FixedCapacityShared != nil {

		// query param fixed.capacity_shared
		var qrFixedCapacityShared bool

		if o.FixedCapacityShared != nil {
			qrFixedCapacityShared = *o.FixedCapacityShared
		}
		qFixedCapacityShared := swag.FormatBool(qrFixedCapacityShared)
		if qFixedCapacityShared != "" {

			if err := r.SetQueryParam("fixed.capacity_shared", qFixedCapacityShared); err != nil {
				return err
			}
		}
	}

	if o.FixedMaxThroughput != nil {

		// query param fixed.max_throughput
		var qrFixedMaxThroughput string

		if o.FixedMaxThroughput != nil {
			qrFixedMaxThroughput = *o.FixedMaxThroughput
		}
		qFixedMaxThroughput := qrFixedMaxThroughput
		if qFixedMaxThroughput != "" {

			if err := r.SetQueryParam("fixed.max_throughput", qFixedMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.FixedMaxThroughputIops != nil {

		// query param fixed.max_throughput_iops
		var qrFixedMaxThroughputIops int64

		if o.FixedMaxThroughputIops != nil {
			qrFixedMaxThroughputIops = *o.FixedMaxThroughputIops
		}
		qFixedMaxThroughputIops := swag.FormatInt64(qrFixedMaxThroughputIops)
		if qFixedMaxThroughputIops != "" {

			if err := r.SetQueryParam("fixed.max_throughput_iops", qFixedMaxThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.FixedMaxThroughputMbps != nil {

		// query param fixed.max_throughput_mbps
		var qrFixedMaxThroughputMbps int64

		if o.FixedMaxThroughputMbps != nil {
			qrFixedMaxThroughputMbps = *o.FixedMaxThroughputMbps
		}
		qFixedMaxThroughputMbps := swag.FormatInt64(qrFixedMaxThroughputMbps)
		if qFixedMaxThroughputMbps != "" {

			if err := r.SetQueryParam("fixed.max_throughput_mbps", qFixedMaxThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.FixedMinThroughput != nil {

		// query param fixed.min_throughput
		var qrFixedMinThroughput string

		if o.FixedMinThroughput != nil {
			qrFixedMinThroughput = *o.FixedMinThroughput
		}
		qFixedMinThroughput := qrFixedMinThroughput
		if qFixedMinThroughput != "" {

			if err := r.SetQueryParam("fixed.min_throughput", qFixedMinThroughput); err != nil {
				return err
			}
		}
	}

	if o.FixedMinThroughputIops != nil {

		// query param fixed.min_throughput_iops
		var qrFixedMinThroughputIops int64

		if o.FixedMinThroughputIops != nil {
			qrFixedMinThroughputIops = *o.FixedMinThroughputIops
		}
		qFixedMinThroughputIops := swag.FormatInt64(qrFixedMinThroughputIops)
		if qFixedMinThroughputIops != "" {

			if err := r.SetQueryParam("fixed.min_throughput_iops", qFixedMinThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.FixedMinThroughputMbps != nil {

		// query param fixed.min_throughput_mbps
		var qrFixedMinThroughputMbps int64

		if o.FixedMinThroughputMbps != nil {
			qrFixedMinThroughputMbps = *o.FixedMinThroughputMbps
		}
		qFixedMinThroughputMbps := swag.FormatInt64(qrFixedMinThroughputMbps)
		if qFixedMinThroughputMbps != "" {

			if err := r.SetQueryParam("fixed.min_throughput_mbps", qFixedMinThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ObjectCount != nil {

		// query param object_count
		var qrObjectCount int64

		if o.ObjectCount != nil {
			qrObjectCount = *o.ObjectCount
		}
		qObjectCount := swag.FormatInt64(qrObjectCount)
		if qObjectCount != "" {

			if err := r.SetQueryParam("object_count", qObjectCount); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Pgid != nil {

		// query param pgid
		var qrPgid int64

		if o.Pgid != nil {
			qrPgid = *o.Pgid
		}
		qPgid := swag.FormatInt64(qrPgid)
		if qPgid != "" {

			if err := r.SetQueryParam("pgid", qPgid); err != nil {
				return err
			}
		}
	}

	if o.PolicyClass != nil {

		// query param policy_class
		var qrPolicyClass string

		if o.PolicyClass != nil {
			qrPolicyClass = *o.PolicyClass
		}
		qPolicyClass := qrPolicyClass
		if qPolicyClass != "" {

			if err := r.SetQueryParam("policy_class", qPolicyClass); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQosPolicyCollectionGet binds the parameter fields
func (o *QosPolicyCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamQosPolicyCollectionGet binds the parameter order_by
func (o *QosPolicyCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
