// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosPolicyDeleteReader is a Reader for the QosPolicyDelete structure.
type QosPolicyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosPolicyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosPolicyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosPolicyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosPolicyDeleteOK creates a QosPolicyDeleteOK with default headers values
func NewQosPolicyDeleteOK() *QosPolicyDeleteOK {
	return &QosPolicyDeleteOK{}
}

/*
QosPolicyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type QosPolicyDeleteOK struct {
}

// IsSuccess returns true when this qos policy delete o k response has a 2xx status code
func (o *QosPolicyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos policy delete o k response has a 3xx status code
func (o *QosPolicyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos policy delete o k response has a 4xx status code
func (o *QosPolicyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos policy delete o k response has a 5xx status code
func (o *QosPolicyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos policy delete o k response a status code equal to that given
func (o *QosPolicyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos policy delete o k response
func (o *QosPolicyDeleteOK) Code() int {
	return 200
}

func (o *QosPolicyDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /storage/qos/policies/{uuid}][%d] qosPolicyDeleteOK", 200)
}

func (o *QosPolicyDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /storage/qos/policies/{uuid}][%d] qosPolicyDeleteOK", 200)
}

func (o *QosPolicyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewQosPolicyDeleteDefault creates a QosPolicyDeleteDefault with default headers values
func NewQosPolicyDeleteDefault(code int) *QosPolicyDeleteDefault {
	return &QosPolicyDeleteDefault{
		_statusCode: code,
	}
}

/*
	QosPolicyDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8454286 | Modifications to these cluster-scoped preset policies is prohibited. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QosPolicyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos policy delete default response has a 2xx status code
func (o *QosPolicyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos policy delete default response has a 3xx status code
func (o *QosPolicyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos policy delete default response has a 4xx status code
func (o *QosPolicyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos policy delete default response has a 5xx status code
func (o *QosPolicyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos policy delete default response a status code equal to that given
func (o *QosPolicyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos policy delete default response
func (o *QosPolicyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *QosPolicyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qos/policies/{uuid}][%d] qos_policy_delete default %s", o._statusCode, payload)
}

func (o *QosPolicyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /storage/qos/policies/{uuid}][%d] qos_policy_delete default %s", o._statusCode, payload)
}

func (o *QosPolicyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosPolicyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
