// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQosPolicyGetParams creates a new QosPolicyGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQosPolicyGetParams() *QosPolicyGetParams {
	return &QosPolicyGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQosPolicyGetParamsWithTimeout creates a new QosPolicyGetParams object
// with the ability to set a timeout on a request.
func NewQosPolicyGetParamsWithTimeout(timeout time.Duration) *QosPolicyGetParams {
	return &QosPolicyGetParams{
		timeout: timeout,
	}
}

// NewQosPolicyGetParamsWithContext creates a new QosPolicyGetParams object
// with the ability to set a context for a request.
func NewQosPolicyGetParamsWithContext(ctx context.Context) *QosPolicyGetParams {
	return &QosPolicyGetParams{
		Context: ctx,
	}
}

// NewQosPolicyGetParamsWithHTTPClient creates a new QosPolicyGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQosPolicyGetParamsWithHTTPClient(client *http.Client) *QosPolicyGetParams {
	return &QosPolicyGetParams{
		HTTPClient: client,
	}
}

/*
QosPolicyGetParams contains all the parameters to send to the API endpoint

	for the qos policy get operation.

	Typically these are written to a http.Request.
*/
type QosPolicyGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	// UUID.
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qos policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosPolicyGetParams) WithDefaults() *QosPolicyGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qos policy get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosPolicyGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the qos policy get params
func (o *QosPolicyGetParams) WithTimeout(timeout time.Duration) *QosPolicyGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qos policy get params
func (o *QosPolicyGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qos policy get params
func (o *QosPolicyGetParams) WithContext(ctx context.Context) *QosPolicyGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qos policy get params
func (o *QosPolicyGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qos policy get params
func (o *QosPolicyGetParams) WithHTTPClient(client *http.Client) *QosPolicyGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qos policy get params
func (o *QosPolicyGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the qos policy get params
func (o *QosPolicyGetParams) WithFields(fields []string) *QosPolicyGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qos policy get params
func (o *QosPolicyGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the qos policy get params
func (o *QosPolicyGetParams) WithUUID(uuid string) *QosPolicyGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the qos policy get params
func (o *QosPolicyGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *QosPolicyGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQosPolicyGet binds the parameter fields
func (o *QosPolicyGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
