// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosPolicyGetReader is a Reader for the QosPolicyGet structure.
type QosPolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosPolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosPolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosPolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosPolicyGetOK creates a QosPolicyGetOK with default headers values
func NewQosPolicyGetOK() *QosPolicyGetOK {
	return &QosPolicyGetOK{}
}

/*
QosPolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type QosPolicyGetOK struct {
	Payload *models.QosPolicy
}

// IsSuccess returns true when this qos policy get o k response has a 2xx status code
func (o *QosPolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos policy get o k response has a 3xx status code
func (o *QosPolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos policy get o k response has a 4xx status code
func (o *QosPolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos policy get o k response has a 5xx status code
func (o *QosPolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos policy get o k response a status code equal to that given
func (o *QosPolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos policy get o k response
func (o *QosPolicyGetOK) Code() int {
	return 200
}

func (o *QosPolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/policies/{uuid}][%d] qosPolicyGetOK %s", 200, payload)
}

func (o *QosPolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/policies/{uuid}][%d] qosPolicyGetOK %s", 200, payload)
}

func (o *QosPolicyGetOK) GetPayload() *models.QosPolicy {
	return o.Payload
}

func (o *QosPolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QosPolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQosPolicyGetDefault creates a QosPolicyGetDefault with default headers values
func NewQosPolicyGetDefault(code int) *QosPolicyGetDefault {
	return &QosPolicyGetDefault{
		_statusCode: code,
	}
}

/*
QosPolicyGetDefault describes a response with status code -1, with default header values.

Error
*/
type QosPolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos policy get default response has a 2xx status code
func (o *QosPolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos policy get default response has a 3xx status code
func (o *QosPolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos policy get default response has a 4xx status code
func (o *QosPolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos policy get default response has a 5xx status code
func (o *QosPolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos policy get default response a status code equal to that given
func (o *QosPolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos policy get default response
func (o *QosPolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *QosPolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/policies/{uuid}][%d] qos_policy_get default %s", o._statusCode, payload)
}

func (o *QosPolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/policies/{uuid}][%d] qos_policy_get default %s", o._statusCode, payload)
}

func (o *QosPolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosPolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
