// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosPolicyModifyCollectionReader is a Reader for the QosPolicyModifyCollection structure.
type QosPolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosPolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosPolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewQosPolicyModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosPolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosPolicyModifyCollectionOK creates a QosPolicyModifyCollectionOK with default headers values
func NewQosPolicyModifyCollectionOK() *QosPolicyModifyCollectionOK {
	return &QosPolicyModifyCollectionOK{}
}

/*
QosPolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type QosPolicyModifyCollectionOK struct {
	Payload *models.QosPolicyJobLinkResponse
}

// IsSuccess returns true when this qos policy modify collection o k response has a 2xx status code
func (o *QosPolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos policy modify collection o k response has a 3xx status code
func (o *QosPolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos policy modify collection o k response has a 4xx status code
func (o *QosPolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos policy modify collection o k response has a 5xx status code
func (o *QosPolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos policy modify collection o k response a status code equal to that given
func (o *QosPolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos policy modify collection o k response
func (o *QosPolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *QosPolicyModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qosPolicyModifyCollectionOK %s", 200, payload)
}

func (o *QosPolicyModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qosPolicyModifyCollectionOK %s", 200, payload)
}

func (o *QosPolicyModifyCollectionOK) GetPayload() *models.QosPolicyJobLinkResponse {
	return o.Payload
}

func (o *QosPolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QosPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQosPolicyModifyCollectionAccepted creates a QosPolicyModifyCollectionAccepted with default headers values
func NewQosPolicyModifyCollectionAccepted() *QosPolicyModifyCollectionAccepted {
	return &QosPolicyModifyCollectionAccepted{}
}

/*
QosPolicyModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type QosPolicyModifyCollectionAccepted struct {
	Payload *models.QosPolicyJobLinkResponse
}

// IsSuccess returns true when this qos policy modify collection accepted response has a 2xx status code
func (o *QosPolicyModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos policy modify collection accepted response has a 3xx status code
func (o *QosPolicyModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos policy modify collection accepted response has a 4xx status code
func (o *QosPolicyModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos policy modify collection accepted response has a 5xx status code
func (o *QosPolicyModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this qos policy modify collection accepted response a status code equal to that given
func (o *QosPolicyModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the qos policy modify collection accepted response
func (o *QosPolicyModifyCollectionAccepted) Code() int {
	return 202
}

func (o *QosPolicyModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qosPolicyModifyCollectionAccepted %s", 202, payload)
}

func (o *QosPolicyModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qosPolicyModifyCollectionAccepted %s", 202, payload)
}

func (o *QosPolicyModifyCollectionAccepted) GetPayload() *models.QosPolicyJobLinkResponse {
	return o.Payload
}

func (o *QosPolicyModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QosPolicyJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQosPolicyModifyCollectionDefault creates a QosPolicyModifyCollectionDefault with default headers values
func NewQosPolicyModifyCollectionDefault(code int) *QosPolicyModifyCollectionDefault {
	return &QosPolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	QosPolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8454147 | The maximum limit for QoS policies has been reached. |
| 8454154 | The name specified for creating conflicts with an existing QoS policy name. |
| 8454194 | The minimum throughput value for the policy group must be less than or equal to the maximum throughput value. |
| 8454260 | Invalid value for maximum and minimum fields. Valid values for max_throughput_iops and max_throughput_mbps combination is for the ratio of max_throughput_mbps and max_throughput_iops to be within 1 to 4096. |
| 8454273 | Invalid value for an adaptive field. Value should be non-zero. |
| 8454277 | The name specified for creating an adaptive QoS policy conflicts with an existing fixed QoS policy name. |
| 8454278 | The name specified for creating a fixed QoS policy conflicts with an existing adaptive QoS policy name. |
| 8454286 | Modifications on these cluster scoped preset policies is prohibited. |
| 8454327 | The existing fixed QoS policy cannot be modified to an adaptive QoS policy. |
| 8454328 | The existing adaptive QoS policy cannot be modified to a fixed QoS policy. |
| 8454379 | The name specified for creating a fixed QoS policy already exists. |
| 8454380 | The name specified for creating an adaptive QoS policy already exists. |
| 8454389 | One specified field cannot be used in combination with at least one other specified field. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type QosPolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos policy modify collection default response has a 2xx status code
func (o *QosPolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos policy modify collection default response has a 3xx status code
func (o *QosPolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos policy modify collection default response has a 4xx status code
func (o *QosPolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos policy modify collection default response has a 5xx status code
func (o *QosPolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos policy modify collection default response a status code equal to that given
func (o *QosPolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos policy modify collection default response
func (o *QosPolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *QosPolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qos_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *QosPolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /storage/qos/policies][%d] qos_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *QosPolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosPolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
QosPolicyModifyCollectionBody qos policy modify collection body
swagger:model QosPolicyModifyCollectionBody
*/
type QosPolicyModifyCollectionBody struct {

	// links
	Links *models.QosPolicyInlineLinks `json:"_links,omitempty"`

	// adaptive
	Adaptive *models.QosPolicyInlineAdaptive `json:"adaptive,omitempty"`

	// error
	Error *models.Error `json:"error,omitempty"`

	// fixed
	Fixed *models.QosPolicyInlineFixed `json:"fixed,omitempty"`

	// Name of the QoS policy.
	// Example: extreme
	Name *string `json:"name,omitempty"`

	// Number of objects attached to this policy.
	// Read Only: true
	ObjectCount *int64 `json:"object_count,omitempty"`

	// Policy group ID of the QoS policy.
	// Read Only: true
	Pgid *int64 `json:"pgid,omitempty"`

	// Class of the QoS policy.
	// Read Only: true
	// Enum: ["undefined","preset","user_defined","system_defined","autovolume","load_control"]
	PolicyClass *string `json:"policy_class,omitempty"`

	// qos policy response inline records
	QosPolicyResponseInlineRecords []*models.QosPolicy `json:"records,omitempty"`

	// Scope of the entity. Set to "cluster" for cluster owned objects and to "svm" for SVM owned objects.
	// Read Only: true
	// Enum: ["cluster","svm"]
	Scope *string `json:"scope,omitempty"`

	// svm
	Svm *models.QosPolicyInlineSvm `json:"svm,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos policy modify collection body
func (o *QosPolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAdaptive(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateFixed(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicyClass(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateScope(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) validateAdaptive(formats strfmt.Registry) error {
	if swag.IsZero(o.Adaptive) { // not required
		return nil
	}

	if o.Adaptive != nil {
		if err := o.Adaptive.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "adaptive")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) validateFixed(formats strfmt.Registry) error {
	if swag.IsZero(o.Fixed) { // not required
		return nil
	}

	if o.Fixed != nil {
		if err := o.Fixed.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fixed")
			}
			return err
		}
	}

	return nil
}

var qosPolicyModifyCollectionBodyTypePolicyClassPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["undefined","preset","user_defined","system_defined","autovolume","load_control"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyModifyCollectionBodyTypePolicyClassPropEnum = append(qosPolicyModifyCollectionBodyTypePolicyClassPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// undefined
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassUndefined captures enum value "undefined"
	QosPolicyModifyCollectionBodyPolicyClassUndefined string = "undefined"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// preset
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassPreset captures enum value "preset"
	QosPolicyModifyCollectionBodyPolicyClassPreset string = "preset"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// user_defined
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassUserDefined captures enum value "user_defined"
	QosPolicyModifyCollectionBodyPolicyClassUserDefined string = "user_defined"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// system_defined
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassSystemDefined captures enum value "system_defined"
	QosPolicyModifyCollectionBodyPolicyClassSystemDefined string = "system_defined"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// autovolume
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassAutovolume captures enum value "autovolume"
	QosPolicyModifyCollectionBodyPolicyClassAutovolume string = "autovolume"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// policy_class
	// PolicyClass
	// load_control
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyPolicyClassLoadControl captures enum value "load_control"
	QosPolicyModifyCollectionBodyPolicyClassLoadControl string = "load_control"
)

// prop value enum
func (o *QosPolicyModifyCollectionBody) validatePolicyClassEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyModifyCollectionBodyTypePolicyClassPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QosPolicyModifyCollectionBody) validatePolicyClass(formats strfmt.Registry) error {
	if swag.IsZero(o.PolicyClass) { // not required
		return nil
	}

	// value enum
	if err := o.validatePolicyClassEnum("info"+"."+"policy_class", "body", *o.PolicyClass); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) validateQosPolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.QosPolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.QosPolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.QosPolicyResponseInlineRecords[i] != nil {
			if err := o.QosPolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

var qosPolicyModifyCollectionBodyTypeScopePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["cluster","svm"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyModifyCollectionBodyTypeScopePropEnum = append(qosPolicyModifyCollectionBodyTypeScopePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// scope
	// Scope
	// cluster
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyScopeCluster captures enum value "cluster"
	QosPolicyModifyCollectionBodyScopeCluster string = "cluster"

	// BEGIN DEBUGGING
	// QosPolicyModifyCollectionBody
	// QosPolicyModifyCollectionBody
	// scope
	// Scope
	// svm
	// END DEBUGGING
	// QosPolicyModifyCollectionBodyScopeSvm captures enum value "svm"
	QosPolicyModifyCollectionBodyScopeSvm string = "svm"
)

// prop value enum
func (o *QosPolicyModifyCollectionBody) validateScopeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyModifyCollectionBodyTypeScopePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QosPolicyModifyCollectionBody) validateScope(formats strfmt.Registry) error {
	if swag.IsZero(o.Scope) { // not required
		return nil
	}

	// value enum
	if err := o.validateScopeEnum("info"+"."+"scope", "body", *o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy modify collection body based on the context it is used
func (o *QosPolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAdaptive(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateFixed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateObjectCount(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePgid(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicyClass(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateScope(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateAdaptive(ctx context.Context, formats strfmt.Registry) error {

	if o.Adaptive != nil {
		if err := o.Adaptive.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "adaptive")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateFixed(ctx context.Context, formats strfmt.Registry) error {

	if o.Fixed != nil {
		if err := o.Fixed.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "fixed")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateObjectCount(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"object_count", "body", o.ObjectCount); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidatePgid(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"pgid", "body", o.Pgid); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidatePolicyClass(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"policy_class", "body", o.PolicyClass); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateQosPolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.QosPolicyResponseInlineRecords); i++ {

		if o.QosPolicyResponseInlineRecords[i] != nil {
			if err := o.QosPolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateScope(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"scope", "body", o.Scope); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *QosPolicyModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res QosPolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QosPolicyInlineLinks qos policy inline links
swagger:model qos_policy_inline__links
*/
type QosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qos policy inline links
func (o *QosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline links based on the context it is used
func (o *QosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QosPolicyInlineAdaptive Adaptive QoS policy-groups define measurable service level objectives (SLOs) that adjust based on the storage object used space and the storage object allocated space.
swagger:model qos_policy_inline_adaptive
*/
type QosPolicyInlineAdaptive struct {

	// Specifies the absolute minimum IOPS that is used as an override when the expected_iops is less than this value. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	AbsoluteMinIops *int64 `json:"absolute_min_iops,omitempty"`

	// Specifies the block size
	// Enum: ["any","4k","8k","16k","32k","64k","128k"]
	BlockSize *string `json:"block_size,omitempty"`

	// Expected IOPS. Specifies the minimum expected IOPS per TB allocated based on the storage object allocated size. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	ExpectedIops *int64 `json:"expected_iops,omitempty"`

	// Specifies the size to be used to calculate expected IOPS per TB. The size options are either the storage object allocated space or the storage object used space.
	// Enum: ["used_space","allocated_space"]
	ExpectedIopsAllocation *string `json:"expected_iops_allocation,omitempty"`

	// Peak IOPS. Specifies the maximum possible IOPS per TB allocated based on the storage object allocated size or the storage object used size.
	PeakIops *int64 `json:"peak_iops,omitempty"`

	// Specifies the size to be used to calculate peak IOPS per TB. The size options are either the storage object allocated space or the storage object used space.
	// Enum: ["used_space","allocated_space"]
	PeakIopsAllocation *string `json:"peak_iops_allocation,omitempty"`
}

// Validate validates this qos policy inline adaptive
func (o *QosPolicyInlineAdaptive) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateBlockSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpectedIopsAllocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePeakIopsAllocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var qosPolicyInlineAdaptiveTypeBlockSizePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["any","4k","8k","16k","32k","64k","128k"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypeBlockSizePropEnum = append(qosPolicyInlineAdaptiveTypeBlockSizePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// any
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeAny captures enum value "any"
	QosPolicyInlineAdaptiveBlockSizeAny string = "any"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 4k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr4k captures enum value "4k"
	QosPolicyInlineAdaptiveBlockSizeNr4k string = "4k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 8k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr8k captures enum value "8k"
	QosPolicyInlineAdaptiveBlockSizeNr8k string = "8k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 16k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr16k captures enum value "16k"
	QosPolicyInlineAdaptiveBlockSizeNr16k string = "16k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 32k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr32k captures enum value "32k"
	QosPolicyInlineAdaptiveBlockSizeNr32k string = "32k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 64k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr64k captures enum value "64k"
	QosPolicyInlineAdaptiveBlockSizeNr64k string = "64k"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// block_size
	// BlockSize
	// 128k
	// END DEBUGGING
	// QosPolicyInlineAdaptiveBlockSizeNr128k captures enum value "128k"
	QosPolicyInlineAdaptiveBlockSizeNr128k string = "128k"
)

// prop value enum
func (o *QosPolicyInlineAdaptive) validateBlockSizeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypeBlockSizePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QosPolicyInlineAdaptive) validateBlockSize(formats strfmt.Registry) error {
	if swag.IsZero(o.BlockSize) { // not required
		return nil
	}

	// value enum
	if err := o.validateBlockSizeEnum("info"+"."+"adaptive"+"."+"block_size", "body", *o.BlockSize); err != nil {
		return err
	}

	return nil
}

var qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["used_space","allocated_space"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum = append(qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// expected_iops_allocation
	// ExpectedIopsAllocation
	// used_space
	// END DEBUGGING
	// QosPolicyInlineAdaptiveExpectedIopsAllocationUsedSpace captures enum value "used_space"
	QosPolicyInlineAdaptiveExpectedIopsAllocationUsedSpace string = "used_space"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// expected_iops_allocation
	// ExpectedIopsAllocation
	// allocated_space
	// END DEBUGGING
	// QosPolicyInlineAdaptiveExpectedIopsAllocationAllocatedSpace captures enum value "allocated_space"
	QosPolicyInlineAdaptiveExpectedIopsAllocationAllocatedSpace string = "allocated_space"
)

// prop value enum
func (o *QosPolicyInlineAdaptive) validateExpectedIopsAllocationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypeExpectedIopsAllocationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QosPolicyInlineAdaptive) validateExpectedIopsAllocation(formats strfmt.Registry) error {
	if swag.IsZero(o.ExpectedIopsAllocation) { // not required
		return nil
	}

	// value enum
	if err := o.validateExpectedIopsAllocationEnum("info"+"."+"adaptive"+"."+"expected_iops_allocation", "body", *o.ExpectedIopsAllocation); err != nil {
		return err
	}

	return nil
}

var qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["used_space","allocated_space"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum = append(qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// peak_iops_allocation
	// PeakIopsAllocation
	// used_space
	// END DEBUGGING
	// QosPolicyInlineAdaptivePeakIopsAllocationUsedSpace captures enum value "used_space"
	QosPolicyInlineAdaptivePeakIopsAllocationUsedSpace string = "used_space"

	// BEGIN DEBUGGING
	// qos_policy_inline_adaptive
	// QosPolicyInlineAdaptive
	// peak_iops_allocation
	// PeakIopsAllocation
	// allocated_space
	// END DEBUGGING
	// QosPolicyInlineAdaptivePeakIopsAllocationAllocatedSpace captures enum value "allocated_space"
	QosPolicyInlineAdaptivePeakIopsAllocationAllocatedSpace string = "allocated_space"
)

// prop value enum
func (o *QosPolicyInlineAdaptive) validatePeakIopsAllocationEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, qosPolicyInlineAdaptiveTypePeakIopsAllocationPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *QosPolicyInlineAdaptive) validatePeakIopsAllocation(formats strfmt.Registry) error {
	if swag.IsZero(o.PeakIopsAllocation) { // not required
		return nil
	}

	// value enum
	if err := o.validatePeakIopsAllocationEnum("info"+"."+"adaptive"+"."+"peak_iops_allocation", "body", *o.PeakIopsAllocation); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this qos policy inline adaptive based on context it is used
func (o *QosPolicyInlineAdaptive) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyInlineAdaptive) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyInlineAdaptive) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineAdaptive
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QosPolicyInlineFixed QoS policy-groups define a fixed service level objective (SLO) for a storage object.
swagger:model qos_policy_inline_fixed
*/
type QosPolicyInlineFixed struct {

	// Specifies whether the capacities are shared across all objects that use this QoS policy-group. Default is false.
	CapacityShared *bool `json:"capacity_shared,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of Kbps, Mbps or Gbps along with or without IOPS. 0 means no maximum throughput is enforced.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of IOPS. 0 means no maximum throughput is enforced.
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Maximum throughput defined by this policy. It is specified in terms of Mbps. 0 means no maximum throughput is enforced.
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of Kbps, Mbps or Gbps along with or without IOPS. 0 means no minimum throughput is enforced.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of IOPS. 0 means no minimum throughput is enforced. These floors are not guaranteed on non-AFF platforms or when FabricPool tiering policies are set.
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Minimum throughput defined by this policy. It is specified in terms of Mbps. 0 means no minimum throughput is enforced.
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`
}

// Validate validates this qos policy inline fixed
func (o *QosPolicyInlineFixed) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineFixed) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"fixed"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"fixed"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyInlineFixed) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"fixed"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"fixed"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyInlineFixed) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"fixed"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"fixed"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *QosPolicyInlineFixed) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"fixed"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"fixed"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this qos policy inline fixed based on context it is used
func (o *QosPolicyInlineFixed) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyInlineFixed) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyInlineFixed) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineFixed
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QosPolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model qos_policy_inline_svm
*/
type QosPolicyInlineSvm struct {

	// links
	Links *models.QosPolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this qos policy inline svm
func (o *QosPolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline svm based on the context it is used
func (o *QosPolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
QosPolicyInlineSvmInlineLinks qos policy inline svm inline links
swagger:model qos_policy_inline_svm_inline__links
*/
type QosPolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this qos policy inline svm inline links
func (o *QosPolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this qos policy inline svm inline links based on the context it is used
func (o *QosPolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *QosPolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *QosPolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *QosPolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res QosPolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
