// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewQosWorkloadCollectionGetParams creates a new QosWorkloadCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewQosWorkloadCollectionGetParams() *QosWorkloadCollectionGetParams {
	return &QosWorkloadCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewQosWorkloadCollectionGetParamsWithTimeout creates a new QosWorkloadCollectionGetParams object
// with the ability to set a timeout on a request.
func NewQosWorkloadCollectionGetParamsWithTimeout(timeout time.Duration) *QosWorkloadCollectionGetParams {
	return &QosWorkloadCollectionGetParams{
		timeout: timeout,
	}
}

// NewQosWorkloadCollectionGetParamsWithContext creates a new QosWorkloadCollectionGetParams object
// with the ability to set a context for a request.
func NewQosWorkloadCollectionGetParamsWithContext(ctx context.Context) *QosWorkloadCollectionGetParams {
	return &QosWorkloadCollectionGetParams{
		Context: ctx,
	}
}

// NewQosWorkloadCollectionGetParamsWithHTTPClient creates a new QosWorkloadCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewQosWorkloadCollectionGetParamsWithHTTPClient(client *http.Client) *QosWorkloadCollectionGetParams {
	return &QosWorkloadCollectionGetParams{
		HTTPClient: client,
	}
}

/*
QosWorkloadCollectionGetParams contains all the parameters to send to the API endpoint

	for the qos workload collection get operation.

	Typically these are written to a http.Request.
*/
type QosWorkloadCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* File.

	   Filter by file
	*/
	File *string

	/* Lun.

	   Filter by lun
	*/
	Lun *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PolicyName.

	   Filter by policy.name
	*/
	PolicyName *string

	/* PolicyUUID.

	   Filter by policy.uuid
	*/
	PolicyUUID *string

	/* Qtree.

	   Filter by qtree
	*/
	Qtree *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* Volume.

	   Filter by volume
	*/
	Volume *string

	/* Wid.

	   Filter by wid
	*/
	Wid *int64

	/* WorkloadClass.

	   Filter by workload_class
	*/
	WorkloadClass *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the qos workload collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosWorkloadCollectionGetParams) WithDefaults() *QosWorkloadCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the qos workload collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *QosWorkloadCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := QosWorkloadCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithTimeout(timeout time.Duration) *QosWorkloadCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithContext(ctx context.Context) *QosWorkloadCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithHTTPClient(client *http.Client) *QosWorkloadCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithFields(fields []string) *QosWorkloadCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithFile adds the file to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithFile(file *string) *QosWorkloadCollectionGetParams {
	o.SetFile(file)
	return o
}

// SetFile adds the file to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetFile(file *string) {
	o.File = file
}

// WithLun adds the lun to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithLun(lun *string) *QosWorkloadCollectionGetParams {
	o.SetLun(lun)
	return o
}

// SetLun adds the lun to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetLun(lun *string) {
	o.Lun = lun
}

// WithMaxRecords adds the maxRecords to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithMaxRecords(maxRecords *int64) *QosWorkloadCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithName(name *string) *QosWorkloadCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithOrderBy(orderBy []string) *QosWorkloadCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPolicyName adds the policyName to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithPolicyName(policyName *string) *QosWorkloadCollectionGetParams {
	o.SetPolicyName(policyName)
	return o
}

// SetPolicyName adds the policyName to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetPolicyName(policyName *string) {
	o.PolicyName = policyName
}

// WithPolicyUUID adds the policyUUID to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithPolicyUUID(policyUUID *string) *QosWorkloadCollectionGetParams {
	o.SetPolicyUUID(policyUUID)
	return o
}

// SetPolicyUUID adds the policyUuid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetPolicyUUID(policyUUID *string) {
	o.PolicyUUID = policyUUID
}

// WithQtree adds the qtree to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithQtree(qtree *string) *QosWorkloadCollectionGetParams {
	o.SetQtree(qtree)
	return o
}

// SetQtree adds the qtree to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetQtree(qtree *string) {
	o.Qtree = qtree
}

// WithReturnRecords adds the returnRecords to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithReturnRecords(returnRecords *bool) *QosWorkloadCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *QosWorkloadCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithSvmName(svmName *string) *QosWorkloadCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithSvmUUID(svmUUID *string) *QosWorkloadCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithUUID(uuid *string) *QosWorkloadCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVolume adds the volume to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithVolume(volume *string) *QosWorkloadCollectionGetParams {
	o.SetVolume(volume)
	return o
}

// SetVolume adds the volume to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetVolume(volume *string) {
	o.Volume = volume
}

// WithWid adds the wid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithWid(wid *int64) *QosWorkloadCollectionGetParams {
	o.SetWid(wid)
	return o
}

// SetWid adds the wid to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetWid(wid *int64) {
	o.Wid = wid
}

// WithWorkloadClass adds the workloadClass to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) WithWorkloadClass(workloadClass *string) *QosWorkloadCollectionGetParams {
	o.SetWorkloadClass(workloadClass)
	return o
}

// SetWorkloadClass adds the workloadClass to the qos workload collection get params
func (o *QosWorkloadCollectionGetParams) SetWorkloadClass(workloadClass *string) {
	o.WorkloadClass = workloadClass
}

// WriteToRequest writes these params to a swagger request
func (o *QosWorkloadCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.File != nil {

		// query param file
		var qrFile string

		if o.File != nil {
			qrFile = *o.File
		}
		qFile := qrFile
		if qFile != "" {

			if err := r.SetQueryParam("file", qFile); err != nil {
				return err
			}
		}
	}

	if o.Lun != nil {

		// query param lun
		var qrLun string

		if o.Lun != nil {
			qrLun = *o.Lun
		}
		qLun := qrLun
		if qLun != "" {

			if err := r.SetQueryParam("lun", qLun); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PolicyName != nil {

		// query param policy.name
		var qrPolicyName string

		if o.PolicyName != nil {
			qrPolicyName = *o.PolicyName
		}
		qPolicyName := qrPolicyName
		if qPolicyName != "" {

			if err := r.SetQueryParam("policy.name", qPolicyName); err != nil {
				return err
			}
		}
	}

	if o.PolicyUUID != nil {

		// query param policy.uuid
		var qrPolicyUUID string

		if o.PolicyUUID != nil {
			qrPolicyUUID = *o.PolicyUUID
		}
		qPolicyUUID := qrPolicyUUID
		if qPolicyUUID != "" {

			if err := r.SetQueryParam("policy.uuid", qPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.Qtree != nil {

		// query param qtree
		var qrQtree string

		if o.Qtree != nil {
			qrQtree = *o.Qtree
		}
		qQtree := qrQtree
		if qQtree != "" {

			if err := r.SetQueryParam("qtree", qQtree); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.Volume != nil {

		// query param volume
		var qrVolume string

		if o.Volume != nil {
			qrVolume = *o.Volume
		}
		qVolume := qrVolume
		if qVolume != "" {

			if err := r.SetQueryParam("volume", qVolume); err != nil {
				return err
			}
		}
	}

	if o.Wid != nil {

		// query param wid
		var qrWid int64

		if o.Wid != nil {
			qrWid = *o.Wid
		}
		qWid := swag.FormatInt64(qrWid)
		if qWid != "" {

			if err := r.SetQueryParam("wid", qWid); err != nil {
				return err
			}
		}
	}

	if o.WorkloadClass != nil {

		// query param workload_class
		var qrWorkloadClass string

		if o.WorkloadClass != nil {
			qrWorkloadClass = *o.WorkloadClass
		}
		qWorkloadClass := qrWorkloadClass
		if qWorkloadClass != "" {

			if err := r.SetQueryParam("workload_class", qWorkloadClass); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamQosWorkloadCollectionGet binds the parameter fields
func (o *QosWorkloadCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamQosWorkloadCollectionGet binds the parameter order_by
func (o *QosWorkloadCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
