// Code generated by go-swagger; DO NOT EDIT.

package storage

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// QosWorkloadCollectionGetReader is a Reader for the QosWorkloadCollectionGet structure.
type QosWorkloadCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *QosWorkloadCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewQosWorkloadCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewQosWorkloadCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewQosWorkloadCollectionGetOK creates a QosWorkloadCollectionGetOK with default headers values
func NewQosWorkloadCollectionGetOK() *QosWorkloadCollectionGetOK {
	return &QosWorkloadCollectionGetOK{}
}

/*
QosWorkloadCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type QosWorkloadCollectionGetOK struct {
	Payload *models.QosWorkloadResponse
}

// IsSuccess returns true when this qos workload collection get o k response has a 2xx status code
func (o *QosWorkloadCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this qos workload collection get o k response has a 3xx status code
func (o *QosWorkloadCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this qos workload collection get o k response has a 4xx status code
func (o *QosWorkloadCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this qos workload collection get o k response has a 5xx status code
func (o *QosWorkloadCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this qos workload collection get o k response a status code equal to that given
func (o *QosWorkloadCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the qos workload collection get o k response
func (o *QosWorkloadCollectionGetOK) Code() int {
	return 200
}

func (o *QosWorkloadCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/workloads][%d] qosWorkloadCollectionGetOK %s", 200, payload)
}

func (o *QosWorkloadCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/workloads][%d] qosWorkloadCollectionGetOK %s", 200, payload)
}

func (o *QosWorkloadCollectionGetOK) GetPayload() *models.QosWorkloadResponse {
	return o.Payload
}

func (o *QosWorkloadCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QosWorkloadResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewQosWorkloadCollectionGetDefault creates a QosWorkloadCollectionGetDefault with default headers values
func NewQosWorkloadCollectionGetDefault(code int) *QosWorkloadCollectionGetDefault {
	return &QosWorkloadCollectionGetDefault{
		_statusCode: code,
	}
}

/*
QosWorkloadCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type QosWorkloadCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this qos workload collection get default response has a 2xx status code
func (o *QosWorkloadCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this qos workload collection get default response has a 3xx status code
func (o *QosWorkloadCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this qos workload collection get default response has a 4xx status code
func (o *QosWorkloadCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this qos workload collection get default response has a 5xx status code
func (o *QosWorkloadCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this qos workload collection get default response a status code equal to that given
func (o *QosWorkloadCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the qos workload collection get default response
func (o *QosWorkloadCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *QosWorkloadCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/workloads][%d] qos_workload_collection_get default %s", o._statusCode, payload)
}

func (o *QosWorkloadCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /storage/qos/workloads][%d] qos_workload_collection_get default %s", o._statusCode, payload)
}

func (o *QosWorkloadCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *QosWorkloadCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
